/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.adapters;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.reflections8.ReflectionsException;
import org.reflections8.adapters.MetadataAdapter;
import org.reflections8.vfs.Vfs;

public class JavassistAdapter
implements MetadataAdapter<ClassFile, FieldInfo, MethodInfo> {
    public static final boolean includeInvisibleTag = true;

    @Override
    public List<FieldInfo> getFields(ClassFile cls) {
        return cls.getFields();
    }

    @Override
    public List<MethodInfo> getMethods(ClassFile cls) {
        return cls.getMethods();
    }

    @Override
    public String getMethodName(MethodInfo method) {
        return method.getName();
    }

    @Override
    public List<String> getParameterNames(MethodInfo method) {
        String descriptor2 = method.getDescriptor();
        descriptor2 = descriptor2.substring(descriptor2.indexOf("(") + 1, descriptor2.lastIndexOf(")"));
        return this.splitDescriptorToTypeNames(descriptor2);
    }

    @Override
    public List<String> getClassAnnotationNames(ClassFile aClass) {
        return this.getAnnotationNames((AnnotationsAttribute)aClass.getAttribute("RuntimeVisibleAnnotations"), (AnnotationsAttribute)aClass.getAttribute("RuntimeInvisibleAnnotations"));
    }

    @Override
    public List<String> getFieldAnnotationNames(FieldInfo field) {
        return this.getAnnotationNames((AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations"), (AnnotationsAttribute)field.getAttribute("RuntimeInvisibleAnnotations"));
    }

    @Override
    public List<String> getMethodAnnotationNames(MethodInfo method) {
        return this.getAnnotationNames((AnnotationsAttribute)method.getAttribute("RuntimeVisibleAnnotations"), (AnnotationsAttribute)method.getAttribute("RuntimeInvisibleAnnotations"));
    }

    @Override
    public List<String> getParameterAnnotationNames(MethodInfo method, int parameterIndex) {
        ArrayList<String> result2 = new ArrayList<String>();
        List<ParameterAnnotationsAttribute> parameterAnnotationsAttributes = Arrays.asList((ParameterAnnotationsAttribute)method.getAttribute("RuntimeVisibleParameterAnnotations"), (ParameterAnnotationsAttribute)method.getAttribute("RuntimeInvisibleParameterAnnotations"));
        if (parameterAnnotationsAttributes != null) {
            for (ParameterAnnotationsAttribute parameterAnnotationsAttribute : parameterAnnotationsAttributes) {
                Annotation[][] annotations2;
                if (parameterAnnotationsAttribute == null || parameterIndex >= (annotations2 = parameterAnnotationsAttribute.getAnnotations()).length) continue;
                Annotation[] annotation = annotations2[parameterIndex];
                result2.addAll(this.getAnnotationNames(annotation));
            }
        }
        return result2;
    }

    @Override
    public String getReturnTypeName(MethodInfo method) {
        String descriptor2 = method.getDescriptor();
        descriptor2 = descriptor2.substring(descriptor2.lastIndexOf(")") + 1);
        return this.splitDescriptorToTypeNames(descriptor2).get(0);
    }

    @Override
    public String getFieldName(FieldInfo field) {
        return field.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassFile getOrCreateClassObject(Vfs.File file) {
        try (InputStream inputStream2 = file.openInputStream();){
            DataInputStream dis = new DataInputStream(new BufferedInputStream(inputStream2));
            ClassFile classFile = new ClassFile(dis);
            return classFile;
        }
        catch (IOException e) {
            throw new ReflectionsException("could not create class file from " + file.getName(), e);
        }
    }

    @Override
    public String getMethodModifier(MethodInfo method) {
        int accessFlags = method.getAccessFlags();
        return AccessFlag.isPrivate(accessFlags) ? "private" : (AccessFlag.isProtected(accessFlags) ? "protected" : (this.isPublic(accessFlags) ? "public" : ""));
    }

    @Override
    public String getMethodKey(ClassFile cls, MethodInfo method) {
        StringJoiner j = new StringJoiner(", ", "(", ")");
        this.getParameterNames(method).forEach(name -> j.add((CharSequence)name));
        return this.getMethodName(method) + j.toString();
    }

    @Override
    public String getMethodFullKey(ClassFile cls, MethodInfo method) {
        return this.getClassName(cls) + "." + this.getMethodKey(cls, method);
    }

    @Override
    public boolean isPublic(Object o) {
        Integer accessFlags = o instanceof ClassFile ? ((ClassFile)o).getAccessFlags() : (o instanceof FieldInfo ? ((FieldInfo)o).getAccessFlags() : (o instanceof MethodInfo ? Integer.valueOf(((MethodInfo)o).getAccessFlags()) : null).intValue());
        return accessFlags != null && AccessFlag.isPublic(accessFlags);
    }

    @Override
    public String getClassName(ClassFile cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(ClassFile cls) {
        return cls.getSuperclass();
    }

    @Override
    public List<String> getInterfacesNames(ClassFile cls) {
        return Arrays.asList(cls.getInterfaces());
    }

    @Override
    public boolean acceptsInput(String file) {
        return file.endsWith(".class");
    }

    private List<String> getAnnotationNames(AnnotationsAttribute ... annotationsAttributes) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (annotationsAttributes != null) {
            for (AnnotationsAttribute annotationsAttribute : annotationsAttributes) {
                if (annotationsAttribute == null) continue;
                for (Annotation annotation : annotationsAttribute.getAnnotations()) {
                    result2.add(annotation.getTypeName());
                }
            }
        }
        return result2;
    }

    private List<String> getAnnotationNames(Annotation[] annotations2) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (Annotation annotation : annotations2) {
            result2.add(annotation.getTypeName());
        }
        return result2;
    }

    private List<String> splitDescriptorToTypeNames(String descriptors) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (descriptors != null && descriptors.length() != 0) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            Descriptor.Iterator iterator2 = new Descriptor.Iterator(descriptors);
            while (iterator2.hasNext()) {
                indices.add(iterator2.next());
            }
            indices.add(descriptors.length());
            for (int i = 0; i < indices.size() - 1; ++i) {
                String s1 = Descriptor.toString(descriptors.substring((Integer)indices.get(i), (Integer)indices.get(i + 1)));
                result2.add(s1);
            }
        }
        return result2;
    }
}

