/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.text;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.HighlightableTransitionAwareIcon;

public class EditContextMenuWidget
extends SubstanceWidget<JTextComponent> {
    protected MouseListener menuMouseListener;
    private static final int ICON_SIZE = 14;

    @Override
    public void installListeners() {
        this.menuMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            private void handleMouseEvent(MouseEvent e) {
                if (!WidgetUtilities.hasTextEditContextMenu((JTextComponent)EditContextMenuWidget.this.jcomp)) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    return;
                }
                ((JTextComponent)EditContextMenuWidget.this.jcomp).requestFocus(true);
                JPopupMenu editMenu = new JPopupMenu();
                editMenu.add(EditContextMenuWidget.this.getCutItem());
                editMenu.add(EditContextMenuWidget.this.getCopyItem());
                editMenu.add(EditContextMenuWidget.this.getPasteItem());
                editMenu.addSeparator();
                editMenu.add(EditContextMenuWidget.this.getDeleteItem());
                editMenu.add(EditContextMenuWidget.this.getSelectAllItem());
                Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), EditContextMenuWidget.this.jcomp);
                editMenu.show(EditContextMenuWidget.this.jcomp, pt.x, pt.y);
            }
        };
        ((JTextComponent)this.jcomp).addMouseListener(this.menuMouseListener);
    }

    @Override
    public void uninstallListeners() {
        ((JTextComponent)this.jcomp).removeMouseListener(this.menuMouseListener);
        this.menuMouseListener = null;
    }

    private JMenuItem getCutItem() {
        JMenuItem result2 = new JMenuItem(SubstanceCortex.GlobalScope.getLabelBundle().getString("EditMenu.cut"));
        result2.setEnabled(((JTextComponent)this.jcomp).isEditable() && ((JTextComponent)this.jcomp).isEnabled() && ((JTextComponent)this.jcomp).getSelectedText() != null);
        HighlightableTransitionAwareIcon icon = new HighlightableTransitionAwareIcon(result2, () -> (TransitionAwareUI)((Object)result2.getUI()), scheme -> SubstanceCortex.GlobalScope.getIconPack().getTextCutActionIcon(14, scheme), SubstanceSlices.ComponentStateFacet.ARM, "substance.widget.editcontext.cut");
        result2.setIcon(icon);
        result2.setDisabledIcon(icon);
        result2.addActionListener(e -> ((JTextComponent)this.jcomp).cut());
        return result2;
    }

    private JMenuItem getCopyItem() {
        JMenuItem result2 = new JMenuItem(SubstanceCortex.GlobalScope.getLabelBundle().getString("EditMenu.copy"));
        result2.setEnabled(((JTextComponent)this.jcomp).isEnabled() && ((JTextComponent)this.jcomp).getSelectedText() != null);
        HighlightableTransitionAwareIcon icon = new HighlightableTransitionAwareIcon(result2, () -> (TransitionAwareUI)((Object)result2.getUI()), scheme -> SubstanceCortex.GlobalScope.getIconPack().getTextCopyActionIcon(14, scheme), SubstanceSlices.ComponentStateFacet.ARM, "substance.widget.editcontext.copy");
        result2.setIcon(icon);
        result2.setDisabledIcon(icon);
        result2.addActionListener(e -> ((JTextComponent)this.jcomp).copy());
        return result2;
    }

    private JMenuItem getPasteItem() {
        JMenuItem result2 = new JMenuItem(SubstanceCortex.GlobalScope.getLabelBundle().getString("EditMenu.paste"));
        boolean isEnabled = false;
        if (((JTextComponent)this.jcomp).isEditable() && ((JTextComponent)this.jcomp).isEnabled()) {
            Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            isEnabled = contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
        result2.setEnabled(isEnabled);
        HighlightableTransitionAwareIcon icon = new HighlightableTransitionAwareIcon(result2, () -> (TransitionAwareUI)((Object)result2.getUI()), scheme -> SubstanceCortex.GlobalScope.getIconPack().getTextPasteActionIcon(14, scheme), SubstanceSlices.ComponentStateFacet.ARM, "substance.widget.editcontext.paste");
        result2.setIcon(icon);
        result2.setDisabledIcon(icon);
        result2.addActionListener(e -> ((JTextComponent)this.jcomp).paste());
        return result2;
    }

    private JMenuItem getDeleteItem() {
        JMenuItem result2 = new JMenuItem(SubstanceCortex.GlobalScope.getLabelBundle().getString("EditMenu.delete"));
        result2.setEnabled(((JTextComponent)this.jcomp).isEditable() && ((JTextComponent)this.jcomp).isEnabled() && ((JTextComponent)this.jcomp).getSelectedText() != null);
        HighlightableTransitionAwareIcon icon = new HighlightableTransitionAwareIcon(result2, () -> (TransitionAwareUI)((Object)result2.getUI()), scheme -> SubstanceCortex.GlobalScope.getIconPack().getTextDeleteActionIcon(14, scheme), SubstanceSlices.ComponentStateFacet.ARM, "substance.widget.editcontext.delete");
        result2.setIcon(icon);
        result2.setDisabledIcon(icon);
        result2.addActionListener(e -> ((JTextComponent)this.jcomp).replaceSelection(null));
        return result2;
    }

    private JMenuItem getSelectAllItem() {
        JMenuItem result2 = new JMenuItem(SubstanceCortex.GlobalScope.getLabelBundle().getString("EditMenu.selectAll"));
        result2.setEnabled(((JTextComponent)this.jcomp).isEnabled() && ((JTextComponent)this.jcomp).getDocument().getLength() > 0);
        HighlightableTransitionAwareIcon icon = new HighlightableTransitionAwareIcon(result2, () -> (TransitionAwareUI)((Object)result2.getUI()), scheme -> SubstanceCortex.GlobalScope.getIconPack().getTextSelectAllActionIcon(14, scheme), SubstanceSlices.ComponentStateFacet.ARM, "substance.widget.editcontext.selectall");
        result2.setIcon(icon);
        result2.setDisabledIcon(icon);
        result2.addActionListener(e -> ((JTextComponent)this.jcomp).selectAll());
        return result2;
    }
}

