/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.filters;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import org.pushingpixels.substance.api.icon.IsHiDpiAware;
import org.pushingpixels.substance.internal.contrib.intellij.JBHiDPIScaledImage;

public abstract class AbstractFilter
implements BufferedImageOp {
    @Override
    public abstract BufferedImage filter(BufferedImage var1, BufferedImage var2);

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        WritableRaster raster = destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        if (src instanceof IsHiDpiAware) {
            return new JBHiDPIScaledImage(destCM, raster, destCM.isAlphaPremultiplied(), null, src.getWidth() / 2, src.getHeight() / 2);
        }
        return new BufferedImage(destCM, raster, destCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return (Point2D)srcPt.clone();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    protected int[] getPixels(BufferedImage img, int x, int y, int w, int h2, int[] pixels) {
        if (w == 0 || h2 == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w * h2];
        } else if (pixels.length < w * h2) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h2, pixels);
        }
        return img.getRGB(x, y, w, h2, pixels, 0, w);
    }

    protected void setPixels(BufferedImage img, int x, int y, int w, int h2, int[] pixels) {
        if (pixels == null || w == 0 || h2 == 0) {
            return;
        }
        if (pixels.length < w * h2) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h2, pixels);
        } else {
            img.setRGB(x, y, w, h2, pixels, 0, w);
        }
    }
}

