/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.util.CondVar;

public class ResponseCollector<T> {
    private final Map<Address, T> responses;
    private final Lock lock = new ReentrantLock(false);
    private final CondVar cond = new CondVar(this.lock);

    public ResponseCollector(Collection<Address> members2) {
        this.responses = members2 != null ? new HashMap(members2.size()) : new HashMap();
        this.reset(members2);
    }

    public ResponseCollector(Address ... members2) {
        this.responses = members2 != null ? new HashMap(members2.length) : new HashMap();
        this.reset(members2);
    }

    public ResponseCollector() {
        this.responses = new HashMap<Address, T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Address member, T data2) {
        if (member == null) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.responses.containsKey(member)) {
                this.responses.put(member, data2);
                this.cond.signal(true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(Address member) {
        if (member == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.responses.remove(member) != null) {
                this.cond.signal(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(List<Address> members2) {
        if (members2 == null || members2.isEmpty()) {
            return;
        }
        this.lock.lock();
        try {
            members2.forEach(this.responses::remove);
            this.cond.signal(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean retainAll(List<Address> members2) {
        if (members2 == null || members2.isEmpty()) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.responses.keySet().retainAll(members2)) {
                this.cond.signal(true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void suspect(Address member) {
        this.remove(member);
    }

    public boolean hasAllResponses() {
        this.lock.lock();
        try {
            boolean bl = this.responses.isEmpty() || this.responses.entrySet().stream().allMatch(entry -> entry.getValue() != null);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfValidResponses() {
        int retval = 0;
        this.lock.lock();
        try {
            for (Map.Entry<Address, T> entry : this.responses.entrySet()) {
                if (entry.getValue() == null) continue;
                ++retval;
            }
            int n = retval;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Address> getMissing() {
        return this.responses.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<Address> getValidResults() {
        return this.responses.entrySet().stream().filter(entry -> entry.getValue() != null).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Map<Address, T> getResults() {
        return this.responses;
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.responses.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean waitForAllResponses(long timeout2) {
        if (timeout2 <= 0L) {
            timeout2 = 2000L;
        }
        return this.cond.waitFor(this::hasAllResponses, timeout2, TimeUnit.MILLISECONDS);
    }

    public void reset() {
        this.reset((Collection<Address>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Collection<Address> members2) {
        this.lock.lock();
        try {
            this.responses.clear();
            if (members2 != null) {
                for (Address mbr : members2) {
                    this.responses.put(mbr, null);
                }
            }
            this.cond.signal(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Address ... members2) {
        this.lock.lock();
        try {
            this.responses.clear();
            if (members2 != null) {
                for (Address mbr : members2) {
                    this.responses.put(mbr, null);
                }
            }
            this.cond.signal(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.format("%s, complete=%s", this.responses, this.hasAllResponses());
    }
}

