/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class PropertiesToAsciidoc {
    protected static final String ROOT_PACKAGE = "org.jgroups";

    public static void main(String[] args2) {
        if (args2.length != 2) {
            PropertiesToAsciidoc.help();
            System.err.println("args[0]=" + args2[0] + ", args[1]=" + args2[1]);
            return;
        }
        String prot_file = args2[0];
        String inst_file = args2[1];
        String temp_file = prot_file + ".tmp";
        String temp_file2 = inst_file + ".tmp";
        try {
            File f = new File(temp_file);
            PropertiesToAsciidoc.copy(new FileReader(prot_file), new FileWriter(f));
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Set<Class<?>> classes2 = Util.findClassesAssignableFrom("org.jgroups.protocols", Protocol.class, cl);
            classes2.addAll(Util.findClassesAssignableFrom("org.jgroups.protocols.pbcast", Protocol.class, cl));
            classes2.addAll(Util.findClassesAssignableFrom("org.jgroups.protocols.dns", Protocol.class, cl));
            classes2.addAll(Util.findClassesAssignableFrom("org.jgroups.protocols.relay", Protocol.class, cl));
            classes2.addAll(Util.findClassesAssignableFrom("org.jgroups.protocols.rules", Protocol.class, cl));
            Properties props = new Properties();
            for (Class<?> clazz : classes2) {
                PropertiesToAsciidoc.convertClassToAsciidocTable(props, clazz, null);
            }
            try (FileInputStream in = new FileInputStream(prot_file);
                 FileOutputStream out = new FileOutputStream(temp_file);){
                PropertiesToAsciidoc.replaceVariables(in, out, props);
            }
            f = new File(temp_file2);
            PropertiesToAsciidoc.copy(new FileReader(new File(inst_file)), new FileWriter(f));
            String s2 = PropertiesToAsciidoc.fileToString(f);
            props = new Properties();
            List<Class<?>> unsupportedClasses = Util.findClassesAnnotatedWith(ROOT_PACKAGE, Unsupported.class);
            PropertiesToAsciidoc.convertUnsupportedToAsciidocTable(props, unsupportedClasses, "Unsupported");
            List<Class<?>> experimentalClasses = Util.findClassesAnnotatedWith(ROOT_PACKAGE, Experimental.class);
            PropertiesToAsciidoc.convertUnsupportedToAsciidocTable(props, experimentalClasses, "Experimental");
            String result2 = Util.substituteVariable(s2, props);
            FileWriter fw = new FileWriter(f, false);
            fw.write(result2);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("PropertiesToXML <path to protocols.adoc file> <path to installation.adoc file>");
    }

    protected static void convertUnsupportedToAsciidocTable(Properties props, List<Class<?>> clazzes, String title) throws ParserConfigurationException, TransformerException {
        ArrayList<String[]> rows = new ArrayList<String[]>(clazzes.size() + 1);
        rows.add(new String[]{"Package", "Class"});
        for (Class<?> clazz : clazzes) {
            rows.add(new String[]{clazz.getPackage().getName(), clazz.getSimpleName()});
        }
        String tmp = PropertiesToAsciidoc.createAsciidocTable(rows, title, "[align=\"left\",width=\"50%\",options=\"header\"]");
        if (clazzes.size() > 1) {
            props.put(title, tmp);
        }
    }

    protected static String createAsciidocTable(List<String[]> rows, String title, String header) throws ParserConfigurationException, TransformerException {
        StringBuilder sb = new StringBuilder(".").append(title).append("\n").append(header).append("\n").append("|=================\n");
        for (String[] row : rows) {
            for (String el : row) {
                sb.append("|").append(el);
            }
            sb.append("\n");
        }
        sb.append("|=================\n");
        return sb.toString();
    }

    private static void convertClassToAsciidocTable(Properties props, Class<?> clazz, String prefix) throws Exception {
        if (clazz.isAnnotationPresent(Unsupported.class)) {
            return;
        }
        TreeMap<String, String> nameToDescription = new TreeMap<String, String>();
        PropertiesToAsciidoc.getDescriptions(clazz, nameToDescription, prefix, false);
        if (nameToDescription.isEmpty()) {
            return;
        }
        ArrayList<String[]> rows = new ArrayList<String[]>(nameToDescription.size() + 1);
        rows.add(new String[]{"Name", "Description"});
        for (Map.Entry entry : nameToDescription.entrySet()) {
            rows.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
        String tmp = PropertiesToAsciidoc.createAsciidocTable(rows, clazz.getSimpleName(), "[align=\"left\",width=\"90%\",cols=\"2,10\",options=\"header\"]");
        props.put(clazz.getSimpleName(), tmp);
    }

    protected static void getDescriptions(Class<?> clazz, Map<String, String> m3, String prefix, boolean print_class) throws IOException, ClassNotFoundException {
        Method[] methods2;
        Property annotation;
        Field[] fields2;
        for (Field field : fields2 = clazz.getDeclaredFields()) {
            if (field.isAnnotationPresent(Property.class)) {
                Object property = field.getName();
                annotation = field.getAnnotation(Property.class);
                String name = annotation.name();
                if (name != null && !name.trim().isEmpty()) {
                    property = name.trim();
                }
                String desc = annotation.description();
                if (prefix != null && !prefix.isEmpty()) {
                    property = prefix + "." + (String)property;
                }
                if (print_class) {
                    property = String.format("%s (%s)", property, clazz.getSimpleName());
                }
                m3.put((String)property, desc);
            }
            if (!field.isAnnotationPresent(Component.class)) continue;
            Component ann = field.getAnnotation(Component.class);
            Class<?> type2 = field.getType();
            if (type2.isInterface() || Modifier.isAbstract(type2.getModifiers())) {
                Set<Class<?>> implementations = Util.findClassesAssignableFrom(ROOT_PACKAGE, type2, Thread.currentThread().getContextClassLoader());
                for (Class clazz2 : implementations) {
                    PropertiesToAsciidoc.getDescriptions(clazz2, m3, ann.name(), true);
                }
                continue;
            }
            PropertiesToAsciidoc.getDescriptions(type2, m3, ann.name(), false);
        }
        for (Method method : methods2 = clazz.getDeclaredMethods()) {
            Object name;
            if (!method.isAnnotationPresent(Property.class)) continue;
            annotation = method.getAnnotation(Property.class);
            String desc = annotation.description();
            if (desc == null || desc.isEmpty()) {
                desc = "n/a";
            }
            if (((String)(name = annotation.name())).length() < 1) {
                name = Util.methodNameToAttributeName(method.getName());
            }
            if (prefix != null && !prefix.isEmpty()) {
                name = prefix + "." + (String)name;
            }
            if (print_class) {
                name = String.format("%s (%s)", name, clazz.getSimpleName());
            }
            m3.put((String)name, desc);
        }
    }

    protected static void replaceVariables(InputStream in, OutputStream out, Properties p) {
        boolean looping = true;
        block6: while (looping) {
            try {
                int ch = in.read();
                if (ch == -1) break;
                switch (ch) {
                    case 92: {
                        String s2;
                        int n1 = in.read();
                        int n2 = in.read();
                        if (n1 == -1 || n2 == -1) {
                            looping = false;
                            if (n1 == -1) continue block6;
                            out.write(n1);
                            continue block6;
                        }
                        if (n1 == 36 && n2 == 123) {
                            s2 = PropertiesToAsciidoc.readUntilBracket(in);
                            out.write(n1);
                            out.write(n2);
                            out.write(s2.getBytes());
                            out.write(125);
                            continue block6;
                        }
                        out.write(ch);
                        out.write(n1);
                        out.write(n2);
                        continue block6;
                    }
                    case 36: {
                        String s2;
                        int n1 = in.read();
                        if (n1 == -1) {
                            out.write(ch);
                            looping = false;
                            continue block6;
                        }
                        if (n1 == 123) {
                            s2 = PropertiesToAsciidoc.readUntilBracket(in);
                            PropertiesToAsciidoc.writeVarToStream(s2, p, out);
                            continue block6;
                        }
                        out.write(ch);
                        out.write(n1);
                        continue block6;
                    }
                }
                out.write(ch);
            }
            catch (IOException e) {
                // empty catch block
                break;
            }
        }
        Util.close(in, out);
    }

    protected static void writeVarToStream(String var, Properties p, OutputStream out) throws IOException {
        String val = (String)p.get(var);
        if (val != null) {
            out.write(val.getBytes());
        }
    }

    protected static String readUntilBracket(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int ch = in.read();
            switch (ch) {
                case -1: {
                    throw new EOFException("no matching } found");
                }
                case 125: {
                    return sb.toString();
                }
            }
            sb.append((char)ch);
        }
    }

    private static String fileToString(File f) throws Exception {
        StringWriter output = new StringWriter();
        FileReader input = new FileReader(f);
        char[] buffer = new char[8192];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        int count2 = 0;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count2 += n;
            }
        }
        finally {
            output.flush();
            output.close();
        }
        return count2;
    }
}

