/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jgroups.blocks.MethodCall;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class PerfUtil {
    public static void init() {
        ClassConfigurator.addIfAbsent((short)1040, GetCall.class);
        ClassConfigurator.addIfAbsent((short)1041, PutCall.class);
        ClassConfigurator.addIfAbsent((short)1042, Results.class);
        ClassConfigurator.addIfAbsent((short)1043, Config.class);
        ClassConfigurator.addIfAbsent((short)1044, CustomCall.class);
    }

    public static class Config
    implements Streamable {
        protected Map<String, Object> values = new HashMap<String, Object>();

        public Map<String, Object> values() {
            return this.values;
        }

        public Config add(String key, Object value) {
            this.values.put(key, value);
            return this;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeInt(this.values.size());
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                Bits.writeString(entry.getKey(), out);
                Util.objectToStream(entry.getValue(), out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = Bits.readString(in);
                Object value = Util.objectFromStream(in);
                if (key == null) continue;
                this.values.put(key, value);
            }
        }

        public String toString() {
            return this.values.toString();
        }
    }

    public static class Results
    implements Streamable {
        protected long num_gets;
        protected long num_puts;
        protected long total_time;
        protected AverageMinMax avg_gets;
        protected AverageMinMax avg_puts;

        public Results() {
        }

        public Results(int num_gets, int num_puts, long total_time, AverageMinMax avg_gets, AverageMinMax avg_puts) {
            this.num_gets = num_gets;
            this.num_puts = num_puts;
            this.total_time = total_time;
            this.avg_gets = avg_gets;
            this.avg_puts = avg_puts;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeLongCompressed(this.num_gets, out);
            Bits.writeLongCompressed(this.num_puts, out);
            Bits.writeLongCompressed(this.total_time, out);
            Util.writeStreamable(this.avg_gets, out);
            Util.writeStreamable(this.avg_puts, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.num_gets = Bits.readLongCompressed(in);
            this.num_puts = Bits.readLongCompressed(in);
            this.total_time = Bits.readLongCompressed(in);
            this.avg_gets = Util.readStreamable(AverageMinMax::new, in);
            this.avg_puts = Util.readStreamable(AverageMinMax::new, in);
        }

        public String toString() {
            long total_reqs = this.num_gets + this.num_puts;
            double total_reqs_per_sec = (double)total_reqs / ((double)this.total_time / 1000.0);
            return String.format("%,.2f reqs/sec (%,d gets, %,d puts, get RTT %,.2f us, put RTT %,.2f us)", total_reqs_per_sec, this.num_gets, this.num_puts, this.avg_gets.average() / 1000.0, this.avg_puts.getAverage() / 1000.0);
        }
    }

    public static class CustomCall
    extends MethodCall {
        protected static final byte NORMAL = 0;
        protected static final byte EXCEPTION = 1;
        protected static final byte CONFIG = 2;
        protected static final byte RESULTS = 3;

        public CustomCall() {
        }

        public CustomCall(short method_id, Object ... args2) {
            super(method_id, args2);
        }

        @Override
        public Supplier<? extends MethodCall> create() {
            return CustomCall::new;
        }

        @Override
        protected void writeArg(DataOutput out, Object obj2) throws IOException {
            if (obj2 instanceof Throwable) {
                Throwable t = (Throwable)obj2;
                out.writeByte(1);
                out.writeUTF(t.getMessage());
                return;
            }
            if (obj2 instanceof Config) {
                out.writeByte(2);
                ((Config)obj2).writeTo(out);
                return;
            }
            if (obj2 instanceof Results) {
                out.writeByte(3);
                ((Results)obj2).writeTo(out);
                return;
            }
            out.writeByte(0);
            Util.objectToStream(obj2, out);
        }

        @Override
        protected Object readArg(DataInput in) throws IOException, ClassNotFoundException {
            byte type2 = in.readByte();
            switch (type2) {
                case 0: {
                    return Util.objectFromStream(in);
                }
                case 1: {
                    String message = in.readUTF();
                    return new RuntimeException(message);
                }
                case 2: {
                    Config cfg = new Config();
                    cfg.readFrom(in);
                    return cfg;
                }
                case 3: {
                    Results res = new Results();
                    res.readFrom(in);
                    return res;
                }
            }
            throw new IllegalArgumentException("type " + type2 + " not known");
        }
    }

    public static class GetCall
    extends MethodCall
    implements SizeStreamable {
        public GetCall() {
        }

        public GetCall(short method_id, Object ... args2) {
            super(method_id, args2);
        }

        @Override
        public Supplier<? extends MethodCall> create() {
            return GetCall::new;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Integer key = (Integer)this.args[0];
            out.writeShort(this.method_id);
            out.writeInt(key);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.method_id = in.readShort();
            this.args = new Object[]{in.readInt()};
        }

        @Override
        public int serializedSize() {
            return 6;
        }
    }

    public static class PutCall
    extends MethodCall
    implements SizeStreamable {
        public PutCall() {
        }

        public PutCall(short method_id, Object ... args2) {
            super(method_id, args2);
        }

        @Override
        public Supplier<? extends MethodCall> create() {
            return PutCall::new;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Integer key = (Integer)this.args[0];
            byte[] val = (byte[])this.args[1];
            out.writeShort(this.method_id);
            out.writeInt(key);
            out.writeInt(val.length);
            out.write(val, 0, val.length);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.method_id = in.readShort();
            int key = in.readInt();
            int length = in.readInt();
            byte[] val = new byte[length];
            in.readFully(val);
            this.args = new Object[]{key, val};
        }

        @Override
        public int serializedSize() {
            byte[] buf = (byte[])this.args[1];
            return 10 + buf.length;
        }
    }
}

