/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.util.Util;

public class EncryptHeader
extends Header {
    public static final byte INSTALL_KEYS = 1;
    public static final byte FETCH_SHARED_KEY = 2;
    protected byte type;
    protected byte[] version;
    protected Address server;
    protected byte[] iv;
    protected boolean needs_deserialization;

    public EncryptHeader() {
    }

    public EncryptHeader(byte type2, byte[] version, byte[] iv) {
        this.type = type2;
        this.version = version;
        this.iv = iv;
    }

    public EncryptHeader(byte type2, byte[] version) {
        this.type = type2;
        this.version = version;
    }

    public EncryptHeader(byte[] version) {
        this.version = version;
    }

    public byte type() {
        return this.type;
    }

    public byte[] version() {
        return this.version;
    }

    public Address server() {
        return this.server;
    }

    public byte[] iv() {
        return this.iv;
    }

    public EncryptHeader server(Address s2) {
        this.server = s2;
        return this;
    }

    public boolean needsDeserialization() {
        return this.needs_deserialization;
    }

    public EncryptHeader needsDeserialization(boolean flag) {
        this.needs_deserialization = flag;
        return this;
    }

    @Override
    public short getMagicId() {
        return 88;
    }

    @Override
    public Supplier<? extends Header> create() {
        return EncryptHeader::new;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeBoolean(this.needs_deserialization);
        Util.writeByteBuffer(this.version, 0, this.version != null ? this.version.length : 0, out);
        Util.writeAddress(this.server, out);
        Util.writeByteBuffer(this.iv, 0, this.iv != null ? this.iv.length : 0, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        this.needs_deserialization = in.readBoolean();
        this.version = Util.readByteBuffer(in);
        this.server = Util.readAddress(in);
        this.iv = Util.readByteBuffer(in);
    }

    @Override
    public String toString() {
        return String.format("%s [version=%s]", EncryptHeader.typeToString(this.type), this.version != null ? Util.byteArrayToHexString(this.version) : "null") + (String)(this.server == null ? "" : " [server=" + this.server + "]") + (String)(this.iv == null ? "" : " [iv=" + Util.byteArrayToHexString(this.iv) + "]");
    }

    @Override
    public int serializedSize() {
        return 1 + Util.size(this.version) + Util.size(this.server) + Util.size(this.iv) + 1;
    }

    protected static String typeToString(byte type2) {
        switch (type2) {
            case 1: {
                return "INSTALL_KEYS";
            }
            case 2: {
                return "FETCH_SHARED_KEY";
            }
        }
        return EncryptHeader.class.getSimpleName();
    }
}

