/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.Closeable;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.blocks.atomic.CounterService;
import org.jgroups.util.Util;

public class CounterServiceDemo {
    static final String props = "SHARED_LOOPBACK:PING(timeout=1000):pbcast.NAKACK(use_mcast_xmit=false;log_discard_msgs=false;log_not_found_msgs=false):UNICAST:pbcast.STABLE(stability_delay=200):pbcast.GMS:FC:FRAG2:COUNTER";
    protected JChannel ch;

    void start(String props, String channel_name) throws Exception {
        this.ch = new JChannel(props);
        this.ch.setName(channel_name);
        this.ch.setReceiver(new Receiver(){

            @Override
            public void viewAccepted(View view) {
                System.out.println("-- view: " + view);
            }
        });
        this.loop();
    }

    public void start(JChannel ch) throws Exception {
        this.ch = ch;
        ch.setReceiver(new Receiver(){

            @Override
            public void viewAccepted(View view) {
                System.out.println("-- view: " + view);
            }
        });
        this.loop();
    }

    void loop() throws Exception {
        CounterService counter_service = new CounterService(this.ch);
        this.ch.connect("counter-cluster");
        Counter counter = counter_service.getOrCreateCounter("mycounter", 1L);
        boolean looping = true;
        while (looping) {
            try {
                int key = Util.keyPress("[1] Increment [2] Decrement [3] Compare and set\n[4] Create counter [5] Delete counter\n[6] Print counters [7] Get counter\n[8] Increment 1M times [9] Dump pending requests [x] Exit\n");
                switch (key) {
                    case 49: {
                        long val = counter.incrementAndGet();
                        System.out.println("counter: " + val);
                        break;
                    }
                    case 50: {
                        long val = counter.decrementAndGet();
                        System.out.println("counter: " + val);
                        break;
                    }
                    case 51: {
                        long expect = Util.readLongFromStdin("expected value: ");
                        long update2 = Util.readLongFromStdin("update: ");
                        if (counter.compareAndSet(expect, update2)) {
                            System.out.println("-- set counter \"" + counter.getName() + "\" to " + update2 + "\n");
                            break;
                        }
                        System.err.println("failed setting counter \"" + counter.getName() + "\" from " + expect + " to " + update2 + ", current value is " + counter.get() + "\n");
                        break;
                    }
                    case 52: {
                        String counter_name = Util.readStringFromStdin("counter name: ");
                        counter = counter_service.getOrCreateCounter(counter_name, 1L);
                        break;
                    }
                    case 53: {
                        String counter_name = Util.readStringFromStdin("counter name: ");
                        counter_service.deleteCounter(counter_name);
                        break;
                    }
                    case 54: {
                        System.out.println("Counters (current=" + counter.getName() + "):\n\n" + counter_service.printCounters());
                        break;
                    }
                    case 55: {
                        counter.get();
                        break;
                    }
                    case 56: {
                        int NUM = Util.readIntFromStdin("num: ");
                        System.out.println();
                        int print = NUM / 10;
                        long retval = 0L;
                        long start = System.currentTimeMillis();
                        for (int i = 0; i < NUM; ++i) {
                            retval = counter.incrementAndGet();
                            if (i <= 0 || i % print != 0) continue;
                            System.out.println("-- count=" + retval);
                        }
                        long diff = System.currentTimeMillis() - start;
                        System.out.println("\n" + NUM + " incrs took " + diff + " ms; " + (double)NUM / ((double)diff / 1000.0) + " ops /sec\n");
                        break;
                    }
                    case 57: {
                        System.out.println("Pending requests:\n" + counter_service.dumpPendingRequests());
                        break;
                    }
                    case -1: 
                    case 120: {
                        looping = false;
                    }
                }
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        Util.close((Closeable)this.ch);
    }

    public static void main(String[] args2) throws Exception {
        String properties2 = props;
        String name = null;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-props")) {
                properties2 = args2[++i];
                continue;
            }
            if (args2[i].equals("-name")) {
                name = args2[++i];
                continue;
            }
            CounterServiceDemo.help();
            return;
        }
        new CounterServiceDemo().start(properties2, name);
    }

    private static void help() {
        System.out.println("CounterServiceDemo [-props props] [-name name]");
    }
}

