/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.BatchMessage;
import org.jgroups.BytesMessage;
import org.jgroups.CompositeMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.FragmentedMessage;
import org.jgroups.LongMessage;
import org.jgroups.Message;
import org.jgroups.MessageFactory;
import org.jgroups.NioMessage;
import org.jgroups.ObjectMessage;

public class DefaultMessageFactory
implements MessageFactory {
    protected static final byte MIN_TYPE = 32;
    protected final Supplier<? extends Message>[] creators = new Supplier[32];
    protected Map<Short, Supplier<? extends Message>> map;

    public DefaultMessageFactory() {
        this.creators[0] = BytesMessage::new;
        this.creators[1] = NioMessage::new;
        this.creators[2] = EmptyMessage::new;
        this.creators[3] = ObjectMessage::new;
        this.creators[4] = LongMessage::new;
        this.creators[5] = CompositeMessage::new;
        this.creators[6] = FragmentedMessage::new;
        this.creators[7] = BatchMessage::new;
    }

    @Override
    public <T extends Message> T create(short type2) {
        Supplier<? extends Message> creator;
        Supplier<? extends Message> supplier = creator = type2 < 32 ? this.creators[type2] : this.map.get(type2);
        if (creator == null) {
            throw new IllegalArgumentException("no creator found for type " + type2);
        }
        return (T)creator.get();
    }

    public <T extends MessageFactory> T register(short type2, Supplier<? extends Message> generator) {
        Objects.requireNonNull(generator, "the creator must be non-null");
        if (type2 < 32) {
            throw new IllegalArgumentException(String.format("type (%d) must be >= 32", type2));
        }
        if (this.map == null) {
            this.map = new HashMap<Short, Supplier<? extends Message>>();
        }
        if (this.map.containsKey(type2)) {
            throw new IllegalArgumentException(String.format("type %d is already taken", type2));
        }
        this.map.put(type2, generator);
        return (T)this;
    }
}

