/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPClass;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPNameAndType;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;
import org.apache.commons.compress.harmony.unpack200.bytecode.ConstantPoolEntry;

public abstract class CPRef
extends ConstantPoolEntry {
    CPClass className;
    transient int classNameIndex;
    protected CPNameAndType nameAndType;
    transient int nameAndTypeIndex;
    protected String cachedToString;

    public CPRef(byte type2, CPClass className, CPNameAndType descriptor2, int globalIndex) {
        super(type2, globalIndex);
        this.className = className;
        this.nameAndType = descriptor2;
        if (descriptor2 == null || className == null) {
            throw new NullPointerException("Null arguments are not allowed");
        }
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        if (this.hashCode() != obj2.hashCode()) {
            return false;
        }
        CPRef other = (CPRef)obj2;
        if (!this.className.equals(other.className)) {
            return false;
        }
        return this.nameAndType.equals(other.nameAndType);
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        ClassFileEntry[] entries2 = new ClassFileEntry[]{this.className, this.nameAndType};
        return entries2;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        this.nameAndTypeIndex = pool.indexOf(this.nameAndType);
        this.classNameIndex = pool.indexOf(this.className);
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            String type2 = this.getTag() == 9 ? "FieldRef" : (this.getTag() == 10 ? "MethoddRef" : (this.getTag() == 11 ? "InterfaceMethodRef" : "unknown"));
            this.cachedToString = type2 + ": " + this.className + "#" + this.nameAndType;
        }
        return this.cachedToString;
    }

    @Override
    protected void writeBody(DataOutputStream dos) throws IOException {
        dos.writeShort(this.classNameIndex);
        dos.writeShort(this.nameAndTypeIndex);
    }
}

