/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;

public abstract class Attribute
extends ClassFileEntry {
    protected final CPUTF8 attributeName;
    private int attributeNameIndex;

    public Attribute(CPUTF8 attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    protected void doWrite(DataOutputStream dos) throws IOException {
        dos.writeShort(this.attributeNameIndex);
        dos.writeInt(this.getLength());
        this.writeBody(dos);
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj2;
        return !(this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName));
    }

    protected CPUTF8 getAttributeName() {
        return this.attributeName;
    }

    protected abstract int getLength();

    protected int getLengthIncludingHeader() {
        return this.getLength() + 2 + 4;
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        return new ClassFileEntry[]{this.getAttributeName()};
    }

    public boolean hasBCIRenumbering() {
        return false;
    }

    public boolean isSourceFileAttribute() {
        return false;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        return result2;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        this.attributeNameIndex = pool.indexOf(this.attributeName);
    }

    protected abstract void writeBody(DataOutputStream var1) throws IOException;
}

