/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.account;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.runelite.client.RuneLiteProperties;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.account.OAuthResponse;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountClient {
    private static final Logger log = LoggerFactory.getLogger(AccountClient.class);
    private final OkHttpClient client;
    private UUID uuid;

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public OAuthResponse login() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("account").addPathSegment("login").addQueryParameter("uuid", this.uuid.toString()).build();
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Built URI: {}", (Object)url);
        }
        Request request = new Request.Builder().url(url).build();
        Response response = this.client.newCall(request).execute();
        try {
            InputStream in = response.body().byteStream();
            OAuthResponse oAuthResponse = RuneLiteAPI.GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), OAuthResponse.class);
            if (response != null) {
                response.close();
            }
            return oAuthResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonParseException ex) {
                throw new IOException(ex);
            }
        }
    }

    public void logout() throws IOException {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("account").addPathSegment("logout").build();
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Built URI: {}", (Object)url);
        }
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
                log.debug("Sent logout request");
            }
        }
    }

    public boolean sessionCheck() {
        HttpUrl url = RuneLiteAPI.getApiBase().newBuilder().addPathSegment("account").addPathSegment("session-check").build();
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Built URI: {}", (Object)url);
        }
        Request request = new Request.Builder().header("RUNELITE-AUTH", this.uuid.toString()).url(url).build();
        Response response = this.client.newCall(request).execute();
        try {
            boolean bl = response.isSuccessful();
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException ex) {
                if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
                    log.debug("Unable to verify session", ex);
                }
                return true;
            }
        }
    }

    public AccountClient(OkHttpClient client) {
        this.client = client;
    }
}

