/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ws;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.account.AccountSession;
import net.runelite.client.account.SessionManager;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.events.PartyMemberAvatar;
import net.runelite.client.util.Text;
import net.runelite.client.ws.PartyMember;
import net.runelite.client.ws.WSClient;
import net.runelite.http.api.ws.messages.party.Join;
import net.runelite.http.api.ws.messages.party.Part;
import net.runelite.http.api.ws.messages.party.PartyChatMessage;
import net.runelite.http.api.ws.messages.party.UserJoin;
import net.runelite.http.api.ws.messages.party.UserPart;
import net.runelite.http.api.ws.messages.party.UserSync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PartyService {
    private static final Logger log = LoggerFactory.getLogger(PartyService.class);
    public static final int PARTY_MAX = 15;
    private static final int MAX_MESSAGE_LEN = 150;
    private static final int MAX_USERNAME_LEN = 32;
    private final WSClient wsClient;
    private final SessionManager sessionManager;
    private final EventBus eventBus;
    private final ChatMessageManager chat;
    private final List<PartyMember> members = new ArrayList<PartyMember>();
    private UUID localPartyId = UUID.randomUUID();
    private UUID publicPartyId;
    private UUID partyId;
    private String username;

    @Inject
    private PartyService(WSClient wsClient, SessionManager sessionManager, EventBus eventBus, ChatMessageManager chat) {
        this.wsClient = wsClient;
        this.sessionManager = sessionManager;
        this.eventBus = eventBus;
        this.chat = chat;
        eventBus.register(this);
    }

    public void changeParty(@Nullable UUID newParty) {
        if (this.username == null) {
            log.warn("Tried to join a party with no username");
            return;
        }
        if (this.wsClient.sessionExists()) {
            this.wsClient.send(new Part());
        }
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Party change to {}", (Object)newParty);
        }
        this.members.clear();
        this.partyId = newParty;
        UUID uUID = this.publicPartyId = newParty != null ? UUID.nameUUIDFromBytes(Hashing.sha256().hashString(newParty.toString(), Charsets.UTF_8).asBytes()) : null;
        if (this.partyId == null) {
            this.localPartyId = UUID.randomUUID();
            if (this.sessionManager.getAccountSession() == null) {
                this.wsClient.changeSession(null);
            }
            this.eventBus.post(new PartyChanged(this.partyId));
            return;
        }
        if (!this.wsClient.sessionExists()) {
            AccountSession accountSession = this.sessionManager.getAccountSession();
            UUID uuid = accountSession != null ? accountSession.getUuid() : UUID.randomUUID();
            this.wsClient.changeSession(uuid);
        }
        this.eventBus.post(new PartyChanged(this.partyId));
        this.wsClient.send(new Join(this.partyId, this.username));
    }

    @Subscribe(priority=1.0f)
    public void onUserJoin(UserJoin message) {
        if (!this.partyId.equals(message.getPartyId())) {
            return;
        }
        PartyMember partyMember = new PartyMember(message.getMemberId(), PartyService.cleanUsername(message.getName()));
        this.members.add(partyMember);
        PartyMember localMember = this.getLocalMember();
        if (localMember != null && message.getMemberId().equals(localMember.getMemberId())) {
            UserSync userSync = new UserSync();
            userSync.setMemberId(message.getMemberId());
            this.wsClient.send(userSync);
        }
    }

    @Subscribe(priority=1.0f)
    public void onUserPart(UserPart message) {
        this.members.removeIf(member -> member.getMemberId().equals(message.getMemberId()));
    }

    @Subscribe
    public void onPartyChatMessage(PartyChatMessage message) {
        String sentMesage = Text.JAGEX_PRINTABLE_CHAR_MATCHER.retainFrom(message.getValue()).replaceAll("<img=.+>", "");
        if (sentMesage.length() > 150) {
            sentMesage = sentMesage.substring(0, 150);
        }
        this.chat.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHAT).sender("Party").name(this.getMemberById(message.getMemberId()).getName()).runeLiteFormattedMessage(sentMesage).build());
    }

    public PartyMember getLocalMember() {
        return this.getMemberByName(this.username);
    }

    public PartyMember getMemberById(UUID id) {
        for (PartyMember member : this.members) {
            if (!id.equals(member.getMemberId())) continue;
            return member;
        }
        return null;
    }

    public PartyMember getMemberByName(String name) {
        for (PartyMember member : this.members) {
            if (!name.equals(member.getName())) continue;
            return member;
        }
        return null;
    }

    public List<PartyMember> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public boolean isInParty() {
        return this.partyId != null;
    }

    public boolean isPartyOwner() {
        return this.localPartyId.equals(this.partyId);
    }

    public void setPartyMemberAvatar(UUID memberID, BufferedImage image) {
        PartyMember memberById = this.getMemberById(memberID);
        if (memberById != null) {
            memberById.setAvatar(image);
            this.eventBus.post(new PartyMemberAvatar(memberID, image));
        }
    }

    private static String cleanUsername(String username) {
        String s2 = Text.removeTags(Text.JAGEX_PRINTABLE_CHAR_MATCHER.retainFrom(username));
        if (s2.length() >= 32) {
            s2 = s2.substring(0, 32);
        }
        return s2;
    }

    public UUID getLocalPartyId() {
        return this.localPartyId;
    }

    public UUID getPublicPartyId() {
        return this.publicPartyId;
    }

    public UUID getPartyId() {
        return this.partyId;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

