/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.timers;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.runelite.client.plugins.timers.GameTimerImageType;
import net.runelite.client.util.RSTimeUnit;

enum GameTimer {
    STAMINA(12625, GameTimerImageType.ITEM, "Stamina", false),
    ANTIFIRE(2452, GameTimerImageType.ITEM, "Antifire", false),
    OVERLOAD(11730, GameTimerImageType.ITEM, "Overload", false),
    CANNON(10, GameTimerImageType.ITEM, "Cannon", 25L, ChronoUnit.MINUTES),
    CANNON_REPAIR(1, GameTimerImageType.ITEM, "Broken Cannon", 10L, ChronoUnit.MINUTES),
    MAGICIMBUE(552, GameTimerImageType.SPRITE, "Magic imbue", false),
    SUPERANTIFIRE(21978, GameTimerImageType.ITEM, "Super antifire", false),
    BIND(319, GameTimerImageType.SPRITE, "Bind", 181, 8L, RSTimeUnit.GAME_TICKS, true),
    SNARE(320, GameTimerImageType.SPRITE, "Snare", 180, 16L, RSTimeUnit.GAME_TICKS, true),
    ENTANGLE(321, GameTimerImageType.SPRITE, "Entangle", 179, 24L, RSTimeUnit.GAME_TICKS, true),
    ICERUSH(325, GameTimerImageType.SPRITE, "Ice rush", 361, 8L, RSTimeUnit.GAME_TICKS, true),
    ICEBURST(326, GameTimerImageType.SPRITE, "Ice burst", 363, 16L, RSTimeUnit.GAME_TICKS, true),
    ICEBLITZ(327, GameTimerImageType.SPRITE, "Ice blitz", 367, 24L, RSTimeUnit.GAME_TICKS, true),
    ICEBARRAGE(328, GameTimerImageType.SPRITE, "Ice barrage", 369, 32L, RSTimeUnit.GAME_TICKS, true),
    IMBUEDHEART(20724, GameTimerImageType.ITEM, "Imbued/Saturated heart", false),
    VENGEANCE(564, GameTimerImageType.SPRITE, "Vengeance", 30L, ChronoUnit.SECONDS),
    HEAL_GROUP(566, GameTimerImageType.SPRITE, "Heal Group", 150L, RSTimeUnit.GAME_TICKS),
    EXSUPERANTIFIRE(22209, GameTimerImageType.ITEM, "Extended Super AntiFire", 6L, ChronoUnit.MINUTES),
    OVERLOAD_RAID(20996, GameTimerImageType.ITEM, "Overload", false),
    PRAYER_ENHANCE(20964, GameTimerImageType.ITEM, "Prayer enhance", 290L, ChronoUnit.SECONDS, true),
    GOD_WARS_ALTAR(201, GameTimerImageType.SPRITE, "God wars altar", 10L, ChronoUnit.MINUTES),
    CHARGE(322, GameTimerImageType.SPRITE, "Charge", false),
    STAFF_OF_THE_DEAD(11791, GameTimerImageType.ITEM, "Staff of the Dead", 1L, ChronoUnit.MINUTES),
    ABYSSAL_SIRE_STUN(13262, GameTimerImageType.ITEM, "Abyssal Sire Stun", 30L, ChronoUnit.SECONDS, true),
    HOME_TELEPORT(356, GameTimerImageType.SPRITE, "Home Teleport", 30L, ChronoUnit.MINUTES),
    MINIGAME_TELEPORT(1053, GameTimerImageType.SPRITE, "Minigame Teleport", 20L, ChronoUnit.MINUTES),
    DRAGON_FIRE_SHIELD(11283, GameTimerImageType.ITEM, "Dragonfire Shield Special", 115L, ChronoUnit.SECONDS),
    DIVINE_SUPER_ATTACK(23697, GameTimerImageType.ITEM, "Divine Super Attack", false),
    DIVINE_SUPER_STRENGTH(23709, GameTimerImageType.ITEM, "Divine Super Strength", false),
    DIVINE_SUPER_DEFENCE(23721, GameTimerImageType.ITEM, "Divine Super Defence", false),
    DIVINE_SUPER_COMBAT(23685, GameTimerImageType.ITEM, "Divine Super Combat", false),
    DIVINE_RANGING(23733, GameTimerImageType.ITEM, "Divine Ranging", false),
    DIVINE_MAGIC(23745, GameTimerImageType.ITEM, "Divine Magic", false),
    DIVINE_BASTION(24635, GameTimerImageType.ITEM, "Divine Bastion", false),
    DIVINE_BATTLEMAGE(24623, GameTimerImageType.ITEM, "Divine Battlemage", false),
    ANTIPOISON(2446, GameTimerImageType.ITEM, "Antipoison", false),
    ANTIVENOM(12905, GameTimerImageType.ITEM, "Anti-venom", false),
    TELEBLOCK(352, GameTimerImageType.SPRITE, "Teleblock", false),
    SHADOW_VEIL(1315, GameTimerImageType.SPRITE, "Shadow veil", true),
    RESURRECT_THRALL(2981, GameTimerImageType.SPRITE, "Resurrect thrall", false),
    WARD_OF_ARCEUUS(1306, GameTimerImageType.SPRITE, "Ward of Arceuus", true),
    DEATH_CHARGE(1310, GameTimerImageType.SPRITE, "Death charge", false),
    MARK_OF_DARKNESS(1305, GameTimerImageType.SPRITE, "Mark of Darkness", true),
    SHADOW_VEIL_COOLDOWN(1334, GameTimerImageType.SPRITE, "Shadow veil cooldown", 30L, ChronoUnit.SECONDS),
    RESURRECT_THRALL_COOLDOWN(2987, GameTimerImageType.SPRITE, "Resurrect thrall cooldown", 17L, RSTimeUnit.GAME_TICKS),
    WARD_OF_ARCEUUS_COOLDOWN(1325, GameTimerImageType.SPRITE, "Ward of Arceuus cooldown", 30L, ChronoUnit.SECONDS),
    DEATH_CHARGE_COOLDOWN(1329, GameTimerImageType.SPRITE, "Death charge cooldown", 60L, ChronoUnit.SECONDS),
    CORRUPTION_COOLDOWN(1327, GameTimerImageType.SPRITE, "Corruption cooldown", 30L, ChronoUnit.SECONDS),
    PICKPOCKET_STUN(206, GameTimerImageType.SPRITE, "Stunned", true),
    FARMERS_AFFINITY(1947, GameTimerImageType.ITEM, "Farmer's Affinity", false),
    INF_RESTORE(11473, GameTimerImageType.ITEM, "Infinite Restore", 30L, ChronoUnit.MINUTES, true),
    INF_PRAYER_POT(11481, GameTimerImageType.ITEM, "Infinite Prayer", 30L, ChronoUnit.MINUTES, true),
    INF_AGGRESSION(11429, GameTimerImageType.ITEM, "Infinite Aggression", 30L, ChronoUnit.MINUTES, true),
    RAIDERSBUFF(29532, GameTimerImageType.ITEM, "Raider Potion", 10L, ChronoUnit.MINUTES, true),
    INF_OVERLOAD(22999, GameTimerImageType.ITEM, "Infinite Overload", 60L, ChronoUnit.MINUTES, true),
    RAGE_POT(11433, GameTimerImageType.ITEM, "Double Damage & XP", 60L, ChronoUnit.MINUTES, true),
    UNICOW_ISLAND_TIMER(24366, GameTimerImageType.ITEM, "Unicow Island", false),
    COX_TIMER(20997, GameTimerImageType.ITEM, "Time in Chambers", false),
    XERIC_TIMER(22396, GameTimerImageType.ITEM, "Trials of Xeric time", false),
    SAFETY_BUFFER(25478, GameTimerImageType.ITEM, "Wilderness Saftey Buffer", TimeUnit.MINUTES.toMillis(30L) / 600L, ChronoUnit.MINUTES, true),
    BONUS_DAMAGE(25042, GameTimerImageType.ITEM, "Bonus Damage", TimeUnit.MINUTES.toMillis(10L) / 600L, ChronoUnit.MINUTES, true),
    BONUS_XP(2528, GameTimerImageType.ITEM, "Bonus XP", TimeUnit.MINUTES.toMillis(10L) / 600L, ChronoUnit.MINUTES, false),
    BONUS_SKILLING_PET_RATE(7968, GameTimerImageType.ITEM, "Bonus Skilling pet rate", TimeUnit.MINUTES.toMillis(10L) / 600L, ChronoUnit.MINUTES, false),
    BONUS_CLUES(24460, GameTimerImageType.ITEM, "Bonus Clues", TimeUnit.MINUTES.toMillis(10L) / 600L, ChronoUnit.MINUTES, false);

    @Nullable
    private final Duration duration;
    @Nullable
    private final Integer graphicId;
    private final String description;
    private final boolean removedOnDeath;
    private final int imageId;
    private final GameTimerImageType imageType;

    private GameTimer(int imageId, GameTimerImageType idType, String description2, Integer graphicId, long time, TemporalUnit unit, boolean removedOnDeath) {
        this.description = description2;
        this.graphicId = graphicId;
        this.duration = Duration.of(time, unit);
        this.imageId = imageId;
        this.imageType = idType;
        this.removedOnDeath = removedOnDeath;
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description2, long time, TemporalUnit unit, boolean removeOnDeath) {
        this(imageId, idType, description2, null, time, unit, removeOnDeath);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description2, long time, TemporalUnit unit) {
        this(imageId, idType, description2, null, time, unit, false);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description2, boolean removedOnDeath) {
        this.duration = null;
        this.graphicId = null;
        this.description = description2;
        this.removedOnDeath = removedOnDeath;
        this.imageId = imageId;
        this.imageType = idType;
    }

    @Nullable
    Duration getDuration() {
        return this.duration;
    }

    @Nullable
    Integer getGraphicId() {
        return this.graphicId;
    }

    String getDescription() {
        return this.description;
    }

    boolean isRemovedOnDeath() {
        return this.removedOnDeath;
    }

    int getImageId() {
        return this.imageId;
    }

    GameTimerImageType getImageType() {
        return this.imageType;
    }
}

