/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.widgets;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.plugins.sailingskill.widgets.BoatWidgetManager;
import net.runelite.client.plugins.sailingskill.widgets.MiscWidgetManager;
import net.runelite.client.plugins.sailingskill.widgets.TabIconManager;
import net.runelite.client.plugins.sailingskill.widgets.ToolsWidgetManager;

public class WidgetSetter {
    @Inject
    private BoatWidgetManager boatWidgetManager;
    @Inject
    private MiscWidgetManager miscWidgetManager;
    @Inject
    private ToolsWidgetManager toolsWidgetManager;
    @Inject
    private TabIconManager tabIconManager;
    @Inject
    private Client client;
    @Inject
    private SailingPlugin plugin;
    private final int CLASSIC_COMBAT_MENU = 35913807;
    private final int MODERN_COMBAT_MENU = 10747976;
    private final int CLASSIC_RESIZED_COMBAT_MENU = 10551371;

    public void setupUnknownTab() {
        Widget widget = this.client.getWidget(35913807);
        if (widget != null) {
            this.setupFixedTab();
            return;
        }
        widget = this.client.getWidget(10551371);
        if (widget != null) {
            this.setupResizableTab();
            return;
        }
        widget = this.client.getWidget(10747976);
        if (widget != null) {
            this.setupModernTab();
        }
    }

    public void setupFixedTab() {
        Widget widget = this.client.getWidget(35913807);
        if (widget == null) {
            return;
        }
        this.setupGeneralTab(widget);
        this.tabIconManager.setFixedSailingTab();
    }

    public void setupResizableTab() {
        Widget widget = this.client.getWidget(10551371);
        if (widget == null) {
            return;
        }
        this.setupGeneralTab(widget);
        this.tabIconManager.setResizableSailingTab();
    }

    public void setupModernTab() {
        Widget widget = this.client.getWidget(10747976);
        if (widget == null) {
            return;
        }
        this.setupGeneralTab(widget);
        this.tabIconManager.setModernSailingTab();
    }

    public void setupGeneralTab(Widget widget) {
        Widget[] children2 = widget.getNestedChildren();
        if (children2 != null) {
            for (int i = 0; i < children2.length; ++i) {
                Widget child = children2[i];
                child.setHidden(i == 0);
            }
        }
        this.boatWidgetManager.setupManager(widget);
        this.miscWidgetManager.setupManager(widget);
        this.toolsWidgetManager.setupManager(widget);
        this.tabIconManager.setAnchorSpriteOverride();
    }

    public void unsetFixedTab() {
        Widget widget = this.client.getWidget(35913807);
        if (widget == null) {
            return;
        }
        this.unsetTab(widget);
        this.tabIconManager.unsetFixedSailingTab();
    }

    public void unsetResizableTab() {
        Widget widget = this.client.getWidget(10551371);
        if (widget == null) {
            return;
        }
        this.unsetTab(widget);
        this.tabIconManager.unsetResizableSailingTab();
    }

    public void unsetModernTab() {
        Widget widget = this.client.getWidget(10747976);
        if (widget == null) {
            return;
        }
        this.unsetTab(widget);
        this.tabIconManager.unsetModernSailingTab();
    }

    public void unsetLastTab() {
        switch (this.plugin.getCurrentGameClientLayout()) {
            case CLASSIC: {
                Widget widget = this.client.getWidget(35913807);
                if (widget != null) {
                    this.unsetFixedTab();
                }
                return;
            }
            case RESIZED: {
                Widget widget = this.client.getWidget(10551371);
                if (widget != null) {
                    this.unsetResizableTab();
                }
                return;
            }
            case MODERN: {
                Widget widget = this.client.getWidget(10747976);
                if (widget == null) break;
                this.unsetModernTab();
            }
        }
    }

    public void unsetTab(Widget widget) {
        Widget[] children2 = widget.getNestedChildren();
        for (int i = 0; i < children2.length; ++i) {
            Widget child = children2[i];
            if (i != 0) continue;
            child.setHidden(false);
        }
        Widget[] dynamicChildren = widget.getDynamicChildren();
        if (dynamicChildren != null) {
            for (Widget child : dynamicChildren) {
                child.setHidden(true);
            }
        }
    }
}

