/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.overlays;

import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.plugins.sailingskill.overlays.XPDrop;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.ImageUtil;

public class XPDropOverlay
extends Overlay {
    private final Client client;
    private final SailingPlugin plugin;
    BufferedImage skillImage = ImageUtil.loadImageResource(this.getClass(), "Skill_Icon.png");
    BufferedImage rangedSkillImage = ImageUtil.loadImageResource(this.getClass(), "ranged.png");
    BufferedImage fishingSkillImage = ImageUtil.loadImageResource(this.getClass(), "Fishing_icon.png");

    @Inject
    private XPDropOverlay(Client client, SailingPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.LOW);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        int yPos;
        int timer;
        XPDrop xpDrop;
        int i;
        Widget xpDisplay = this.client.getWidget(WidgetInfo.EXPERIENCE_TRACKER_WIDGET);
        ArrayList<XPDrop> xpSailingDrops = this.plugin.getXpSailingDrops();
        ArrayList<XPDrop> xpCannonDrops = this.plugin.getXpCannonDrops();
        ArrayList<XPDrop> xpFishDrops = this.plugin.getXpFishDrops();
        if (xpDisplay == null) {
            xpSailingDrops.clear();
            xpCannonDrops.clear();
            return null;
        }
        int x = xpDisplay.getRelativeX();
        int y = xpDisplay.getRelativeY();
        for (i = 0; i < xpSailingDrops.size(); ++i) {
            xpDrop = xpSailingDrops.get(i);
            timer = xpDrop.getTimer();
            xpDrop.setTimer(timer - 1);
            yPos = xpDrop.getYPosition();
            xpDrop.setYPosition(yPos - 1);
            if (timer == 0) {
                xpSailingDrops.remove(xpDrop);
                continue;
            }
            graphics.drawImage((Image)this.skillImage, x + 85, y + yPos, null);
        }
        for (i = 0; i < xpCannonDrops.size(); ++i) {
            xpDrop = xpCannonDrops.get(i);
            timer = xpDrop.getTimer();
            xpDrop.setTimer(timer - 1);
            yPos = xpDrop.getYPosition();
            xpDrop.setYPosition(yPos - 1);
            if (timer == 0) {
                xpCannonDrops.remove(xpDrop);
                continue;
            }
            graphics.drawImage((Image)this.skillImage, x + 85, y + yPos, null);
            graphics.drawImage((Image)this.rangedSkillImage, x + 85, y + yPos + 30, null);
        }
        for (i = 0; i < xpFishDrops.size(); ++i) {
            xpDrop = xpFishDrops.get(i);
            timer = xpDrop.getTimer();
            xpDrop.setTimer(timer - 1);
            yPos = xpDrop.getYPosition();
            xpDrop.setYPosition(yPos - 1);
            if (timer == 0) {
                xpFishDrops.remove(xpDrop);
                continue;
            }
            graphics.drawImage((Image)this.skillImage, x + 85, y + yPos, null);
            graphics.drawImage((Image)this.fishingSkillImage, x + 85, y + yPos + 30, null);
        }
        return null;
    }
}

