/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.overlays;

import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.plugins.sailingskill.overlays.FishDrop;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ImageUtil;

public class FishOverlay
extends Overlay {
    private final Client client;
    private final SailingPlugin plugin;
    BufferedImage grouperImage = ImageUtil.loadImageResource(this.getClass(), "Fish_Grouper.png");
    BufferedImage marlinImage = ImageUtil.loadImageResource(this.getClass(), "Fish_Marlin.png");
    BufferedImage sturgeonImage = ImageUtil.loadImageResource(this.getClass(), "Fish_Sturgeon.png");
    BufferedImage rodImage = ImageUtil.loadImageResource(this.getClass(), "Fishing_rod.png");

    @Inject
    private FishOverlay(Client client, SailingPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.LOW);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getShipObject() == null) {
            return null;
        }
        if (this.plugin.isFishing()) {
            LocalPoint localPoint = this.plugin.getShipObject().getLocation();
            if (localPoint == null) {
                return null;
            }
            Point point = Perspective.getCanvasImageLocation(this.client, localPoint, this.marlinImage, 0);
            OverlayUtil.renderImageLocation(graphics, point, this.rodImage);
            ArrayList<FishDrop> fishList = this.plugin.getFishDrops();
            for (int i = 0; i < fishList.size(); ++i) {
                BufferedImage image;
                FishDrop fishDrop = fishList.get(i);
                int timer = fishDrop.getTimer();
                int nextTimer = timer - 1;
                if (nextTimer == 0) {
                    fishList.remove(fishDrop);
                    continue;
                }
                fishDrop.setTimer(nextTimer);
                switch (fishDrop.getId()) {
                    default: {
                        image = this.marlinImage;
                        break;
                    }
                    case 2: {
                        image = this.grouperImage;
                        break;
                    }
                    case 3: {
                        image = this.sturgeonImage;
                    }
                }
                OverlayUtil.renderImageLocation(graphics, point, image);
            }
        }
        return null;
    }
}

