/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.overlays;

import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.sailingskill.SailingConfig;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class CannonOverlay
extends Overlay {
    private final Client client;
    private final SailingPlugin plugin;

    @Inject
    private CannonOverlay(Client client, SailingConfig config, SailingPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.NONE);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getShipObject() == null) {
            return null;
        }
        if (this.plugin.isShowCannonRange() && this.plugin.getCannonTiles() != null) {
            for (Tile tile : this.plugin.getCannonTiles()) {
                LocalPoint localPoint = tile.getLocalLocation();
                this.renderTile(graphics, localPoint, Color.RED, 0.0, new Color(255, 0, 0, 20));
            }
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, LocalPoint dest, Color color, double borderWidth, Color fillColor) {
        if (dest == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly(this.client, dest);
        if (poly == null) {
            return;
        }
        OverlayUtil.renderPolygon(graphics, poly, fillColor, fillColor, new BasicStroke((float)borderWidth));
    }
}

