/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill;

import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.Animation;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Model;
import net.runelite.api.Player;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.sailingskill.BoatMaths;
import net.runelite.client.plugins.sailingskill.BoatTool;
import net.runelite.client.plugins.sailingskill.ModelHandler;
import net.runelite.client.plugins.sailingskill.SailingConfig;
import net.runelite.client.plugins.sailingskill.combat.CannonRange;
import net.runelite.client.plugins.sailingskill.combat.HitSplat;
import net.runelite.client.plugins.sailingskill.combat.Projectile;
import net.runelite.client.plugins.sailingskill.npcs.NPCCharacter;
import net.runelite.client.plugins.sailingskill.npcs.NPCRegions;
import net.runelite.client.plugins.sailingskill.npcs.NPCSize;
import net.runelite.client.plugins.sailingskill.npcs.NPCSpawns;
import net.runelite.client.plugins.sailingskill.npcs.NPCType;
import net.runelite.client.plugins.sailingskill.overlays.CannonOverlay;
import net.runelite.client.plugins.sailingskill.overlays.FishDrop;
import net.runelite.client.plugins.sailingskill.overlays.FishOverlay;
import net.runelite.client.plugins.sailingskill.overlays.GuideOverlay;
import net.runelite.client.plugins.sailingskill.overlays.HitsplatOverlay;
import net.runelite.client.plugins.sailingskill.overlays.XPDrop;
import net.runelite.client.plugins.sailingskill.overlays.XPDropOverlay;
import net.runelite.client.plugins.sailingskill.trials.TrialObject;
import net.runelite.client.plugins.sailingskill.trials.TrialRegions;
import net.runelite.client.plugins.sailingskill.widgets.GameClientLayout;
import net.runelite.client.plugins.sailingskill.widgets.WidgetSetter;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Sailing", description="Allows you to test some basic mechanics of a Sailing skill", tags={"sailing", "skill", "game mode", "gamemode"}, enabledByDefault=false, hidden=true)
public class SailingPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(SailingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SailingConfig config;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CannonOverlay cannonOverlay;
    @Inject
    private GuideOverlay guideOverlay;
    @Inject
    private HitsplatOverlay hitsplatOverlay;
    @Inject
    private XPDropOverlay xpDropOverlay;
    @Inject
    private FishOverlay fishOverlay;
    @Inject
    private ModelHandler modelHandler;
    @Inject
    private WidgetSetter widgetSetter;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private GameClientLayout currentGameClientLayout;
    private int currentTrial = -1;
    private int currentNPCSpawns = -1;
    private boolean modelsLoaded;
    private Model shipModel0;
    private Model shipModelN45;
    private Model shipModelN90;
    private Model shipModelP45;
    private Model shipModelP90;
    private Tile lastSelectedTile;
    private RuneLiteObject shipObject;
    private int buildBoatTimer = 0;
    private int BUILD_BOAT_TIMER_START = 10;
    private boolean anchorMode = true;
    private boolean showCannonRange = false;
    private ArrayList<Tile> cannonTiles;
    private boolean enableKeyboardControl = true;
    private boolean fireCannon = false;
    private int cannonCoolDown = 0;
    private boolean fishing = false;
    private final Random random = new Random();
    private int speed = 1;
    private int boatMomentum = 0;
    private int windDirection = 0;
    private int absoluteBoatOrientation;
    private int sailLength;
    private int boatRotationQueue = 0;
    private int sailLengthQueue = 0;
    private int windChangeTimer = 0;
    private int healthBarTimer = 0;
    private int currentHealth = 0;
    private int maxHealth = 0;
    private boolean deathState = false;
    private BoatTool currentBoatTool = BoatTool.CANNON;
    private int xpDropAccumulator = 0;
    private final int WATER_OVERLAY_ID = 6;
    private final int REGION_PIRATES_COVE = 5;
    private final int PROJECTILE_HIT_RANGE = 6;
    private final ArrayList<RuneLiteObject> configObjects = new ArrayList();
    private final ArrayList<RuneLiteObject> fishObjects = new ArrayList();
    private final ArrayList<NPCCharacter> npcCharacters = new ArrayList();
    private final ArrayList<NPCCharacter> regionNPCs = new ArrayList();
    private final ArrayList<Projectile> activeProjectiles = new ArrayList();
    private final ArrayList<HitSplat> hitSplats = new ArrayList();
    private final ArrayList<XPDrop> xpSailingDrops = new ArrayList();
    private final ArrayList<XPDrop> xpCannonDrops = new ArrayList();
    private final ArrayList<XPDrop> xpFishDrops = new ArrayList();
    private final ArrayList<FishDrop> fishDrops = new ArrayList();
    private Model model;
    private int vertexFileSize;
    private int faceFileSize;

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.cannonOverlay);
        this.overlayManager.add(this.guideOverlay);
        this.overlayManager.add(this.hitsplatOverlay);
        this.overlayManager.add(this.xpDropOverlay);
        this.overlayManager.add(this.fishOverlay);
        this.keyManager.registerKeyListener(this);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.cannonOverlay);
        this.overlayManager.remove(this.guideOverlay);
        this.overlayManager.remove(this.hitsplatOverlay);
        this.overlayManager.remove(this.xpDropOverlay);
        this.overlayManager.remove(this.fishOverlay);
        this.clientThread.invoke(this::despawnBoat);
        this.clientThread.invoke(this::clearTrialSet);
        this.currentTrial = 0;
        this.currentNPCSpawns = 0;
        this.keyManager.unregisterKeyListener(this);
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        RuneLiteObject runeLiteObject;
        this.updateProjectilePosition();
        this.updatePlayerHitSplats();
        for (NPCCharacter npc : this.npcCharacters) {
            runeLiteObject = npc.getRuneLiteObject();
            if (runeLiteObject.getAnimation() == npc.getAttackAnimation() && runeLiteObject.getAnimationFrame() == npc.getAttackAnimFrames()) {
                runeLiteObject.setAnimation(npc.getIdleAnimation());
            }
            if (runeLiteObject.getAnimation() != this.modelHandler.krakenBiteAnimation || runeLiteObject.getAnimationFrame() != 9) continue;
            runeLiteObject.setAnimation(npc.getIdleAnimation());
        }
        for (int i = 0; i < this.npcCharacters.size(); ++i) {
            NPCCharacter npc;
            npc = this.npcCharacters.get(i);
            runeLiteObject = npc.getRuneLiteObject();
            if (runeLiteObject.isActive()) continue;
            npc.setHealthBarTimer(0);
            this.npcCharacters.remove(npc);
        }
        this.updateNPCOrientation();
        if (this.deathState && !this.shipObject.isActive()) {
            this.despawnBoat();
            this.deathState = false;
            return;
        }
        if (this.shipObject == null || this.speed == 0 || this.deathState) {
            this.boatMomentum = 0;
            return;
        }
        int finalSpeed = this.speed;
        if (this.boatMomentum > 0) {
            --this.boatMomentum;
            ++finalSpeed;
        }
        int orientation = BoatMaths.translateOrientation(this.absoluteBoatOrientation);
        int currentSceneX = this.shipObject.getLocation().getSceneX();
        int currentSceneY = this.shipObject.getLocation().getSceneY();
        int[] bestAvailableWaterTile = this.checkTileCollision(finalSpeed);
        if (currentSceneX == bestAvailableWaterTile[0] && currentSceneY == bestAvailableWaterTile[1]) {
            this.boatMomentum = 0;
            return;
        }
        int tickMod = 30 / finalSpeed;
        if (this.client.getGameCycle() % tickMod == 0) {
            int modifierX = this.getXMovement(orientation);
            int modifierZ = this.getYMovement(orientation);
            LocalPoint localPoint = LocalPoint.fromScene(currentSceneX + modifierX, currentSceneY + modifierZ);
            this.shipObject.setLocation(localPoint, 0);
        }
        ++this.xpDropAccumulator;
    }

    public void updateProjectilePosition() {
        for (int i = 0; i < this.activeProjectiles.size(); ++i) {
            Projectile projectile = this.activeProjectiles.get(i);
            projectile.setTimer(projectile.getTimer() + 1);
            RuneLiteObject projectileObject = projectile.getProjectile();
            if (projectileObject == null) continue;
            if (projectile.isTargetsPlayer()) {
                int currentProjectileX = projectileObject.getLocation().getX();
                int currentProjectileY = projectileObject.getLocation().getY();
                int boatX = this.shipObject.getLocation().getX();
                int boatY = this.shipObject.getLocation().getY();
                int xDifference = boatX - currentProjectileX;
                int yDifference = boatY - currentProjectileY;
                if (Math.abs(xDifference) < 6 && Math.abs(yDifference) < 6) {
                    projectileObject.setActive(false);
                    this.activeProjectiles.remove(projectile);
                    if (this.deathState) continue;
                    int damageRoll = this.random.nextInt(projectile.getMaxHit()) + 1;
                    double speedDefenseMod = (double)(this.speed - 1) / 10.0;
                    damageRoll -= (int)((double)damageRoll * speedDefenseMod);
                    int nextHealth = this.currentHealth - damageRoll;
                    int hitSplatPosition = this.hitSplats.size() + 1;
                    if (this.hitSplats.size() > 4) {
                        HitSplat lastHitSplat = this.hitSplats.get(0);
                        for (HitSplat hitSplat : this.hitSplats) {
                            if (hitSplat.getHitTimer() <= lastHitSplat.getHitTimer()) continue;
                            lastHitSplat = hitSplat;
                            hitSplatPosition = hitSplat.getSplatPosition();
                        }
                    }
                    HitSplat hitSplat = new HitSplat(damageRoll, 80, hitSplatPosition);
                    this.hitSplats.add(0, hitSplat);
                    this.healthBarTimer = 400;
                    if (nextHealth <= 0) {
                        hitSplat.setHitValue(this.currentHealth);
                        this.currentHealth = 0;
                        this.shipObject.setShouldLoop(false);
                        this.shipObject.setAnimation(this.modelHandler.fireAnimation);
                        RuneLiteObject fire = this.client.createRuneLiteObject();
                        fire.setModel(this.modelHandler.fireModel);
                        fire.setAnimation(this.modelHandler.fireAnimation);
                        fire.setLocation(this.shipObject.getLocation(), 0);
                        fire.setActive(true);
                        this.deathState = true;
                    } else {
                        this.currentHealth = nextHealth;
                    }
                } else {
                    int newX = xDifference * projectile.getTimer() / 80 + currentProjectileX;
                    int newY = yDifference * projectile.getTimer() / 80 + currentProjectileY;
                    projectileObject.setLocation(new LocalPoint(newX, newY), 0);
                }
            }
            if (projectile.isTargetsPlayer()) continue;
            NPCCharacter npc = projectile.getTarget();
            RuneLiteObject target = npc.getRuneLiteObject();
            if (!npc.isDying()) {
                int currentProjectileX = projectileObject.getLocation().getX();
                int currentProjectileY = projectileObject.getLocation().getY();
                int currentTargetX = target.getLocation().getX();
                int currentTargetY = target.getLocation().getY();
                int xDifference = currentTargetX - currentProjectileX;
                int yDifference = currentTargetY - currentProjectileY;
                if (Math.abs(xDifference) < 6 && Math.abs(yDifference) < 6) {
                    int currentHealth = npc.getCurrentHealth();
                    int damageVariation = this.random.nextInt(projectile.getMaxHit()) + 5;
                    int nextHealth = currentHealth - damageVariation;
                    if (!npc.isDying()) {
                        npc.setLastHit(damageVariation);
                        npc.setHitTimer(80);
                        npc.setHealthBarTimer(400);
                        npc.setCurrentHealth(nextHealth);
                        if (nextHealth <= 0) {
                            npc.setLastHit(currentHealth);
                            target.setShouldLoop(false);
                            target.setAnimation(npc.getDeathAnimation());
                            if (npc.getNpcType() == NPCType.MERCHANT) {
                                RuneLiteObject fire = this.client.createRuneLiteObject();
                                fire.setModel(this.modelHandler.fireModel);
                                fire.setAnimation(this.modelHandler.fireAnimation);
                                fire.setLocation(target.getLocation(), 0);
                                fire.setActive(true);
                            }
                            npc.setDying(true);
                        }
                    }
                    projectileObject.setActive(false);
                    this.activeProjectiles.remove(projectile);
                    continue;
                }
                int newX = xDifference * projectile.getTimer() / 50 + currentProjectileX;
                int newY = yDifference * projectile.getTimer() / 50 + currentProjectileY;
                projectileObject.setLocation(new LocalPoint(newX, newY), 0);
                continue;
            }
            projectileObject.setActive(false);
            this.activeProjectiles.remove(projectile);
        }
    }

    public void updatePlayerHitSplats() {
        for (int i = 0; i < this.hitSplats.size(); ++i) {
            HitSplat hitSplat = this.hitSplats.get(i);
            if (hitSplat.getHitTimer() > 0) continue;
            this.hitSplats.remove(hitSplat);
        }
    }

    public void updateNPCOrientation() {
        for (NPCCharacter npc : this.npcCharacters) {
            if (npc.isDying() || !npc.isChasing()) continue;
            RuneLiteObject runeLiteObject = npc.getRuneLiteObject();
            double currentShipX = this.shipObject.getLocation().getX();
            double currentShipY = this.shipObject.getLocation().getY();
            double currentNPCX = runeLiteObject.getLocation().getX();
            double currentNPCY = runeLiteObject.getLocation().getY();
            double xDifference = currentNPCX - currentShipX;
            double yDifference = currentNPCY - currentShipY;
            double angle = 0.0;
            double npcToShipAngle = Math.abs(Math.atan(yDifference / xDifference));
            if (xDifference > 0.0 && yDifference <= 0.0) {
                angle = npcToShipAngle + 4.71238898038469;
            } else if (xDifference >= 0.0 && yDifference > 0.0) {
                angle = Math.atan(xDifference / yDifference) + Math.PI;
            } else if (xDifference < 0.0 && yDifference >= 0.0) {
                angle = npcToShipAngle + 1.5707963267948966;
            } else if (xDifference <= 0.0 && yDifference < 0.0) {
                angle = Math.atan(xDifference / yDifference);
            }
            int nextOrientation = (int)(angle * 1024.0 / Math.PI - 1024.0);
            if (nextOrientation < 0) {
                nextOrientation += 2048;
            }
            runeLiteObject.setOrientation(nextOrientation);
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (event.getFirstEntry().getType().equals((Object)MenuAction.WALK)) {
            this.setWaterTileRightClick();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == WidgetInfo.FIXED_VIEWPORT_COMBAT_TAB.getGroupId()) {
            this.currentGameClientLayout = GameClientLayout.CLASSIC;
            if (this.shipObject == null) {
                return;
            }
            this.widgetSetter.setupFixedTab();
        }
        if (event.getGroupId() == WidgetInfo.RESIZABLE_VIEWPORT_COMBAT_TAB.getGroupId()) {
            this.currentGameClientLayout = GameClientLayout.RESIZED;
            if (this.shipObject == null) {
                return;
            }
            this.widgetSetter.setupResizableTab();
        }
        if (event.getGroupId() == WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_COMBAT_ICON.getGroupId()) {
            this.currentGameClientLayout = GameClientLayout.MODERN;
            if (this.shipObject == null) {
                return;
            }
            this.widgetSetter.setupModernTab();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            this.despawnBoat();
            this.deathState = false;
            return;
        }
        this.currentTrial = 0;
        this.currentNPCSpawns = 0;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.modelsLoaded) {
            this.modelHandler.loadModels();
            this.shipModel0 = this.modelHandler.shipModel0;
            this.shipModelN45 = this.modelHandler.shipModelN45;
            this.shipModelN90 = this.modelHandler.shipModelN90;
            this.shipModelP45 = this.modelHandler.shipModelP45;
            this.shipModelP90 = this.modelHandler.shipModelP90;
            this.modelsLoaded = true;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.checkRegionChanges();
        if (this.buildBoatTimer > 0) {
            --this.buildBoatTimer;
            Player player = this.client.getLocalPlayer();
            if (this.buildBoatTimer == 0) {
                this.buildBoat();
                player.setIdlePoseAnimation(808);
            } else if (player.getIdlePoseAnimation() != 898) {
                player.setIdlePoseAnimation(898);
            }
        }
        if (this.shipObject != null) {
            this.updateBoatOrientation();
            this.updateSailLength();
            this.recalculateSpeed();
            this.updateCannonRange();
            this.fireCannon();
            this.checkXPDrop();
            this.checkFishingCatch();
            this.updateCamera();
            this.updateNPCAggression();
            this.fireNPCProjectiles();
        }
        this.updateNPCPositions();
    }

    public void checkRegionChanges() {
        Player player = this.client.getLocalPlayer();
        WorldPoint worldPoint = WorldPoint.fromLocalInstance(this.client, player.getLocalLocation());
        int regionId = worldPoint.getRegionID();
        boolean withinTrialRegion = false;
        int startTrialObject = 0;
        int endTrialObject = 0;
        int nextTrial = 0;
        block0: for (TrialRegions reg : TrialRegions.values()) {
            for (int region : reg.getRegionArray()) {
                if (regionId != region) continue;
                startTrialObject = reg.getStartTrialObject();
                endTrialObject = reg.getEndTrialObject();
                withinTrialRegion = true;
                nextTrial = reg.getTrialId();
                continue block0;
            }
        }
        if (withinTrialRegion && this.client.getPlane() == 0) {
            if (this.currentTrial != nextTrial) {
                this.currentTrial = nextTrial;
                this.deployTrialSet(startTrialObject, endTrialObject);
            }
        } else {
            this.currentTrial = 0;
            this.clearTrialSet();
        }
        boolean withinNPCRegion = false;
        int startNPC = 0;
        int endNPC = 0;
        int nextNPCSpawn = 0;
        block2: for (NPCRegions reg : NPCRegions.values()) {
            for (int region : reg.getRegionArray()) {
                if (regionId != region) continue;
                startNPC = reg.getStartNPC();
                endNPC = reg.getEndNPC();
                withinNPCRegion = true;
                nextNPCSpawn = reg.getTrialId();
                continue block2;
            }
        }
        if (withinNPCRegion && this.client.getPlane() == 0) {
            if (this.currentNPCSpawns != nextNPCSpawn) {
                this.currentNPCSpawns = nextNPCSpawn;
                this.deployNPCSet(startNPC, endNPC);
            }
        } else {
            this.currentNPCSpawns = 0;
            this.clearRegionNPCSet();
        }
    }

    public void updateBoatOrientation() {
        if (this.boatRotationQueue > 0) {
            this.absoluteBoatOrientation += 256;
            if (this.absoluteBoatOrientation == 2048) {
                this.absoluteBoatOrientation = 0;
            }
            this.shipObject.setOrientation(this.absoluteBoatOrientation);
            --this.boatRotationQueue;
        }
        if (this.boatRotationQueue < 0) {
            this.absoluteBoatOrientation -= 256;
            if (this.absoluteBoatOrientation == -256) {
                this.absoluteBoatOrientation = 1792;
            }
            this.shipObject.setOrientation(this.absoluteBoatOrientation);
            ++this.boatRotationQueue;
        }
    }

    public void updateSailLength() {
        int newSailLength = this.sailLength + this.sailLengthQueue;
        this.sailLengthQueue = 0;
        if (newSailLength < 0) {
            this.sailLength = 0;
            this.anchorMode = true;
            return;
        }
        this.sailLength = Math.min(newSailLength, 3);
        this.anchorMode = false;
    }

    public void recalculateSpeed() {
        if (this.shipObject == null) {
            return;
        }
        if (this.anchorMode || this.sailLength == 0) {
            this.speed = 0;
            this.boatMomentum = 0;
            return;
        }
        int newSpeed = this.sailLength;
        if (this.speed > newSpeed) {
            this.boatMomentum = 30;
        }
        this.speed = newSpeed;
    }

    public void updateWindDirection() {
        ++this.windChangeTimer;
        if (this.windChangeTimer >= this.config.windChangeRate()) {
            int roll = this.random.nextInt(8) * 256;
            while (roll == this.windDirection) {
                roll = this.random.nextInt(8) * 256;
            }
            this.windDirection = roll;
            this.windChangeTimer = 0;
        }
    }

    public void updateBoatModel() {
        int currentBoatOrientation = BoatMaths.translateOrientation(this.absoluteBoatOrientation);
        int difference = BoatMaths.boundOrientation(currentBoatOrientation - this.windDirection) / 256;
        Model lastModel = this.shipObject.getModel();
        switch (difference) {
            case 0: {
                this.shipObject.setModel(this.shipModel0);
                break;
            }
            case 1: {
                this.shipObject.setModel(this.shipModelN45);
                break;
            }
            case 2: 
            case 3: {
                this.shipObject.setModel(this.shipModelN90);
                break;
            }
            case 4: {
                if (lastModel == this.shipModelN45 || lastModel == this.shipModelN90 || lastModel == this.shipModel0) {
                    this.shipObject.setModel(this.shipModelN90);
                    break;
                }
                this.shipObject.setModel(this.shipModelP90);
                break;
            }
            case 5: 
            case 6: {
                this.shipObject.setModel(this.shipModelP90);
                break;
            }
            case 7: {
                this.shipObject.setModel(this.shipModelP45);
            }
        }
    }

    public void updateCannonRange() {
        int currentX = this.shipObject.getLocation().getSceneX();
        int currentY = this.shipObject.getLocation().getSceneY();
        int direction = BoatMaths.translateOrientation(this.absoluteBoatOrientation);
        int directionX = 0;
        int directionY = 0;
        switch (direction) {
            default: {
                --directionY;
                break;
            }
            case 256: {
                --directionY;
                --directionX;
                break;
            }
            case 512: {
                --directionX;
                break;
            }
            case 768: {
                ++directionY;
                --directionX;
                break;
            }
            case 1024: {
                ++directionY;
                break;
            }
            case 1280: {
                ++directionY;
                ++directionX;
                break;
            }
            case 1536: {
                ++directionX;
                break;
            }
            case 1792: {
                ++directionX;
                --directionY;
            }
        }
        int[] cannonRangeX = CannonRange.getCannonX(direction);
        int[] cannonRangeY = CannonRange.getCannonY(direction);
        int finalSpeed = this.speed;
        if (this.boatMomentum > 0) {
            ++finalSpeed;
        }
        if (this.anchorMode) {
            finalSpeed = 0;
        }
        int changeX = directionX * finalSpeed;
        int changeY = directionY * finalSpeed;
        this.cannonTiles = this.getTiles(currentX + changeX, currentY + changeY, cannonRangeX, cannonRangeY);
    }

    public void fireCannon() {
        if (this.cannonCoolDown > 0) {
            --this.cannonCoolDown;
            this.fireCannon = false;
            return;
        }
        if (this.deathState) {
            return;
        }
        if (this.fireCannon) {
            boolean targetExists = false;
            this.fireCannon = false;
            block0: for (NPCCharacter npc : this.npcCharacters) {
                if (npc.isDying()) continue;
                RuneLiteObject runeLiteObject = npc.getRuneLiteObject();
                for (Tile tile : this.cannonTiles) {
                    LocalPoint npcLocation;
                    LocalPoint tileLocation = tile.getLocalLocation();
                    if (tileLocation.distanceTo(npcLocation = runeLiteObject.getLocation()) > npc.getNpcSize().getHitboxRadius()) continue;
                    targetExists = true;
                    this.spawnProjectile(npc, this.shipTypeMaxHit(), this.shipObject.getLocation(), this.modelHandler.cannonballModel, null, false);
                    continue block0;
                }
            }
            if (targetExists) {
                XPDrop xpDrop = new XPDrop(false, true, 325, 350);
                this.xpCannonDrops.add(xpDrop);
                this.cannonCoolDown = 1;
            } else {
                this.sendChatMessage("There are no valid targets to fire on!");
            }
        }
    }

    public void checkXPDrop() {
        if (this.xpDropAccumulator >= 120) {
            this.xpDropAccumulator = 0;
            XPDrop xpDrop = new XPDrop(false, false, 325, 350);
            this.xpSailingDrops.add(xpDrop);
        }
    }

    public void checkFishingCatch() {
        if (!this.fishing || !this.validFishingTile()) {
            this.fishing = false;
            return;
        }
        if (this.client.getTickCount() % 12 > 0) {
            return;
        }
        this.xpFishDrops.add(new XPDrop(false, true, 325, 350));
        switch (this.currentTrial) {
            default: {
                this.sendChatMessage("You catch a marlin.");
                FishDrop fishDrop = new FishDrop(1, 100);
                this.fishDrops.add(fishDrop);
                break;
            }
            case 4: {
                this.sendChatMessage("You catch a grouper.");
                FishDrop fishDrop = new FishDrop(2, 100);
                this.fishDrops.add(fishDrop);
                break;
            }
            case 5: {
                this.sendChatMessage("You catch a sturgeon.");
                FishDrop fishDrop = new FishDrop(3, 100);
                this.fishDrops.add(fishDrop);
            }
        }
    }

    public void updateCamera() {
        if (!this.config.enableAutoCamera()) {
            return;
        }
        int direction = -1;
        int boatOrientation = BoatMaths.translateOrientation(this.absoluteBoatOrientation);
        switch (boatOrientation) {
            case 1024: {
                direction = 1;
                break;
            }
            case 1536: {
                direction = 2;
                break;
            }
            case 0: {
                direction = 3;
                break;
            }
            case 512: {
                direction = 4;
            }
        }
        if (direction == -1) {
            return;
        }
        this.client.runScript(1050, direction);
    }

    public void updateNPCAggression() {
        for (NPCCharacter npc : this.npcCharacters) {
            if (!npc.isAggressive()) continue;
            if (this.deathState) {
                npc.setAttacking(false);
                npc.setChasing(false);
                continue;
            }
            LocalPoint shipLocation = this.shipObject.getLocation();
            RuneLiteObject npcObject = npc.getRuneLiteObject();
            LocalPoint npcLocation = npcObject.getLocation();
            int distance = npcLocation.distanceTo(shipLocation);
            int attackRange = npc.getAttackRange() * 128;
            int chaseRange = npc.getChaseRange() * 128;
            int krakenBiteRange = 1408;
            if (distance <= attackRange) {
                npc.setAttacking(true);
                npc.setChasing(true);
            } else if (distance <= chaseRange) {
                npc.setAttacking(false);
                npc.setChasing(true);
            } else {
                npc.setAttacking(false);
                npc.setChasing(false);
            }
            if (npc.getNpcType() != NPCType.KRAKEN_BOSS) continue;
            if (distance <= krakenBiteRange) {
                npc.setKrakenBossBite(true);
                return;
            }
            npc.setKrakenBossBite(false);
        }
    }

    public void fireNPCProjectiles() {
        for (NPCCharacter npc : this.npcCharacters) {
            int coolDown = npc.getCoolDownTimer();
            if (coolDown > 0) {
                npc.setCoolDownTimer(coolDown - 1);
                continue;
            }
            if (!npc.isAggressive() || npc.isDying() || !npc.isAttacking()) continue;
            RuneLiteObject runeLiteObject = npc.getRuneLiteObject();
            if (npc.isKrakenBossBite()) {
                this.spawnProjectile(null, 400, runeLiteObject.getLocation(), this.modelHandler.emptyModel, null, true);
                runeLiteObject.setAnimation(this.modelHandler.krakenBiteAnimation);
            } else {
                int maxHit = npc.getMaxHit();
                if (npc.getNpcType() == NPCType.KRAKEN_TENTACLE && (this.speed > 2 || this.speed > 1 && this.boatMomentum > 0)) {
                    maxHit = 5;
                    this.sendChatMessage("Your speed prevents the tentacle from scoring a direct hit.");
                }
                this.spawnProjectile(null, maxHit, runeLiteObject.getLocation(), npc.getProjectileModel(), npc.getProjectileAnimation(), true);
                runeLiteObject.setAnimation(npc.getAttackAnimation());
            }
            npc.setCoolDownTimer(npc.getAttackSpeed());
        }
    }

    public void updateNPCPositions() {
        for (NPCCharacter npc : this.npcCharacters) {
            int xShift;
            if (npc.isDying() || npc.isStationary()) continue;
            NPCType type2 = npc.getNpcType();
            RuneLiteObject runeLiteObject = npc.getRuneLiteObject();
            LocalPoint localPoint = runeLiteObject.getLocation();
            int plane = 0;
            if (type2 == NPCType.KRAKEN || type2 == NPCType.CROCODILE) {
                if (!npc.isChasing() || npc.isAttacking() || this.shipObject == null) continue;
                int currentNPCX = localPoint.getSceneX();
                int currentNPCY = localPoint.getSceneY();
                int boatX = this.shipObject.getLocation().getSceneX();
                int boatY = this.shipObject.getLocation().getSceneY();
                int xDifference = boatX - currentNPCX;
                int yDifference = boatY - currentNPCY;
                if (xDifference == 0 && yDifference == 0) continue;
                int xShift2 = 0;
                int yShift = 0;
                if (xDifference > 0) {
                    xShift2 = 1;
                }
                if (xDifference < 0) {
                    xShift2 = -1;
                }
                if (yDifference > 0) {
                    yShift = 1;
                }
                if (yDifference < 0) {
                    yShift = -1;
                }
                boolean moveTileX = false;
                boolean moveTileY = false;
                LocalPoint localPointX = LocalPoint.fromScene(currentNPCX + xShift2, currentNPCY);
                if (xShift2 != 0 && this.getTileOverlay(localPointX) == 6) {
                    moveTileX = true;
                }
                LocalPoint localPointY = LocalPoint.fromScene(currentNPCX, currentNPCY + yShift);
                if (yShift != 0 && this.getTileOverlay(localPointY) == 6) {
                    moveTileY = true;
                }
                if (moveTileX && moveTileY) {
                    LocalPoint localPointXY = LocalPoint.fromScene(currentNPCX + xShift2, currentNPCY + yShift);
                    if (this.getTileOverlay(localPointXY) == 6) {
                        runeLiteObject.setLocation(localPointXY, plane);
                    }
                } else if (moveTileX) {
                    runeLiteObject.setLocation(localPointX, plane);
                } else if (moveTileY) {
                    runeLiteObject.setLocation(localPointY, plane);
                }
                if ((moveTileX || moveTileY) && npc.getNpcType() == NPCType.CROCODILE) {
                    runeLiteObject.setAnimation(npc.getWalkAnimation());
                } else if (!moveTileX && !moveTileY && npc.getNpcType() == NPCType.CROCODILE) {
                    runeLiteObject.setAnimation(npc.getIdleAnimation());
                }
            }
            if (type2 != NPCType.GULL) continue;
            if (this.client.getTickCount() / 10 % 2 == 0) {
                xShift = -1;
                runeLiteObject.setOrientation(512);
            } else {
                xShift = 1;
                runeLiteObject.setOrientation(1536);
            }
            LocalPoint nextPosition = LocalPoint.fromScene(localPoint.getSceneX() + xShift, localPoint.getSceneY());
            runeLiteObject.setLocation(nextPosition, 0);
        }
    }

    public void deployNPCSet(int firstNPC, int lastNPC) {
        block8: for (int i = firstNPC; i < lastNPC; ++i) {
            NPCSpawns npcSpawns = NPCSpawns.values()[i];
            LocalPoint localPoint = LocalPoint.fromWorld(this.client, npcSpawns.getXLocation(), npcSpawns.getYLocation());
            switch (npcSpawns.getNpcType()) {
                case MERCHANT: {
                    this.spawnDummy(localPoint, true);
                    continue block8;
                }
                case KRAKEN: {
                    this.spawnKraken(localPoint, true);
                    continue block8;
                }
                case KRAKEN_BOSS: {
                    this.spawnKrakenBoss(localPoint, true);
                    continue block8;
                }
                case GULL: {
                    this.spawnGull(localPoint, true);
                    continue block8;
                }
                case CROCODILE: {
                    this.spawnCrocodile(localPoint, true);
                    continue block8;
                }
                case KRAKEN_TENTACLE: {
                    this.spawnTentacle(localPoint, true);
                }
            }
        }
    }

    public void clearRegionNPCSet() {
        for (int i = 0; i < this.npcCharacters.size(); ++i) {
            NPCCharacter npc = this.npcCharacters.get(i);
            if (!npc.isRegionNPC()) {
                return;
            }
            RuneLiteObject runeLiteObject = npc.getRuneLiteObject();
            runeLiteObject.setActive(false);
            this.npcCharacters.remove(npc);
        }
    }

    public void deployTrialSet(int firstObject, int lastObject) {
        for (int i = firstObject; i < lastObject; ++i) {
            Animation rlAnimation;
            Model rlModel;
            TrialObject trialObject = TrialObject.values()[i];
            RuneLiteObject runeLiteObject = this.client.createRuneLiteObject();
            WorldPoint worldPoint = new WorldPoint(trialObject.getXLocation(), trialObject.getYLocation(), 0);
            LocalPoint localPoint = LocalPoint.fromWorld(this.client, worldPoint);
            if (localPoint == null) continue;
            runeLiteObject.setLocation(localPoint, 0);
            int modelId = trialObject.getModelId();
            switch (modelId) {
                default: {
                    rlModel = this.modelHandler.greyRockLarge;
                    rlAnimation = this.modelHandler.greyRockAnimation;
                    break;
                }
                case 2: {
                    rlModel = this.modelHandler.greyRockSmall;
                    rlAnimation = this.modelHandler.greyRockAnimation;
                    break;
                }
                case 3: {
                    rlModel = this.modelHandler.mossyRockSmall;
                    rlAnimation = null;
                    break;
                }
                case 4: {
                    rlModel = this.modelHandler.mossyRockLarge;
                    rlAnimation = null;
                    runeLiteObject.setDrawFrontTilesFirst(true);
                    runeLiteObject.setRadius(100);
                    break;
                }
                case 5: {
                    rlModel = this.modelHandler.mossyRockTriple;
                    rlAnimation = null;
                    break;
                }
                case 6: {
                    rlModel = this.modelHandler.emptyModel;
                    rlAnimation = null;
                    break;
                }
                case 7: {
                    rlModel = this.modelHandler.flagModel;
                    rlAnimation = this.modelHandler.flagAnimation;
                    break;
                }
                case 8: {
                    rlModel = this.modelHandler.basalt1;
                    rlAnimation = null;
                    break;
                }
                case 9: {
                    rlModel = this.modelHandler.basalt2;
                    rlAnimation = null;
                    break;
                }
                case 10: {
                    rlModel = this.modelHandler.basalt3;
                    rlAnimation = null;
                    break;
                }
                case 11: {
                    rlModel = this.modelHandler.basalt4;
                    rlAnimation = null;
                    break;
                }
                case 12: {
                    rlModel = this.modelHandler.basalt5;
                    rlAnimation = null;
                    break;
                }
                case 13: {
                    rlModel = this.modelHandler.basalt6;
                    rlAnimation = null;
                    break;
                }
                case 14: {
                    rlModel = this.modelHandler.basalt7;
                    rlAnimation = null;
                    runeLiteObject.setDrawFrontTilesFirst(true);
                    runeLiteObject.setRadius(100);
                    break;
                }
                case 15: {
                    rlModel = this.modelHandler.basalt8;
                    rlAnimation = null;
                    runeLiteObject.setDrawFrontTilesFirst(true);
                    runeLiteObject.setRadius(100);
                    break;
                }
                case 16: {
                    rlModel = this.modelHandler.fishModel;
                    rlAnimation = this.modelHandler.fishAnimation;
                    runeLiteObject.setDrawFrontTilesFirst(true);
                    runeLiteObject.setRadius(100);
                    break;
                }
                case 17: {
                    rlModel = this.modelHandler.fishSpace;
                    rlAnimation = null;
                }
            }
            runeLiteObject.setModel(rlModel);
            if (rlAnimation != null) {
                runeLiteObject.setAnimation(rlAnimation);
                runeLiteObject.setShouldLoop(true);
            }
            runeLiteObject.setOrientation(trialObject.getRotation());
            runeLiteObject.setActive(true);
            if (modelId == 16 || modelId == 17) {
                this.fishObjects.add(runeLiteObject);
                continue;
            }
            this.configObjects.add(runeLiteObject);
        }
    }

    public void clearTrialSet() {
        RuneLiteObject runeLiteObject;
        int i;
        for (i = 0; i < this.configObjects.size(); ++i) {
            runeLiteObject = this.configObjects.get(i);
            runeLiteObject.setActive(false);
        }
        for (i = 0; i < this.fishObjects.size(); ++i) {
            runeLiteObject = this.fishObjects.get(i);
            runeLiteObject.setActive(false);
        }
        this.fishObjects.clear();
        this.configObjects.clear();
    }

    public void setWaterTileRightClick() {
        Tile tile = this.client.getSelectedSceneTile();
        if (tile == null) {
            return;
        }
        if (this.getTileOverlay(tile.getLocalLocation()) != 6) {
            return;
        }
        this.lastSelectedTile = tile;
        this.client.createMenuEntry(-1).setOption("Build boat").onClick(this::checkBoatPrerequisites);
        this.client.createMenuEntry(-2).setOption("Spawn dummy").onClick(this::spawnDummyRightClick);
        this.client.createMenuEntry(-3).setOption("Spawn kraken").onClick(this::spawnKrakenRightClick);
        this.client.createMenuEntry(-4).setOption("Spawn gull").onClick(this::spawnGullRightClick);
        this.client.createMenuEntry(-5).setOption("Spawn crocodile").onClick(this::spawnCrocodileRightClick);
    }

    public void spawnNPC(NPCType npcType, Model model, NPCSize npcSize, Model projectileModel, int radius, Animation idleAnimation, Animation walkAnimation, Animation attackAnimation, Animation deathAnimation, int attackAnimFrames, Animation projectileAnimation, LocalPoint localPoint, int attackRange, int chaseRange, int maxHit, int attackSpeed, int maxHealth, boolean aggressive, boolean stationary, boolean regionNPC) {
        RuneLiteObject runeLiteObject = this.client.createRuneLiteObject();
        if (localPoint == null) {
            return;
        }
        runeLiteObject.setLocation(localPoint, 0);
        runeLiteObject.setModel(model);
        runeLiteObject.setRadius(radius);
        runeLiteObject.setAnimation(idleAnimation);
        runeLiteObject.setShouldLoop(true);
        runeLiteObject.setDrawFrontTilesFirst(true);
        runeLiteObject.setActive(true);
        int randomOrientation = this.random.nextInt(7) * 256;
        runeLiteObject.setOrientation(randomOrientation);
        NPCCharacter npc = new NPCCharacter(npcType, npcSize, runeLiteObject, projectileModel, idleAnimation, walkAnimation, attackAnimation, deathAnimation, attackAnimFrames, projectileAnimation, maxHealth, attackRange, chaseRange, maxHit, attackSpeed, aggressive, stationary, regionNPC);
        this.npcCharacters.add(npc);
    }

    public void spawnDummyRightClick(MenuEntry menuEntry) {
        LocalPoint localPoint = this.lastSelectedTile.getLocalLocation();
        this.spawnDummy(localPoint, false);
    }

    public void spawnDummy(LocalPoint localPoint, boolean regionNPC) {
        this.spawnNPC(NPCType.MERCHANT, this.modelHandler.npcShipModel, NPCSize.PLUS, null, 120, this.modelHandler.boatIdleAnimation, null, null, this.modelHandler.boatDeathAnimation, 0, null, localPoint, 5, 0, 10, 5, 100, false, true, regionNPC);
    }

    public void spawnKrakenRightClick(MenuEntry menuEntry) {
        LocalPoint localPoint = this.lastSelectedTile.getLocalLocation();
        this.spawnKraken(localPoint, false);
    }

    public void spawnKraken(LocalPoint localPoint, boolean regionNPC) {
        this.spawnNPC(NPCType.KRAKEN, this.modelHandler.krakenModel, NPCSize.LARGE, this.modelHandler.krakenProjectileModel, 120, this.modelHandler.krakenIdleAnimation, null, this.modelHandler.krakenSpellAnimation, this.modelHandler.krakenDeathAnimation, 17, null, localPoint, 7, 14, 30, 5, 255, true, false, regionNPC);
    }

    public void spawnKrakenBossRightClick(MenuEntry menuEntry) {
        LocalPoint localPoint = this.lastSelectedTile.getLocalLocation();
        this.spawnKrakenBoss(localPoint, false);
    }

    public void spawnKrakenBoss(LocalPoint localPoint, boolean regionNPC) {
        this.spawnNPC(NPCType.KRAKEN_BOSS, this.modelHandler.krakenGiantModel, NPCSize.GIGANTIC, this.modelHandler.krakenBossProjectileModel, 1400, this.modelHandler.krakenIdleAnimation, null, this.modelHandler.krakenSpellAnimation, this.modelHandler.krakenDeathAnimation, 17, this.modelHandler.krakenBossProjectileAnimation, localPoint, 30, 60, 45, 10, 1000, true, true, regionNPC);
    }

    public void spawnTentacleRightClick(MenuEntry menuEntry) {
        LocalPoint localPoint = this.lastSelectedTile.getLocalLocation();
        this.spawnTentacle(localPoint, false);
    }

    public void spawnTentacle(LocalPoint localPoint, boolean regionNPC) {
        this.spawnNPC(NPCType.KRAKEN_TENTACLE, this.modelHandler.krakenTentacleModel, NPCSize.HUGE, this.modelHandler.emptyModel, 700, this.modelHandler.tentacleIdleAnimation, null, this.modelHandler.tentacleAttackAnimation, this.modelHandler.tentacleDeathAnimation, 13, null, localPoint, 8, 20, 25, 6, 125, true, true, regionNPC);
    }

    public void spawnGullRightClick(MenuEntry menuEntry) {
        LocalPoint localPoint = this.lastSelectedTile.getLocalLocation();
        this.spawnGull(localPoint, false);
    }

    public void spawnGull(LocalPoint localPoint, boolean regionNPC) {
        this.spawnNPC(NPCType.GULL, this.modelHandler.gullModel, NPCSize.SMALL, null, 80, this.modelHandler.gullIdleAnimation, null, null, this.modelHandler.gullDeathAnimation, 0, null, localPoint, 1, 0, 1, 4, 25, false, false, regionNPC);
    }

    public void spawnCrocodileRightClick(MenuEntry menuEntry) {
        LocalPoint localPoint = this.lastSelectedTile.getLocalLocation();
        this.spawnCrocodile(localPoint, false);
    }

    public void spawnCrocodile(LocalPoint localPoint, boolean regionNPC) {
        this.spawnNPC(NPCType.CROCODILE, this.modelHandler.crocodileModel, NPCSize.PLUS, this.modelHandler.emptyModel, 100, this.modelHandler.crocodileIdleAnimation, this.modelHandler.crocodileWalkAnimation, this.modelHandler.crocodileAttackAnimation, this.modelHandler.crocodileIdleAnimation, 2, null, localPoint, 1, 7, 10, 2, 100, true, false, regionNPC);
    }

    public void spawnProjectile(NPCCharacter target, int maxHit, LocalPoint origin, Model model, Animation animation, boolean targetsPlayer) {
        RuneLiteObject projectileObject = this.client.createRuneLiteObject();
        Projectile projectile = new Projectile(projectileObject, target, targetsPlayer, maxHit, 0);
        projectileObject.setLocation(origin, 0);
        projectileObject.setModel(model);
        projectileObject.setActive(true);
        if (projectileObject.getAnimation() != null) {
            projectileObject.setAnimation(animation);
            projectileObject.setShouldLoop(true);
        }
        this.activeProjectiles.add(projectile);
    }

    public int[] checkTileCollision(int speed) {
        LocalPoint lp = this.shipObject.getLocation();
        int curX = lp.getSceneX();
        int curY = lp.getSceneY();
        int direction = BoatMaths.translateOrientation(this.absoluteBoatOrientation);
        int nextX = 0;
        int nextY = 0;
        switch (direction) {
            default: {
                --nextY;
                break;
            }
            case 256: {
                --nextY;
                --nextX;
                break;
            }
            case 512: {
                --nextX;
                break;
            }
            case 768: {
                ++nextY;
                --nextX;
                break;
            }
            case 1024: {
                ++nextY;
                break;
            }
            case 1280: {
                ++nextY;
                ++nextX;
                break;
            }
            case 1536: {
                ++nextX;
                break;
            }
            case 1792: {
                ++nextX;
                --nextY;
            }
        }
        int projectedX = speed * nextX;
        int projectedY = speed * nextY;
        for (int i = speed; i > 0; --i) {
            Tile furtherTile = this.getTile(curX, curY, nextX * i, nextY * i);
            Tile nearerTile = this.getTile(curX, curY, nextX * (i - 1), nextY * (i - 1));
            if (nearerTile == null) {
                projectedX = curX;
                projectedY = curY;
                continue;
            }
            if (furtherTile == null) {
                projectedX = nearerTile.getLocalLocation().getSceneX();
                projectedY = nearerTile.getLocalLocation().getSceneY();
                continue;
            }
            short furtherOverlay = this.getTileOverlay(furtherTile);
            short nearerOverlay = this.getTileOverlay(nearerTile);
            byte furtherTileFlag = this.getTileFlag(furtherTile);
            byte nearerTileFlag = this.getTileFlag(nearerTile);
            GameObject[] furtherGameObjects = furtherTile.getGameObjects();
            GameObject[] nearerGameObjects = nearerTile.getGameObjects();
            boolean furtherGameObjectBlocked = false;
            boolean nearerGameObjectBlocked = false;
            for (GameObject gameObject : furtherGameObjects) {
                if (gameObject == null) continue;
                furtherGameObjectBlocked = true;
                break;
            }
            for (GameObject gameObject : nearerGameObjects) {
                if (gameObject == null) continue;
                nearerGameObjectBlocked = true;
                break;
            }
            boolean furtherRLObjectBlocked = false;
            boolean nearerRLObjectBlocked = false;
            LocalPoint furtherTileCoords = furtherTile.getLocalLocation();
            int furtherTileX = furtherTileCoords.getSceneX();
            int furtherTileY = furtherTileCoords.getSceneY();
            LocalPoint nearerTileCoords = nearerTile.getLocalLocation();
            int nearerTileX = nearerTileCoords.getSceneX();
            int nearerTileY = nearerTileCoords.getSceneX();
            for (RuneLiteObject runeLiteObject : this.configObjects) {
                LocalPoint rlObjectCoords = runeLiteObject.getLocation();
                int rlObjectX = rlObjectCoords.getSceneX();
                int rlObjectY = rlObjectCoords.getSceneY();
                if (furtherTileX == rlObjectX && furtherTileY == rlObjectY) {
                    furtherRLObjectBlocked = true;
                }
                if (nearerTileX != rlObjectX || nearerTileY != rlObjectY) continue;
                nearerRLObjectBlocked = true;
            }
            boolean furtherTileHasKraken = false;
            boolean nearerTileHasKraken = false;
            if (this.currentNPCSpawns == 5) {
                for (NPCCharacter npc : this.npcCharacters) {
                    if (npc.getNpcType() != NPCType.KRAKEN_BOSS && npc.getNpcType() != NPCType.KRAKEN_TENTACLE) continue;
                    LocalPoint npcLocalPoint = npc.getRuneLiteObject().getLocation();
                    int npcRadius = npc.getNpcSize().getHitboxRadius();
                    if (nearerTileCoords.distanceTo(npcLocalPoint) < npcRadius) {
                        nearerTileHasKraken = true;
                    }
                    if (furtherTileCoords.distanceTo(npcLocalPoint) >= npcRadius) continue;
                    furtherTileHasKraken = true;
                }
            }
            if (!(furtherOverlay != 6 && nearerOverlay == 6 || (furtherTileFlag & 2) != 0 && (nearerTileFlag & 2) == 0 || furtherGameObjectBlocked && !nearerGameObjectBlocked || furtherRLObjectBlocked && !nearerRLObjectBlocked) && (!furtherTileHasKraken || nearerTileHasKraken)) continue;
            projectedX = nearerTile.getLocalLocation().getSceneX();
            projectedY = nearerTile.getLocalLocation().getSceneY();
        }
        return new int[]{projectedX, projectedY};
    }

    public Tile getTile(int currentX, int currentY, int addX, int addY) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int z = 0;
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[z][x][y];
                if (tile == null) continue;
                int tileX = tile.getLocalLocation().getSceneX();
                int tileY = tile.getLocalLocation().getSceneY();
                if (tileX != currentX + addX || tileY != currentY + addY) continue;
                return tile;
            }
        }
        return null;
    }

    public ArrayList<Tile> getTiles(int currentX, int currentY, int[] addX, int[] addY) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int z = 0;
        ArrayList<Tile> tileList = new ArrayList<Tile>();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[z][x][y];
                if (tile == null) continue;
                int tileX = tile.getLocalLocation().getSceneX();
                int tileY = tile.getLocalLocation().getSceneY();
                for (int i = 0; i < addX.length; ++i) {
                    if (tileX != currentX + addX[i] || tileY != currentY + addY[i]) continue;
                    tileList.add(tile);
                }
            }
        }
        return tileList;
    }

    public short getTileOverlay(Tile tile) {
        LocalPoint localPoint = tile.getLocalLocation();
        return this.getTileOverlay(localPoint);
    }

    public short getTileOverlay(LocalPoint localPoint) {
        int z = 0;
        int x = localPoint.getSceneX();
        int y = localPoint.getSceneY();
        Scene scene = this.client.getScene();
        short[][][] overlays = scene.getOverlayIds();
        return overlays[z][x][y];
    }

    public byte getTileFlag(Tile tile) {
        LocalPoint localPoint = tile.getLocalLocation();
        return this.getTileFlag(localPoint);
    }

    public byte getTileFlag(LocalPoint localPoint) {
        int z = 1;
        int x = localPoint.getSceneX();
        int y = localPoint.getSceneY();
        byte[][][] settings = this.client.getTileSettings();
        return settings[z][x][y];
    }

    public void checkBoatPrerequisites(MenuEntry menuEntry) {
        LocalPoint localPoint = this.getTilePlayerFaces();
        if (localPoint == null) {
            return;
        }
        if (this.getTileOverlay(localPoint) != 6) {
            this.sendChatMessage("You may want to build your boat on water. Walk up to and face a water tile and attempt 'Build boat' again.");
            return;
        }
        this.buildBoatTimer = this.BUILD_BOAT_TIMER_START;
    }

    public LocalPoint getTilePlayerFaces() {
        Player player = this.client.getLocalPlayer();
        int orientation = player.getOrientation();
        int xLocation = player.getWorldLocation().getX();
        int yLocation = player.getWorldLocation().getY();
        int direction = BoatMaths.translateOrientation(orientation);
        switch (direction) {
            default: {
                --yLocation;
                break;
            }
            case 256: {
                --yLocation;
                --xLocation;
                break;
            }
            case 512: {
                --xLocation;
                break;
            }
            case 768: {
                ++yLocation;
                --xLocation;
                break;
            }
            case 1024: {
                ++yLocation;
                break;
            }
            case 1280: {
                ++yLocation;
                ++xLocation;
                break;
            }
            case 1536: {
                ++xLocation;
                break;
            }
            case 1792: {
                ++xLocation;
                --yLocation;
            }
        }
        WorldPoint worldPoint = new WorldPoint(xLocation, yLocation, 0);
        return LocalPoint.fromWorld(this.client, worldPoint);
    }

    public void buildBoat() {
        LocalPoint localPoint = this.getTilePlayerFaces();
        if (this.getTileOverlay(localPoint) != 6 || (this.getTileFlag(localPoint) & 2) != 0) {
            this.sendChatMessage("You may want to build your boat on water. Walk up to and face a water tile and attempt 'Build boat' again.");
            return;
        }
        this.createBoat(localPoint);
        this.widgetSetter.setupUnknownTab();
        this.currentHealth = this.getBoatTypeMaxHealth();
        this.maxHealth = this.getBoatTypeMaxHealth();
    }

    public void createBoat(LocalPoint localPoint) {
        if (this.shipObject != null) {
            this.shipObject.setActive(false);
        }
        this.shipObject = this.client.createRuneLiteObject();
        this.shipObject.setModel(this.shipModel0);
        this.absoluteBoatOrientation = 0;
        this.sailLength = 0;
        this.shipObject.setLocation(localPoint, 0);
        this.shipObject.setRadius(220);
        this.shipObject.setActive(true);
        this.shipObject.setAnimation(this.modelHandler.boatIdleAnimation);
        this.shipObject.setShouldLoop(true);
        this.anchorMode = true;
        this.deathState = false;
    }

    public void despawnBoat() {
        if (this.shipObject == null) {
            return;
        }
        this.hitSplats.clear();
        this.healthBarTimer = 0;
        this.shipObject.setActive(false);
        this.shipObject = null;
        this.widgetSetter.unsetLastTab();
    }

    public int getBoatTypeMaxHealth() {
        switch (this.config.boatType()) {
            default: {
                return 50;
            }
            case OAK: {
                return 80;
            }
            case WILLOW: {
                return 110;
            }
            case MAPLE: {
                return 140;
            }
            case YEW: {
                return 170;
            }
            case MAGIC: {
                return 200;
            }
            case REDWOOD: 
        }
        return 230;
    }

    public void useCurrentTool() {
        switch (this.currentBoatTool) {
            case CANNON: {
                this.readyCannon();
                return;
            }
            case FISHING_ROD: {
                this.startFishing();
                return;
            }
            case HARPOON: {
                this.sendChatMessage("Sailing isn't real so you can't hunt for seabirds.");
                return;
            }
            case NET: {
                this.sendChatMessage("Sailing isn't real so you can't dredge for minerals.");
                return;
            }
            case SPYGLASS: {
                this.sendChatMessage("Sailing isn't real so you can't spot for treasures.");
                return;
            }
            case PLUNDER: {
                this.sendChatMessage("Sailing isn't real so you can't plunder merchant boats.");
            }
        }
    }

    public void startFishing() {
        if (this.validFishingTile()) {
            this.sendChatMessage("You cast your rod and wait for a bite.");
            this.fishing = true;
            return;
        }
        this.sendChatMessage("You need to be over a valid fishing spot to start fishing.");
    }

    public boolean validFishingTile() {
        LocalPoint localPoint = this.shipObject.getLocation();
        int x = localPoint.getSceneX();
        int y = localPoint.getSceneY();
        boolean fishingLocation = false;
        for (RuneLiteObject runeLiteObject : this.fishObjects) {
            LocalPoint fishPoint = runeLiteObject.getLocation();
            int fishX = fishPoint.getSceneX();
            int fishY = fishPoint.getSceneY();
            if (x != fishX || y != fishY) continue;
            fishingLocation = true;
            break;
        }
        return fishingLocation;
    }

    public void readyCannon() {
        if (this.shipObject == null) {
            return;
        }
        this.fireCannon = true;
    }

    public int shipTypeMaxHit() {
        switch (this.config.boatType()) {
            default: {
                return 20;
            }
            case OAK: {
                return 25;
            }
            case WILLOW: {
                return 30;
            }
            case MAPLE: {
                return 35;
            }
            case YEW: {
                return 40;
            }
            case MAGIC: {
                return 45;
            }
            case REDWOOD: 
        }
        return 50;
    }

    public void rotateBoatCW() {
        if (this.deathState) {
            return;
        }
        this.boatRotationQueue = 1;
    }

    public void rotateBoatCCW() {
        if (this.deathState) {
            return;
        }
        this.boatRotationQueue = -1;
    }

    public void increaseSailLength() {
        if (this.sailLengthQueue < 1) {
            this.sailLengthQueue = 1;
            return;
        }
        ++this.sailLengthQueue;
    }

    public void decreaseSailLength() {
        if (this.sailLengthQueue > -1) {
            this.sailLengthQueue = -1;
            return;
        }
        --this.sailLengthQueue;
    }

    public void setSailLength(int newSailLength) {
        this.sailLengthQueue = 0;
        this.sailLength = newSailLength;
        this.anchorMode = this.sailLength == 0;
    }

    public int getXMovement(int orientation) {
        if (orientation == 0 || orientation == 1024) {
            return 0;
        }
        if (orientation == 256 || orientation == 512 || orientation == 768) {
            return -1;
        }
        if (orientation == 1280 || orientation == 1536 || orientation == 1792) {
            return 1;
        }
        return 0;
    }

    public int getYMovement(int orientation) {
        if (orientation == 512 || orientation == 1536) {
            return 0;
        }
        if (orientation == 1792 || orientation == 0 || orientation == 256) {
            return -1;
        }
        if (orientation == 768 || orientation == 1024 || orientation == 1280) {
            return 1;
        }
        return 0;
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message).build());
    }

    @Provides
    SailingConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(SailingConfig.class);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.enableKeyboardControl && this.shipObject != null) {
            if (e.getKeyChar() == this.config.turnLeftHotkey().charAt(0)) {
                this.rotateBoatCCW();
            }
            if (e.getKeyChar() == this.config.turnRightHotkey().charAt(0)) {
                this.rotateBoatCW();
            }
            if (e.getKeyChar() == this.config.sailIncreaseHotkey().charAt(0)) {
                this.increaseSailLength();
            }
            if (e.getKeyChar() == this.config.sailDecreaseHotkey().charAt(0)) {
                this.decreaseSailLength();
            }
            if (e.getKeyCode() == 32) {
                this.useCurrentTool();
            }
        }
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public SailingConfig getConfig() {
        return this.config;
    }

    public SpriteManager getSpriteManager() {
        return this.spriteManager;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public CannonOverlay getCannonOverlay() {
        return this.cannonOverlay;
    }

    public GuideOverlay getGuideOverlay() {
        return this.guideOverlay;
    }

    public HitsplatOverlay getHitsplatOverlay() {
        return this.hitsplatOverlay;
    }

    public XPDropOverlay getXpDropOverlay() {
        return this.xpDropOverlay;
    }

    public FishOverlay getFishOverlay() {
        return this.fishOverlay;
    }

    public ModelHandler getModelHandler() {
        return this.modelHandler;
    }

    public WidgetSetter getWidgetSetter() {
        return this.widgetSetter;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public ChatMessageManager getChatMessageManager() {
        return this.chatMessageManager;
    }

    public GameClientLayout getCurrentGameClientLayout() {
        return this.currentGameClientLayout;
    }

    public int getCurrentTrial() {
        return this.currentTrial;
    }

    public int getCurrentNPCSpawns() {
        return this.currentNPCSpawns;
    }

    public boolean isModelsLoaded() {
        return this.modelsLoaded;
    }

    public Model getShipModel0() {
        return this.shipModel0;
    }

    public Model getShipModelN45() {
        return this.shipModelN45;
    }

    public Model getShipModelN90() {
        return this.shipModelN90;
    }

    public Model getShipModelP45() {
        return this.shipModelP45;
    }

    public Model getShipModelP90() {
        return this.shipModelP90;
    }

    public Tile getLastSelectedTile() {
        return this.lastSelectedTile;
    }

    public RuneLiteObject getShipObject() {
        return this.shipObject;
    }

    public int getBuildBoatTimer() {
        return this.buildBoatTimer;
    }

    public int getBUILD_BOAT_TIMER_START() {
        return this.BUILD_BOAT_TIMER_START;
    }

    public boolean isAnchorMode() {
        return this.anchorMode;
    }

    public boolean isShowCannonRange() {
        return this.showCannonRange;
    }

    public ArrayList<Tile> getCannonTiles() {
        return this.cannonTiles;
    }

    public boolean isEnableKeyboardControl() {
        return this.enableKeyboardControl;
    }

    public boolean isFireCannon() {
        return this.fireCannon;
    }

    public int getCannonCoolDown() {
        return this.cannonCoolDown;
    }

    public boolean isFishing() {
        return this.fishing;
    }

    public Random getRandom() {
        return this.random;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getBoatMomentum() {
        return this.boatMomentum;
    }

    public int getWindDirection() {
        return this.windDirection;
    }

    public int getAbsoluteBoatOrientation() {
        return this.absoluteBoatOrientation;
    }

    public int getSailLength() {
        return this.sailLength;
    }

    public int getBoatRotationQueue() {
        return this.boatRotationQueue;
    }

    public int getSailLengthQueue() {
        return this.sailLengthQueue;
    }

    public int getWindChangeTimer() {
        return this.windChangeTimer;
    }

    public int getHealthBarTimer() {
        return this.healthBarTimer;
    }

    public int getCurrentHealth() {
        return this.currentHealth;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public boolean isDeathState() {
        return this.deathState;
    }

    public BoatTool getCurrentBoatTool() {
        return this.currentBoatTool;
    }

    public int getXpDropAccumulator() {
        return this.xpDropAccumulator;
    }

    public int getWATER_OVERLAY_ID() {
        Objects.requireNonNull(this);
        return 6;
    }

    public int getREGION_PIRATES_COVE() {
        return this.REGION_PIRATES_COVE;
    }

    public int getPROJECTILE_HIT_RANGE() {
        Objects.requireNonNull(this);
        return 6;
    }

    public ArrayList<RuneLiteObject> getConfigObjects() {
        return this.configObjects;
    }

    public ArrayList<RuneLiteObject> getFishObjects() {
        return this.fishObjects;
    }

    public ArrayList<NPCCharacter> getNpcCharacters() {
        return this.npcCharacters;
    }

    public ArrayList<NPCCharacter> getRegionNPCs() {
        return this.regionNPCs;
    }

    public ArrayList<Projectile> getActiveProjectiles() {
        return this.activeProjectiles;
    }

    public ArrayList<HitSplat> getHitSplats() {
        return this.hitSplats;
    }

    public ArrayList<XPDrop> getXpSailingDrops() {
        return this.xpSailingDrops;
    }

    public ArrayList<XPDrop> getXpCannonDrops() {
        return this.xpCannonDrops;
    }

    public ArrayList<XPDrop> getXpFishDrops() {
        return this.xpFishDrops;
    }

    public ArrayList<FishDrop> getFishDrops() {
        return this.fishDrops;
    }

    public Model getModel() {
        return this.model;
    }

    public int getVertexFileSize() {
        return this.vertexFileSize;
    }

    public int getFaceFileSize() {
        return this.faceFileSize;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setClientThread(ClientThread clientThread) {
        this.clientThread = clientThread;
    }

    public void setConfig(SailingConfig config) {
        this.config = config;
    }

    public void setSpriteManager(SpriteManager spriteManager) {
        this.spriteManager = spriteManager;
    }

    public void setOverlayManager(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
    }

    public void setCannonOverlay(CannonOverlay cannonOverlay) {
        this.cannonOverlay = cannonOverlay;
    }

    public void setGuideOverlay(GuideOverlay guideOverlay) {
        this.guideOverlay = guideOverlay;
    }

    public void setHitsplatOverlay(HitsplatOverlay hitsplatOverlay) {
        this.hitsplatOverlay = hitsplatOverlay;
    }

    public void setXpDropOverlay(XPDropOverlay xpDropOverlay) {
        this.xpDropOverlay = xpDropOverlay;
    }

    public void setFishOverlay(FishOverlay fishOverlay) {
        this.fishOverlay = fishOverlay;
    }

    public void setModelHandler(ModelHandler modelHandler) {
        this.modelHandler = modelHandler;
    }

    public void setWidgetSetter(WidgetSetter widgetSetter) {
        this.widgetSetter = widgetSetter;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setChatMessageManager(ChatMessageManager chatMessageManager) {
        this.chatMessageManager = chatMessageManager;
    }

    public void setCurrentGameClientLayout(GameClientLayout currentGameClientLayout) {
        this.currentGameClientLayout = currentGameClientLayout;
    }

    public void setCurrentTrial(int currentTrial) {
        this.currentTrial = currentTrial;
    }

    public void setCurrentNPCSpawns(int currentNPCSpawns) {
        this.currentNPCSpawns = currentNPCSpawns;
    }

    public void setModelsLoaded(boolean modelsLoaded) {
        this.modelsLoaded = modelsLoaded;
    }

    public void setShipModel0(Model shipModel0) {
        this.shipModel0 = shipModel0;
    }

    public void setShipModelN45(Model shipModelN45) {
        this.shipModelN45 = shipModelN45;
    }

    public void setShipModelN90(Model shipModelN90) {
        this.shipModelN90 = shipModelN90;
    }

    public void setShipModelP45(Model shipModelP45) {
        this.shipModelP45 = shipModelP45;
    }

    public void setShipModelP90(Model shipModelP90) {
        this.shipModelP90 = shipModelP90;
    }

    public void setLastSelectedTile(Tile lastSelectedTile) {
        this.lastSelectedTile = lastSelectedTile;
    }

    public void setShipObject(RuneLiteObject shipObject) {
        this.shipObject = shipObject;
    }

    public void setBuildBoatTimer(int buildBoatTimer) {
        this.buildBoatTimer = buildBoatTimer;
    }

    public void setBUILD_BOAT_TIMER_START(int BUILD_BOAT_TIMER_START) {
        this.BUILD_BOAT_TIMER_START = BUILD_BOAT_TIMER_START;
    }

    public void setAnchorMode(boolean anchorMode) {
        this.anchorMode = anchorMode;
    }

    public void setShowCannonRange(boolean showCannonRange) {
        this.showCannonRange = showCannonRange;
    }

    public void setCannonTiles(ArrayList<Tile> cannonTiles) {
        this.cannonTiles = cannonTiles;
    }

    public void setEnableKeyboardControl(boolean enableKeyboardControl) {
        this.enableKeyboardControl = enableKeyboardControl;
    }

    public void setFireCannon(boolean fireCannon) {
        this.fireCannon = fireCannon;
    }

    public void setCannonCoolDown(int cannonCoolDown) {
        this.cannonCoolDown = cannonCoolDown;
    }

    public void setFishing(boolean fishing) {
        this.fishing = fishing;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setBoatMomentum(int boatMomentum) {
        this.boatMomentum = boatMomentum;
    }

    public void setWindDirection(int windDirection) {
        this.windDirection = windDirection;
    }

    public void setAbsoluteBoatOrientation(int absoluteBoatOrientation) {
        this.absoluteBoatOrientation = absoluteBoatOrientation;
    }

    public void setBoatRotationQueue(int boatRotationQueue) {
        this.boatRotationQueue = boatRotationQueue;
    }

    public void setSailLengthQueue(int sailLengthQueue) {
        this.sailLengthQueue = sailLengthQueue;
    }

    public void setWindChangeTimer(int windChangeTimer) {
        this.windChangeTimer = windChangeTimer;
    }

    public void setHealthBarTimer(int healthBarTimer) {
        this.healthBarTimer = healthBarTimer;
    }

    public void setCurrentHealth(int currentHealth) {
        this.currentHealth = currentHealth;
    }

    public void setMaxHealth(int maxHealth) {
        this.maxHealth = maxHealth;
    }

    public void setDeathState(boolean deathState) {
        this.deathState = deathState;
    }

    public void setCurrentBoatTool(BoatTool currentBoatTool) {
        this.currentBoatTool = currentBoatTool;
    }

    public void setXpDropAccumulator(int xpDropAccumulator) {
        this.xpDropAccumulator = xpDropAccumulator;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setVertexFileSize(int vertexFileSize) {
        this.vertexFileSize = vertexFileSize;
    }

    public void setFaceFileSize(int faceFileSize) {
        this.faceFileSize = faceFileSize;
    }
}

