/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.playerindicators;

import com.google.inject.Provides;
import java.awt.Color;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.MenuOpened;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ChatIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsConfig;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsMinimapOverlay;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsOverlay;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsService;
import net.runelite.client.plugins.playerindicators.PlayerIndicatorsTileOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;

@PluginDescriptor(name="Player Indicators", description="Highlight players on-screen and/or on the minimap", tags={"highlight", "minimap", "overlay", "players"})
public class PlayerIndicatorsPlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PlayerIndicatorsConfig config;
    @Inject
    private PlayerIndicatorsOverlay playerIndicatorsOverlay;
    @Inject
    private PlayerIndicatorsTileOverlay playerIndicatorsTileOverlay;
    @Inject
    private PlayerIndicatorsMinimapOverlay playerIndicatorsMinimapOverlay;
    @Inject
    private PlayerIndicatorsService playerIndicatorsService;
    @Inject
    private Client client;
    @Inject
    private ChatIconManager chatIconManager;

    @Provides
    PlayerIndicatorsConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(PlayerIndicatorsConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.playerIndicatorsOverlay);
        this.overlayManager.add(this.playerIndicatorsTileOverlay);
        this.overlayManager.add(this.playerIndicatorsMinimapOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.playerIndicatorsOverlay);
        this.overlayManager.remove(this.playerIndicatorsTileOverlay);
        this.overlayManager.remove(this.playerIndicatorsMinimapOverlay);
    }

    public void onClientTick(ClientTick clientTick) {
        if (this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (menuEntries == null) {
            return;
        }
        boolean modified = false;
        for (MenuEntry entry : menuEntries) {
            Decorations decorations;
            int type2 = entry.getType().getId();
            if (type2 >= 2000) {
                type2 -= 2000;
            }
            if (type2 != MenuAction.WALK.getId() && type2 != MenuAction.SPELL_CAST_ON_PLAYER.getId() && type2 != MenuAction.ITEM_USE_ON_PLAYER.getId() && type2 != MenuAction.PLAYER_FIRST_OPTION.getId() && type2 != MenuAction.PLAYER_SECOND_OPTION.getId() && type2 != MenuAction.PLAYER_THIRD_OPTION.getId() && type2 != MenuAction.PLAYER_FOURTH_OPTION.getId() && type2 != MenuAction.PLAYER_FIFTH_OPTION.getId() && type2 != MenuAction.PLAYER_SIXTH_OPTION.getId() && type2 != MenuAction.PLAYER_SEVENTH_OPTION.getId() && type2 != MenuAction.PLAYER_EIGTH_OPTION.getId() && type2 != MenuAction.RUNELITE_PLAYER.getId()) continue;
            Player[] players = this.client.getCachedPlayers();
            Player player = null;
            int identifier = (int)entry.getIdentifier();
            if (type2 == MenuAction.WALK.getId()) {
                --identifier;
            }
            if (identifier >= 0 && identifier < players.length) {
                player = players[identifier];
            }
            if (player == null || (decorations = this.getDecorations(player)) == null) continue;
            String oldTarget = entry.getTarget();
            String newTarget = this.decorateTarget(oldTarget, decorations);
            entry.setTarget(newTarget);
            modified = true;
        }
        if (modified) {
            this.client.setMenuEntries(menuEntries);
        }
    }

    @Subscribe(priority=1.0f)
    public void onMenuOpened(MenuOpened event) {
        if (this.config.condensePlayerOptions()) {
            this.condensePlayerOptions();
        }
    }

    private void condensePlayerOptions() {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        MenuEntry parentMenu = null;
        Player prev = null;
        for (int i = menuEntries.length - 1; i >= 0; --i) {
            MenuEntry menuEntry = menuEntries[i];
            MenuAction type2 = menuEntry.getType();
            Player player = menuEntry.getPlayer();
            if (player != null && type2 != MenuAction.ITEM_USE_ON_PLAYER) {
                System.out.println(player.getName());
                if (prev != player) {
                    MenuEntry copy2 = this.client.createMenuEntry(-1).setIdentifier(menuEntry.getIdentifier()).setOption(menuEntry.getOption()).setTarget(menuEntry.getTarget()).setType(menuEntry.getType()).setParam0(menuEntry.getParam0()).setParam1(menuEntry.getParam1()).setDeprioritized(menuEntry.isDeprioritized());
                    System.out.println(copy2.getOption() + "/" + String.valueOf((Object)copy2.getType()));
                    menuEntry.setOption("");
                    menuEntry.setType(MenuAction.RUNELITE_SUBMENU);
                    menuEntry.setDeprioritized(false);
                    parentMenu = menuEntry;
                    menuEntry = copy2;
                }
                menuEntry.setParent(parentMenu);
            }
            prev = player;
        }
    }

    private Decorations getDecorations(Player player) {
        int image = -1;
        Color color = null;
        if (Arrays.stream(this.client.playerlist()).anyMatch(s2 -> player.getName().equalsIgnoreCase((String)s2)) && this.config.highlightFriends()) {
            color = this.config.getFriendColor();
        } else if (!player.isFriendsChatMember() && !player.isClanMember() && this.config.highlightOthers()) {
            color = this.config.getOthersColor();
        }
        if (image == -1 && color == null) {
            return null;
        }
        return new Decorations(image, color);
    }

    private String decorateTarget(String oldTarget, Decorations decorations) {
        Object newTarget = oldTarget;
        if (decorations.getColor() != null) {
            int idx = oldTarget.indexOf(62);
            if (idx != -1) {
                newTarget = oldTarget.substring(idx + 1);
            }
            newTarget = ColorUtil.prependColorTag((String)newTarget, decorations.getColor());
        }
        if (decorations.getImage() != -1) {
            newTarget = "<img=" + decorations.getImage() + ">" + (String)newTarget;
        }
        return newTarget;
    }

    private static final class Decorations {
        private final int image;
        private final Color color;

        public Decorations(int image, Color color) {
            this.image = image;
            this.color = color;
        }

        public int getImage() {
            return this.image;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Decorations)) {
                return false;
            }
            Decorations other = (Decorations)o;
            if (this.getImage() != other.getImage()) {
                return false;
            }
            Color this$color = this.getColor();
            Color other$color = other.getColor();
            return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.getImage();
            Color $color = this.getColor();
            result2 = result2 * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
            return result2;
        }

        public String toString() {
            return "PlayerIndicatorsPlugin.Decorations(image=" + this.getImage() + ", color=" + String.valueOf(this.getColor()) + ")";
        }
    }
}

