/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.minimap;

import com.google.inject.Provides;
import java.awt.Color;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.MouseManager;
import net.runelite.client.input.MouseWheelListener;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.minimap.MinimapConfig;
import net.runelite.client.plugins.minimap.MinimapDot;

@PluginDescriptor(name="Minimap", description="Customize the color of minimap dots, hide the minimap, and zoom", tags={"items", "npcs", "players", "zoom"})
public class MinimapPlugin
extends Plugin
implements MouseWheelListener {
    private static final int DOT_ITEM = 0;
    private static final int DOT_NPC = 1;
    private static final int DOT_PLAYER = 2;
    private static final int DOT_FRIEND = 3;
    private static final int DOT_TEAM = 4;
    private static final int DOT_FRIENDSCHAT = 5;
    private static final int DOT_CLAN = 5;
    @Inject
    private Client client;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private MinimapConfig config;
    private SpritePixels[] originalDotSprites;

    @Provides
    private MinimapConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(MinimapConfig.class);
    }

    @Override
    protected void startUp() {
        this.mouseManager.registerMouseWheelListener(this);
        this.storeOriginalDots();
        this.replaceMapDots();
        this.client.setMinimapZoom(this.config.zoom());
        if (this.config.hdMinimap()) {
            this.client.setHdMinimapEnabled(true);
            this.client.setGameState(1);
        }
    }

    @Override
    protected void shutDown() {
        this.restoreOriginalDots();
        this.client.setMinimapZoom(false);
        this.client.setHdMinimapEnabled(false);
        this.client.setGameState(1);
        this.mouseManager.unregisterMouseWheelListener(this);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN && this.originalDotSprites == null) {
            this.storeOriginalDots();
            this.replaceMapDots();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("minimap")) {
            return;
        }
        if (event.getKey().equals("zoom")) {
            this.client.setMinimapZoom(this.config.zoom());
            return;
        }
        if (event.getKey().equals("hdminimap")) {
            this.client.setHdMinimapEnabled(this.config.hdMinimap());
            this.client.setGameState(1);
            return;
        }
        this.replaceMapDots();
    }

    private void replaceMapDots() {
        SpritePixels[] mapDots = this.client.getMapDots();
        if (mapDots == null) {
            return;
        }
        this.applyDot(mapDots, 0, this.config.itemColor());
        this.applyDot(mapDots, 1, this.config.npcColor());
        this.applyDot(mapDots, 2, this.config.playerColor());
        this.applyDot(mapDots, 3, this.config.friendColor());
        this.applyDot(mapDots, 4, this.config.teamColor());
        this.applyDot(mapDots, 5, this.config.clanChatColor());
    }

    private void applyDot(SpritePixels[] mapDots, int id, Color color) {
        if (id < mapDots.length && color != null) {
            mapDots[id] = MinimapDot.create(this.client, color);
        }
    }

    private void storeOriginalDots() {
        SpritePixels[] originalDots = this.client.getMapDots();
        if (originalDots == null) {
            return;
        }
        this.originalDotSprites = Arrays.copyOf(originalDots, originalDots.length);
    }

    private void restoreOriginalDots() {
        SpritePixels[] mapDots = this.client.getMapDots();
        if (this.originalDotSprites == null || mapDots == null) {
            return;
        }
        System.arraycopy(this.originalDotSprites, 0, mapDots, 0, mapDots.length);
    }

    @Override
    public MouseWheelEvent mouseWheelMoved(MouseWheelEvent event) {
        int mouseY;
        int mouseX;
        if (this.client.getGameState() == GameState.LOGGED_IN && this.inMap(mouseX = this.client.getMouseCanvasPosition().getX(), mouseY = this.client.getMouseCanvasPosition().getY(), this.client.isResized(), this.client.getCanvasWidth()).booleanValue() && this.client.isMinimapZoom()) {
            int zoom = (int)this.client.getMinimapZoom();
            this.client.setMinimapZoom(zoom += event.getWheelRotation() * 35);
            if (zoom > 210) {
                this.client.setMinimapZoom(210.0);
            }
            if (zoom < -70) {
                this.client.setMinimapZoom(-70.0);
            }
        }
        return event;
    }

    public Boolean inMap(int mouseX, int mouseY, boolean resized, int width) {
        int i = mouseX - 25 - 547;
        int j = mouseY - 5 - 3;
        if (resized) {
            i = mouseX - (width - 182 + 24);
            j = mouseY - 8;
        }
        return this.inCircle(0, 0, i, j, 76);
    }

    public boolean inCircle(int circleX, int circleY, int clickX, int clickY, int radius) {
        return Math.pow(circleX + radius - clickX, 2.0) + Math.pow(circleY + radius - clickY, 2.0) < Math.pow(radius, 2.0);
    }
}

