/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene.model_overrides;

import com.google.gson.annotations.JsonAdapter;
import java.util.HashSet;
import java.util.Set;
import net.runelite.api.Model;
import net.runelite.client.plugins.hd.data.NpcID;
import net.runelite.client.plugins.hd.data.ObjectID;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.data.materials.UvType;
import net.runelite.client.plugins.hd.scene.model_overrides.InheritTileColorType;
import net.runelite.client.plugins.hd.scene.model_overrides.TzHaarRecolorType;
import net.runelite.client.plugins.hd.utils.AABB;

public class ModelOverride {
    public static ModelOverride NONE = new ModelOverride();
    private static final Set<Integer> EMPTY = new HashSet<Integer>();
    public String description = "UNKNOWN";
    @JsonAdapter(value=NpcID.JsonAdapter.class)
    public Set<Integer> npcIds = EMPTY;
    @JsonAdapter(value=ObjectID.JsonAdapter.class)
    public Set<Integer> objectIds = EMPTY;
    public Material baseMaterial = Material.NONE;
    public Material textureMaterial = Material.NONE;
    public UvType uvType = UvType.VANILLA;
    public float uvScale = 1.0f;
    public int uvOrientation = 0;
    public boolean forceOverride = false;
    public boolean flatNormals = false;
    public boolean removeBakedLighting = false;
    public boolean castShadows = true;
    public boolean receiveShadows = true;
    public float shadowOpacityThreshold = 0.0f;
    public TzHaarRecolorType tzHaarRecolorType = TzHaarRecolorType.NONE;
    public InheritTileColorType inheritTileColorType = InheritTileColorType.NONE;
    @JsonAdapter(value=AABB.JsonAdapter.class)
    public AABB[] hideInAreas = new AABB[0];

    public void gsonReallyShouldSupportThis() {
        if (this.baseMaterial == null) {
            this.baseMaterial = ModelOverride.NONE.baseMaterial;
        }
        if (this.textureMaterial == null) {
            this.textureMaterial = ModelOverride.NONE.textureMaterial;
        }
        if (this.uvType == null) {
            this.uvType = ModelOverride.NONE.uvType;
        }
        if (this.tzHaarRecolorType == null) {
            this.tzHaarRecolorType = ModelOverride.NONE.tzHaarRecolorType;
        }
        if (this.inheritTileColorType == null) {
            this.inheritTileColorType = ModelOverride.NONE.inheritTileColorType;
        }
        if (this.hideInAreas == null) {
            this.hideInAreas = new AABB[0];
        }
        if (!this.castShadows && this.shadowOpacityThreshold == 0.0f) {
            this.shadowOpacityThreshold = 1.0f;
        }
    }

    public void computeModelUvw(float[] out, int i, float x, float y, float z, int orientation) {
        float temp;
        double sin;
        double cos;
        double rad;
        if (orientation % 2048 != 0) {
            rad = (double)orientation * 0.0030679615757712823;
            cos = Math.cos(rad);
            sin = Math.sin(rad);
            temp = (float)((double)x * sin + (double)z * cos);
            x = (float)((double)x * cos - (double)z * sin);
            z = temp;
        }
        x = (x / 128.0f + 0.5f) / this.uvScale;
        y = (y / 128.0f + 0.5f) / this.uvScale;
        z = (z / 128.0f + 0.5f) / this.uvScale;
        this.uvType.computeModelUvw(out, i, x, y, z);
        if (this.uvOrientation % 2048 != 0) {
            rad = (double)this.uvOrientation * 0.0030679615757712823;
            cos = Math.cos(rad);
            sin = Math.sin(rad);
            x = out[i] - 0.5f;
            z = out[i + 1] - 0.5f;
            temp = (float)((double)x * sin + (double)z * cos);
            x = (float)((double)x * cos - (double)z * sin);
            z = temp;
            out[i] = x + 0.5f;
            out[i + 1] = z + 0.5f;
        }
    }

    public void fillUvsForFace(float[] out, Model model, int orientation, UvType uvType, int face) {
        switch (uvType) {
            case WORLD_XY: 
            case WORLD_XZ: 
            case WORLD_YZ: {
                uvType.computeWorldUvw(out, 0, this.uvScale);
                uvType.computeWorldUvw(out, 4, this.uvScale);
                uvType.computeWorldUvw(out, 8, this.uvScale);
                break;
            }
            case MODEL_XY: 
            case MODEL_XY_MIRROR_A: 
            case MODEL_XY_MIRROR_B: 
            case MODEL_XZ: 
            case MODEL_XZ_MIRROR_A: 
            case MODEL_XZ_MIRROR_B: 
            case MODEL_YZ: 
            case MODEL_YZ_MIRROR_A: 
            case MODEL_YZ_MIRROR_B: {
                int[] vertexX = model.getVerticesX();
                int[] vertexY = model.getVerticesY();
                int[] vertexZ = model.getVerticesZ();
                int triA = model.getFaceIndices1()[face];
                int triB = model.getFaceIndices2()[face];
                int triC = model.getFaceIndices3()[face];
                this.computeModelUvw(out, 0, vertexX[triA], vertexY[triA], vertexZ[triA], orientation);
                this.computeModelUvw(out, 4, vertexX[triB], vertexY[triB], vertexZ[triB], orientation);
                this.computeModelUvw(out, 8, vertexX[triC], vertexY[triC], vertexZ[triC], orientation);
                break;
            }
            case VANILLA: {
                int[] vertexX = model.getVerticesX();
                int[] vertexY = model.getVerticesY();
                int[] vertexZ = model.getVerticesZ();
                int texFace = model.getTextureFaces()[face] & 0xFF;
                if (texFace != 255) {
                    int texA = model.getTexIndices1()[texFace];
                    int texB = model.getTexIndices2()[texFace];
                    int texC = model.getTexIndices3()[texFace];
                    out[0] = vertexX[texA];
                    out[1] = vertexY[texA];
                    out[2] = vertexZ[texA];
                    out[4] = vertexX[texB];
                    out[5] = vertexY[texB];
                    out[6] = vertexZ[texB];
                    out[8] = vertexX[texC];
                    out[9] = vertexY[texC];
                    out[10] = vertexZ[texC];
                    break;
                }
            }
            default: {
                out[0] = 0.0f;
                out[1] = 0.0f;
                out[2] = 0.0f;
                out[4] = 1.0f;
                out[5] = 0.0f;
                out[6] = 0.0f;
                out[8] = 0.0f;
                out[9] = 1.0f;
                out[10] = 0.0f;
            }
        }
    }
}

