/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene.lights;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.client.plugins.hd.data.NpcID;
import net.runelite.client.plugins.hd.data.ObjectID;
import net.runelite.client.plugins.hd.scene.lights.Alignment;
import net.runelite.client.plugins.hd.scene.lights.LightType;
import net.runelite.client.plugins.hd.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Light {
    private static final Logger log = LoggerFactory.getLogger(Light.class);
    public String description;
    @Nullable
    public Integer worldX;
    @Nullable
    public Integer worldY;
    public int plane;
    @NonNull
    public Alignment alignment = Alignment.CENTER;
    public int height;
    public int radius;
    public float strength;
    public float[] color;
    @NonNull
    public LightType type = LightType.STATIC;
    public float duration;
    public float range;
    public int fadeInDuration;
    @JsonAdapter(value=NpcID.JsonAdapter.class)
    public HashSet<Integer> npcIds = new HashSet();
    @JsonAdapter(value=ObjectID.JsonAdapter.class)
    public HashSet<Integer> objectIds = new HashSet();
    @JsonAdapter(value=IntegerSetAdapter.class)
    public HashSet<Integer> projectileIds = new HashSet();
    @JsonAdapter(value=IntegerSetAdapter.class)
    public HashSet<Integer> graphicsObjectIds = new HashSet();

    public Light(String description2, int worldX, int worldY, int plane, Integer height, @NonNull Alignment alignment, int radius, float strength, float[] color, @NonNull LightType type2, float duration, float range, Integer fadeInDuration, HashSet<Integer> npcIds, HashSet<Integer> objectIds, HashSet<Integer> projectileIds, HashSet<Integer> graphicsObjectIds) {
        if (alignment == null) {
            throw new NullPointerException("alignment is marked non-null but is null");
        }
        if (type2 == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.description = description2;
        this.worldX = worldX;
        this.worldY = worldY;
        this.plane = plane;
        this.height = height;
        this.alignment = alignment;
        this.radius = radius;
        this.strength = strength;
        this.color = color;
        this.type = type2;
        this.duration = duration;
        this.range = range;
        this.fadeInDuration = fadeInDuration;
        this.npcIds = npcIds == null ? new HashSet() : npcIds;
        this.objectIds = objectIds == null ? new HashSet() : objectIds;
        this.projectileIds = projectileIds == null ? new HashSet() : projectileIds;
        this.graphicsObjectIds = graphicsObjectIds == null ? new HashSet() : graphicsObjectIds;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof Light)) {
            return false;
        }
        Light other = (Light)obj2;
        return other.description.equals(this.description) && Light.equal(other.worldX, this.worldX) && Light.equal(other.worldY, this.worldY) && Light.equal(other.plane, this.plane) && Light.equal(other.height, this.height) && other.alignment == this.alignment && other.radius == this.radius && other.strength == this.strength && Arrays.equals(other.color, this.color) && other.type == this.type && other.duration == this.duration && other.range == this.range && Light.equal(other.fadeInDuration, this.fadeInDuration) && other.npcIds.equals(this.npcIds) && other.objectIds.equals(this.objectIds) && other.projectileIds.equals(this.projectileIds) && other.graphicsObjectIds.equals(this.graphicsObjectIds);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + this.description.hashCode();
        hash = hash * 37 + (this.worldX == null ? 0 : this.worldX);
        hash = hash * 37 + (this.worldY == null ? 0 : this.worldY);
        hash = hash * 37 + this.plane;
        hash = hash * 37 + this.height;
        hash = hash * 37 + this.alignment.hashCode();
        hash = hash * 37 + this.radius;
        hash = hash * 37 + (int)this.strength;
        for (float f : this.color) {
            hash = hash * 37 + Float.floatToIntBits(f);
        }
        hash = hash * 37 + this.type.hashCode();
        hash = hash * 37 + Float.floatToIntBits(this.duration);
        hash = hash * 37 + Float.floatToIntBits(this.range);
        hash = hash * 37 + this.fadeInDuration;
        hash = hash * 37 + this.npcIds.hashCode();
        hash = hash * 37 + this.objectIds.hashCode();
        hash = hash * 37 + this.projectileIds.hashCode();
        hash = hash * 37 + this.graphicsObjectIds.hashCode();
        return hash;
    }

    private static boolean equal(Integer a, Integer b) {
        if (a != null && b != null) {
            return a.equals(b);
        }
        return a == null && b == null;
    }

    public Light() {
    }

    public static class IntegerSetAdapter
    extends TypeAdapter<HashSet<Integer>> {
        @Override
        public HashSet<Integer> read(JsonReader in) throws IOException {
            return GsonUtils.parseIDArray(in, null);
        }

        @Override
        public void write(JsonWriter out, HashSet<Integer> value) throws IOException {
            GsonUtils.writeIDArray(out, value, null);
        }
    }
}

