/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.utils.Props;
import net.runelite.client.plugins.hd.utils.ResourcePath;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TextureManager {
    private static final Logger log = LoggerFactory.getLogger(TextureManager.class);
    private static final String[] SUPPORTED_IMAGE_EXTENSIONS = new String[]{"png", "jpg"};
    private static final float HALF_PI = 1.5707964f;
    private static final ResourcePath TEXTURE_PATH = Props.getPathOrDefault("rlhd.texture-path", () -> ResourcePath.path(TextureManager.class, "textures"));
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private ClientThread clientThread;
    private int textureArray;
    private int textureSize;
    private int[] materialOrdinalToTextureIndex;
    private int[] materialReplacements;
    private IntBuffer pixelBuffer;
    private BufferedImage scaledImage;
    private BufferedImage vanillaImage;

    public void startUp() {
        TEXTURE_PATH.watch(path -> {
            if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
                log.debug("Loading Textures...");
            }
            this.freeTextures();
        });
    }

    public void shutDown() {
        this.freeTextures();
    }

    public int getTextureIndex(Material material) {
        return material == null ? -1 : this.materialOrdinalToTextureIndex[material.ordinal()];
    }

    public Material getEffectiveMaterial(Material material) {
        int replacement = this.materialReplacements[material.ordinal()];
        return replacement == -1 ? material : Material.values()[replacement];
    }

    public void ensureTexturesLoaded(TextureProvider textureProvider) {
        int i;
        if (this.textureArray != 0) {
            return;
        }
        if (!this.allTexturesLoaded(textureProvider)) {
            return;
        }
        Texture[] textures = textureProvider.getTextures();
        HashSet<Integer> diffuseIds = new HashSet<Integer>();
        for (int i2 = 0; i2 < textures.length; ++i2) {
            Material[] texture = textures[i2];
            if (texture == null) continue;
            diffuseIds.add(i2);
        }
        int textureCount = diffuseIds.size();
        for (Material material : Material.values()) {
            if (material.vanillaTextureIndex != -1 && !diffuseIds.add(material.vanillaTextureIndex)) continue;
            ++textureCount;
        }
        this.textureSize = this.config.textureResolution().getSize();
        this.textureArray = GL43C.glGenTextures();
        GL43C.glActiveTexture(33985);
        GL43C.glBindTexture(35866, this.textureArray);
        if (GL.getCapabilities().glTexStorage3D != 0L) {
            GL43C.glTexStorage3D(35866, 8, 35907, this.textureSize, this.textureSize, textureCount);
        } else {
            int i3 = 0;
            for (int size = this.textureSize; size >= 1; size /= 2) {
                GL43C.glTexImage3D(35866, i3++, 35907, size, size, textureCount, 0, 6408, 5121, 0L);
            }
        }
        GL43C.glTexParameteri(35866, 10241, 9728);
        GL43C.glTexParameteri(35866, 10240, 9728);
        GL43C.glTexParameteri(35866, 10242, 10497);
        GL43C.glTexParameteri(35866, 10243, 10497);
        this.setAnisotropicFilteringLevel();
        double save = textureProvider.getBrightness();
        textureProvider.setBrightness(1.0);
        int[] vanillaPixels = new int[16384];
        this.pixelBuffer = BufferUtils.createIntBuffer(this.textureSize * this.textureSize);
        this.scaledImage = new BufferedImage(this.textureSize, this.textureSize, 2);
        this.vanillaImage = new BufferedImage(128, 128, 2);
        int materialCount = Material.values().length;
        this.materialOrdinalToTextureIndex = new int[materialCount];
        this.materialReplacements = new int[materialCount];
        Arrays.fill(this.materialOrdinalToTextureIndex, -1);
        Arrays.fill(this.materialReplacements, -1);
        float[] textureAnimations = new float[textureCount * 2];
        ArrayDeque<Integer> unusedIndices = new ArrayDeque<Integer>();
        for (i = 0; i < textures.length; ++i) {
            int direction;
            Texture texture = textures[i];
            if (texture == null) {
                unusedIndices.addLast(i);
                continue;
            }
            Material[] material = Material.getTexture(i);
            if (material.parent != null) {
                this.materialOrdinalToTextureIndex[material.ordinal()] = this.materialOrdinalToTextureIndex[material.parent.ordinal()];
                continue;
            }
            Object textureName = material == Material.NONE ? "" + i : material.name().toLowerCase();
            BufferedImage image = this.loadTextureImage((String)textureName);
            if (image == null) {
                int[] pixels = textureProvider.load(i);
                if (pixels == null) {
                    log.warn("No vanilla pixels for texture index {}", (Object)i);
                    unusedIndices.addLast(i);
                    continue;
                }
                if (pixels.length != 16384) {
                    log.warn("Unknown dimensions for vanilla texture at index {} ({} pixels)", (Object)i, (Object)pixels.length);
                    unusedIndices.addLast(i);
                    continue;
                }
                for (int j = 0; j < pixels.length; ++j) {
                    int p = pixels[j];
                    vanillaPixels[j] = p == 0 ? 0 : 0xFF000000 | p & 0xFFFFFF;
                }
                this.vanillaImage.setRGB(0, 0, 128, 128, vanillaPixels, 0, 128);
                image = this.vanillaImage;
            }
            this.uploadTexture(i, image);
            if (material != Material.NONE) {
                this.materialOrdinalToTextureIndex[material.ordinal()] = i;
            }
            if ((direction = texture.getAnimationDirection()) == 0) continue;
            float speed = (float)(texture.getAnimationSpeed() * 50) / 128.0f;
            float radians2 = (float)direction * -1.5707964f;
            textureAnimations[i * 2] = (float)Math.cos(radians2) * speed;
            textureAnimations[i * 2 + 1] = (float)Math.sin(radians2) * speed;
        }
        int vanillaCount = i - unusedIndices.size();
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Loaded {} vanilla textures", (Object)vanillaCount);
        }
        for (Material material : Material.values()) {
            if (material == Material.NONE) continue;
            if (material.parent != null) {
                this.materialOrdinalToTextureIndex[material.ordinal()] = this.materialOrdinalToTextureIndex[material.parent.ordinal()];
                continue;
            }
            String textureName = material.name().toLowerCase();
            BufferedImage image = this.loadTextureImage(textureName);
            if (image == null) {
                log.trace("No texture override for: {}", (Object)textureName);
                continue;
            }
            Integer index = -1;
            for (Material toReplace : material.materialsToReplace) {
                if (!material.replacementCondition.apply(this.config).booleanValue()) continue;
                index = this.materialOrdinalToTextureIndex[toReplace.ordinal()];
                this.materialReplacements[toReplace.ordinal()] = material.ordinal();
            }
            if (index == -1 && (index = (Integer)unusedIndices.pollFirst()) == null) {
                index = i++;
            }
            this.uploadTexture(index, image);
            this.materialOrdinalToTextureIndex[material.ordinal()] = index;
        }
        int hdCount = i - unusedIndices.size() - vanillaCount;
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Loaded {} HD textures", (Object)hdCount);
        }
        GL43C.glGenerateMipmap(35866);
        this.pixelBuffer = null;
        this.scaledImage = null;
        this.vanillaImage = null;
        textureProvider.setBrightness(save);
        GL43C.glActiveTexture(33984);
        this.plugin.updateMaterialUniformBuffer(textureAnimations);
        this.plugin.updateWaterTypeUniformBuffer();
    }

    private BufferedImage loadTextureImage(String textureName) {
        for (String ext : SUPPORTED_IMAGE_EXTENSIONS) {
            ResourcePath path = ResourcePath.path(TextureManager.class, "textures", textureName + "." + ext);
            try {
                return path.loadImage();
            }
            catch (Exception ex) {
                log.trace("Failed to load texture: {}", (Object)path, (Object)ex);
            }
        }
        log.trace("Missing texture file: {}", (Object)textureName);
        return null;
    }

    private void uploadTexture(int index, BufferedImage image) {
        AffineTransform t = new AffineTransform();
        t.scale((double)this.textureSize / (double)image.getWidth(), (double)this.textureSize / (double)image.getHeight());
        AffineTransformOp scaleOp = new AffineTransformOp(t, 3);
        scaleOp.filter(image, this.scaledImage);
        int[] pixels = ((DataBufferInt)this.scaledImage.getRaster().getDataBuffer()).getData();
        this.pixelBuffer.put(pixels).flip();
        GL43C.glTexSubImage3D(35866, 0, 0, 0, index, this.textureSize, this.textureSize, 1, 32993, 33639, this.pixelBuffer);
    }

    private void setAnisotropicFilteringLevel() {
        int level = this.config.anisotropicFilteringLevel();
        if (level == 0) {
            GL43C.glTexParameteri(35866, 10241, 9728);
        } else {
            GL43C.glTexParameteri(35866, 10241, 9987);
        }
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxSamples = GL43C.glGetFloat(34047);
            float anisoLevel = Math.max(1.0f, Math.min(maxSamples, (float)level));
            GL43C.glTexParameterf(35866, 34046, anisoLevel);
        }
    }

    public void freeTextures() {
        this.clientThread.invoke(() -> {
            GL43C.glDeleteTextures(this.textureArray);
            this.textureArray = 0;
        });
    }

    private boolean allTexturesLoaded(TextureProvider textureProvider) {
        Texture[] textures = textureProvider.getTextures();
        if (textures == null || textures.length == 0) {
            return false;
        }
        for (int textureId = 0; textureId < textures.length; ++textureId) {
            int[] pixels;
            Texture texture = textures[textureId];
            if (texture == null || (pixels = textureProvider.load(textureId)) != null) continue;
            return false;
        }
        return true;
    }
}

