/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.model;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferPool {
    private static final Logger log = LoggerFactory.getLogger(BufferPool.class);
    private static final long BUFFER_SIZE = 294912L;
    private final ArrayList<Long> allocationHandles = new ArrayList();
    private final ArrayDeque<Long> bufferAddressStack = new ArrayDeque();

    public BufferPool(long byteCapacity) throws OutOfMemoryError {
        try {
            this.allocateChunk(byteCapacity);
        }
        catch (Throwable err) {
            this.freeAllocations();
            log.warn("Unable to allocate {} bytes as a single chunk", (Object)byteCapacity, (Object)err);
            try {
                long chunkSize;
                for (long bytesRemaining = byteCapacity; bytesRemaining > 0L; bytesRemaining -= chunkSize) {
                    chunkSize = Math.min(bytesRemaining, 0x40000000L);
                    this.allocateChunk(chunkSize);
                }
            }
            catch (Throwable err2) {
                this.freeAllocations();
                log.error("Unable to allocate {} bytes in chunks of up to 1 GiB each", (Object)byteCapacity, (Object)err2);
                throw err2;
            }
        }
    }

    public boolean isEmpty() {
        return this.bufferAddressStack.isEmpty();
    }

    private void allocateChunk(long chunkSize) throws OutOfMemoryError {
        long handle = MemoryUtil.nmemAllocChecked(chunkSize);
        this.allocationHandles.add(handle);
        long cursor = 0L;
        while (chunkSize - cursor >= 294912L) {
            this.bufferAddressStack.push(handle + cursor);
            cursor += 294912L;
        }
    }

    public void freeAllocations() {
        this.bufferAddressStack.clear();
        Iterator<Long> iterator2 = this.allocationHandles.iterator();
        while (iterator2.hasNext()) {
            MemoryUtil.nmemFree(iterator2.next());
            iterator2.remove();
        }
    }

    public void putIntBuffer(IntBuffer buffer) {
        this.bufferAddressStack.push(MemoryUtil.memAddress(buffer));
    }

    public IntBuffer takeIntBuffer(int capacity) {
        if (this.bufferAddressStack.isEmpty()) {
            return null;
        }
        return MemoryUtil.memIntBuffer(this.bufferAddressStack.pop(), capacity);
    }

    public void putFloatBuffer(FloatBuffer buffer) {
        this.bufferAddressStack.push(MemoryUtil.memAddress(buffer));
    }

    public FloatBuffer takeFloatBuffer(int capacity) {
        if (this.bufferAddressStack.isEmpty()) {
            return null;
        }
        return MemoryUtil.memFloatBuffer(this.bufferAddressStack.pop(), capacity);
    }
}

