/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.data.materials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import net.runelite.client.plugins.hd.HdPluginConfig;
import net.runelite.client.plugins.hd.utils.ColorUtils;

public enum Material {
    NONE,
    VANILLA(NONE, p -> p.setHasTransparency(true)),
    UNLIT(NONE, p -> p.setUnlit(true)),
    TRANSPARENT,
    LAVA_FLOW_MAP,
    WATER_FLOW_MAP,
    UNDERWATER_FLOW_MAP,
    CAUSTICS_MAP,
    WATER_NORMAL_MAP_1,
    WATER_NORMAL_MAP_2,
    WATER_FOAM,
    WOODEN_DOOR_HANDLE(0),
    WATER_FLAT(1),
    BRICK(2),
    WOOD_PLANKS_1(3, p -> p.setSpecular(0.35f, 30.0f)),
    LARGE_DOOR(4),
    DARK_WOOD(5),
    ROOF_SHINGLES_1(6, p -> p.setSpecular(0.5f, 30.0f)),
    WOODEN_SCREEN(7, p -> p.setHasTransparency(true)),
    LEAVES_SIDE(8, p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f)),
    TREE_RINGS(9, p -> p.setHasTransparency(true)),
    MOSS_BRANCH(10),
    CONCRETE(11),
    IRON_BARS(12, p -> p.setHasTransparency(true)),
    PAINTING_LANDSCAPE(13),
    PAINTING_KING(14),
    MARBLE_DARK(15, p -> p.setSpecular(1.1f, 380.0f)),
    SIMPLE_GRAIN_WOOD(16),
    WATER_DROPLETS(17, p -> p.setHasTransparency(true)),
    HAY(18),
    NET(19, p -> p.setHasTransparency(true)),
    BOOKCASE(20),
    ROOF_WOODEN_SLATE(21, p -> p.setHasTransparency(true)),
    CRATE(22, p -> p.setSpecular(0.35f, 30.0f)),
    BRICK_BROWN(23),
    WATER_FLAT_2(24),
    SWAMP_WATER_FLAT(25),
    WEB(26, p -> p.setHasTransparency(true)),
    ROOF_SLATE(27),
    MOSS(28, p -> p.setHasTransparency(true)),
    TROPICAL_LEAF(29, p -> p.setBrightness(0.5f).setHasTransparency(true)),
    WILLOW_LEAVES(30, p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.0f)),
    LAVA(31, p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.05f, 36.0f, 22.0f).setScroll(0.0f, 0.33333334f)),
    TREE_DOOR_BROWN(32),
    MAPLE_LEAVES(33, p -> p.setHasTransparency(true).setTextureScale(1.3f, 1.025f)),
    MAGIC_STARS(34, p -> p.setHasTransparency(true).setUnlit(true).setOverrideBaseColor(true)),
    SAND_BRICK(35),
    DOOR_TEXTURE(36),
    BLADE(37),
    SANDSTONE(38),
    PAINTING_ELF(39),
    FIRE_CAPE(40, p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.05f, 12.0f, 4.0f).setScroll(0.0f, -0.33333334f)),
    LEAVES_DISEASED(41, p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f)),
    MARBLE(42, p -> p.setSpecular(1.0f, 400.0f)),
    CLEAN_TILE(43),
    ROOF_SHINGLES_2(44),
    ROOF_BRICK_TILE(45),
    STONE_PATTERN(46),
    TEXTURE_47(47),
    HIEROGLYPHICS(48),
    TEXTURE_49(49),
    ROOF_BRICK_TILE_GREEN(50),
    CLEAN_WOOD_FLOOR(51),
    SNOW_FLAKES(52, p -> p.setHasTransparency(true)),
    FROZEN_ABYSSAL_WHIP(53),
    UNUSED_UI_TEXTURE(54),
    ROOF_BRICK_TILE_DARK(55),
    RED_LAVA(56),
    SMOKE_BATTLESTAFF(57),
    UNUSED_LEAVES(58, p -> p.setHasTransparency(true)),
    INFERNAL_CAPE(59, p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.02f, 12.0f, 4.0f).setScroll(0.0f, 0.0f)),
    LEAVES_TOP(60, p -> p.setHasTransparency(true)),
    CLAN_SKULL(61, p -> p.setHasTransparency(true)),
    CLAN_PARTYHAT(62, p -> p.setHasTransparency(true)),
    CLAN_MAGIC_ICON(63, p -> p.setHasTransparency(true)),
    CLAN_MIME_HAPPY(64, p -> p.setHasTransparency(true)),
    CLAN_HELMET(65, p -> p.setHasTransparency(true)),
    CLAN_SWORDS(66, p -> p.setHasTransparency(true)),
    CLAN_MIME_SAD(67, p -> p.setHasTransparency(true)),
    CLAN_SKILLING(68, p -> p.setHasTransparency(true)),
    CLAN_FARMING(69, p -> p.setHasTransparency(true)),
    CLAN_ARROWS(70, p -> p.setHasTransparency(true)),
    CLAN_RUNE(71, p -> p.setHasTransparency(true)),
    CLAN_THIEVING(72, p -> p.setHasTransparency(true)),
    CLAN_BONES(73, p -> p.setHasTransparency(true)),
    CLAN_CABBAGE(74, p -> p.setHasTransparency(true)),
    CLAN_CAT(75, p -> p.setHasTransparency(true)),
    CLAN_COMPASS(76, p -> p.setHasTransparency(true)),
    CLAN_FISH(77, p -> p.setHasTransparency(true)),
    CLAN_HITPOINTS(78, p -> p.setHasTransparency(true)),
    CLAN_PRAYER(79, p -> p.setHasTransparency(true)),
    CLAN_HUNTER(80, p -> p.setHasTransparency(true)),
    CLAN_RING(81, p -> p.setHasTransparency(true)),
    CLAN_ROBINHOOD(82, p -> p.setHasTransparency(true)),
    CLAN_FLOWER(83, p -> p.setHasTransparency(true)),
    CLAN_DEFENCE(84, p -> p.setHasTransparency(true)),
    CLAN_ZAMORAK(85, p -> p.setHasTransparency(true)),
    CLAN_GROUP(86, p -> p.setHasTransparency(true)),
    CLAN_GROUP_HARDCORE(87, p -> p.setHasTransparency(true)),
    CLAN_EMPTY(88, p -> p.setHasTransparency(true)),
    SHAYZIEN_LEAVES_TOP(89, p -> p.setHasTransparency(true)),
    SHAYZIEN_LEAVES_SIDE(90, p -> p.setHasTransparency(true).setTextureScale(1.025f, 1.025f)),
    WATER_ICE(91),
    SNOW_ROOF(92),
    SMALL_SNOWFLAKES(93),
    COLOR_MAP(94),
    CONCRETE_DARK(95),
    HIEROGLYPHICS_LARGE(96, p -> p.setHasTransparency(true)),
    HIEROGLYPHICS_SMALL(97, p -> p.setHasTransparency(true)),
    FOG_STATIC(98, p -> p.setHasTransparency(true)),
    FOG_VERY_SLOW(FOG_STATIC, p -> p.setVanillaTextureIndex(99).setHasTransparency(true)),
    FOG_SLOW(FOG_STATIC, p -> p.setVanillaTextureIndex(100).setHasTransparency(true)),
    FOG_MEDIUM(FOG_STATIC, p -> p.setVanillaTextureIndex(101).setHasTransparency(true)),
    FOG_FAST(FOG_STATIC, p -> p.setVanillaTextureIndex(102).setHasTransparency(true)),
    FOG_VERY_FAST(FOG_STATIC, p -> p.setVanillaTextureIndex(103).setHasTransparency(true)),
    FOG_LIGHT_STATIC(104, p -> p.setHasTransparency(true)),
    FOG_LIGHT_VERY_SLOW(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(105).setHasTransparency(true)),
    FOG_LIGHT_SLOW(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(106).setHasTransparency(true)),
    FOG_LIGHT_MEDIUM(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(107).setHasTransparency(true)),
    FOG_LIGHT_FAST(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(108).setHasTransparency(true)),
    FOG_LIGHT_VERY_FAST(FOG_LIGHT_STATIC, p -> p.setVanillaTextureIndex(109).setHasTransparency(true)),
    FOG_HEAVY_STATIC(110, p -> p.setHasTransparency(true)),
    FOG_HEAVY_VERY_SLOW(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(111).setHasTransparency(true)),
    FOG_HEAVY_SLOW(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(112).setHasTransparency(true)),
    FOG_HEAVY_MEDIUM(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(113).setHasTransparency(true)),
    FOG_HEAVY_FAST(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(114).setHasTransparency(true)),
    FOG_HEAVY_VERY_FAST(FOG_HEAVY_STATIC, p -> p.setVanillaTextureIndex(115).setHasTransparency(true)),
    SKULLS(116),
    SKULLS_FOG(117),
    SKULLS_FOG_LIGHT(118),
    SKULLS_FOG_DARK(119),
    BRICK_BROWN_HORIZONTAL(120),
    NEW_TREE(123),
    NEW_TREE2(124),
    CUSTOM_TEXTURE24(126),
    CUSTOM_TEXTURE25(127),
    CUSTOM_TEXTURE26(128),
    CUSTOM_TEXTURE27(129),
    CUSTOM_TEXTURE28(130),
    CUSTOM_TEXTURE29(131),
    CUSTOM_TEXTURE30(132),
    CUSTOM_TEXTURE31(133),
    CUSTOM_TEXTURE32(134),
    CUSTOM_TEXTURE33(135),
    CUSTOM_TEXTURE34(136),
    DISCORD_CAPE(137),
    CUSTOM_TEXTURE1(138),
    CUSTOM_TEXTURE2(139),
    CUSTOM_TEXTURE3(140),
    CUSTOM_TEXTURE4(141),
    CUSTOM_TEXTURE5(142),
    CUSTOM_TEXTURE6(143),
    CUSTOM_TEXTURE7(145),
    CUSTOM_TEXTURE8(146),
    CUSTOM_TEXTURE9(147),
    CUSTOM_TEXTURE10(148),
    CUSTOM_TEXTURE11(149),
    CUSTOM_TEXTURE12(150),
    CUSTOM_TEXTURE13(151),
    CUSTOM_TEXTURE14(152),
    CUSTOM_TEXTURE15(153),
    CUSTOM_TEXTURE16(154),
    CUSTOM_TEXTURE17(155),
    CUSTOM_TEXTURE18(156),
    CUSTOM_TEXTURE19(157),
    CUSTOM_TEXTURE20(158),
    CUSTOM_TEXTURE21(159),
    CUSTOM_TEXTURE22(160),
    CUSTOM_TEXTURE23(161),
    WHITE(NONE),
    BLANK_GLOSS(WHITE, p -> p.setSpecular(0.9f, 280.0f)),
    BLANK_SEMIGLOSS(WHITE, p -> p.setSpecular(0.35f, 80.0f)),
    SNOW_1,
    SNOW_2,
    SNOW_2_DARK(SNOW_2, p -> p.setBrightness(0.5f)),
    SNOW_3,
    SNOW_4,
    GRASS_1,
    GRASS_2,
    GRASS_3,
    GRASS_SCROLLING(GRASS_1, p -> p.setScroll(0.0f, 1.4285715f)),
    DIRT_1,
    DIRT_2,
    GRAVEL_N,
    GRAVEL(p -> p.setNormalMap(GRAVEL_N).setSpecular(0.4f, 130.0f)),
    GRAVEL_LIGHT(GRAVEL, p -> p.setBrightness(1.5f)),
    DIRT_1_SHINY(DIRT_1, p -> p.setSpecular(1.1f, 380.0f)),
    DIRT_2_SHINY(DIRT_2, p -> p.setSpecular(1.1f, 380.0f)),
    GRAVEL_SHINY(GRAVEL, p -> p.setSpecular(1.1f, 380.0f)),
    GRAVEL_SHINY_LIGHT(GRAVEL, p -> p.setSpecular(1.1f, 380.0f).setBrightness(1.55f)),
    SAND_1_N,
    SAND_1(p -> p.setNormalMap(SAND_1_N).setSpecular(0.2f, 10.0f)),
    SAND_2_N,
    SAND_2(p -> p.setNormalMap(SAND_2_N).setSpecular(0.2f, 10.0f)),
    SAND_3_N,
    SAND_3(p -> p.setNormalMap(SAND_3_N).setSpecular(0.2f, 10.0f)),
    GRUNGE_1,
    GRUNGE_1_SHINY(GRUNGE_1, p -> p.setSpecular(0.7f, 300.0f)),
    GRUNGE_2,
    GRUNGE_2_SHINY(GRUNGE_2, p -> p.setSpecular(0.7f, 300.0f)),
    SUBMERGED_GRUNGE_2(GRUNGE_2, p -> p.setFlowMap(UNDERWATER_FLOW_MAP).setFlowMapStrength(0.075f).setFlowMapDuration(new float[]{12.0f, -12.0f})),
    ROCK_1,
    ROCK_1_LIGHT(ROCK_1, p -> p.setBrightness(1.4f)),
    ROCK_2,
    ROCK_3_D,
    ROCK_3_N,
    ROCK_3(p -> p.setNormalMap(ROCK_3_N).setDisplacementMap(ROCK_3_D).setDisplacementScale(0.15f).setSpecular(0.4f, 20.0f).setBrightness(1.2f)),
    ROCK_3_SMOOTH(ROCK_3, p -> p.setDisplacementScale(0.0f).setTextureScale(1.0f, 1.0f, 0.15f).setSpecular(0.3f, 40.0f)),
    ROCK_3_ORE(ROCK_3, p -> p.setSpecular(1.0f, 20.0f)),
    ROCK_4_D,
    ROCK_4_N,
    ROCK_4(p -> p.setNormalMap(ROCK_4_N).setDisplacementMap(ROCK_4_D).setDisplacementScale(0.15f).setSpecular(0.4f, 20.0f).setBrightness(1.2f)),
    ROCK_4_ORE(ROCK_4, p -> p.setSpecular(1.0f, 20.0f)),
    ROCK_5_D,
    ROCK_5_N,
    ROCK_5(p -> p.setNormalMap(ROCK_5_N).setDisplacementMap(ROCK_5_D).setDisplacementScale(0.15f).setSpecular(0.4f, 20.0f).setBrightness(1.2f)),
    ROCK_5_ORE(ROCK_5, p -> p.setSpecular(1.0f, 20.0f)),
    CARPET,
    FINE_CARPET(CARPET, p -> p.setBrightness(1.4f).setTextureScale(0.5f, 0.5f)),
    FALADOR_PATH_BRICK_N,
    FALADOR_PATH_BRICK(p -> p.setNormalMap(FALADOR_PATH_BRICK_N).setSpecular(0.3f, 30.0f)),
    JAGGED_STONE_TILE_N,
    JAGGED_STONE_TILE(p -> p.setNormalMap(JAGGED_STONE_TILE_N).setSpecular(0.5f, 30.0f)),
    TILE_SMALL_1(p -> p.setSpecular(0.8f, 70.0f)),
    TILES_1_2x2,
    TILES_2_2x2_N,
    TILES_2_2x2(p -> p.setNormalMap(TILES_2_2x2_N).setSpecular(0.3f, 30.0f)),
    TILES_2x2_1_GLOSS(TILES_1_2x2, p -> p.setSpecular(1.0f, 70.0f)),
    TILES_2x2_2_GLOSS(TILES_2_2x2, p -> p.setSpecular(1.0f, 70.0f)),
    TILES_2x2_1_SEMIGLOSS(TILES_1_2x2, p -> p.setSpecular(0.5f, 300.0f)),
    TILES_2x2_2_SEMIGLOSS(TILES_2_2x2, p -> p.setSpecular(0.5f, 300.0f)),
    MARBLE_1,
    MARBLE_2,
    MARBLE_3,
    MARBLE_1_GLOSS(MARBLE_1, p -> p.setSpecular(0.9f, 280.0f)),
    MARBLE_2_GLOSS(MARBLE_2, p -> p.setSpecular(0.8f, 300.0f)),
    MARBLE_3_GLOSS(MARBLE_3, p -> p.setSpecular(0.7f, 320.0f)),
    MARBLE_1_SEMIGLOSS(MARBLE_1, p -> p.setSpecular(0.35f, 80.0f)),
    MARBLE_2_SEMIGLOSS(MARBLE_2, p -> p.setSpecular(0.3f, 100.0f)),
    MARBLE_3_SEMIGLOSS(MARBLE_3, p -> p.setSpecular(0.4f, 120.0f)),
    LASSAR_UNDERCITY_TILE_NORMAL,
    LASSAR_UNDERCITY_TILE_DISP,
    LASSAR_UNDERCITY_TILES(MARBLE_2_SEMIGLOSS, p -> p.setNormalMap(LASSAR_UNDERCITY_TILE_NORMAL).setDisplacementMap(LASSAR_UNDERCITY_TILE_DISP).setDisplacementScale(0.015f)),
    LASSAR_UNDERCITY_TILES_SUBMERGED(LASSAR_UNDERCITY_TILES, p -> p.setFlowMap(UNDERWATER_FLOW_MAP).setFlowMapStrength(0.025f).setFlowMapDuration(new float[]{10.0f, -10.0f})),
    HD_LAVA_1(p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.04f, 36.0f, 12.0f)),
    HD_LAVA_2(p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.04f, 36.0f, 12.0f)),
    HD_MAGMA_1(p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.04f, 36.0f, 12.0f)),
    HD_MAGMA_2(p -> p.setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.04f, 36.0f, 12.0f)),
    BARK,
    LIGHT_BARK(BARK, p -> p.setBrightness(1.75f)),
    WOOD_GRAIN,
    WOOD_GRAIN_2_N,
    WOOD_GRAIN_2(p -> p.setNormalMap(WOOD_GRAIN_2_N).setSpecular(0.3f, 30.0f)),
    WOOD_GRAIN_2_WIDE(WOOD_GRAIN_2, p -> p.setTextureScale(1.5f, 0.5f)),
    WOOD_GRAIN_3_D,
    WOOD_GRAIN_3_N,
    WOOD_GRAIN_3(p -> p.setDisplacementMap(WOOD_GRAIN_3_D).setNormalMap(WOOD_GRAIN_3_N).setSpecular(0.3f, 25.0f)),
    DOCK_FENCE,
    DOCK_FENCE_DARK(DOCK_FENCE, p -> p.setBrightness(0.6f)),
    HD_INFERNAL_CAPE(p -> p.replaceIf(HdPluginConfig::hdInfernalTexture, INFERNAL_CAPE).setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.02f, 12.0f, 4.0f).setScroll(0.0f, 0.33333334f)),
    HD_BRICK_N,
    HD_BRICK_D,
    HD_BRICK(p -> p.setNormalMap(HD_BRICK_N).setDisplacementMap(HD_BRICK_D).setDisplacementScale(0.05f).setSpecular(0.3f, 20.0f)),
    HD_ROOF_SHINGLES_N,
    HD_ROOF_SHINGLES_1(p -> p.replaceIf(HdPluginConfig::objectTextures, ROOF_SHINGLES_1).setSpecular(0.5f, 30.0f).setNormalMap(HD_ROOF_SHINGLES_N)),
    HD_MARBLE_DARK(p -> p.replaceIf(HdPluginConfig::objectTextures, MARBLE_DARK).setSpecular(1.1f, 380.0f)),
    HD_BRICK_BROWN_N,
    HD_BRICK_BROWN_D,
    HD_BRICK_BROWN(p -> p.setNormalMap(HD_BRICK_BROWN_N).setDisplacementMap(HD_BRICK_BROWN_D).setDisplacementScale(0.05f).setSpecular(0.35f, 20.0f)),
    HD_LAVA_3(p -> p.replaceIf(HdPluginConfig::objectTextures, LAVA).setUnlit(true).setOverrideBaseColor(true).setFlowMap(LAVA_FLOW_MAP, 0.05f, 36.0f, 22.0f).setScroll(0.0f, 0.33333334f)),
    HD_ROOF_SHINGLES_2(p -> p.replaceIf(HdPluginConfig::objectTextures, ROOF_SHINGLES_2).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_SHINGLES_N)),
    HD_SIMPLE_GRAIN_WOOD_D,
    HD_SIMPLE_GRAIN_WOOD_N,
    HD_SIMPLE_GRAIN_WOOD(p -> p.setSpecular(0.3f, 20.0f).setNormalMap(HD_SIMPLE_GRAIN_WOOD_N).setDisplacementMap(HD_SIMPLE_GRAIN_WOOD_D).setDisplacementScale(0.008f)),
    WORN_TILES,
    STONE_N,
    STONE,
    STONE_NORMALED(STONE, p -> p.setNormalMap(STONE_N).setSpecular(0.3f, 30.0f)),
    STONE_NORMALED_DARK(STONE_NORMALED, p -> p.setBrightness(0.88f)),
    STONE_LOWGLOSS(STONE, p -> p.setSpecular(0.3f, 30.0f)),
    STONE_SEMIGLOSS(STONE, p -> p.setSpecular(0.6f, 100.0f)),
    STONE_SCROLLING(STONE, p -> p.setScroll(0.0f, -1.4285715f)),
    WALL_STONE_N,
    WALL_STONE(p -> p.setNormalMap(WALL_STONE_N)),
    METALLIC_1,
    METALLIC_1_SEMIGLOSS(METALLIC_1, p -> p.setSpecular(0.3f, 80.0f)),
    METALLIC_1_GLOSS(METALLIC_1, p -> p.setSpecular(0.7f, 80.0f)),
    METALLIC_1_HIGHGLOSS(METALLIC_1, p -> p.setSpecular(1.1f, 80.0f)),
    METALLIC_2(METALLIC_1, p -> p.setBrightness(1.8f)),
    METALLIC_2_SEMIGLOSS(METALLIC_2, p -> p.setSpecular(0.3f, 80.0f)),
    METALLIC_2_GLOSS(METALLIC_2, p -> p.setSpecular(0.7f, 80.0f)),
    METALLIC_2_HIGHGLOSS(METALLIC_2, p -> p.setSpecular(1.1f, 80.0f)),
    METALLIC_NONE_GLOSS(NONE, p -> p.setSpecular(0.7f, 80.0f)),
    WATTLE_1,
    ICE_1(SNOW_4, p -> p.replaceIf(HdPluginConfig::winterTheme, WATER_FLAT_2, WATER_FLAT).setSpecular(1.1f, 200.0f)),
    ICE_1_HIGHGLOSS(ICE_1, p -> p.replaceIf(HdPluginConfig::winterTheme, WATER_FLAT_2, WATER_FLAT).setSpecular(3.1f, 30.0f)),
    ICE_2(SNOW_2, p -> p.setSpecular(1.5f, 800.0f)),
    ICE_3(GRUNGE_2, p -> p.setSpecular(1.9f, 1000.0f)),
    ICE_4(WHITE, p -> p.setSpecular(1.5f, 1000.0f).setNormalMap(WATER_NORMAL_MAP_2)),
    SLIME_GRUNGE(GRUNGE_1, p -> p.setSpecular(4.1f, 60.0f)),
    WATER_PUDDLE(NONE, p -> p.setSpecular(1.5f, 80.0f)),
    HD_WOOD_PLANKS_1_N,
    HD_WOOD_PLANKS_1(p -> p.setNormalMap(HD_WOOD_PLANKS_1_N).setSpecular(0.5f, 80.0f).setBrightness(1.2f)),
    HD_WOOD_PLANKS_2_N,
    HD_WOOD_PLANKS_2(p -> p.setNormalMap(HD_WOOD_PLANKS_2_N).setSpecular(0.3f, 40.0f).setBrightness(1.2f)),
    HD_CRATE_N,
    HD_CRATE(p -> p.setNormalMap(HD_CRATE_N).setSpecular(0.25f, 30.0f).setBrightness(0.9f)),
    HD_ROOF_BRICK_TILE_N,
    HD_ROOF_BRICK_TILE_1(p -> p.replaceIf(HdPluginConfig::objectTextures, ROOF_BRICK_TILE, ROOF_BRICK_TILE_GREEN, ROOF_BRICK_TILE_DARK).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_BRICK_TILE_N)),
    HD_ROOF_BRICK_TILE_2(p -> p.replaceIf(HdPluginConfig::objectTextures, ROOF_BRICK_TILE_GREEN).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_BRICK_TILE_N)),
    HD_ROOF_BRICK_TILE_3(p -> p.replaceIf(HdPluginConfig::objectTextures, ROOF_BRICK_TILE_DARK).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_BRICK_TILE_N)),
    PLANT_GRUNGE_1(GRUNGE_1, p -> p.setSpecular(0.25f, 25.0f)),
    PLANT_GRUNGE_2(GRUNGE_2, p -> p.setSpecular(0.2f, 20.0f)),
    HD_CONCRETE_D,
    HD_CONCRETE_N,
    HD_CONCRETE(p -> p.setNormalMap(HD_CONCRETE_N).setDisplacementMap(HD_CONCRETE_D).setDisplacementScale(0.05f).setSpecular(0.3f, 20.0f).setBrightness(0.75f)),
    HD_HAY_N,
    HD_HAY(p -> p.setSpecular(0.3f, 20.0f).setNormalMap(HD_HAY_N)),
    GRAY_75(NONE, p -> p.setBrightness(ColorUtils.srgbToLinear(0.75f))),
    GRAY_65(NONE, p -> p.setBrightness(ColorUtils.srgbToLinear(0.65f))),
    GRAY_50(NONE, p -> p.setBrightness(ColorUtils.srgbToLinear(0.5f))),
    GRAY_25(NONE, p -> p.setBrightness(ColorUtils.srgbToLinear(0.25f))),
    OOZE(GRAY_65, p -> p.setSpecular(1.5f, 600.0f)),
    BONE(GRUNGE_2, p -> p.setSpecular(0.25f, 20.0f)),
    ABYSSAL_D,
    ABYSSAL_N,
    ABYSSAL(p -> p.setSpecular(4.5f, 400.0f).setNormalMap(ABYSSAL_N).setDisplacementMap(ABYSSAL_D).setDisplacementScale(0.2f).setBrightness(3.0f)),
    ABYSSAL_2_D,
    ABYSSAL_2_N,
    ABYSSAL_2(p -> p.setSpecular(7.0f, 400.0f).setNormalMap(ABYSSAL_2_N).setDisplacementMap(ABYSSAL_2_D).setDisplacementScale(0.1f).setBrightness(1.9f)),
    LEAVES_YELLOW_SIDE(LEAVES_SIDE.ordinal()),
    LEAVES_YELLOW_TOP(LEAVES_TOP.ordinal()),
    LEAVES_RED_SIDE(LEAVES_SIDE.ordinal()),
    LEAVES_RED_TOP(LEAVES_TOP.ordinal()),
    LEAVES_ORANGE_SIDE(LEAVES_SIDE.ordinal()),
    LEAVES_ORANGE_TOP(LEAVES_TOP.ordinal()),
    WINTER_WILLOW_LEAVES(p -> p.replaceIf(HdPluginConfig::winterTheme, WILLOW_LEAVES).setTextureScale(1.025f, 1.0f)),
    WINTER_MAPLE_LEAVES(p -> p.replaceIf(HdPluginConfig::winterTheme, MAPLE_LEAVES).setTextureScale(1.3f, 1.0f)),
    WINTER_PAINTINGS(p -> p.replaceIf(HdPluginConfig::winterTheme, PAINTING_LANDSCAPE, PAINTING_KING, PAINTING_ELF)),
    WINTER_HD_ROOF_SHINGLES_1(p -> p.replaceIf(HdPluginConfig::winterTheme, ROOF_SHINGLES_1).setSpecular(0.5f, 30.0f).setNormalMap(HD_ROOF_SHINGLES_N)),
    WINTER_HD_ROOF_SHINGLES_2(p -> p.replaceIf(HdPluginConfig::winterTheme, ROOF_SHINGLES_2).setSpecular(0.3f, 30.0f).setNormalMap(HD_ROOF_SHINGLES_N)),
    WINTER_HD_ROOF_BRICK_TILES(p -> p.replaceIf(HdPluginConfig::winterTheme, ROOF_BRICK_TILE, ROOF_BRICK_TILE_GREEN, ROOF_BRICK_TILE_DARK)),
    WINTER_HD_ROOF_SLATES(p -> p.replaceIf(HdPluginConfig::winterTheme, ROOF_SLATE, ROOF_WOODEN_SLATE).setSpecular(0.5f, 30.0f)),
    WINTER_JAGGED_STONE_TILE(p -> p.setNormalMap(JAGGED_STONE_TILE_N).setSpecular(0.6f, 30.0f).setBrightness(1.4f)),
    WINTER_JAGGED_STONE_TILE_LIGHT(WINTER_JAGGED_STONE_TILE, p -> p.setNormalMap(JAGGED_STONE_TILE_N).setSpecular(0.6f, 30.0f).setBrightness(4.0f)),
    WINTER_JAGGED_STONE_TILE_LIGHTER(WINTER_JAGGED_STONE_TILE, p -> p.setNormalMap(JAGGED_STONE_TILE_N).setSpecular(0.6f, 30.0f).setBrightness(12.0f));

    public final Material parent;
    public final Material normalMap;
    public final Material displacementMap;
    public final Material roughnessMap;
    public final Material ambientOcclusionMap;
    public final Material flowMap;
    public final int vanillaTextureIndex;
    public final boolean hasTransparency;
    public final boolean overrideBaseColor;
    public final boolean unlit;
    public final float brightness;
    public final float displacementScale;
    public final float flowMapStrength;
    public final float[] flowMapDuration;
    public final float specularStrength;
    public final float specularGloss;
    public final float[] scrollSpeed;
    public final float[] textureScale;
    public final List<Material> materialsToReplace = new ArrayList<Material>();
    public final Function<HdPluginConfig, Boolean> replacementCondition;
    private static final HashMap<Integer, Material> VANILLA_TEXTURE_MAP;

    private Material() {
        this((Builder b) -> {});
    }

    private Material(int vanillaTextureIndex) {
        this((Builder p) -> p.setVanillaTextureIndex(vanillaTextureIndex));
    }

    private Material(Material parent) {
        this(parent, (Builder p) -> {});
    }

    private Material(Material parent, Consumer<Builder> consumer) {
        this((Builder b) -> b.setParent(parent).apply(consumer));
    }

    private Material(int vanillaTextureIndex, Consumer<Builder> consumer) {
        this((Builder b) -> b.setVanillaTextureIndex(vanillaTextureIndex).apply(consumer));
    }

    private Material(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        this.parent = builder.parent;
        this.normalMap = builder.normalMap;
        this.displacementMap = builder.displacementMap;
        this.roughnessMap = builder.roughnessMap;
        this.ambientOcclusionMap = builder.ambientOcclusionMap;
        this.flowMap = builder.flowMap;
        this.vanillaTextureIndex = builder.vanillaTextureIndex;
        this.hasTransparency = builder.hasTransparency;
        this.overrideBaseColor = builder.overrideBaseColor;
        this.unlit = builder.unlit;
        this.brightness = builder.brightness;
        this.displacementScale = builder.displacementScale;
        this.flowMapStrength = builder.flowMapStrength;
        this.flowMapDuration = builder.flowMapDuration;
        this.specularStrength = builder.specularStrength;
        this.specularGloss = builder.specularGloss;
        this.scrollSpeed = builder.scrollSpeed;
        this.textureScale = builder.textureScale;
        this.materialsToReplace.addAll(builder.materialsToReplace);
        this.replacementCondition = builder.replacementCondition;
    }

    public static Material getTexture(int vanillaTextureId) {
        return VANILLA_TEXTURE_MAP.getOrDefault(vanillaTextureId, NONE);
    }

    static {
        VANILLA_TEXTURE_MAP = new HashMap();
        for (Material material : Material.values()) {
            if (material.vanillaTextureIndex == -1) continue;
            VANILLA_TEXTURE_MAP.putIfAbsent(material.vanillaTextureIndex, material);
        }
    }

    private static class Builder {
        private Material parent;
        private Material normalMap = NONE;
        private Material displacementMap = NONE;
        private Material roughnessMap = NONE;
        private Material ambientOcclusionMap = NONE;
        private Material flowMap = LAVA_FLOW_MAP;
        private int vanillaTextureIndex = -1;
        private boolean hasTransparency = false;
        private boolean overrideBaseColor = false;
        private boolean unlit = false;
        private float brightness = 1.0f;
        private float displacementScale = 0.1f;
        private float flowMapStrength;
        private float[] flowMapDuration = new float[]{0.0f, 0.0f};
        private float specularStrength;
        private float specularGloss;
        private float[] scrollSpeed = new float[]{0.0f, 0.0f};
        private float[] textureScale = new float[]{1.0f, 1.0f};
        private List<Material> materialsToReplace = new ArrayList<Material>();
        private Function<HdPluginConfig, Boolean> replacementCondition;

        private Builder() {
        }

        Builder apply(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        Builder setParent(Material parent) {
            this.parent = parent;
            this.normalMap = parent.normalMap;
            this.displacementMap = parent.displacementMap;
            this.roughnessMap = parent.roughnessMap;
            this.ambientOcclusionMap = parent.ambientOcclusionMap;
            this.flowMap = parent.flowMap;
            this.vanillaTextureIndex = parent.vanillaTextureIndex;
            this.hasTransparency = parent.hasTransparency;
            this.overrideBaseColor = parent.overrideBaseColor;
            this.unlit = parent.unlit;
            this.brightness = parent.brightness;
            this.displacementScale = parent.displacementScale;
            this.flowMapStrength = parent.flowMapStrength;
            this.flowMapDuration = parent.flowMapDuration;
            this.specularStrength = parent.specularStrength;
            this.specularGloss = parent.specularGloss;
            this.scrollSpeed = parent.scrollSpeed;
            this.textureScale = parent.textureScale;
            this.materialsToReplace.addAll(parent.materialsToReplace);
            this.replacementCondition = parent.replacementCondition;
            return this;
        }

        Builder setSpecular(float specularStrength, float specularGloss) {
            this.specularStrength = specularStrength;
            this.specularGloss = specularGloss;
            return this;
        }

        Builder setFlowMap(Material flowMap, float flowMapStrength, float durationX, float durationY) {
            this.flowMap = flowMap;
            this.flowMapStrength = flowMapStrength;
            this.flowMapDuration = new float[]{durationX, durationY};
            return this;
        }

        Builder setScroll(float speedX, float speedY) {
            this.scrollSpeed = new float[]{-speedX, -speedY};
            return this;
        }

        Builder setTextureScale(float x, float y) {
            this.textureScale = new float[]{x, y};
            return this;
        }

        Builder replaceIf(@NonNull Function<HdPluginConfig, Boolean> condition, Material ... materialsToReplace) {
            if (condition == null) {
                throw new NullPointerException("condition is marked non-null but is null");
            }
            if (materialsToReplace == null) {
                throw new NullPointerException("materialsToReplace is marked non-null but is null");
            }
            Collections.addAll(this.materialsToReplace, materialsToReplace);
            this.replacementCondition = condition;
            return this;
        }

        Builder setTextureScale(float ... xyz) {
            this.textureScale = Arrays.copyOf(this.textureScale, 3);
            System.arraycopy(xyz, 0, this.textureScale, 0, Math.min(3, xyz.length));
            return this;
        }

        public Builder setNormalMap(Material normalMap) {
            this.normalMap = normalMap;
            return this;
        }

        public Builder setDisplacementMap(Material displacementMap) {
            this.displacementMap = displacementMap;
            return this;
        }

        public Builder setRoughnessMap(Material roughnessMap) {
            this.roughnessMap = roughnessMap;
            return this;
        }

        public Builder setAmbientOcclusionMap(Material ambientOcclusionMap) {
            this.ambientOcclusionMap = ambientOcclusionMap;
            return this;
        }

        public Builder setFlowMap(Material flowMap) {
            this.flowMap = flowMap;
            return this;
        }

        public Builder setVanillaTextureIndex(int vanillaTextureIndex) {
            this.vanillaTextureIndex = vanillaTextureIndex;
            return this;
        }

        public Builder setHasTransparency(boolean hasTransparency) {
            this.hasTransparency = hasTransparency;
            return this;
        }

        public Builder setOverrideBaseColor(boolean overrideBaseColor) {
            this.overrideBaseColor = overrideBaseColor;
            return this;
        }

        public Builder setUnlit(boolean unlit) {
            this.unlit = unlit;
            return this;
        }

        public Builder setBrightness(float brightness) {
            this.brightness = brightness;
            return this;
        }

        public Builder setDisplacementScale(float displacementScale) {
            this.displacementScale = displacementScale;
            return this;
        }

        public Builder setFlowMapStrength(float flowMapStrength) {
            this.flowMapStrength = flowMapStrength;
            return this;
        }

        public Builder setFlowMapDuration(float[] flowMapDuration) {
            this.flowMapDuration = flowMapDuration;
            return this;
        }

        public Builder setSpecularStrength(float specularStrength) {
            this.specularStrength = specularStrength;
            return this;
        }

        public Builder setSpecularGloss(float specularGloss) {
            this.specularGloss = specularGloss;
            return this;
        }

        public Builder setScrollSpeed(float[] scrollSpeed) {
            this.scrollSpeed = scrollSpeed;
            return this;
        }

        public Builder setMaterialsToReplace(List<Material> materialsToReplace) {
            this.materialsToReplace = materialsToReplace;
            return this;
        }

        public Builder setReplacementCondition(Function<HdPluginConfig, Boolean> replacementCondition) {
            this.replacementCondition = replacementCondition;
            return this;
        }
    }
}

