/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.greenscreen;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.greenscreen.GreenScreenConfig;
import net.runelite.client.plugins.greenscreen.GreenScreenOverlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Green Screen", enabledByDefault=false)
public class GreenScreenPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GreenScreenPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GreenScreenConfig config;
    @Inject
    private GreenScreenOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private KeyManager keyManager;
    private boolean renderGreenscreen;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.hotkey()){

        @Override
        public void hotkeyPressed() {
            GreenScreenPlugin.this.renderGreenscreen = !GreenScreenPlugin.this.renderGreenscreen;
        }
    };

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.renderGreenscreen = this.config.defaultState();
        this.keyManager.registerKeyListener(this.hotkeyListener);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.keyManager.unregisterKeyListener(this.hotkeyListener);
    }

    @Provides
    GreenScreenConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(GreenScreenConfig.class);
    }

    public boolean isRenderGreenscreen() {
        return this.renderGreenscreen;
    }
}

