/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.doorkicker;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Door Kicker", description="Assert your dominance against the doors")
public class DoorKickerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DoorKickerPlugin.class);
    @Inject
    private Client client;
    private LocalPoint doorLocation;

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked e) {
        this.doorLocation = e.getMenuOption().equals("Open") && e.getMenuTarget().endsWith("Door") ? LocalPoint.fromScene(e.getParam0(), e.getParam1()) : null;
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        Player local;
        if (this.doorLocation != null && this.doorLocation.distanceTo((local = this.client.getLocalPlayer()).getLocalLocation()) <= 128) {
            local.setAnimation(423);
            local.setActionFrame(0);
            this.doorLocation = null;
        }
    }
}

