/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.antidrag;

import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.antidrag.AntiDragConfig;

@PluginDescriptor(name="Anti Drag", description="Prevent dragging an item for a specified delay", tags={"antidrag", "delay", "inventory", "items"}, enabledByDefault=false)
public class AntiDragPlugin
extends Plugin
implements KeyListener {
    static final String CONFIG_GROUP = "antiDrag";
    private static final int DEFAULT_DELAY = 5;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private AntiDragConfig config;
    @Inject
    private KeyManager keyManager;
    private boolean shiftHeld;
    private boolean ctrlHeld;

    @Provides
    AntiDragConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(AntiDragConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.clientThread.invokeLater(() -> {
            if (!this.config.onShiftOnly()) {
                this.setDragDelay();
            }
        });
        this.keyManager.registerKeyListener(this);
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientThread.invokeLater(this::resetDragDelay);
        this.keyManager.unregisterKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 17 && this.config.disableOnCtrl() && !this.config.onShiftOnly()) {
            this.resetDragDelay();
            this.ctrlHeld = true;
        } else if (e.getKeyCode() == 16 && this.config.onShiftOnly()) {
            this.setDragDelay();
            this.shiftHeld = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17 && this.config.disableOnCtrl() && !this.config.onShiftOnly()) {
            this.setDragDelay();
            this.ctrlHeld = false;
        } else if (e.getKeyCode() == 16 && this.config.onShiftOnly()) {
            this.resetDragDelay();
            this.shiftHeld = false;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            if (!this.config.disableOnCtrl()) {
                this.ctrlHeld = false;
            }
            if (this.config.onShiftOnly()) {
                this.shiftHeld = false;
                this.clientThread.invoke(this::resetDragDelay);
            } else {
                this.clientThread.invoke(this::setDragDelay);
            }
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.shiftHeld = false;
            this.ctrlHeld = false;
            this.clientThread.invoke(this::resetDragDelay);
        } else if (!this.config.onShiftOnly()) {
            this.clientThread.invoke(this::setDragDelay);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (!(widgetLoaded.getGroupId() != 100003 && widgetLoaded.getGroupId() != 5064 && widgetLoaded.getGroupId() != 100007 || this.config.onShiftOnly() && !this.shiftHeld || this.ctrlHeld)) {
            this.setBankDragDelay(this.config.dragDelay());
        }
    }

    private void setBankDragDelay(int delay) {
        Widget[] items;
        Widget bankItemContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        Widget bankInventoryItemsContainer = this.client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER);
        Widget bankDepositContainer = this.client.getWidget(WidgetInfo.DEPOSIT_BOX_INVENTORY_ITEMS_CONTAINER);
        if (bankItemContainer != null) {
            for (Widget item : items = bankItemContainer.getDynamicChildren()) {
                item.setDragDeadTime(delay);
            }
        }
        if (bankInventoryItemsContainer != null) {
            for (Widget item : items = bankInventoryItemsContainer.getDynamicChildren()) {
                item.setDragDeadTime(delay);
            }
        }
        if (bankDepositContainer != null) {
            for (Widget item : items = bankDepositContainer.getDynamicChildren()) {
                item.setDragDeadTime(delay);
            }
        }
    }

    private void setDragDelay() {
        this.client.setInventoryDragDelay(this.config.dragDelay());
        this.setBankDragDelay(this.config.dragDelay());
    }

    private void resetDragDelay() {
        this.client.setInventoryDragDelay(5);
        this.setBankDragDelay(5);
    }
}

