/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemQuantityChanged;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LootManager {
    private static final Logger log = LoggerFactory.getLogger(LootManager.class);
    private static final Map<Integer, Integer> NPC_DEATH_ANIMATIONS = ImmutableMap.of(492, 3993);
    private final EventBus eventBus;
    private final Client client;
    private final ListMultimap<Integer, ItemStack> itemSpawns = ArrayListMultimap.create();
    private final Set<LocalPoint> killPoints = new HashSet<LocalPoint>();
    private WorldPoint playerLocationLastTick;
    private WorldPoint krakenPlayerLocation;
    private NPC delayedLootNpc;
    private int delayedLootTickLimit;

    @Inject
    private LootManager(EventBus eventBus, Client client) {
        this.eventBus = eventBus;
        this.client = client;
        eventBus.register(this);
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        if (npc == this.delayedLootNpc) {
            this.delayedLootNpc = null;
            this.delayedLootTickLimit = 0;
        }
        if (!npc.isDead()) {
            int id = npc.getId();
            switch (id) {
                case 412: 
                case 413: 
                case 421: 
                case 422: 
                case 458: 
                case 459: 
                case 460: 
                case 461: 
                case 462: 
                case 463: 
                case 537: 
                case 1024: 
                case 1543: 
                case 7392: 
                case 7407: 
                case 7408: 
                case 7797: 
                case 7888: 
                case 7889: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.processNpcLoot(npc);
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned playerDespawned) {
        int y;
        Player player = playerDespawned.getPlayer();
        if (player.getHealthRatio() != 0) {
            return;
        }
        LocalPoint location = LocalPoint.fromWorld(this.client, player.getWorldLocation());
        if (location == null || this.killPoints.contains(location)) {
            return;
        }
        int x = location.getSceneX();
        int packed = x << 8 | (y = location.getSceneY());
        Collection items = this.itemSpawns.get((Object)packed);
        if (items.isEmpty()) {
            return;
        }
        this.killPoints.add(location);
        this.eventBus.post(new PlayerLootReceived(player, items));
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        Tile tile = itemSpawned.getTile();
        LocalPoint location = new LocalPoint(tile.getWorldLocation().getX(), tile.getWorldLocation().getY());
        int packed = location.getSceneX() << 8 | location.getSceneY();
        this.itemSpawns.put(packed, new ItemStack(item.getId(), item.getQuantity(), location));
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Item spawn {} ({}) location {} packed {}", item.getId(), item.getQuantity(), location, packed);
        }
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        TileItem item = itemDespawned.getItem();
        LocalPoint location = new LocalPoint(itemDespawned.getTile().getWorldLocation().getX(), itemDespawned.getTile().getWorldLocation().getY());
        if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
            log.debug("Item despawn {} ({}) location {}", item.getId(), item.getQuantity(), location);
        }
    }

    @Subscribe
    public void onItemQuantityChanged(ItemQuantityChanged itemQuantityChanged) {
        TileItem item = itemQuantityChanged.getItem();
        Tile tile = itemQuantityChanged.getTile();
        LocalPoint location = new LocalPoint(tile.getWorldLocation().getX(), tile.getWorldLocation().getY());
        int packed = location.getSceneX() << 8 | location.getSceneY();
        int diff = itemQuantityChanged.getNewQuantity() - itemQuantityChanged.getOldQuantity();
        if (diff <= 0) {
            return;
        }
        this.itemSpawns.put(packed, new ItemStack(item.getId(), diff, location));
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        if (!(e.getActor() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)e.getActor();
        int id = npc.getId();
        Integer deathAnim = NPC_DEATH_ANIMATIONS.get(id);
        if (deathAnim != null && deathAnim.intValue() == npc.getAnimation()) {
            if (id == 492) {
                this.krakenPlayerLocation = this.client.getLocalPlayer().getWorldLocation();
            } else {
                this.processNpcLoot(npc);
            }
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        NPC npc = npcChanged.getNpc();
        if (npc.getId() == 9433 || npc.getId() == 9424) {
            this.delayedLootNpc = npc;
            this.delayedLootTickLimit = 15;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.delayedLootNpc != null && this.delayedLootTickLimit-- > 0) {
            this.processDelayedLoot();
        }
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        this.playerLocationLastTick = this.client.getLocalPlayer().getWorldLocation();
        this.killPoints.clear();
    }

    private void processDelayedLoot() {
        int sceneY;
        LocalPoint localPoint = new LocalPoint(this.delayedLootNpc.getWorldLocation().getX(), this.delayedLootNpc.getWorldLocation().getY());
        if (localPoint == null) {
            log.debug("Scene changed away from delayed loot location");
            this.delayedLootNpc = null;
            this.delayedLootTickLimit = 0;
            return;
        }
        int sceneX = localPoint.getSceneX();
        int packed = sceneX << 8 | (sceneY = localPoint.getSceneY());
        Collection itemStacks = this.itemSpawns.get((Object)packed);
        if (itemStacks.isEmpty()) {
            return;
        }
        log.debug("Got delayed loot stack from {}: {}", (Object)this.delayedLootNpc.getName(), (Object)itemStacks);
        this.eventBus.post(new NpcLootReceived(this.delayedLootNpc, itemStacks));
        this.delayedLootNpc = null;
        this.delayedLootTickLimit = 0;
    }

    private void processNpcLoot(NPC npc) {
        LocalPoint location = new LocalPoint(npc.getWorldLocation().getX(), npc.getWorldLocation().getY());
        if (location == null || this.killPoints.contains(location)) {
            return;
        }
        int x = npc.getWorldLocation().getX();
        int y = npc.getWorldLocation().getY();
        int size = npc.getComposition().getSize();
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int packed = location.getSceneX() + i << 8 | location.getSceneY() + j;
                Collection items = this.itemSpawns.get((Object)packed);
                allItems.addAll(items);
            }
        }
        if (allItems.isEmpty()) {
            return;
        }
        this.killPoints.add(location);
        this.eventBus.post(new NpcLootReceived(npc, allItems));
        this.itemSpawns.clear();
    }

    private WorldPoint getDropLocation(NPC npc, WorldPoint worldLocation) {
        block0 : switch (npc.getId()) {
            case 494: 
            case 6640: 
            case 6656: {
                worldLocation = this.playerLocationLastTick;
                break;
            }
            case 492: {
                worldLocation = this.krakenPlayerLocation;
                break;
            }
            case 2042: 
            case 2043: 
            case 2044: {
                for (Map.Entry entry : this.itemSpawns.entries()) {
                    if (((ItemStack)entry.getValue()).getId() != 12934) continue;
                    int packed = (Integer)entry.getKey();
                    int unpackedX = packed >> 8;
                    int unpackedY = packed & 0xFF;
                    worldLocation = WorldPoint.fromScene(this.client, unpackedX, unpackedY, worldLocation.getPlane());
                    break block0;
                }
                break;
            }
            case 8026: 
            case 8058: 
            case 8059: 
            case 8060: 
            case 8061: {
                int x = worldLocation.getX() + 3;
                int y = worldLocation.getY() + 3;
                if (this.playerLocationLastTick.getX() < x) {
                    x -= 4;
                } else if (this.playerLocationLastTick.getX() > x) {
                    x += 4;
                }
                if (this.playerLocationLastTick.getY() < y) {
                    y -= 4;
                } else if (this.playerLocationLastTick.getY() > y) {
                    y += 4;
                }
                worldLocation = new WorldPoint(x, y, worldLocation.getPlane());
            }
        }
        return worldLocation;
    }

    private WorldPoint getAdjacentSquareLootTile(NPC npc) {
        NPCComposition composition = npc.getComposition();
        WorldPoint worldLocation = npc.getWorldLocation();
        int x = worldLocation.getX();
        int y = worldLocation.getY();
        return new WorldPoint(x, y, worldLocation.getPlane());
    }

    public Collection<ItemStack> getItemSpawns(WorldPoint worldPoint) {
        LocalPoint localPoint = LocalPoint.fromWorld(this.client, worldPoint);
        if (localPoint == null) {
            return Collections.emptyList();
        }
        int sceneX = localPoint.getSceneX();
        int sceneY = localPoint.getSceneY();
        int packed = sceneX << 8 | sceneY;
        Collection itemStacks = this.itemSpawns.get((Object)packed);
        return Collections.unmodifiableList(itemStacks);
    }
}

