/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.gson.Gson;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AccountHashChanged;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.WorldChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.account.SessionManager;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigData;
import net.runelite.client.config.ConfigDescriptor;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigInvocationHandler;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigItemDescriptor;
import net.runelite.client.config.ConfigProfile;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.ConfigSectionDescriptor;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.ModifierlessKeybind;
import net.runelite.client.config.ProfileManager;
import net.runelite.client.config.Range;
import net.runelite.client.config.RuneScapeProfile;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.config.Units;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ConfigSync;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.events.SessionClose;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.RunnableExceptionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    public static final String RSPROFILE_GROUP = "rsprofile";
    public static final String RSPROFILE_DISPLAY_NAME = "displayName";
    public static final String RSPROFILE_TYPE = "type";
    private static final String RSPROFILE_ACCOUNT_HASH = "accountHash";
    private static final long RSPROFILE_ID = -1L;
    private static final String RSPROFILE_NAME = "$rsprofile";
    private static final int KEY_SPLITTER_GROUP = 0;
    private static final int KEY_SPLITTER_PROFILE = 1;
    private static final int KEY_SPLITTER_KEY = 2;
    @Nullable
    private final String configProfileName;
    private final EventBus eventBus;
    @Nullable
    private final Client client;
    private final Gson gson;
    private final ProfileManager profileManager;
    private final ConfigInvocationHandler handler = new ConfigInvocationHandler(this);
    private ConfigProfile profile;
    private ConfigProfile rsProfile;
    private ConfigData configProfile;
    private ConfigData rsProfileConfigProfile;
    @Nullable
    private String rsProfileKey;

    @Inject
    private ConfigManager(@Nullable @Named(value="profile") String profile, ScheduledExecutorService scheduledExecutorService, EventBus eventBus, @Nullable Client client, Gson gson, ProfileManager profileManager, SessionManager sessionManager) {
        this.configProfileName = profile;
        this.eventBus = eventBus;
        this.client = client;
        this.gson = gson;
        this.profileManager = profileManager;
        scheduledExecutorService.scheduleWithFixedDelay(RunnableExceptionLogger.wrap(this::sendConfig), 30 + (int)(300.0 * Math.random()), 300L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchProfile(ConfigProfile newProfile) {
        ConfigData oldData;
        if (newProfile.getId() == this.profile.getId()) {
            log.warn("switching to already-active profile!");
            return;
        }
        this.sendConfig();
        log.info("Switching profile to: {} ({})", (Object)newProfile.getName(), (Object)newProfile.getId());
        ConfigData newData = new ConfigData(ProfileManager.profileConfigFile(newProfile));
        HashSet<String> allKeys = new HashSet<String>(newData.keySet());
        ConfigManager configManager = this;
        synchronized (configManager) {
            this.handler.invalidate();
            oldData = this.configProfile;
            this.profile = newProfile;
            this.configProfile = newData;
        }
        allKeys.addAll(oldData.keySet());
        for (String wholeKey : allKeys) {
            String newValue;
            String[] split = ConfigManager.splitKey(wholeKey);
            if (split == null) continue;
            String groupName = split[0];
            String profile = split[1];
            String key = split[2];
            String oldValue = oldData.getProperty(wholeKey);
            if (Objects.equals(oldValue, newValue = newData.getProperty(wholeKey))) continue;
            log.debug("Loading configuration value {}: {}", (Object)wholeKey, (Object)newValue);
            ConfigChanged configChanged = new ConfigChanged();
            configChanged.setGroup(groupName);
            configChanged.setProfile(profile);
            configChanged.setKey(key);
            configChanged.setOldValue(oldValue);
            configChanged.setNewValue(newValue);
            this.eventBus.post(configChanged);
        }
        this.eventBus.post(new ProfileChanged());
    }

    public String getRSProfileKey() {
        return this.rsProfileKey;
    }

    @Subscribe
    public void onSessionClose(SessionClose sessionClose) {
        try (ProfileManager.Lock lock = this.profileManager.lock();){
            this.profile = ConfigManager.updateProfile(lock, this.profile);
            this.rsProfile = ConfigManager.updateProfile(lock, this.rsProfile);
            lock.getProfiles().removeIf(p -> p != this.profile && !p.isInternal() && p.isSync());
            if (this.profile.isSync()) {
                log.info("Active remote profile '{}' lost due to session close, converting to a local profile.", (Object)this.profile.getName());
                this.profile.setSync(false);
                this.profile.setRev(-1L);
            }
            lock.dirty();
        }
    }

    public void toggleSync(ConfigProfile profile, boolean sync) {
        log.debug("Setting sync for {}: {}", (Object)profile.getName(), (Object)sync);
        this.sendConfig();
        try (ProfileManager.Lock lock = this.profileManager.lock();){
            profile = lock.findProfile(profile.getId());
            if (profile == null || profile.isSync() == sync) {
                return;
            }
            profile.setSync(sync);
            lock.dirty();
            if (sync) {
                File from = ProfileManager.profileConfigFile(profile);
                ConfigData configData = new ConfigData(from);
            }
        }
    }

    public void renameProfile(ConfigProfile profile, String name) {
    }

    private void migrate() {
        try (ProfileManager.Lock lock = this.profileManager.lock();){
            List<ConfigProfile> profiles = lock.getProfiles();
            File configFile = new File(RuneLite.RUNELITE_DIR, "settings.properties");
            if (profiles.isEmpty() && configFile.exists()) {
                String targetProfileName = "default";
                log.info("Performing migration of config from {} to profile '{}'", (Object)configFile.getName(), (Object)targetProfileName);
                ConfigProfile targetProfile = lock.createProfile(targetProfileName);
                profiles.forEach(p -> p.setActive(false));
                targetProfile.setActive(true);
                if (this.rsProfile == null) {
                    this.rsProfile = lock.findProfile(RSPROFILE_NAME);
                    if (this.rsProfile == null) {
                        this.rsProfile = lock.createProfile(RSPROFILE_NAME, -1L);
                    }
                    this.rsProfile.setSync(true);
                }
                if (this.rsProfileConfigProfile == null) {
                    this.rsProfileConfigProfile = new ConfigData(ProfileManager.profileConfigFile(this.rsProfile));
                }
                this.importAndMigrate(lock, configFile, targetProfile);
            }
        }
    }

    public void importAndMigrate(ProfileManager.Lock lock, File from, ConfigProfile targetProfile) {
        ConfigData migratingData = new ConfigData(from);
        ConfigData configData = new ConfigData(ProfileManager.profileConfigFile(targetProfile));
        log.debug("Importing profile from {}", (Object)from);
        HashSet<String> rsProfileKeys = new HashSet<String>();
        ArrayList<Map.Entry<String, String>> rsProfileEntries = new ArrayList<Map.Entry<String, String>>();
        int keys2 = 0;
        for (Map.Entry<String, String> entry : migratingData.get().entrySet()) {
            String[] split = ConfigManager.splitKey(entry.getKey());
            if (split == null) continue;
            String string2 = split[1];
            if (string2 != null) {
                rsProfileKeys.add(string2);
                rsProfileEntries.add(entry);
                continue;
            }
            configData.setProperty(entry.getKey(), entry.getValue());
            ++keys2;
        }
        if (rsProfileKeys.size() > 0) {
            HashMap<String, String> oldToNewRSProfile = new HashMap<String, String>();
            List<RuneScapeProfile> existingProfiles = this.getRSProfiles();
            for (String string3 : rsProfileKeys) {
                try {
                    RuneScapeProfileType type2;
                    long accHash;
                    RuneScapeProfile newProfile;
                    String strHash = migratingData.getProperty(ConfigManager.getWholeKey(RSPROFILE_GROUP, string3, RSPROFILE_ACCOUNT_HASH));
                    String strType = migratingData.getProperty(ConfigManager.getWholeKey(RSPROFILE_GROUP, string3, RSPROFILE_TYPE));
                    if (!Strings.isNullOrEmpty(strHash) && !Strings.isNullOrEmpty(strType) && (newProfile = this.findRSProfile(existingProfiles, accHash = Long.parseLong(strHash), type2 = RuneScapeProfileType.valueOf(strType), null, true)) != null) {
                        existingProfiles.add(newProfile);
                        oldToNewRSProfile.put(string3, newProfile.getKey());
                        log.info("importing rsprofile \"{}\" as \"{}\"", (Object)string3, (Object)newProfile.getKey());
                        continue;
                    }
                    log.info("not importing rsprofile key \"{}\" (hash={} type={})", string3, strHash, strType);
                }
                catch (IllegalArgumentException e) {
                    log.info("failed to unmarshal imported rsprofile data for key \"{}\"", (Object)string3, (Object)e);
                }
            }
            for (Map.Entry entry : rsProfileEntries) {
                String[] split = ConfigManager.splitKey((String)entry.getKey());
                assert (split != null);
                String profile = split[1];
                if ((profile = (String)oldToNewRSProfile.get(profile)) == null || this.getConfiguration(split[0], profile, split[2]) != null) continue;
                this.setConfiguration(split[0], profile, split[2], (String)entry.getValue());
            }
        }
        configData.patch(configData.swapChanges());
        this.rsProfile = ConfigManager.updateProfile(lock, this.rsProfile);
        this.saveConfiguration(lock, this.rsProfile, this.rsProfileConfigProfile);
        log.info("Finished importing {} keys", (Object)keys2);
    }

    private static void removeDuplicateProfiles(ProfileManager.Lock lock) {
        HashMap<Long, ConfigProfile> seen = new HashMap<Long, ConfigProfile>();
        Iterator<ConfigProfile> it = lock.getProfiles().iterator();
        while (it.hasNext()) {
            ConfigProfile profile = it.next();
            if (seen.containsKey(profile.getId())) {
                ConfigProfile existing = (ConfigProfile)seen.get(profile.getId());
                log.warn("Duplicate profiles detected: {} and {}. Removing the latter.", (Object)existing, (Object)profile);
                it.remove();
                lock.dirty();
                continue;
            }
            seen.put(profile.getId(), profile);
        }
    }

    private static void fixRsProfileName(ProfileManager.Lock lock) {
        ConfigProfile rsProfile = lock.findProfile(-1L);
        if (rsProfile != null && !rsProfile.getName().equals(RSPROFILE_NAME)) {
            log.warn("renaming {} to {}", (Object)rsProfile, (Object)RSPROFILE_NAME);
            rsProfile.setName(RSPROFILE_NAME);
            lock.dirty();
        }
    }

    public void load() {
        this.migrate();
        try (ProfileManager.Lock lock = this.profileManager.lock();){
            ConfigManager.removeDuplicateProfiles(lock);
            ConfigManager.fixRsProfileName(lock);
            ConfigProfile profile = null;
            ConfigProfile rsProfile = null;
            for (ConfigProfile p2 : lock.getProfiles()) {
                if (p2.isInternal()) {
                    log.debug("Profile '{}' (sync: {}, active: {}, id: {}, internal)", p2.getName(), p2.isSync(), p2.getId(), p2.isActive());
                    if (!p2.getName().equals(RSPROFILE_NAME)) continue;
                    rsProfile = p2;
                    continue;
                }
                log.info("Profile '{}' (sync: {}, active: {}, id: {})", p2.getName(), p2.isSync(), p2.isActive(), p2.getId());
                if (this.configProfileName != null) {
                    if (!p2.getName().equals(this.configProfileName)) continue;
                    profile = p2;
                    continue;
                }
                if (p2.isActive()) {
                    profile = p2;
                    continue;
                }
                if (profile != null) continue;
                profile = p2;
            }
            if (profile != null) {
                log.info("Using profile: {} ({})", (Object)profile.getName(), (Object)profile.getId());
            } else {
                profile = lock.createProfile(this.configProfileName != null ? this.configProfileName : "default");
                if (this.configProfileName == null) {
                    lock.getProfiles().forEach(p -> p.setActive(false));
                    profile.setActive(true);
                }
                log.info("Creating profile: {} ({})", (Object)profile.getName(), (Object)profile.getId());
            }
            if (rsProfile == null) {
                rsProfile = lock.createProfile(RSPROFILE_NAME, -1L);
            }
            rsProfile.setSync(true);
            this.profile = profile;
            this.rsProfile = rsProfile;
            this.configProfile = new ConfigData(ProfileManager.profileConfigFile(profile));
            this.rsProfileConfigProfile = new ConfigData(ProfileManager.profileConfigFile(rsProfile));
        }
        this.eventBus.post(new ProfileChanged());
    }

    public <T extends Config> T getConfig(Class<T> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new RuntimeException("Non-public configuration classes can't have default methods invoked");
        }
        Config t = (Config)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this.handler);
        return (T)t;
    }

    public List<String> getConfigurationKeys(String prefix) {
        return this.configProfile.keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toList());
    }

    public List<String> getRSProfileConfigurationKeys(String group, String profile, String keyPrefix) {
        if (profile == null) {
            return Collections.emptyList();
        }
        assert (profile.startsWith(RSPROFILE_GROUP));
        String prefix = group + "." + profile + "." + keyPrefix;
        return this.rsProfileConfigProfile.keySet().stream().filter(k -> k.startsWith(prefix)).map(k -> ConfigManager.splitKey(k)[2]).collect(Collectors.toList());
    }

    public static String getWholeKey(String groupName, String profile, String key) {
        if (profile == null) {
            return groupName + "." + key;
        }
        return groupName + "." + profile + "." + key;
    }

    private String getConfiguration(ConfigData configData, String groupName, String rsProfile, String key) {
        return configData.getProperty(ConfigManager.getWholeKey(groupName, rsProfile, key));
    }

    public String getConfiguration(String groupName, String key) {
        return this.getConfiguration(this.configProfile, groupName, null, key);
    }

    public String getRSProfileConfiguration(String groupName, String key) {
        String rsProfileKey = this.rsProfileKey;
        if (rsProfileKey == null) {
            return null;
        }
        return this.getConfiguration(this.rsProfileConfigProfile, groupName, rsProfileKey, key);
    }

    public String getConfiguration(String groupName, String profile, String key) {
        if (profile != null) {
            return this.getConfiguration(this.rsProfileConfigProfile, groupName, profile, key);
        }
        return this.getConfiguration(this.configProfile, groupName, null, key);
    }

    public <T> T getConfiguration(String groupName, String key, Type clazz) {
        return this.getConfiguration(groupName, null, key, clazz);
    }

    public <T> T getRSProfileConfiguration(String groupName, String key, Type clazz) {
        String rsProfileKey = this.rsProfileKey;
        if (rsProfileKey == null) {
            return null;
        }
        return this.getConfiguration(groupName, rsProfileKey, key, clazz);
    }

    public <T> T getConfiguration(String groupName, String profile, String key, Type type2) {
        String value = this.getConfiguration(groupName, profile, key);
        if (!Strings.isNullOrEmpty(value)) {
            try {
                return (T)this.stringToObject(value, type2);
            }
            catch (Exception e) {
                log.warn("Unable to unmarshal {} ", (Object)ConfigManager.getWholeKey(groupName, profile, key), (Object)e);
            }
        }
        return null;
    }

    private void setConfiguration(ConfigData configData, String groupName, String profile, String key, @NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (Strings.isNullOrEmpty(groupName) || Strings.isNullOrEmpty(key) || key.indexOf(58) != -1 || key.startsWith("$")) {
            throw new IllegalArgumentException();
        }
        assert (!key.startsWith("rsprofile."));
        String wholeKey = ConfigManager.getWholeKey(groupName, profile, key);
        String oldValue = configData.setProperty(wholeKey, value);
        if (Objects.equals(oldValue, value)) {
            return;
        }
        log.debug("Setting configuration value for {} to {}", (Object)wholeKey, (Object)value);
        this.handler.invalidate();
        ConfigChanged configChanged = new ConfigChanged();
        configChanged.setGroup(groupName);
        configChanged.setProfile(profile);
        configChanged.setKey(key);
        configChanged.setOldValue(oldValue);
        configChanged.setNewValue(value);
        this.eventBus.post(configChanged);
    }

    public void setConfiguration(String groupName, String profile, String key, @NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (profile != null) {
            this.setConfiguration(this.rsProfileConfigProfile, groupName, profile, key, value);
        } else {
            this.setConfiguration(this.configProfile, groupName, null, key, value);
        }
    }

    public void setConfiguration(String groupName, String key, String value) {
        this.setConfiguration(this.configProfile, groupName, null, key, value);
    }

    public <T> void setConfiguration(String groupName, String profile, String key, T value) {
        this.setConfiguration(groupName, profile, key, this.objectToString(value));
    }

    public <T> void setConfiguration(String groupName, String key, T value) {
        this.setConfiguration(groupName, null, key, value);
    }

    public <T> void setRSProfileConfiguration(String groupName, String key, T value) {
        String rsProfileKey = this.rsProfileKey;
        if (rsProfileKey == null) {
            if (this.client == null) {
                log.warn("trying to use profile without injected client");
                return;
            }
            String displayName = null;
            Player p = this.client.getLocalPlayer();
            if (p == null) {
                log.warn("trying to create profile without display name");
            } else {
                displayName = p.getName();
            }
            RuneScapeProfile prof = this.findRSProfile(this.getRSProfiles(), this.client.getAccountHash(), RuneScapeProfileType.getCurrent(this.client), displayName, true);
            if (prof == null) {
                log.warn("trying to create a profile while not logged in");
                return;
            }
            this.rsProfileKey = rsProfileKey = prof.getKey();
            log.debug("RS profile changed to {}", (Object)rsProfileKey);
            this.eventBus.post(new RuneScapeProfileChanged());
        }
        this.setConfiguration(groupName, rsProfileKey, key, value);
    }

    private void unsetConfiguration(ConfigData configData, String groupName, String profile, String key) {
        assert (!key.startsWith("rsprofile."));
        String wholeKey = ConfigManager.getWholeKey(groupName, profile, key);
        String oldValue = configData.unset(wholeKey);
        if (oldValue == null) {
            return;
        }
        log.debug("Unsetting configuration value for {}", (Object)wholeKey);
        this.handler.invalidate();
        ConfigChanged configChanged = new ConfigChanged();
        configChanged.setGroup(groupName);
        configChanged.setProfile(profile);
        configChanged.setKey(key);
        configChanged.setOldValue(oldValue);
        this.eventBus.post(configChanged);
    }

    public void unsetConfiguration(String groupName, String profile, String key) {
        if (profile != null) {
            this.unsetConfiguration(this.rsProfileConfigProfile, groupName, profile, key);
        } else {
            this.unsetConfiguration(this.configProfile, groupName, null, key);
        }
    }

    public void unsetConfiguration(String groupName, String key) {
        this.unsetConfiguration(this.configProfile, groupName, null, key);
    }

    public void unsetRSProfileConfiguration(String groupName, String key) {
        String rsProfileKey = this.rsProfileKey;
        if (rsProfileKey == null) {
            return;
        }
        this.unsetConfiguration(this.rsProfileConfigProfile, groupName, rsProfileKey, key);
    }

    public ConfigDescriptor getConfigDescriptor(Config configurationProxy) {
        Class<?> inter = configurationProxy.getClass().getInterfaces()[0];
        ConfigGroup group = inter.getAnnotation(ConfigGroup.class);
        if (group == null) {
            throw new IllegalArgumentException("Not a config group");
        }
        List<ConfigSectionDescriptor> sections = Arrays.stream(inter.getDeclaredFields()).filter(m3 -> m3.isAnnotationPresent(ConfigSection.class) && m3.getType() == String.class).map(m3 -> {
            try {
                return new ConfigSectionDescriptor(String.valueOf(m3.get(inter)), m3.getDeclaredAnnotation(ConfigSection.class));
            }
            catch (IllegalAccessException e) {
                log.warn("Unable to load section {}::{}", (Object)inter.getSimpleName(), (Object)m3.getName());
                return null;
            }
        }).filter(Objects::nonNull).sorted((a, b) -> ComparisonChain.start().compare(a.getSection().position(), b.getSection().position()).compare((Comparable<?>)((Object)a.getSection().name()), (Comparable<?>)((Object)b.getSection().name())).result()).collect(Collectors.toList());
        List<ConfigItemDescriptor> items = Arrays.stream(inter.getMethods()).filter(m3 -> m3.getParameterCount() == 0 && m3.isAnnotationPresent(ConfigItem.class)).map(m3 -> new ConfigItemDescriptor(m3.getDeclaredAnnotation(ConfigItem.class), m3.getGenericReturnType(), m3.getDeclaredAnnotation(Range.class), m3.getDeclaredAnnotation(Alpha.class), m3.getDeclaredAnnotation(Units.class))).sorted((a, b) -> ComparisonChain.start().compare(a.getItem().position(), b.getItem().position()).compare((Comparable<?>)((Object)a.getItem().name()), (Comparable<?>)((Object)b.getItem().name())).result()).collect(Collectors.toList());
        return new ConfigDescriptor(group, sections, items);
    }

    public <T extends Config> void setDefaultConfiguration(T proxy, boolean override) {
        Class<?> clazz = proxy.getClass().getInterfaces()[0];
        ConfigGroup group = clazz.getAnnotation(ConfigGroup.class);
        if (group == null) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            Object defaultValue;
            String current;
            ConfigItem item = method.getAnnotation(ConfigItem.class);
            if (item == null || method.getParameterCount() != 0) continue;
            if (!method.isDefault()) {
                if (!override || (current = this.getConfiguration(group.value(), item.keyName())) == null) continue;
                this.unsetConfiguration(group.value(), item.keyName());
                continue;
            }
            if (!override && (current = this.getConfiguration(group.value(), item.keyName(), method.getGenericReturnType())) != null) continue;
            try {
                defaultValue = ConfigInvocationHandler.callDefaultMethod(proxy, method, null);
            }
            catch (Throwable ex) {
                log.warn(null, ex);
                continue;
            }
            String current2 = this.getConfiguration(group.value(), item.keyName());
            String valueString = this.objectToString(defaultValue);
            if (Objects.equals(current2, valueString) || Strings.isNullOrEmpty(current2) && Strings.isNullOrEmpty(valueString)) continue;
            log.debug("Setting default configuration value for {}.{} to {}", group.value(), item.keyName(), defaultValue);
            this.setConfiguration(group.value(), item.keyName(), valueString);
        }
    }

    Object stringToObject(String str, Type type2) {
        ParameterizedType parameterizedType;
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return Boolean.parseBoolean(str);
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return Integer.parseInt(str);
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return Long.parseLong(str);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return Double.parseDouble(str);
        }
        if (type2 == Color.class) {
            return ColorUtil.fromString(str);
        }
        if (type2 == Dimension.class) {
            String[] splitStr = str.split("x");
            int width = Integer.parseInt(splitStr[0]);
            int height = Integer.parseInt(splitStr[1]);
            return new Dimension(width, height);
        }
        if (type2 == Point.class) {
            String[] splitStr = str.split(":");
            int width = Integer.parseInt(splitStr[0]);
            int height = Integer.parseInt(splitStr[1]);
            return new Point(width, height);
        }
        if (type2 == Rectangle.class) {
            String[] splitStr = str.split(":");
            int x = Integer.parseInt(splitStr[0]);
            int y = Integer.parseInt(splitStr[1]);
            int width = Integer.parseInt(splitStr[2]);
            int height = Integer.parseInt(splitStr[3]);
            return new Rectangle(x, y, width, height);
        }
        if (type2 instanceof Class && ((Class)type2).isEnum()) {
            return Enum.valueOf((Class)type2, str);
        }
        if (type2 == Instant.class) {
            return Instant.parse(str);
        }
        if (type2 == Keybind.class || type2 == ModifierlessKeybind.class) {
            String[] splitStr = str.split(":");
            int code = Integer.parseInt(splitStr[0]);
            int mods = Integer.parseInt(splitStr[1]);
            if (type2 == ModifierlessKeybind.class) {
                return new ModifierlessKeybind(code, mods);
            }
            return new Keybind(code, mods);
        }
        if (type2 == WorldPoint.class) {
            String[] splitStr = str.split(":");
            int x = Integer.parseInt(splitStr[0]);
            int y = Integer.parseInt(splitStr[1]);
            int plane = Integer.parseInt(splitStr[2]);
            return new WorldPoint(x, y, plane);
        }
        if (type2 == Duration.class) {
            return Duration.ofMillis(Long.parseLong(str));
        }
        if (type2 == byte[].class) {
            return Base64.getUrlDecoder().decode(str);
        }
        if (type2 instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type2).getRawType() == Set.class) {
            return this.gson.fromJson(str, (Type)parameterizedType);
        }
        return str;
    }

    @Nullable
    String objectToString(Object object) {
        if (object instanceof Color) {
            return String.valueOf(((Color)object).getRGB());
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        if (object instanceof Dimension) {
            Dimension d = (Dimension)object;
            return d.width + "x" + d.height;
        }
        if (object instanceof Point) {
            Point p = (Point)object;
            return p.x + ":" + p.y;
        }
        if (object instanceof Rectangle) {
            Rectangle r = (Rectangle)object;
            return r.x + ":" + r.y + ":" + r.width + ":" + r.height;
        }
        if (object instanceof Instant) {
            return ((Instant)object).toString();
        }
        if (object instanceof Keybind) {
            Keybind k = (Keybind)object;
            return k.getKeyCode() + ":" + k.getModifiers();
        }
        if (object instanceof WorldPoint) {
            WorldPoint wp = (WorldPoint)object;
            return wp.getX() + ":" + wp.getY() + ":" + wp.getPlane();
        }
        if (object instanceof Duration) {
            return Long.toString(((Duration)object).toMillis());
        }
        if (object instanceof byte[]) {
            return Base64.getUrlEncoder().encodeToString((byte[])object);
        }
        if (object instanceof Set) {
            return this.gson.toJson(object, (Type)((Object)Set.class));
        }
        return object == null ? null : object.toString();
    }

    @Subscribe(priority=-100.0f)
    private void onClientShutdown(ClientShutdown e) {
        this.sendConfig();
    }

    public void sendConfig() {
        this.eventBus.post(new ConfigSync());
        try (ProfileManager.Lock lock = this.profileManager.lock();){
            this.profile = ConfigManager.updateProfile(lock, this.profile);
            this.rsProfile = ConfigManager.updateProfile(lock, this.rsProfile);
            this.saveConfiguration(lock, this.profile, this.configProfile);
            this.saveConfiguration(lock, this.rsProfile, this.rsProfileConfigProfile);
        }
    }

    private static ConfigProfile updateProfile(ProfileManager.Lock lock, ConfigProfile profile) {
        ConfigProfile p = lock.findProfile(profile.getId());
        if (p == null) {
            log.warn("Lost active profile {}!", (Object)profile.getName());
            p = lock.createProfile(profile.getName(), profile.getId());
            p.setActive(profile.isActive());
        } else if (profile.getRev() != p.getRev()) {
            log.debug("Profile {} changed on disk", (Object)p.getName());
        }
        return p;
    }

    private void saveConfiguration(ProfileManager.Lock lock, ConfigProfile profile, ConfigData data2) {
        Map<String, String> patch = data2.swapChanges();
        if (patch.isEmpty()) {
            return;
        }
        log.debug("Saving profile {} (patch size: {})", (Object)profile.getName(), (Object)patch.size());
        data2.patch(patch);
    }

    public List<RuneScapeProfile> getRSProfiles() {
        String prefix = "rsprofile.rsprofile.";
        HashSet<String> profileKeys = new HashSet<String>();
        for (String key2 : this.rsProfileConfigProfile.keySet()) {
            String[] split;
            if (!key2.startsWith(prefix) || (split = ConfigManager.splitKey(key2)) == null) continue;
            profileKeys.add(split[1]);
        }
        return profileKeys.stream().map(key -> {
            Long accid = (Long)this.getConfiguration(RSPROFILE_GROUP, (String)key, RSPROFILE_ACCOUNT_HASH, Long.TYPE);
            RuneScapeProfile prof = new RuneScapeProfile(this.getConfiguration(RSPROFILE_GROUP, (String)key, RSPROFILE_DISPLAY_NAME), (RuneScapeProfileType)((Object)((Object)this.getConfiguration(RSPROFILE_GROUP, (String)key, RSPROFILE_TYPE, (Type)((Object)RuneScapeProfileType.class)))), accid == null ? -1L : accid, (String)key);
            return prof;
        }).sorted(Comparator.comparing(RuneScapeProfile::getKey)).collect(Collectors.toCollection(ArrayList::new));
    }

    private synchronized RuneScapeProfile findRSProfile(List<RuneScapeProfile> profiles, long accountHash, RuneScapeProfileType type2, String displayName, boolean create) {
        if (accountHash == -1L) {
            return null;
        }
        List matches = profiles.stream().filter(p -> p.getType() == type2 && accountHash == p.getAccountHash()).collect(Collectors.toList());
        if (matches.size() > 1) {
            log.warn("multiple matching profiles, choosing {}, ignoring {}", matches.get(0), (Object)matches.subList(1, matches.size()));
        }
        if (matches.size() >= 1) {
            return (RuneScapeProfile)matches.get(0);
        }
        if (!create) {
            return null;
        }
        Set keys2 = profiles.stream().map(RuneScapeProfile::getKey).collect(Collectors.toSet());
        byte[] key = new byte[]{(byte)accountHash, (byte)(accountHash >> 8), (byte)(accountHash >> 16), (byte)(accountHash >> 24), (byte)(accountHash >> 32), (byte)(accountHash >> 40)};
        key[0] = (byte)(key[0] + type2.ordinal());
        for (int i = 0; i < 255; ++i) {
            String keyStr = "rsprofile." + Base64.getUrlEncoder().encodeToString(key);
            if (!keys2.contains(keyStr)) {
                log.info("creating new profile {} for account hash {} ({})", new Object[]{keyStr, accountHash, type2});
                this.setConfiguration(RSPROFILE_GROUP, keyStr, RSPROFILE_ACCOUNT_HASH, accountHash);
                this.setConfiguration(RSPROFILE_GROUP, keyStr, RSPROFILE_TYPE, type2);
                if (displayName != null) {
                    this.setConfiguration(RSPROFILE_GROUP, keyStr, RSPROFILE_DISPLAY_NAME, displayName);
                }
                return new RuneScapeProfile(displayName, type2, accountHash, keyStr);
            }
            key[1] = (byte)(key[1] + 1);
        }
        throw new RuntimeException("too many rs profiles");
    }

    private void updateRSProfile() {
        String key;
        if (this.client == null) {
            return;
        }
        List<RuneScapeProfile> profiles = this.getRSProfiles();
        RuneScapeProfile prof = this.findRSProfile(profiles, this.client.getAccountHash(), RuneScapeProfileType.getCurrent(this.client), null, false);
        String string2 = key = prof == null ? null : prof.getKey();
        if (Objects.equals(key, this.rsProfileKey)) {
            return;
        }
        this.rsProfileKey = key;
        log.debug("RS profile changed to {}", (Object)key);
        this.eventBus.post(new RuneScapeProfileChanged());
    }

    @Subscribe
    private void onAccountHashChanged(AccountHashChanged ev) {
        this.updateRSProfile();
    }

    @Subscribe
    private void onWorldChanged(WorldChanged ev) {
        this.updateRSProfile();
    }

    @Subscribe
    private void onPlayerChanged(PlayerChanged ev) {
        if (ev.getPlayer() == this.client.getLocalPlayer()) {
            String name = ev.getPlayer().getName();
            this.setRSProfileConfiguration(RSPROFILE_GROUP, RSPROFILE_DISPLAY_NAME, name);
        }
    }

    @Subscribe
    private void onRuneScapeProfileChanged(RuneScapeProfileChanged ev) {
        ConfigProfile switchToProfile = null;
        try (ProfileManager.Lock lock = this.profileManager.lock();){
            for (ConfigProfile lockProfile : lock.getProfiles()) {
                List<String> get2 = lockProfile.getDefaultForRsProfiles();
                if (get2 == null || !get2.contains(this.rsProfileKey)) continue;
                switchToProfile = lockProfile;
                lock.getProfiles().forEach(p -> p.setActive(false));
                switchToProfile.setActive(true);
                lock.dirty();
                break;
            }
        }
        if (switchToProfile != null) {
            log.debug("Switching to default profile {} for rsprofile {}", (Object)switchToProfile.getName(), (Object)this.rsProfileKey);
            this.switchProfile(switchToProfile);
        }
    }

    @Nullable
    @VisibleForTesting
    static String[] splitKey(String key) {
        int i = key.indexOf(46);
        if (i == -1) {
            return null;
        }
        String group = key.substring(0, i);
        String profile = null;
        if ((key = key.substring(i + 1)).startsWith("rsprofile.")) {
            i = key.indexOf(46, RSPROFILE_GROUP.length() + 2);
            profile = key.substring(0, i);
            key = key.substring(i + 1);
        }
        return new String[]{group, profile, key};
    }

    public ConfigProfile getProfile() {
        return this.profile;
    }
}

