/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.UnsafeUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ToolkitLock;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTJNILibLoader;
import jogamp.nativewindow.jawt.x11.X11SunJDKReflection;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.nativewindow.x11.X11Lib;

public class JAWTUtil {
    public static final boolean DEBUG;
    private static final boolean SKIP_AWT_HIDPI;
    public static final int JAWT_MACOSX_USE_CALAYER = Integer.MIN_VALUE;
    public static final VersionNumber JAWT_MacOSXCALayerMinVersion;
    public static final VersionNumber JAWT_MacOSXCALayerRequiredForJavaVersion;
    private static final boolean headlessMode;
    private static final JAWT jawtLockObject;
    private static final Method isQueueFlusherThread;
    private static final boolean j2dExist;
    private static final Method stkAWTLockMID;
    private static final Method stkAWTUnlockMID;
    private static final boolean hasSTKAWTLock;
    private static final Method stkDisableBackgroundEraseMID;
    private static final RecursiveLock jawtLock;
    private static final ToolkitLock jawtToolkitLock;
    private static final Method gdGetScaleFactorMID;
    private static final Method gdGetCGDisplayIDMIDOnOSX;
    public static final int JAWT_OSX_CALAYER_QUIRK_SIZE = 1;
    public static final int JAWT_OSX_CALAYER_QUIRK_POSITION = 2;
    public static final int JAWT_OSX_CALAYER_QUIRK_LAYOUT = 4;

    public static boolean isOffscreenLayerSupported() {
        return PlatformPropsImpl.OS_TYPE == Platform.OSType.MACOS && PlatformPropsImpl.OS_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerMinVersion) >= 0;
    }

    public static boolean isOffscreenLayerRequired() {
        return PlatformPropsImpl.OS_TYPE == Platform.OSType.MACOS && PlatformPropsImpl.JAVA_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerRequiredForJavaVersion) >= 0;
    }

    public static int getOSXCALayerQuirks() {
        int n = 0;
        if (PlatformPropsImpl.OS_TYPE == Platform.OSType.MACOS && PlatformPropsImpl.OS_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerMinVersion) >= 0) {
            n |= 1;
            int n2 = PlatformPropsImpl.JAVA_VERSION_NUMBER.compareTo(PlatformPropsImpl.Version17);
            n = n2 < 0 || n2 == 0 && PlatformPropsImpl.JAVA_VERSION_UPDATE < 40 ? (n |= 2) : (n |= 4);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JAWT getJAWT(boolean bl) {
        boolean bl2;
        boolean bl3;
        JAWT jAWT = JAWT.create();
        int n = 65540;
        if (JAWTUtil.isOffscreenLayerRequired()) {
            if (PlatformPropsImpl.OS_TYPE != Platform.OSType.MACOS) throw new InternalError("offscreen required, but n/a for: " + (Object)((Object)PlatformPropsImpl.OS_TYPE));
            if (PlatformPropsImpl.OS_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerMinVersion) < 0) throw new RuntimeException("OSX: Invalid version of Java (" + PlatformPropsImpl.JAVA_VERSION_NUMBER + ") / OS X (" + PlatformPropsImpl.OS_VERSION_NUMBER + ")");
            n |= Integer.MIN_VALUE;
            bl3 = true;
            bl2 = false;
        } else if (bl && JAWTUtil.isOffscreenLayerSupported()) {
            if (PlatformPropsImpl.OS_TYPE != Platform.OSType.MACOS) throw new InternalError("offscreen requested and supported, but n/a for: " + (Object)((Object)PlatformPropsImpl.OS_TYPE));
            n |= Integer.MIN_VALUE;
            bl3 = true;
            bl2 = true;
        } else {
            bl3 = false;
            bl2 = true;
        }
        if (DEBUG) {
            System.err.println("JAWTUtil.getJAWT(tryOffscreenLayer " + bl3 + ", tryOnscreen " + bl2 + ")");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3) {
            stringBuilder.append("Offscreen 0x").append(Integer.toHexString(n));
            if (JAWT.getJAWT(jAWT, n)) {
                return jAWT;
            }
        }
        if (!bl2) throw new RuntimeException("Unable to initialize JAWT, trials: " + stringBuilder.toString());
        if (bl3) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("Onscreen 0x").append(Integer.toHexString(65540));
        if (!JAWT.getJAWT(jAWT, 65540)) throw new RuntimeException("Unable to initialize JAWT, trials: " + stringBuilder.toString());
        return jAWT;
    }

    public static boolean isJAWTUsingOffscreenLayer(JAWT jAWT) {
        return 0 != (jAWT.getCachedVersion() & Integer.MIN_VALUE);
    }

    public static void initSingleton() {
    }

    public static void shutdown() {
    }

    public static boolean hasJava2D() {
        return j2dExist;
    }

    public static boolean isJava2DQueueFlusherThread() {
        boolean bl = false;
        if (j2dExist) {
            try {
                bl = (Boolean)isQueueFlusherThread.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean isHeadlessMode() {
        return headlessMode;
    }

    public static void lockToolkit() throws NativeWindowException {
        jawtLock.lock();
        if (1 == jawtLock.getHoldCount() && !headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            if (hasSTKAWTLock) {
                try {
                    stkAWTLockMID.invoke(null, (Object[])null);
                }
                catch (Exception exception) {
                    throw new NativeWindowException("SunToolkit.awtLock failed", exception);
                }
            } else {
                jawtLockObject.Lock();
            }
        }
        if (ToolkitLock.TRACE_LOCK) {
            System.err.println("JAWTUtil-ToolkitLock.lock(): " + jawtLock);
        }
    }

    public static void unlockToolkit() {
        jawtLock.validateLocked();
        if (ToolkitLock.TRACE_LOCK) {
            System.err.println("JAWTUtil-ToolkitLock.unlock(): " + jawtLock);
        }
        if (1 == jawtLock.getHoldCount() && !headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            if (hasSTKAWTLock) {
                try {
                    stkAWTUnlockMID.invoke(null, (Object[])null);
                }
                catch (Exception exception) {
                    throw new NativeWindowException("SunToolkit.awtUnlock failed", exception);
                }
            } else {
                jawtLockObject.Unlock();
            }
        }
        jawtLock.unlock();
    }

    public static final void validateLocked() throws RuntimeException {
        jawtLock.validateLocked();
    }

    public static ToolkitLock getJAWTToolkitLock() {
        return jawtToolkitLock;
    }

    public static boolean disableBackgroundErase(Component component) {
        block3: {
            if (null != stkDisableBackgroundEraseMID) {
                try {
                    stkDisableBackgroundEraseMID.invoke((Object)component.getToolkit(), component);
                    return true;
                }
                catch (Exception exception) {
                    if (!DEBUG) break block3;
                    ExceptionUtils.dumpThrowable("JAWTUtil", exception);
                }
            }
        }
        return false;
    }

    public static final Integer getMonitorDisplayID(GraphicsDevice graphicsDevice) {
        if (null != gdGetCGDisplayIDMIDOnOSX) {
            try {
                Object object = gdGetCGDisplayIDMIDOnOSX.invoke((Object)graphicsDevice, new Object[0]);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static final boolean getPixelScale(GraphicsDevice graphicsDevice, float[] fArray, float[] fArray2) {
        boolean bl = fArray[0] != 1.0f || fArray[1] != 1.0f;
        fArray[0] = 1.0f;
        fArray[1] = 1.0f;
        float f = 1.0f;
        float f2 = 1.0f;
        boolean bl2 = false;
        if (!SKIP_AWT_HIDPI) {
            Object object;
            if (null != gdGetCGDisplayIDMIDOnOSX) {
                try {
                    object = gdGetCGDisplayIDMIDOnOSX.invoke((Object)graphicsDevice, new Object[0]);
                    if (object instanceof Integer) {
                        int n = (Integer)object;
                        f2 = f = OSXUtil.GetScreenPixelScaleByDisplayID(n);
                        bl2 = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!bl2 && null != gdGetScaleFactorMID) {
                try {
                    object = gdGetScaleFactorMID.invoke((Object)graphicsDevice, new Object[0]);
                    if (object instanceof Integer) {
                        f = ((Integer)object).floatValue();
                    } else if (object instanceof Double) {
                        f = ((Double)object).floatValue();
                    }
                    f2 = f;
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!bl2) {
                object = graphicsDevice.getDefaultConfiguration();
                AffineTransform affineTransform = ((GraphicsConfiguration)object).getDefaultTransform();
                f = (float)affineTransform.getScaleX();
                f2 = (float)affineTransform.getScaleY();
            }
        }
        bl = fArray2[0] != f || fArray2[1] != f2;
        fArray2[0] = f;
        fArray2[1] = f2;
        return bl;
    }

    public static final boolean getPixelScale(GraphicsConfiguration graphicsConfiguration, float[] fArray, float[] fArray2) {
        boolean bl;
        GraphicsDevice graphicsDevice;
        GraphicsDevice graphicsDevice2 = graphicsDevice = null != graphicsConfiguration ? graphicsConfiguration.getDevice() : null;
        if (null == graphicsDevice) {
            bl = fArray[0] != 1.0f || fArray[1] != 1.0f || fArray2[0] != 1.0f || fArray2[1] != 1.0f;
            fArray[0] = 1.0f;
            fArray[1] = 1.0f;
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
        } else {
            bl = JAWTUtil.getPixelScale(graphicsDevice, fArray, fArray2);
        }
        return bl;
    }

    private static String getThreadName() {
        return Thread.currentThread().getName();
    }

    private static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    public static AbstractGraphicsDevice createDevice(Component component) throws IllegalArgumentException {
        String string2;
        if (!component.isDisplayable()) {
            throw new IllegalArgumentException("Given AWT-Component is not displayable: " + component);
        }
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (null == graphicsConfiguration) {
            throw new IllegalArgumentException("Given AWT-Component has no GraphicsConfiguration set: " + component);
        }
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        String string3 = NativeWindowFactory.getNativeWindowType(true);
        if (".x11" == string3) {
            long l = X11SunJDKReflection.graphicsDeviceGetDisplay(graphicsDevice);
            if (0L == l) {
                string2 = null;
                if (DEBUG) {
                    System.err.println(JAWTUtil.getThreadName() + " - JAWTUtil.createDevice: Null AWT dpy, default X11 display");
                }
            } else {
                string2 = X11Lib.XDisplayString(l);
                if (DEBUG) {
                    System.err.println(JAWTUtil.getThreadName() + " - JAWTUtil.createDevice: AWT dpy " + string2 + " / " + JAWTUtil.toHexString(l));
                }
            }
        } else {
            string2 = null;
        }
        return NativeWindowFactory.createDevice(string2, true);
    }

    public static AbstractGraphicsScreen getAbstractGraphicsScreen(Component component) throws IllegalArgumentException {
        AbstractGraphicsDevice abstractGraphicsDevice = JAWTUtil.createDevice(component);
        return NativeWindowFactory.createScreen(abstractGraphicsDevice, AWTGraphicsScreen.findScreenIndex(component.getGraphicsConfiguration().getDevice()));
    }

    static {
        Serializable serializable;
        DEBUG = Debug.debug("JAWT");
        JAWT_MacOSXCALayerMinVersion = new VersionNumber(10, 6, 4);
        JAWT_MacOSXCALayerRequiredForJavaVersion = Platform.Version17;
        SKIP_AWT_HIDPI = PropertyAccess.isPropertyDefined("nativewindow.awt.nohidpi", true);
        if (DEBUG) {
            System.err.println("JAWTUtil initialization (JAWT/JNI/...); SKIP_AWT_HIDPI " + SKIP_AWT_HIDPI);
        }
        if (headlessMode = GraphicsEnvironment.isHeadless()) {
            jawtLockObject = null;
            isQueueFlusherThread = null;
            j2dExist = false;
            stkAWTLockMID = null;
            stkAWTUnlockMID = null;
            hasSTKAWTLock = false;
            stkDisableBackgroundEraseMID = null;
            gdGetScaleFactorMID = null;
            gdGetCGDisplayIDMIDOnOSX = null;
        } else {
            boolean bl;
            Object object;
            block17: {
                JAWTJNILibLoader.initSingleton();
                if (!NWJNILibLoader.loadNativeWindow("awt")) {
                    throw new NativeWindowException("NativeWindow AWT native library load error.");
                }
                jawtLockObject = JAWTUtil.getJAWT(false);
                boolean bl2 = false;
                serializable = null;
                Method method = null;
                try {
                    serializable = Class.forName("jogamp.opengl.awt.Java2D");
                    method = ((Class)serializable).getMethod("isQueueFlusherThread", null);
                    bl2 = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                isQueueFlusherThread = method;
                j2dExist = bl2;
                object = AccessController.doPrivileged(new PrivilegedAction<SunToolkitData>(){

                    @Override
                    public SunToolkitData run() {
                        return UnsafeUtil.doWithoutIllegalAccessLogger(new PrivilegedAction<SunToolkitData>(){

                            @Override
                            public SunToolkitData run() {
                                SunToolkitData sunToolkitData;
                                block2: {
                                    sunToolkitData = new SunToolkitData();
                                    try {
                                        Class<?> clazz = Class.forName("sun.awt.SunToolkit");
                                        sunToolkitData.awtLockMID = clazz.getDeclaredMethod("awtLock", new Class[0]);
                                        sunToolkitData.awtLockMID.setAccessible(true);
                                        sunToolkitData.awtUnlockMID = clazz.getDeclaredMethod("awtUnlock", new Class[0]);
                                        sunToolkitData.awtUnlockMID.setAccessible(true);
                                        sunToolkitData.disableBackgroundEraseMID = clazz.getDeclaredMethod("disableBackgroundErase", Component.class);
                                        sunToolkitData.disableBackgroundEraseMID.setAccessible(true);
                                        sunToolkitData.ok = true;
                                    }
                                    catch (Exception exception) {
                                        if (!DEBUG) break block2;
                                        System.err.println("JAWTUtil stk.0: " + exception.getMessage());
                                    }
                                }
                                return sunToolkitData;
                            }
                        });
                    }
                });
                stkAWTLockMID = ((SunToolkitData)object).awtLockMID;
                stkAWTUnlockMID = ((SunToolkitData)object).awtUnlockMID;
                stkDisableBackgroundEraseMID = ((SunToolkitData)object).disableBackgroundEraseMID;
                bl = false;
                if (((SunToolkitData)object).ok) {
                    try {
                        stkAWTLockMID.invoke(null, (Object[])null);
                        stkAWTUnlockMID.invoke(null, (Object[])null);
                        bl = true;
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block17;
                        System.err.println("JAWTUtil stk.awtLock.1: " + exception.getMessage());
                    }
                }
            }
            hasSTKAWTLock = bl;
            if (PlatformPropsImpl.JAVA_9) {
                gdGetScaleFactorMID = null;
                gdGetCGDisplayIDMIDOnOSX = null;
            } else {
                object = (GraphicsDeviceData)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        GraphicsDeviceData graphicsDeviceData;
                        block3: {
                            graphicsDeviceData = new GraphicsDeviceData();
                            try {
                                GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                                Class<?> clazz = graphicsDevice.getClass();
                                graphicsDeviceData.getScaleFactorMID = clazz.getDeclaredMethod("getScaleFactor", new Class[0]);
                                graphicsDeviceData.getScaleFactorMID.setAccessible(true);
                                if (Platform.OSType.MACOS == PlatformPropsImpl.OS_TYPE) {
                                    graphicsDeviceData.getCGDisplayIDMIDOnOSX = clazz.getDeclaredMethod("getCGDisplayID", new Class[0]);
                                    graphicsDeviceData.getCGDisplayIDMIDOnOSX.setAccessible(true);
                                }
                            }
                            catch (Throwable throwable) {
                                if (!DEBUG) break block3;
                                System.err.println("JAWTUtil scaleFactor: " + throwable.getMessage());
                            }
                        }
                        return graphicsDeviceData;
                    }
                });
                gdGetScaleFactorMID = ((GraphicsDeviceData)object).getScaleFactorMID;
                gdGetCGDisplayIDMIDOnOSX = ((GraphicsDeviceData)object).getCGDisplayIDMIDOnOSX;
            }
        }
        jawtLock = LockFactory.createRecursiveLock();
        jawtToolkitLock = new ToolkitLock(){

            @Override
            public final void lock() {
                JAWTUtil.lockToolkit();
            }

            @Override
            public final void unlock() {
                JAWTUtil.unlockToolkit();
            }

            @Override
            public final void validateLocked() throws RuntimeException {
                JAWTUtil.validateLocked();
            }

            @Override
            public final void dispose() {
            }

            public String toString() {
                return "JAWTToolkitLock[obj 0x" + Integer.toHexString(this.hashCode()) + ", isOwner " + jawtLock.isOwner(Thread.currentThread()) + ", " + jawtLock + "]";
            }
        };
        Map map2 = null;
        try {
            if (EventQueue.isDispatchThread()) {
                map2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            } else {
                serializable = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable((ArrayList)serializable){
                    final /* synthetic */ ArrayList val$desktophintsBucket;
                    {
                        this.val$desktophintsBucket = arrayList;
                    }

                    @Override
                    public void run() {
                        Map map2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                        if (null != map2) {
                            this.val$desktophintsBucket.add(map2);
                        }
                    }
                });
                map2 = ((ArrayList)serializable).size() > 0 ? (Map)((ArrayList)serializable).get(0) : null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("JAWTUtil: Has sun.awt.SunToolkit: awtLock/awtUnlock " + hasSTKAWTLock + ", disableBackgroundErase " + (null != stkDisableBackgroundEraseMID));
            System.err.println("JAWTUtil: Has Java2D " + j2dExist);
            System.err.println("JAWTUtil: Is headless " + headlessMode);
            int n = null != map2 ? map2.size() : 0;
            System.err.println("JAWTUtil: AWT Desktop hints " + n);
            System.err.println("JAWTUtil: OffscreenLayer Supported: " + JAWTUtil.isOffscreenLayerSupported() + " - Required " + JAWTUtil.isOffscreenLayerRequired());
        }
    }

    private static class GraphicsDeviceData {
        Method getScaleFactorMID;
        Method getCGDisplayIDMIDOnOSX;
        boolean ok;

        GraphicsDeviceData() {
        }
    }

    private static class SunToolkitData {
        Method awtLockMID;
        Method awtUnlockMID;
        Method disableBackgroundEraseMID;
        boolean ok;

        SunToolkitData() {
        }
    }
}

