/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.util.Bitstream;
import java.util.ArrayList;
import java.util.List;
import jogamp.common.os.elf.IOUtils;
import jogamp.common.os.elf.Section;
import jogamp.common.os.elf.SectionHeader;

public class SectionArmAttributes
extends Section {
    public static final byte FORMAT_VERSION_A = 65;
    public static final byte ABI_VFP_ARGS_IS_BASE_VARIANT = 0;
    public static final byte ABI_VFP_ARGS_IS_VFP_VARIANT = 1;
    public static final byte ABI_VFP_ARGS_IS_CUSTOM_VARIANT = 2;
    public static final byte ABI_VFP_ARGS_IS_BOTH_BASE_AND_VFP_VARIANT = 3;
    public final List<VendorAttributes> vendorAttributesList;

    public static final boolean abiVFPArgsAcceptsVFPVariant(byte by) {
        return 1 == by || 3 == by;
    }

    SectionArmAttributes(SectionHeader sectionHeader, byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        super(sectionHeader, byArray, n, n2);
        this.vendorAttributesList = SectionArmAttributes.parse(sectionHeader, byArray, n, n2);
    }

    @Override
    public String toString() {
        return "SectionArmAttributes[" + super.toSubString() + ", " + this.vendorAttributesList.toString() + "]";
    }

    public final Attribute get(Tag tag) {
        for (int i = 0; i < this.vendorAttributesList.size(); ++i) {
            List<Attribute> list = this.vendorAttributesList.get((int)i).attributes;
            for (int j = 0; j < list.size(); ++j) {
                Attribute attribute = list.get(j);
                if (attribute.tag != tag) continue;
                return attribute;
            }
        }
        return null;
    }

    public final List<Attribute> get(String string2) {
        return SectionArmAttributes.get(this.vendorAttributesList, string2);
    }

    static final List<Attribute> get(List<VendorAttributes> list, String string2) {
        for (int i = 0; i < list.size(); ++i) {
            VendorAttributes vendorAttributes = list.get(i);
            if (!vendorAttributes.vendor.equals(string2)) continue;
            return vendorAttributes.attributes;
        }
        return null;
    }

    static List<VendorAttributes> parse(SectionHeader sectionHeader, byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        Bitstream.checkBounds(byArray, n, n2);
        Object object = n;
        if (65 != byArray[object]) {
            throw new IllegalArgumentException("ShArmAttr: Not version A, but: " + IOUtils.toHexString(byArray[object]));
        }
        ++object;
        ArrayList<VendorAttributes> arrayList = new ArrayList<VendorAttributes>();
        boolean bl = sectionHeader.eh2.eh1.isBigEndian();
        while (object < n2) {
            Object object2;
            int n3 = object;
            int n4 = IOUtils.readUInt32(bl, byArray, object);
            Object object3 = new int[]{0};
            String string2 = IOUtils.getString(byArray, object += 4, n4 - 4, object3);
            object = object3[0];
            object3 = new ArrayList();
            while (object < n4) {
                object2 = new int[]{0};
                SectionArmAttributes.parseSub(bl, byArray, object, n4 - object, (int[])object2, (List<Attribute>)object3);
                object = object2[0];
            }
            if (n3 + n4 != object) {
                throw new IllegalArgumentException("ShArmAttr: Section length count mismatch, expected " + (n3 + n4) + ", has " + object);
            }
            object2 = SectionArmAttributes.get(arrayList, string2);
            if (null != object2) {
                object2.addAll(object3);
                continue;
            }
            arrayList.add(new VendorAttributes(string2, (List<Attribute>)object3));
        }
        return arrayList;
    }

    private static void parseSub(boolean bl, byte[] byArray, int n, int n2, int[] nArray, List<Attribute> list) throws IndexOutOfBoundsException, IllegalArgumentException {
        int n3;
        Bitstream.checkBounds(byArray, n, n2);
        int n4 = n;
        byte by = byArray[n4++];
        Tag tag = Tag.get(by);
        if (null == tag) {
            throw new IllegalArgumentException("ShArmAttr: Invalid Sub-Section tag (NaT): " + by);
        }
        switch (tag) {
            case File: 
            case Section: 
            case Symbol: {
                n3 = IOUtils.readUInt32(bl, byArray, n4);
                n4 += 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("ShArmAttr: Invalid Sub-Section tag: " + (Object)((Object)tag));
            }
        }
        if (Tag.File == tag) {
            block7: while (n4 < n + n3) {
                byte by2;
                Tag tag2;
                if (null == (tag2 = Tag.get(by2 = byArray[n4++]))) {
                    throw new IllegalArgumentException("ShArmAttr: Invalid Attribute tag (NaT): " + by2);
                }
                switch (tag2.type) {
                    case NTBS: {
                        int[] nArray2 = new int[]{0};
                        String string2 = IOUtils.getString(byArray, n4, n3 + n - n4, nArray2);
                        list.add(new Attribute(tag2, string2));
                        n4 = nArray2[0];
                        continue block7;
                    }
                    case ULEB128: {
                        byte by3 = byArray[n4++];
                        list.add(new Attribute(tag2, new Byte(by3)));
                        continue block7;
                    }
                }
                throw new IllegalArgumentException("ShArmAttr: Invalid Attribute tag: " + (Object)((Object)tag2));
            }
        }
        nArray[0] = n + n3;
    }

    public static class VendorAttributes {
        public final String vendor;
        public final List<Attribute> attributes;

        VendorAttributes(String string2, List<Attribute> list) {
            this.vendor = string2;
            this.attributes = list;
        }

        public String toString() {
            return this.vendor + this.attributes.toString();
        }
    }

    public static class Attribute {
        public final Tag tag;
        private final Object value;

        Attribute(Tag tag, Object object) {
            this.tag = tag;
            this.value = object;
        }

        public final boolean isNTBS() {
            return Type.NTBS == this.tag.type;
        }

        public final String getNTBS() {
            if (Type.NTBS == this.tag.type) {
                return (String)this.value;
            }
            throw new IllegalArgumentException("Not NTBS but " + (Object)((Object)this.tag.type));
        }

        public final boolean isULEB128() {
            return Type.ULEB128 == this.tag.type;
        }

        public final byte getULEB128() {
            if (Type.ULEB128 == this.tag.type) {
                return (Byte)this.value;
            }
            throw new IllegalArgumentException("Not ULEB128 but " + (Object)((Object)this.tag.type));
        }

        public String toString() {
            return (Object)((Object)this.tag) + " = " + this.value;
        }
    }

    public static enum Tag {
        None(0, Type.None),
        File(1, Type.SubSection),
        Section(2, Type.SubSection),
        Symbol(3, Type.SubSection),
        CPU_raw_name(4, Type.NTBS),
        CPU_name(5, Type.NTBS),
        CPU_arch(6, Type.ULEB128),
        CPU_arch_profile(7, Type.ULEB128),
        ARM_ISA_use(8, Type.ULEB128),
        THUMB_ISA_use(9, Type.ULEB128),
        FP_arch(10, Type.ULEB128),
        WMMX_arch(11, Type.ULEB128),
        Advanced_SIMD_arch(12, Type.ULEB128),
        PCS_config(13, Type.ULEB128),
        ABI_PCS_R9_use(14, Type.ULEB128),
        ABI_PCS_RW_data(15, Type.ULEB128),
        ABI_PCS_RO_data(16, Type.ULEB128),
        ABI_PCS_GOT_use(17, Type.ULEB128),
        ABI_PCS_wchar_t(18, Type.ULEB128),
        ABI_FP_rounding(19, Type.ULEB128),
        ABI_FP_denormal(20, Type.ULEB128),
        ABI_FP_exceptions(21, Type.ULEB128),
        ABI_FP_user_exceptions(22, Type.ULEB128),
        ABI_FP_number_model(23, Type.ULEB128),
        ABI_align_needed(24, Type.ULEB128),
        ABI_align_preserved(25, Type.ULEB128),
        ABI_enum_size(26, Type.ULEB128),
        ABI_HardFP_use(27, Type.ULEB128),
        ABI_VFP_args(28, Type.ULEB128),
        ABI_WMMX_args(29, Type.ULEB128),
        ABI_optimization_goals(30, Type.ULEB128),
        ABI_FP_optimization_goals(31, Type.ULEB128),
        compatibility(32, Type.NTBS),
        CPU_unaligned_access(34, Type.ULEB128),
        FP_HP_extension(36, Type.ULEB128),
        ABI_FP_16bit_format(38, Type.ULEB128),
        MPextension_use(42, Type.ULEB128),
        DIV_use(44, Type.ULEB128),
        nodefaults(64, Type.ULEB128),
        also_compatible_with(65, Type.ULEB128),
        T2EE_use(66, Type.ULEB128),
        conformance(67, Type.NTBS),
        Virtualization_use(68, Type.ULEB128),
        undefined69(69, Type.None),
        MPextension_use_legacy(70, Type.ULEB128);

        public final int id;
        public final Type type;

        public static Tag get(int n) {
            Tag[] tagArray = Tag.values();
            int n2 = tagArray.length;
            for (int i = 0; i < n2; ++i) {
                if (tagArray[i].id != n) continue;
                return tagArray[i];
            }
            return null;
        }

        private Tag(int n2, Type type2) {
            this.id = n2;
            this.type = type2;
        }
    }

    public static enum Type {
        None,
        SubSection,
        NTBS,
        ULEB128;

    }
}

