/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import org.reactivestreams.Subscriber;

public class AppendOnlyLinkedArrayList<T> {
    final int capacity;
    final Object[] head;
    Object[] tail;
    int offset;

    public AppendOnlyLinkedArrayList(int capacity) {
        this.capacity = capacity;
        this.head = new Object[capacity + 1];
        this.tail = this.head;
    }

    public void add(T value) {
        int o = this.offset;
        int c = this.capacity;
        if (o == c) {
            Object[] next2;
            this.tail[c] = next2 = new Object[c + 1];
            this.tail = next2;
            o = 0;
        }
        this.tail[o] = value;
        this.offset = o + 1;
    }

    public void setFirst(T value) {
        this.head[0] = value;
    }

    public void forEachWhile(NonThrowingPredicate<? super T> consumer) {
        Object[] a = this.head;
        int c = this.capacity;
        while (a != null) {
            Object o;
            for (int i = 0; i < c && (o = a[i]) != null; ++i) {
                if (!consumer.test(o)) continue;
                return;
            }
            a = (Object[])a[c];
        }
    }

    public <U> boolean accept(Subscriber<? super U> subscriber) {
        Object[] a = this.head;
        int c = this.capacity;
        while (a != null) {
            Object o;
            for (int i = 0; i < c && (o = a[i]) != null; ++i) {
                if (!NotificationLite.acceptFull(o, subscriber)) continue;
                return true;
            }
            a = (Object[])a[c];
        }
        return false;
    }

    public <U> boolean accept(Observer<? super U> observer) {
        Object[] a = this.head;
        int c = this.capacity;
        while (a != null) {
            Object o;
            for (int i = 0; i < c && (o = a[i]) != null; ++i) {
                if (!NotificationLite.acceptFull(o, observer)) continue;
                return true;
            }
            a = (Object[])a[c];
        }
        return false;
    }

    public <S> void forEachWhile(S state, BiPredicate<? super S, ? super T> consumer) throws Throwable {
        Object[] a = this.head;
        int c = this.capacity;
        while (true) {
            for (int i = 0; i < c; ++i) {
                Object o = a[i];
                if (o == null) {
                    return;
                }
                if (!consumer.test(state, o)) continue;
                return;
            }
            a = (Object[])a[c];
        }
    }

    public static interface NonThrowingPredicate<T>
    extends Predicate<T> {
        @Override
        public boolean test(T var1);
    }
}

