/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.security;

import com.thoughtworks.xstream.security.RegExpTypePermission;

public class WildcardTypePermission
extends RegExpTypePermission {
    public WildcardTypePermission(String[] patterns) {
        this(false, patterns);
    }

    public WildcardTypePermission(boolean allowAnonymous, String[] patterns) {
        super(WildcardTypePermission.getRegExpPatterns(patterns, allowAnonymous));
    }

    private static String[] getRegExpPatterns(String[] wildcards, boolean allowAnonymous) {
        if (wildcards == null) {
            return null;
        }
        String[] regexps = new String[wildcards.length];
        for (int i = 0; i < wildcards.length; ++i) {
            String wildcardExpression = wildcards[i];
            StringBuffer result2 = new StringBuffer(wildcardExpression.length() * 2);
            result2.append("(?u)");
            int length = wildcardExpression.length();
            block6: for (int j = 0; j < length; ++j) {
                char ch = wildcardExpression.charAt(j);
                switch (ch) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '|': {
                        result2.append('\\').append(ch);
                        continue block6;
                    }
                    case '?': {
                        result2.append('.');
                        continue block6;
                    }
                    case '*': {
                        if (j + 1 < length && wildcardExpression.charAt(j + 1) == '*') {
                            result2.append(allowAnonymous ? "[\\P{C}]*" : "[\\P{C}&&[^$]]*(?:\\$[^0-9$][\\P{C}&&[^.$]]*)*");
                            ++j;
                            continue block6;
                        }
                        result2.append(allowAnonymous ? "[\\P{C}&&[^.]]*" : "[\\P{C}&&[^.$]]*(?:\\$[^0-9$][\\P{C}&&[^.$]]*)*");
                        continue block6;
                    }
                    default: {
                        result2.append(ch);
                    }
                }
            }
            regexps[i] = result2.toString();
        }
        return regexps;
    }
}

