/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Errors;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.TypeConverter;

public final class TypeConverterBinding
implements Element {
    private final Object source;
    private final Matcher<? super TypeLiteral<?>> typeMatcher;
    private final TypeConverter typeConverter;

    public TypeConverterBinding(Object source2, Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter typeConverter) {
        this.source = Preconditions.checkNotNull(source2, "source");
        this.typeMatcher = Preconditions.checkNotNull(typeMatcher, "typeMatcher");
        this.typeConverter = Preconditions.checkNotNull(typeConverter, "typeConverter");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Matcher<? super TypeLiteral<?>> getTypeMatcher() {
        return this.typeMatcher;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).convertToTypes(this.typeMatcher, this.typeConverter);
    }

    public String toString() {
        String string2 = String.valueOf(this.typeConverter);
        String string3 = String.valueOf(this.typeMatcher);
        String string4 = String.valueOf(Errors.convert(this.source));
        return new StringBuilder(27 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append(" which matches ").append(string3).append(" (bound at ").append(string4).append(")").toString();
    }
}

