/*
 * Decompiled with CFR 0.152.
 */
package com.client.utilities;

import com.client.sign.Signlink;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.management.MBeanServer;

public class Misc {
    private static final DecimalFormat NUMBER_FORMAT_2 = new DecimalFormat("#.##");
    private static final DecimalFormat NUMBER_FORMAT_0 = new DecimalFormat("#");
    private static String OS;

    public static String formatNumber(double number) {
        return NumberFormat.getInstance().format(number);
    }

    public static String getOsName() {
        if (OS == null) {
            OS = System.getProperty("os.name");
        }
        return OS;
    }

    public static boolean isWindows() {
        return Misc.getOsName().startsWith("Windows");
    }

    public static String getUnderscoredNumber(int number) {
        Object string2 = String.valueOf(number);
        for (int i = ((String)string2).length() - 3; i > 0; i -= 3) {
            string2 = ((String)string2).substring(0, i) + "_" + ((String)string2).substring(i);
        }
        return string2;
    }

    public static String format(long amount) {
        if (amount >= 1000000000L) {
            return NUMBER_FORMAT_2.format((double)amount / 1.0E9) + "B";
        }
        if (amount >= 100000000L) {
            return NUMBER_FORMAT_0.format((double)amount / 1.0E8) + "M";
        }
        if (amount >= 1000000L) {
            return NUMBER_FORMAT_2.format((double)amount / 1000000.0) + "M";
        }
        if (amount >= 100000L) {
            return NUMBER_FORMAT_0.format((double)amount / 1000.0) + "K";
        }
        if (amount >= 1000L) {
            return NUMBER_FORMAT_2.format((double)amount / 1000.0) + "K";
        }
        return "" + amount;
    }

    public static void dumpHeap(boolean live) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            String outputFile = Signlink.getCacheDirectory() + "error_logs/" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm")) + ".hprof";
            mxBean.dumpHeap(outputFile, live);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        NUMBER_FORMAT_2.setRoundingMode(RoundingMode.DOWN);
        NUMBER_FORMAT_0.setRoundingMode(RoundingMode.DOWN);
        OS = null;
    }
}

