/*
 * Decompiled with CFR 0.152.
 */
package com.client.util.math;

public final class Quaternionf {
    private static final Quaternionf[] p;
    private static final int pl;
    private static int pc;
    public static final Quaternionf IDENTITY;
    float x;
    float y;
    float w;
    float z;

    public Quaternionf() {
        this.identity();
    }

    public Quaternionf(float x, float y, float w, float z) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.z = z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Quaternionf[] quaternionfArray = p;
        synchronized (p) {
            if (pc < pl - 1) {
                Quaternionf.p[Quaternionf.pc++] = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Quaternionf take() {
        Quaternionf[] quaternionfArray = p;
        synchronized (p) {
            if (pc == 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return new Quaternionf();
            }
            p[--pc].identity();
            // ** MonitorExit[var0] (shouldn't be in output)
            return p[pc];
        }
    }

    void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void faa(float a1, float a2, float a3, float air) {
        float s2 = (float)Math.sin(air * 0.5f);
        float c = (float)Math.cos(air * 0.5f);
        this.x = s2 * a1;
        this.y = a2 * s2;
        this.z = s2 * a3;
        this.w = c;
    }

    void identity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public void mp(Quaternionf other) {
        this.set(other.x * this.w + other.w * this.x + other.y * this.z - other.z * this.y, other.z * this.x + this.w * other.y + (this.y * other.w - this.z * other.x), other.x * this.y + other.w * this.z - this.x * other.y + other.z * this.w, other.w * this.w - other.x * this.x - this.y * other.y - other.z * this.z);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Quaternionf)) {
            return false;
        }
        Quaternionf other = (Quaternionf)o;
        return this.x == other.x && this.y == other.y && other.z == this.z && other.w == this.w;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z + "," + this.w;
    }

    public int hashCode() {
        float hashCode2 = 1.0f;
        hashCode2 = hashCode2 * 31.0f + this.x;
        hashCode2 = this.y + hashCode2 * 31.0f;
        hashCode2 = 31.0f * hashCode2 + this.z;
        hashCode2 = 31.0f * hashCode2 + this.w;
        return (int)hashCode2;
    }

    static {
        IDENTITY = new Quaternionf();
        pl = 100;
        p = new Quaternionf[100];
        pc = 0;
    }
}

