/*
 * Decompiled with CFR 0.152.
 */
package com.client.sound;

import com.client.features.settings.Preferences;
import java.io.File;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;

public class WavPlayer {
    public static final WavPlayer player = new WavPlayer();
    public static final float MIN_VOLUME_DB = -80.0f;
    public static final int MAX_VOLUME = 256;
    public static float volume = (int)(256.0f * (float)Preferences.getPreferences().musicVolume / 10.0f);

    public static void main(String args2) throws Exception {
        while (volume > 0.0f) {
            Clip c = player.play(new File(args2));
            Thread.sleep(c.getMicrosecondLength() / 1000L);
            FloatControl gain = (FloatControl)c.getControl(FloatControl.Type.MASTER_GAIN);
            gain.setValue(-80.0f * (256.0f - volume) / 256.0f);
        }
    }

    public Clip play(File f) throws Exception {
        return this.play(AudioSystem.getAudioInputStream(f));
    }

    public Clip play(InputStream in) throws Exception {
        return this.play(AudioSystem.getAudioInputStream(in));
    }

    public Clip play(AudioInputStream stream) throws Exception {
        Clip clip = AudioSystem.getClip();
        clip.open(stream);
        FloatControl gain = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
        gain.setValue(-80.0f * (256.0f - volume) / 256.0f);
        clip.start();
        return clip;
    }

    public void setVolume(float volume) {
        WavPlayer.volume = (int)volume;
    }

    public void setVolume(int volume) {
        WavPlayer.volume = volume;
    }

    public int getVolume() {
        return (int)volume;
    }
}

