/*
 * Decompiled with CFR 0.152.
 */
package com.client.script;

import com.client.script.ClientScript;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;

public class ClientScripts {
    private static final Map<Integer, ClientScript> scripts = new HashMap<Integer, ClientScript>();

    public static void load() {
        Reflections reflections = new Reflections("com.client.script.impl", new SubTypesScanner(false));
        Set<Class<Object>> classes2 = reflections.getSubTypesOf(Object.class);
        Pattern pattern = Pattern.compile("_(\\d+)_", 2);
        classes2.forEach(clazz -> {
            Matcher matcher = pattern.matcher(clazz.getName());
            if (!matcher.find()) {
                System.err.println("Couldn't load class in com.client.script.impl because the id couldn't be derived:" + clazz.getName());
                return;
            }
            try {
                int scriptId = Integer.parseInt(matcher.group(1));
                Object instance = clazz.getConstructors()[0].newInstance(new Object[0]);
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.getName().equalsIgnoreCase("handle")) continue;
                    scripts.put(scriptId, new ClientScript(scriptId, instance, method));
                    return;
                }
                throw new IllegalStateException("No handle method for class: " + String.valueOf(clazz));
            }
            catch (Exception e) {
                System.err.println("Error parsing script" + clazz.getName());
                e.printStackTrace();
                return;
            }
        });
        System.out.println("Loaded " + scripts.size() + " client scripts.");
    }

    public static void execute(int id, Object[] arguments2) {
        if (!scripts.containsKey(id)) {
            return;
        }
        try {
            ClientScript script = scripts.get(id);
            script.getMethod().invoke(script.getInstance(), arguments2);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            System.err.println("Error invoking client script: " + id);
            e.printStackTrace();
        }
    }
}

