/*
 * Decompiled with CFR 0.152.
 */
package com.client.instruction;

import com.client.Client;
import com.client.Script;
import com.client.ScriptEvent;
import com.client.instruction.Instruction;
import com.client.instruction.InstructionArgs;
import com.client.instruction.InstructionId;

public class InstructionProcessor {
    public static void invoke(int instructionId, InstructionArgs args2) {
        try {
            InstructionId identifier = InstructionId.fromId(instructionId);
            if (identifier == InstructionId.NOTHING) {
                System.err.println("Could not invoke missing instruction with id " + instructionId + ".");
                return;
            }
            Instruction instruction = identifier.getInstruction();
            if (instruction == null) {
                System.err.println("No valid instruction mapped to id " + String.valueOf((Object)identifier) + ".");
                return;
            }
            System.out.println("Invoking script " + instruction.getClass().getName() + " with instructions [" + String.valueOf(args2) + "]");
            instruction.invoke(args2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void runScript(ScriptEvent var0, int var1, int var2) {
        Object[] var3 = var0.args;
        int var5 = (Integer)var3[0];
        Script var4 = Script.scripts[var5];
        if (var4 != null) {
            Client.runScriptLogic(var0, var4, var1, var2);
        }
    }

    public static void runScriptEvent(ScriptEvent var0) {
        InstructionProcessor.runScript(var0, 500000, 475000);
    }
}

