/*
 * Decompiled with CFR 0.152.
 */
package com.client.instruction;

import com.client.graphics.interfaces.RSInterface;
import java.util.Arrays;

public class InstructionArgs {
    private Integer[] intStack;
    private String[] stringStack;
    private int intStackPos;
    private int stringStackPos;

    public static InstructionArgs createStack() {
        return new InstructionArgs(new Integer[0], new String[0]);
    }

    public static InstructionArgs createFrom(Integer[] intArgs, String[] stringArgs) {
        return new InstructionArgs(intArgs, stringArgs);
    }

    public static InstructionArgs createFrom(InstructionArgs from) {
        Integer[] is = Arrays.copyOf(from.intStack, from.intStack.length);
        String[] ss = Arrays.copyOf(from.stringStack, from.stringStack.length);
        return InstructionArgs.createFrom(is, ss);
    }

    private InstructionArgs(Integer[] intArgs, String[] stringArgs) {
        this.intStack = intArgs;
        this.stringStack = stringArgs;
        this.intStackPos = this.intStack.length;
        this.stringStackPos = this.stringStack.length;
    }

    public int getNextInt() {
        return this.intStack[--this.intStackPos];
    }

    public RSInterface getNextInterface() {
        int id = this.getNextInt();
        if (id < 0 || id >= RSInterface.interfaceCache.length) {
            return null;
        }
        return RSInterface.interfaceCache[id];
    }

    public void addNextBool(boolean bool) {
        this.addNextInt(bool ? 1 : 0);
    }

    public boolean getNextBool() {
        return this.getNextInt() == 1;
    }

    public InstructionArgs addNextInt(int value) {
        if (this.intStackPos >= this.intStack.length) {
            int oldSize = this.intStack.length;
            Integer[] newStack = new Integer[oldSize + 1];
            System.arraycopy(this.intStack, 0, newStack, 0, oldSize);
            this.intStack = null;
            this.intStack = newStack;
        }
        this.intStack[this.intStackPos++] = value;
        return this;
    }

    public String getNextString() {
        return this.stringStack[--this.stringStackPos];
    }

    public InstructionArgs addNextString(String value) {
        if (this.stringStackPos >= this.stringStack.length) {
            int oldSize = this.stringStack.length;
            String[] newStack = new String[oldSize + 1];
            System.arraycopy(this.stringStack, 0, newStack, 0, oldSize);
            this.stringStack = null;
            this.stringStack = newStack;
        }
        this.stringStack[this.stringStackPos++] = value;
        return this;
    }

    public int getIntArg(int position) {
        return this.intStack[position];
    }

    public String getStringArg(int position) {
        return this.stringStack[this.stringStackPos - position];
    }

    public InstructionArgs intStackOffset(int offset) {
        this.intStackPos -= offset;
        return this;
    }

    public InstructionArgs stringStackOffset(int offset) {
        this.stringStackPos -= offset;
        return this;
    }

    public String toString() {
        return "InstructionArgs(intStack=" + Arrays.deepToString(this.intStack) + ", stringStack=" + Arrays.deepToString(this.stringStack) + ", intStackPos=" + this.intStackPos + ", stringStackPos=" + this.stringStackPos + ")";
    }
}

