/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.sprites;

import com.client.Sprite;
import com.client.sign.Signlink;
import java.io.File;

public class OsrsSprite {
    private Sprite[] cache = null;
    private static final File spriteDirectory = new File(Signlink.getCacheDirectory() + "sprites/osrs/");

    public Sprite getSprite(int id) {
        if (this.cache == null) {
            return null;
        }
        if (this.cache[id] == null) {
            this.cache[id] = this.load(id);
        }
        return this.cache[id];
    }

    public void startup() {
        System.out.println("spriteDirectory: " + spriteDirectory.getAbsolutePath());
        System.out.println("exists: " + spriteDirectory.exists());
        System.out.println("isDirectory: " + spriteDirectory.isDirectory());
        File[] files = spriteDirectory.listFiles();
        if (files == null) {
            System.err.println("Error: Unable to list files in the directory: " + String.valueOf(spriteDirectory));
            return;
        }
        System.out.println("Number of files: " + files.length);
        this.cache = new Sprite[files.length];
    }

    public Sprite load(int id) {
        if (this.cache[id] != null) {
            return this.cache[id];
        }
        Sprite sprite = new Sprite(id, true);
        return sprite;
    }

    public int cacheSize() {
        return this.cache.length;
    }

    public Sprite[] getCache() {
        return this.cache;
    }

    public void setCache(Sprite[] cache) {
        this.cache = cache;
    }

    public static File getSpriteDirectory() {
        return spriteDirectory;
    }
}

