/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl.health_hud;

import com.client.Client;
import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.builder.InterfaceBuilder;

public class HealthHud
extends InterfaceBuilder {
    public static int healthHudTimeoutTick = -1;
    public static final int WIDGET_ID = 19000;
    public static final int VARP_TYPE = 1312;
    public static final int VARP_HEALTH = 1313;
    public static int HEADER_ID = 19003;
    public static int PROGRESS_WIDGET_ID;

    public HealthHud() {
        super(19000);
    }

    @Override
    public void build() {
        int x = 148;
        int y = 25;
        int width = 210;
        int height = 46;
        HealthHud.addBox(this.nextInterface(), width, height, 1, 0, 0, 250);
        this.child(x, y);
        HealthHud.addRectangle(this.nextInterface(), width - 1, height - 3, 4010791, 0, true);
        this.child(x + 1, y + 1);
        HealthHud.addText(this.nextInterface(), 0, 0xFF9933, true, "Boss Name");
        this.child(width / 2 + x, y + 5);
        RSInterface progress = HealthHud.addProgressBar(this.nextInterface(), width - 5, 20, 2221, 10400);
        progress.font = Client.getInstance().newSmallFont;
        progress.fillColor = 65535;
        this.child(x + 6, y + 20);
        PROGRESS_WIDGET_ID = progress.id;
        HealthHud.setHudType(HudType.REGULAR);
        Client.instance.parallelWidgetList.add(this.getRoot());
    }

    public static void onVarpChange(int id, int value) {
        if (id == 1313) {
            int currentHealth = value & 0xFFFF;
            int maxHealth = value >> 16 & 0xFFFF;
            RSInterface progress = RSInterface.interfaceCache[PROGRESS_WIDGET_ID];
            progress.message = currentHealth + "/" + maxHealth;
        } else if (id == 1312) {
            HealthHud.setHudType(HudType.values()[value]);
        }
    }

    public static void setHudType(HudType type2) {
        RSInterface progress = RSInterface.interfaceCache[PROGRESS_WIDGET_ID];
        progress.fillColor = type2.getMainColor();
        progress.progressBackColor = type2.getBackColor();
        progress.progressBackAlpha = type2.getBackAlpha();
    }

    public static HudType getHudType() {
        return RSInterface.interfaceCache[HealthHud.PROGRESS_WIDGET_ID].hudType;
    }

    public static enum HudType {
        REGULAR(65280, 0xFF0000, 255),
        ORANGE_SHIELD(16747008, 0, 150),
        CYAN_SHIELD(65535, 0, 150),
        PURPLE_SHIELD(8130495, 0, 150),
        BLUE_SHIELD(3421419, 0, 150),
        YELLOW_SHIELD(14604050, 0, 150);

        private final int mainColor;
        private final int backColor;
        private final int backAlpha;

        public int getMainColor() {
            return this.mainColor;
        }

        public int getBackColor() {
            return this.backColor;
        }

        public int getBackAlpha() {
            return this.backAlpha;
        }

        private HudType(int mainColor, int backColor, int backAlpha) {
            this.mainColor = mainColor;
            this.backColor = backColor;
            this.backAlpha = backAlpha;
        }
    }
}

