/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.builder.impl.tasks;

import com.client.Sprite;
import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.builder.InterfaceBuilder;
import com.client.graphics.interfaces.builder.impl.tasks.TaskEntryHoverInterfaceBuilder;
import com.client.graphics.interfaces.builder.impl.tasks.TaskInterface;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskEntry;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskEntryType;

public class TaskEntryInterfaceBuilder
extends InterfaceBuilder {
    public static final int ENTRY_HEIGHT_SEPARATION = 28;
    public static int achievementsInterfaceSize;
    private static Sprite background;
    private static Sprite backgroundHover;
    private final TaskEntry taskEntry;
    private final TaskEntryType type;

    public TaskEntryInterfaceBuilder(TaskEntryType type2, int baseInterfaceId, TaskEntry taskEntry) {
        super(baseInterfaceId);
        this.taskEntry = taskEntry;
        this.type = type2;
        this.getRoot().width = 200;
        this.getRoot().height = 28;
    }

    @Override
    public void build() {
        if (background == null) {
            background = TaskInterface.getSprite("orange_outline_box");
            backgroundHover = TaskInterface.getSprite("orange_outline_box_hover");
            background.setTransparency(255, 255, 255);
        }
        try {
            int startInterfaceId = this.getCurrentInterfaceId();
            double completionPercentage = this.taskEntry.getCompletionPercentage();
            int color = RSInterface.getRgbProgressColor(completionPercentage);
            boolean claimable = this.taskEntry.isClaimable();
            String buttonText = claimable ? "Claim: " : "Select: ";
            RSInterface button = TaskEntryInterfaceBuilder.addButton(this.nextInterface(), background, buttonText + this.taskEntry.getTitle(), 4);
            this.child(0, 0);
            button.setHover(this.getCurrentInterfaceId(), TaskInterface.TEST_MODE ? 0L : 700L);
            TaskEntryHoverInterfaceBuilder hover = new TaskEntryHoverInterfaceBuilder(this.getCurrentInterfaceId(), 150, this.taskEntry);
            hover.build();
            this.setNextInterfaceId(hover.getCurrentInterfaceId());
            RSInterface title = TaskEntryInterfaceBuilder.addText(this.nextInterface(), 0, color, false, this.taskEntry.getTitle());
            this.child(4, 3);
            String progressText = claimable ? "<clan=6>Claim " : this.taskEntry.getProgressSlash(true);
            RSInterface progress = TaskEntryInterfaceBuilder.addLeftText(this.nextInterface(), 0, color, progressText);
            this.child(148, 3);
            int barWidth = 143 / this.taskEntry.getProgress().size();
            for (int index = 0; index < this.taskEntry.getProgress().size(); ++index) {
                double difficultyCompletionPercentage = this.taskEntry.getCompletionPercentage(index);
                TaskEntryInterfaceBuilder.addProgressBar2021(this.nextInterface(), barWidth, 6, 0);
                TaskEntryInterfaceBuilder.get((int)this.lastInterface()).progressBar2021Percentage = difficultyCompletionPercentage;
                this.child(4 + index * barWidth, 16);
            }
            this.getRoot().setNewButtonClicking();
            button.setHoverAction(() -> {
                if (button.isHovered) {
                    button.sprite1 = button.sprite2 = backgroundHover;
                    button.drawsTransparent = true;
                    button.transparency = 100;
                    title.textColor = 0xFFFFFF;
                    progress.textColor = 0xFFFFFF;
                } else {
                    button.sprite1 = button.sprite2 = background;
                    button.drawsTransparent = false;
                    title.textColor = color;
                    progress.textColor = color;
                }
            });
            if (this.type == TaskEntryType.ACHIEVEMENTS && achievementsInterfaceSize == 0) {
                achievementsInterfaceSize = this.getCurrentInterfaceId() - startInterfaceId + 1;
            }
        }
        catch (Exception e) {
            System.err.println("Error in entry: " + String.valueOf(this.taskEntry));
            e.printStackTrace();
        }
    }
}

