/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.builder.impl.tasks;

import com.client.StringUtils;
import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.builder.InterfaceBuilder;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskDifficulty;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskEntry;
import com.client.model.GameItem;

public class TaskEntryHoverInterfaceBuilder
extends InterfaceBuilder {
    private final int width;
    private final TaskEntry taskEntry;
    private int x;
    private int y;
    private int centerX;

    public TaskEntryHoverInterfaceBuilder(int baseInterfaceId, int width, TaskEntry taskEntry) {
        super(baseInterfaceId);
        this.width = width;
        this.taskEntry = taskEntry;
    }

    @Override
    public void build() {
        this.getRoot().type = 0;
        this.getRoot().height = 150;
        this.getRoot().width = this.width;
        this.x = 12;
        this.centerX = this.x + 75;
        RSInterface box = TaskEntryHoverInterfaceBuilder.addBox(this.nextInterface(), 0, 0xFFFFA0, 200, this.getRoot().width, this.getRoot().height);
        this.child(this.x, 0);
        this.y = 3;
        String difficulty = this.taskEntry.getTaskDifficulty() == TaskDifficulty.NONE ? "" : StringUtils.fixName(this.taskEntry.getTaskDifficulty().toString().toLowerCase());
        TaskEntryHoverInterfaceBuilder.addNewText(this.nextInterface(), difficulty, 0, 0, false, false);
        this.child(this.x + 2, this.y);
        if (difficulty.length() != 0) {
            this.y += this.getLineHeight(difficulty);
        }
        TaskEntryHoverInterfaceBuilder.addNewText(this.nextInterface(), this.taskEntry.getTitle(), 0, 0, true, false);
        this.child(this.centerX, this.y);
        int lineHeight = this.getLineHeight(this.taskEntry.getTitle());
        this.y += lineHeight;
        if (lineHeight > 0) {
            this.y += 4;
        }
        TaskEntryHoverInterfaceBuilder.addNewText(this.nextInterface(), this.taskEntry.getDescription(), 0, 0, true, false);
        this.child(this.centerX, this.y);
        lineHeight = this.getLineHeight(this.taskEntry.getDescription());
        this.y += lineHeight;
        if (lineHeight > 0) {
            this.y += 6;
        }
        String rewards = this.taskEntry.getExtraRewards().length() != 0 || this.taskEntry.getRewards() != null ? "Rewards" : "";
        TaskEntryHoverInterfaceBuilder.addNewText(this.nextInterface(), rewards, 0, 0, true, false);
        this.child(this.centerX, this.y);
        this.y += this.getLineHeight(rewards);
        this.createRewardItemsContainer();
        String extraRewards = this.taskEntry.getExtraRewards() == null ? "" : this.taskEntry.getExtraRewards();
        TaskEntryHoverInterfaceBuilder.addNewText(this.nextInterface(), extraRewards, 0, 0, true, false);
        this.child(this.centerX, this.y);
        this.y += this.getLineHeight(this.taskEntry.getExtraRewards());
        this.y += 4;
        box.height = this.y;
        this.getRoot().height = this.y;
    }

    private void createRewardItemsContainer() {
        int itemCount = this.taskEntry.getRewards() == null ? 0 : this.taskEntry.getRewards().size();
        int itemsWidth = Math.min(itemCount, 4);
        int itemsHeight = Math.max((int)Math.ceil((double)itemCount / 4.0), 1);
        RSInterface items = TaskEntryHoverInterfaceBuilder.addItemContainer(this.nextInterface(), itemsWidth, itemsHeight, 0, 0, false, new String[0]);
        int itemsDrawWidth = Math.min(4, itemCount) * 32;
        int itemsX = this.centerX - itemsDrawWidth / 2;
        this.child(itemsX, this.y);
        if (itemCount > 0) {
            for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
                GameItem item = this.taskEntry.getRewards().get(itemIndex);
                items.inventoryItemId[itemIndex] = item.getId() + 1;
                items.inventoryAmounts[itemIndex] = item.getAmount();
            }
            this.y += 32 * items.height;
            this.y += 4;
        }
    }

    private int getLineHeight(String text) {
        int nlIndex;
        if (text == null || text.length() == 0) {
            return 0;
        }
        int lines = 1;
        while ((nlIndex = text.indexOf("\\n")) != -1) {
            ++lines;
            text = text.substring(nlIndex + 3);
        }
        return lines * 10;
    }
}

