/*
 * Decompiled with CFR 0.152.
 */
package com.client.features.settings;

import com.client.Rasterizer3D;
import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.impl.SettingsTabWidget;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class Preferences {
    private static final Logger log = Logger.getLogger(Preferences.class.getName());
    private static Preferences preferences = new Preferences();
    public int soundVolume = 5;
    public int areaSoundVolume = 5;
    public int musicVolume = 5;
    public double brightness = 0.75;
    public Boolean fixed = true;
    public int screenWidth;
    public int screenHeight;
    public int dragTime = 5;
    public boolean hidePetOptions;
    public boolean pmNotifications;
    public String groundItemTextShowMoreThan = "";
    public String groundItemTextShow = "";
    public String groundItemTextHide = "";
    public boolean groundItemAlwaysShowUntradables;
    public boolean musicEnabled;

    public static Preferences getPreferences() {
        return preferences;
    }

    public static void load() {
        try {
            File preferencesFile = new File(Preferences.getFileLocation());
            if (preferencesFile.exists()) {
                ObjectNode node = new ObjectMapper().readValue(preferencesFile, ObjectNode.class);
                if (node.has("soundVolume")) {
                    Preferences.preferences.soundVolume = node.get("soundVolume").intValue();
                }
                if (node.has("areaSoundVolume")) {
                    Preferences.preferences.areaSoundVolume = node.get("areaSoundVolume").intValue();
                }
                if (node.has("musicVolume")) {
                    Preferences.preferences.musicVolume = node.get("musicVolume").intValue();
                }
                if (node.has("brightness")) {
                    Preferences.preferences.brightness = node.get("brightness").doubleValue();
                }
                if (node.has("screenWidth")) {
                    Preferences.preferences.screenWidth = node.get("screenWidth").intValue();
                }
                if (node.has("screenHeight")) {
                    Preferences.preferences.screenHeight = node.get("screenHeight").intValue();
                }
                if (node.has("dragTime")) {
                    Preferences.preferences.dragTime = node.get("dragTime").intValue();
                }
                if (node.has("hidePetOptions")) {
                    Preferences.preferences.hidePetOptions = node.get("hidePetOptions").booleanValue();
                }
                if (node.has("pmNotifications")) {
                    Preferences.preferences.pmNotifications = node.get("pmNotifications").booleanValue();
                }
                if (node.has("mode1")) {
                    Preferences.preferences.fixed = node.get("mode1").booleanValue();
                }
                if (node.has("groundItemTextShowMoreThan")) {
                    Preferences.preferences.groundItemTextShowMoreThan = node.get("groundItemTextShowMoreThan").textValue();
                }
                if (node.has("groundItemTextShow")) {
                    Preferences.preferences.groundItemTextShow = node.get("groundItemTextShow").textValue();
                }
                if (node.has("groundItemTextHide")) {
                    Preferences.preferences.groundItemTextHide = node.get("groundItemTextHide").textValue();
                }
                if (node.has("groundItemAlwaysShowUntradables")) {
                    Preferences.preferences.groundItemAlwaysShowUntradables = node.get("groundItemAlwaysShowUntradables").booleanValue();
                }
                if (node.has("musicEnabled")) {
                    Preferences.preferences.musicEnabled = node.get("musicEnabled").booleanValue();
                }
            } else {
                Preferences.save();
            }
        }
        catch (Exception e) {
            log.severe("Error while loading preferences.");
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writerWithDefaultPrettyPrinter().writeValue(new File(Preferences.getFileLocation()), (Object)preferences);
        }
        catch (IOException e) {
            log.severe("Error while saving preferences.");
            e.printStackTrace();
        }
    }

    public static String getFileLocation() {
        return System.getProperty("user.home") + File.separator + "RuneFury".toLowerCase() + "_properties.json";
    }

    public void updateClientConfiguration() {
        Rasterizer3D.setBrightness(this.brightness);
        SettingsTabWidget.brightnessSlider.setValue(this.brightness);
        SettingsTabWidget.musicVolumeSlider.setValue(10 - this.musicVolume);
        SettingsTabWidget.soundVolumeSlider.setValue(10 - this.soundVolume);
        SettingsTabWidget.areaSoundVolumeSlider.setValue(10 - this.areaSoundVolume);
        RSInterface.interfaceCache[42553].active = this.hidePetOptions;
    }
}

