/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.Deque;
import com.client.GameObject;
import com.client.GroundDecoration;
import com.client.GroundItemTile;
import com.client.Model;
import com.client.Rasterizer2D;
import com.client.Rasterizer3D;
import com.client.Renderable;
import com.client.SceneCluster;
import com.client.ShapedTile;
import com.client.SimpleTile;
import com.client.Tile;
import com.client.VertexNormal;
import com.client.WallDecoration;
import com.client.WallObject;
import com.client.engine.impl.MouseHandler;
import java.util.HashSet;
import java.util.Set;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Perspective;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.rs.api.RSGameObject;
import net.runelite.rs.api.RSNodeDeque;
import net.runelite.rs.api.RSPlayer;
import net.runelite.rs.api.RSRenderable;
import net.runelite.rs.api.RSScene;
import net.runelite.rs.api.RSTile;
import net.runelite.rs.api.RSTileItem;

public final class SceneGraph
implements RSScene {
    public static int viewDistance = 9;
    public static boolean pitchRelaxEnabled;
    public static boolean hdMinimapEnabled;
    public static int skyboxColor;
    public static int[] tmpX;
    public static int[] tmpY;
    public static int roofRemovalMode;
    public static final Set<RSTile> tilesToRemove;
    private static final int INVALID_HSL_COLOR = 12345678;
    private static final int DEFAULT_DISTANCE = 25;
    private static final int PITCH_LOWER_LIMIT = 128;
    private static final int PITCH_UPPER_LIMIT = 383;
    public static boolean lowMem;
    private final int maxY;
    private final int maxX;
    private final int maxZ;
    private final int[][][] heightMap;
    private final Tile[][][] tileArray;
    public int minLevel;
    private int interactableObjectCacheCurrPos;
    private final GameObject[] gameObjectsCache;
    private final int[][][] anIntArrayArrayArray445;
    public int tileUpdateCount;
    public int currentRenderPlane;
    public int cycle;
    public int minTileX;
    public int maxTileX;
    public int minTileZ;
    public int maxTileZ;
    public int screenCenterX;
    public int screenCenterZ;
    public static int xCameraPos;
    public static int zCameraPos;
    public static int yCameraPos;
    public static int camUpDownY;
    public static int camUpDownX;
    public static int camLeftRightY;
    public static int camLeftRightX;
    private static GameObject[] interactableObjects;
    private static final int[] anIntArray463;
    private static final int[] anIntArray464;
    private static final int[] anIntArray465;
    private static final int[] anIntArray466;
    public static boolean clicked;
    public static int clickScreenX;
    public static int clickScreenY;
    public static int clickedTileX;
    public static int clickedTileY;
    public static int hoverX;
    public static int hoverY;
    private static final int cullingClusterPlaneCount;
    private static int[] sceneClusterCounts;
    private static SceneCluster[][] sceneClusters;
    private static int anInt475;
    private static final SceneCluster[] aClass47Array476;
    private static Deque tileDeque;
    private static final int[] anIntArray478;
    private static final int[] anIntArray479;
    private static final int[] anIntArray480;
    private static final int[] anIntArray481;
    private static final int[] anIntArray482;
    private static final int[] anIntArray483;
    private static final int[] anIntArray484;
    private static final int[] TEXTURE_COLORS;
    private final int[] anIntArray486;
    private final int[] anIntArray487;
    private int anInt488;
    private final int[][] tileVertices = new int[][]{new int[16], {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1}, {0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1}};
    private final int[][] tileVertexIndices = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {12, 8, 4, 0, 13, 9, 5, 1, 14, 10, 6, 2, 15, 11, 7, 3}, {15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0}, {3, 7, 11, 15, 2, 6, 10, 14, 1, 5, 9, 13, 0, 4, 8, 12}};
    public static boolean[][][][] visibilityMap;
    public static boolean[][] renderArea;
    private static int viewportHalfWidth;
    private static int viewportHalfHeight;
    private static int xMin;
    private static int yMin;
    private static int xMax;
    private static int yMax;
    private int drawDistance = 25;

    public SceneGraph(int[][][] heightMap) {
        int yLocSize = 104;
        int xLocSize = 104;
        int zLocSize = 4;
        this.gameObjectsCache = new GameObject[10000];
        this.anIntArray486 = new int[10000];
        this.anIntArray487 = new int[10000];
        this.maxY = zLocSize;
        this.maxX = xLocSize;
        this.maxZ = yLocSize;
        this.tileArray = new Tile[zLocSize][xLocSize][yLocSize];
        this.anIntArrayArrayArray445 = new int[zLocSize][xLocSize + 1][yLocSize + 1];
        this.heightMap = heightMap;
        this.initToNull();
    }

    public static void destructor() {
        interactableObjects = null;
        sceneClusterCounts = null;
        sceneClusters = null;
        tileDeque = null;
        visibilityMap = null;
        renderArea = null;
    }

    public void initToNull() {
        int i;
        for (int zLoc = 0; zLoc < this.maxY; ++zLoc) {
            for (int xLoc = 0; xLoc < this.maxX; ++xLoc) {
                for (int yLoc = 0; yLoc < this.maxZ; ++yLoc) {
                    this.tileArray[zLoc][xLoc][yLoc] = null;
                }
            }
        }
        for (int plane = 0; plane < cullingClusterPlaneCount; ++plane) {
            for (int j1 = 0; j1 < sceneClusterCounts[plane]; ++j1) {
                SceneGraph.sceneClusters[plane][j1] = null;
            }
            SceneGraph.sceneClusterCounts[plane] = 0;
        }
        for (i = 0; i < this.interactableObjectCacheCurrPos; ++i) {
            this.gameObjectsCache[i] = null;
        }
        this.interactableObjectCacheCurrPos = 0;
        for (i = 0; i < interactableObjects.length; ++i) {
            SceneGraph.interactableObjects[i] = null;
        }
    }

    public void method275(int zLoc) {
        this.minLevel = zLoc;
        for (int xLoc = 0; xLoc < this.maxX; ++xLoc) {
            for (int yLoc = 0; yLoc < this.maxZ; ++yLoc) {
                if (this.tileArray[zLoc][xLoc][yLoc] != null) continue;
                this.tileArray[zLoc][xLoc][yLoc] = new Tile(zLoc, xLoc, yLoc);
            }
        }
    }

    public void applyBridgeMode(int yLoc, int xLoc) {
        Tile tileFirstFloor = this.tileArray[0][xLoc][yLoc];
        for (int zLoc = 0; zLoc < 3; ++zLoc) {
            this.tileArray[zLoc][xLoc][yLoc] = this.tileArray[zLoc + 1][xLoc][yLoc];
            Tile tile = this.tileArray[zLoc][xLoc][yLoc];
            if (tile == null) continue;
            --tile.z1AnInt1307;
            for (int j1 = 0; j1 < tile.gameObjectIndex; ++j1) {
                GameObject gameObject = tile.gameObjects[j1];
                if ((gameObject.uid >> 29 & 3L) != 2L || gameObject.xLocLow != xLoc || gameObject.yLocHigh != yLoc) continue;
                --gameObject.zLoc;
            }
        }
        if (this.tileArray[0][xLoc][yLoc] == null) {
            this.tileArray[0][xLoc][yLoc] = new Tile(0, xLoc, yLoc);
        }
        this.tileArray[0][xLoc][yLoc].firstFloorTile = tileFirstFloor;
        this.tileArray[3][xLoc][yLoc] = null;
    }

    public static void createNewSceneCluster(int z, int lowestX, int lowestZ, int highestX, int highestY, int highestZ, int lowestY, int searchMask) {
        SceneCluster sceneCluster = new SceneCluster();
        sceneCluster.startXLoc = lowestX / 128;
        sceneCluster.endXLoc = highestX / 128;
        sceneCluster.startYLoc = lowestY / 128;
        sceneCluster.endYLoc = highestY / 128;
        sceneCluster.orientation = searchMask;
        sceneCluster.startXPos = lowestX;
        sceneCluster.endXPos = highestX;
        sceneCluster.startYPos = lowestY;
        sceneCluster.endYPos = highestY;
        sceneCluster.startZPos = highestZ;
        sceneCluster.endZPos = lowestZ;
        int n = z;
        int n2 = sceneClusterCounts[n];
        sceneClusterCounts[n] = n2 + 1;
        SceneGraph.sceneClusters[z][n2] = sceneCluster;
    }

    public void setTileLogicHeight(int zLoc, int xLoc, int yLoc, int logicHeight) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile != null) {
            this.tileArray[zLoc][xLoc][yLoc].logicHeight = logicHeight;
        }
    }

    public void addTile(int zLoc, int xLoc, int yLoc, int shape, int i1, int j1, int k1, int l1, int i2, int j2, int k2, int l2, int i3, int j3, int k3, int l3, int i4, int j4, int k4, int l4) {
        if (shape == 0) {
            SimpleTile simpleTile = new SimpleTile(k2, l2, i3, j3, -1, k4, false);
            for (int lowerZLoc = zLoc; lowerZLoc >= 0; --lowerZLoc) {
                if (this.tileArray[lowerZLoc][xLoc][yLoc] != null) continue;
                this.tileArray[lowerZLoc][xLoc][yLoc] = new Tile(lowerZLoc, xLoc, yLoc);
            }
            this.tileArray[zLoc][xLoc][yLoc].mySimpleTile = simpleTile;
        } else if (shape == 1) {
            SimpleTile simpleTile = new SimpleTile(k3, l3, i4, j4, j1, l4, k1 == l1 && k1 == i2 && k1 == j2);
            for (int lowerZLoc = zLoc; lowerZLoc >= 0; --lowerZLoc) {
                if (this.tileArray[lowerZLoc][xLoc][yLoc] != null) continue;
                this.tileArray[lowerZLoc][xLoc][yLoc] = new Tile(lowerZLoc, xLoc, yLoc);
            }
            this.tileArray[zLoc][xLoc][yLoc].mySimpleTile = simpleTile;
        } else {
            ShapedTile shapedTile = new ShapedTile(yLoc, k3, j3, i2, j1, i4, i1, k2, k4, i3, j2, l1, k1, shape, j4, l3, l2, xLoc, l4);
            for (int k5 = zLoc; k5 >= 0; --k5) {
                if (this.tileArray[k5][xLoc][yLoc] != null) continue;
                this.tileArray[k5][xLoc][yLoc] = new Tile(k5, xLoc, yLoc);
            }
            this.tileArray[zLoc][xLoc][yLoc].myShapedTile = shapedTile;
        }
    }

    public void addGroundDecoration(int zLoc, int zPos, int yLoc, Renderable renderable, byte objectRotationType, long uid, int xLoc) {
        if (renderable == null) {
            return;
        }
        GroundDecoration groundDecoration = new GroundDecoration();
        groundDecoration.renderable = renderable;
        groundDecoration.xPos = xLoc * 128 + 64;
        groundDecoration.yPos = yLoc * 128 + 64;
        groundDecoration.tileHeights = zPos;
        groundDecoration.uid = uid;
        groundDecoration.mask = objectRotationType;
        if (this.tileArray[zLoc][xLoc][yLoc] == null) {
            this.tileArray[zLoc][xLoc][yLoc] = new Tile(zLoc, xLoc, yLoc);
            groundDecoration.zLoc = zLoc;
        }
        this.tileArray[zLoc][xLoc][yLoc].groundDecoration = groundDecoration;
        this.tileArray[zLoc][xLoc][yLoc].groundObjectChanged();
    }

    public void addGroundItemTile(Object obj2, int xLoc, long uid, Renderable firstNode, int zPos, Renderable secondNode, Renderable thirdNode, int zLoc, int yLoc) {
        GroundItemTile groundItemTile = new GroundItemTile();
        groundItemTile.topNode = thirdNode;
        groundItemTile.xPos = xLoc * 128 + 64;
        groundItemTile.yPos = yLoc * 128 + 64;
        groundItemTile.tileHeights = zPos;
        groundItemTile.uid = uid;
        groundItemTile.lowerNode = firstNode;
        groundItemTile.middleNode = secondNode;
        groundItemTile.zLoc = zLoc;
        int largestItemDropHeight = 0;
        Tile parentTile = this.tileArray[zLoc][xLoc][yLoc];
        if (parentTile != null) {
            for (int i = 0; i < parentTile.gameObjectIndex; ++i) {
                int objectItemDropHeight;
                if (!(parentTile.gameObjects[i].renderable instanceof Model) || (objectItemDropHeight = ((Model)parentTile.gameObjects[i].renderable).itemDropHeight) <= largestItemDropHeight) continue;
                largestItemDropHeight = objectItemDropHeight;
            }
            this.tileArray[zLoc][xLoc][yLoc].groundItemTile = groundItemTile;
        }
        groundItemTile.itemDropHeight = largestItemDropHeight;
        if (this.tileArray[zLoc][xLoc][yLoc] == null) {
            this.tileArray[zLoc][xLoc][yLoc] = new Tile(zLoc, xLoc, yLoc);
            this.tileArray[zLoc][xLoc][yLoc].groundItemTile = groundItemTile;
        }
    }

    public void addWallObject(int orientation1, Renderable renderable1, long uid, int yLoc, byte objectFaceType, int xLoc, Renderable renderable2, int zPos, int orientation2, int zLoc) {
        if (renderable1 == null && renderable2 == null) {
            return;
        }
        WallObject wallObject = new WallObject();
        wallObject.uid = uid;
        wallObject.mask = objectFaceType;
        wallObject.xPos = xLoc * 128 + 64;
        wallObject.yPos = yLoc * 128 + 64;
        wallObject.tileHeights = zPos;
        wallObject.renderable1 = renderable1;
        wallObject.renderable2 = renderable2;
        wallObject.orientation1 = orientation1;
        wallObject.orientation2 = orientation2;
        for (int z = zLoc; z >= 0; --z) {
            if (this.tileArray[z][xLoc][yLoc] != null) continue;
            this.tileArray[z][xLoc][yLoc] = new Tile(z, xLoc, yLoc);
            wallObject.zLoc = z;
        }
        this.tileArray[zLoc][xLoc][yLoc].wallObject = wallObject;
        this.tileArray[zLoc][xLoc][yLoc].wallObjectChanged();
    }

    public void addWallDecoration(long uid, int yLoc, int orientation2, int zLoc, int xOffset, int zPos, Renderable renderable, int xLoc, byte objectRotationType, int yOffset, int orientation) {
        if (renderable == null) {
            return;
        }
        WallDecoration wallDecoration = new WallDecoration();
        wallDecoration.uid = uid;
        wallDecoration.mask = objectRotationType;
        wallDecoration.xPos = xLoc * 128 + 64 + xOffset;
        wallDecoration.yPos = yLoc * 128 + 64 + yOffset;
        wallDecoration.tileHeights = zPos;
        wallDecoration.renderable = renderable;
        wallDecoration.orientation = orientation;
        wallDecoration.orientation2 = orientation2;
        for (int z = zLoc; z >= 0; --z) {
            if (this.tileArray[z][xLoc][yLoc] != null) continue;
            this.tileArray[z][xLoc][yLoc] = new Tile(z, xLoc, yLoc);
            wallDecoration.zLoc = z;
        }
        this.tileArray[zLoc][xLoc][yLoc].wallDecoration = wallDecoration;
        this.tileArray[zLoc][xLoc][yLoc].decorativeObjectChanged();
    }

    public boolean addTiledObject(long uid, byte objectRotationType, int tileHeight, int sizeY, Renderable renderable, int sizeX, int zLoc, int turnValue, int yLoc, int xLoc) {
        if (renderable == null) {
            return true;
        }
        int xPos = xLoc * 128 + 64 * sizeX;
        int yPos = yLoc * 128 + 64 * sizeY;
        return this.addAnimableC(zLoc, xLoc, yLoc, sizeX, sizeY, xPos, yPos, tileHeight, renderable, turnValue, false, uid, objectRotationType);
    }

    public boolean addAnimableA(int zLoc, int turnValue, int k, long uid, int yPos, int halfSizePos, int xPos, Renderable animable, boolean flag) {
        if (animable == null) {
            return true;
        }
        if (!Client.instance.addEntityMarker(xPos, yPos, animable)) {
            return true;
        }
        int startXLoc = xPos - halfSizePos;
        int startYLoc = yPos - halfSizePos;
        int endXLoc = xPos + halfSizePos;
        int endYLoc = yPos + halfSizePos;
        if (flag) {
            if (turnValue > 640 && turnValue < 1408) {
                endYLoc += 128;
            }
            if (turnValue > 1152 && turnValue < 1920) {
                endXLoc += 128;
            }
            if (turnValue > 1664 || turnValue < 384) {
                startYLoc -= 128;
            }
            if (turnValue > 128 && turnValue < 896) {
                startXLoc -= 128;
            }
        }
        return this.addAnimableC(zLoc, startXLoc /= 128, startYLoc /= 128, (endXLoc /= 128) - startXLoc + 1, (endYLoc /= 128) - startYLoc + 1, xPos, yPos, k, animable, turnValue, true, uid, (byte)0);
    }

    public boolean addToScenePlayerAsObject(int zLoc, int playerYPos, Renderable playerAsObject, int playerTurnValue, int objectEndYLoc, int playerXPos, int playerHeight, int objectStartXLoc, int objectEndXLoc, long uid, int objectStartYLoc) {
        return playerAsObject == null || this.addAnimableC(zLoc, objectStartXLoc, objectStartYLoc, objectEndXLoc - objectStartXLoc + 1, objectEndYLoc - objectStartYLoc + 1, playerXPos, playerYPos, playerHeight, playerAsObject, playerTurnValue, true, uid, (byte)0);
    }

    private boolean addAnimableC(int zLoc, int xLoc, int yLoc, int sizeX, int sizeY, int xPos, int yPos, int tileHeight, Renderable renderable, int turnValue, boolean isDynamic, long uid, byte objectRotationType) {
        if (!Client.instance.addEntityMarker(xPos, yPos, renderable)) {
            return true;
        }
        for (int x = xLoc; x < xLoc + sizeX; ++x) {
            for (int y = yLoc; y < yLoc + sizeY; ++y) {
                if (x < 0 || y < 0 || x >= this.maxX || y >= this.maxZ) {
                    return false;
                }
                Tile tile = this.tileArray[zLoc][x][y];
                if (tile == null || tile.gameObjectIndex < 5) continue;
                return false;
            }
        }
        GameObject gameObject = new GameObject();
        gameObject.uid = uid;
        gameObject.mask = objectRotationType;
        gameObject.zLoc = zLoc;
        gameObject.xPos = xPos;
        gameObject.yPos = yPos;
        gameObject.tileHeight = tileHeight;
        gameObject.renderable = renderable;
        gameObject.turnValue = turnValue;
        gameObject.xLocLow = xLoc;
        gameObject.yLocHigh = yLoc;
        gameObject.xLocHigh = xLoc + sizeX - 1;
        gameObject.yLocLow = yLoc + sizeY - 1;
        for (int x = xLoc; x < xLoc + sizeX; ++x) {
            for (int y = yLoc; y < yLoc + sizeY; ++y) {
                int mask = 0;
                if (x > xLoc) {
                    ++mask;
                }
                if (x < xLoc + sizeX - 1) {
                    mask += 4;
                }
                if (y > yLoc) {
                    mask += 8;
                }
                if (y < yLoc + sizeY - 1) {
                    mask += 2;
                }
                for (int z = zLoc; z >= 0; --z) {
                    if (this.tileArray[z][x][y] != null) continue;
                    this.tileArray[z][x][y] = new Tile(z, x, y);
                }
                Tile tile = this.tileArray[zLoc][x][y];
                tile.gameObjects[tile.gameObjectIndex] = gameObject;
                tile.gameObjectsChanged(tile.gameObjectIndex);
                tile.tiledObjectMasks[tile.gameObjectIndex] = mask;
                tile.totalTiledObjectMask |= mask;
                ++tile.gameObjectIndex;
            }
        }
        if (isDynamic) {
            this.gameObjectsCache[this.interactableObjectCacheCurrPos++] = gameObject;
        }
        return true;
    }

    public void clearGameObjectCache() {
        for (int i = 0; i < this.interactableObjectCacheCurrPos; ++i) {
            GameObject object5 = this.gameObjectsCache[i];
            this.remove(object5);
            this.gameObjectsCache[i] = null;
        }
        this.interactableObjectCacheCurrPos = 0;
    }

    private void remove(GameObject gameObject) {
        for (int x = gameObject.xLocLow; x <= gameObject.xLocHigh; ++x) {
            for (int y = gameObject.yLocHigh; y <= gameObject.yLocLow; ++y) {
                int i;
                Tile tile = this.tileArray[gameObject.zLoc][x][y];
                if (tile == null) continue;
                for (i = 0; i < tile.gameObjectIndex; ++i) {
                    if (tile.gameObjects[i] != gameObject) continue;
                    --tile.gameObjectIndex;
                    for (int i1 = i; i1 < tile.gameObjectIndex; ++i1) {
                        tile.gameObjects[i1] = tile.gameObjects[i1 + 1];
                        tile.tiledObjectMasks[i1] = tile.tiledObjectMasks[i1 + 1];
                    }
                    tile.gameObjects[tile.gameObjectIndex] = null;
                    tile.gameObjectsChanged(tile.gameObjectIndex);
                    break;
                }
                tile.totalTiledObjectMask = 0;
                for (i = 0; i < tile.gameObjectIndex; ++i) {
                    tile.totalTiledObjectMask |= tile.tiledObjectMasks[i];
                }
            }
        }
    }

    public void method290(int yLoc, int k, int xLoc, int zLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null) {
            return;
        }
        WallDecoration wallDecoration = tile.wallDecoration;
        if (wallDecoration != null) {
            int xPos = xLoc * 128 + 64;
            int yPos = yLoc * 128 + 64;
            wallDecoration.xPos = xPos + (wallDecoration.xPos - xPos) * k / 16;
            wallDecoration.yPos = yPos + (wallDecoration.yPos - yPos) * k / 16;
        }
    }

    @Override
    public void removeWallObject(int xLoc, int zLoc, int yLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile != null) {
            tile.wallObject = null;
            tile.wallObjectChanged();
        }
    }

    public void removeWallDecoration(int yLoc, int zLoc, int xLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile != null) {
            tile.wallDecoration = null;
            tile.decorativeObjectChanged();
        }
    }

    public void removeTiledObject(int zLoc, int xLoc, int yLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null) {
            return;
        }
        for (int j1 = 0; j1 < tile.gameObjectIndex; ++j1) {
            GameObject gameObject = tile.gameObjects[j1];
            if ((gameObject.uid >> 29 & 3L) != 2L || gameObject.xLocLow != xLoc || gameObject.yLocHigh != yLoc) continue;
            this.remove(gameObject);
            return;
        }
    }

    public void removeGroundDecoration(int zLoc, int yLoc, int xLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null) {
            return;
        }
        tile.groundDecoration = null;
        tile.groundObjectChanged();
    }

    public void removeGroundItemTile(int zLoc, int xLoc, int yLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile != null) {
            tile.groundItemTile = null;
        }
    }

    public WallObject getWallObject(int zLoc, int xLoc, int yLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null) {
            return null;
        }
        return tile.wallObject;
    }

    public WallDecoration getWallDecoration(int xLoc, int yLoc, int zLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null) {
            return null;
        }
        return tile.wallDecoration;
    }

    public GameObject getGameObject(int xLoc, int yLoc, int zLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null) {
            return null;
        }
        for (int i = 0; i < tile.gameObjectIndex; ++i) {
            GameObject gameObject = tile.gameObjects[i];
            if ((gameObject.uid >> 29 & 3L) != 2L || gameObject.xLocLow != xLoc || gameObject.yLocHigh != yLoc) continue;
            return gameObject;
        }
        return null;
    }

    public GroundDecoration getGroundDecoration(int yLoc, int xLoc, int zLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null || tile.groundDecoration == null) {
            return null;
        }
        return tile.groundDecoration;
    }

    public long getWallObjectUid(int zLoc, int xLoc, int yLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null || tile.wallObject == null) {
            return 0L;
        }
        return tile.wallObject.uid;
    }

    public long getWallDecorationUid(int zLoc, int xLoc, int yLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null || tile.wallDecoration == null) {
            return 0L;
        }
        return tile.wallDecoration.uid;
    }

    public long getGameObjectUid(int zLoc, int xLoc, int yLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null) {
            return 0L;
        }
        for (int i = 0; i < tile.gameObjectIndex; ++i) {
            GameObject gameObject = tile.gameObjects[i];
            if ((gameObject.uid >> 29 & 3L) != 2L || gameObject.xLocLow != xLoc || gameObject.yLocHigh != yLoc) continue;
            return gameObject.uid;
        }
        return 0L;
    }

    public long getGroundDecorationUid(int zLoc, int xLoc, int yLoc) {
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null || tile.groundDecoration == null) {
            return 0L;
        }
        return tile.groundDecoration.uid;
    }

    public void shadeModels(int lightY, int lightX, int lightZ) {
        int intensity = 64;
        int diffusion = 768;
        int lightDistance = (int)Math.sqrt(lightX * lightX + lightY * lightY + lightZ * lightZ);
        int someLightQualityVariable = diffusion * lightDistance >> 8;
        for (int zLoc = 0; zLoc < this.maxY; ++zLoc) {
            for (int xLoc = 0; xLoc < this.maxX; ++xLoc) {
                for (int yLoc = 0; yLoc < this.maxZ; ++yLoc) {
                    Tile tile = this.tileArray[zLoc][xLoc][yLoc];
                    if (tile == null) continue;
                    WallObject wallObject = tile.wallObject;
                    if (wallObject != null && wallObject.renderable1 != null && wallObject.renderable1.normals != null) {
                        this.method307(zLoc, 1, 1, xLoc, yLoc, (Model)wallObject.renderable1);
                        if (wallObject.renderable2 != null && wallObject.renderable2.normals != null) {
                            this.method307(zLoc, 1, 1, xLoc, yLoc, (Model)wallObject.renderable2);
                            this.mergeNormals((Model)wallObject.renderable1, (Model)wallObject.renderable2, 0, 0, 0, false);
                            ((Model)wallObject.renderable2).setLighting(intensity, someLightQualityVariable, lightX, lightY, lightZ);
                        }
                        ((Model)wallObject.renderable1).setLighting(intensity, someLightQualityVariable, lightX, lightY, lightZ);
                    }
                    for (int k2 = 0; k2 < tile.gameObjectIndex; ++k2) {
                        GameObject interactableObject = tile.gameObjects[k2];
                        if (interactableObject == null || interactableObject.renderable == null || interactableObject.renderable.normals == null) continue;
                        this.method307(zLoc, interactableObject.xLocHigh - interactableObject.xLocLow + 1, interactableObject.yLocLow - interactableObject.yLocHigh + 1, xLoc, yLoc, (Model)interactableObject.renderable);
                        ((Model)interactableObject.renderable).setLighting(intensity, someLightQualityVariable, lightX, lightY, lightZ);
                    }
                    GroundDecoration groundDecoration = tile.groundDecoration;
                    if (groundDecoration == null || groundDecoration.renderable.normals == null) continue;
                    this.method306GroundDecorationOnly(xLoc, zLoc, (Model)groundDecoration.renderable, yLoc);
                    ((Model)groundDecoration.renderable).setLighting(intensity, someLightQualityVariable, lightX, lightY, lightZ);
                }
            }
        }
    }

    private void method306GroundDecorationOnly(int modelXLoc, int modelZLoc, Model model, int modelYLoc) {
        Tile tile;
        if (modelXLoc < this.maxX && (tile = this.tileArray[modelZLoc][modelXLoc + 1][modelYLoc]) != null && tile.groundDecoration != null && tile.groundDecoration.renderable.normals != null) {
            this.mergeNormals(model, (Model)tile.groundDecoration.renderable, 128, 0, 0, true);
        }
        if (modelYLoc < this.maxX && (tile = this.tileArray[modelZLoc][modelXLoc][modelYLoc + 1]) != null && tile.groundDecoration != null && tile.groundDecoration.renderable.normals != null) {
            this.mergeNormals(model, (Model)tile.groundDecoration.renderable, 0, 0, 128, true);
        }
        if (modelXLoc < this.maxX && modelYLoc < this.maxZ && (tile = this.tileArray[modelZLoc][modelXLoc + 1][modelYLoc + 1]) != null && tile.groundDecoration != null && tile.groundDecoration.renderable.normals != null) {
            this.mergeNormals(model, (Model)tile.groundDecoration.renderable, 128, 0, 128, true);
        }
        if (modelXLoc < this.maxX && modelYLoc > 0 && (tile = this.tileArray[modelZLoc][modelXLoc + 1][modelYLoc - 1]) != null && tile.groundDecoration != null && tile.groundDecoration.renderable.normals != null) {
            this.mergeNormals(model, (Model)tile.groundDecoration.renderable, 128, 0, -128, true);
        }
    }

    private void method307(int modelZLoc, int modelXSize, int modelYSize, int modelXLoc, int modelYLoc, Model model) {
        boolean flag = true;
        int startX = modelXLoc;
        int stopX = modelXLoc + modelXSize;
        int startY = modelYLoc - 1;
        int stopY = modelYLoc + modelYSize;
        for (int zLoc = modelZLoc; zLoc <= modelZLoc + 1; ++zLoc) {
            if (zLoc == this.maxY) continue;
            for (int xLoc = startX; xLoc <= stopX; ++xLoc) {
                if (xLoc < 0 || xLoc >= this.maxX) continue;
                for (int yLoc = startY; yLoc <= stopY; ++yLoc) {
                    Tile tile;
                    if (yLoc < 0 || yLoc >= this.maxZ || flag && xLoc < stopX && yLoc < stopY && (yLoc >= modelYLoc || xLoc == modelXLoc) || (tile = this.tileArray[zLoc][xLoc][yLoc]) == null) continue;
                    int relativeHeightToModelTile = (this.heightMap[zLoc][xLoc][yLoc] + this.heightMap[zLoc][xLoc + 1][yLoc] + this.heightMap[zLoc][xLoc][yLoc + 1] + this.heightMap[zLoc][xLoc + 1][yLoc + 1]) / 4 - (this.heightMap[modelZLoc][modelXLoc][modelYLoc] + this.heightMap[modelZLoc][modelXLoc + 1][modelYLoc] + this.heightMap[modelZLoc][modelXLoc][modelYLoc + 1] + this.heightMap[modelZLoc][modelXLoc + 1][modelYLoc + 1]) / 4;
                    WallObject wallObject = tile.wallObject;
                    if (wallObject != null && wallObject.renderable1 != null && wallObject.renderable1.normals != null) {
                        this.mergeNormals(model, (Model)wallObject.renderable1, (xLoc - modelXLoc) * 128 + (1 - modelXSize) * 64, relativeHeightToModelTile, (yLoc - modelYLoc) * 128 + (1 - modelYSize) * 64, flag);
                    }
                    if (wallObject != null && wallObject.renderable2 != null && wallObject.renderable2.normals != null) {
                        this.mergeNormals(model, (Model)wallObject.renderable2, (xLoc - modelXLoc) * 128 + (1 - modelXSize) * 64, relativeHeightToModelTile, (yLoc - modelYLoc) * 128 + (1 - modelYSize) * 64, flag);
                    }
                    for (int i = 0; i < tile.gameObjectIndex; ++i) {
                        GameObject gameObject = tile.gameObjects[i];
                        if (gameObject == null || gameObject.renderable == null || gameObject.renderable.normals == null) continue;
                        int tiledObjectXSize = gameObject.xLocHigh - gameObject.xLocLow + 1;
                        int tiledObjectYSize = gameObject.yLocLow - gameObject.yLocHigh + 1;
                        this.mergeNormals(model, (Model)gameObject.renderable, (gameObject.xLocLow - modelXLoc) * 128 + (tiledObjectXSize - modelXSize) * 64, relativeHeightToModelTile, (gameObject.yLocHigh - modelYLoc) * 128 + (tiledObjectYSize - modelYSize) * 64, flag);
                    }
                }
            }
            --startX;
            flag = false;
        }
    }

    private void mergeNormals(Model model, Model secondModel, int posX, int posY, int posZ, boolean flag) {
        int triangle;
        ++this.anInt488;
        int count2 = 0;
        int[] vertices = secondModel.verticesX;
        int vertexCount = secondModel.verticesCount;
        for (int vertex = 0; vertex < model.verticesCount; ++vertex) {
            int z;
            int x;
            int y;
            VertexNormal vertexNormal = model.normals[vertex];
            VertexNormal offsetVertexNormal = model.vertexNormalsOffsets[vertex];
            if (offsetVertexNormal.magnitude == 0 || (y = model.verticesY[vertex] - posY) > secondModel.maxY || (x = model.verticesX[vertex] - posX) < secondModel.minX || x > secondModel.maxX || (z = model.verticesZ[vertex] - posZ) < secondModel.minZ || z > secondModel.maxZ) continue;
            for (int v = 0; v < vertexCount; ++v) {
                VertexNormal vertexNormal2 = secondModel.normals[v];
                VertexNormal offsetVertexNormal2 = secondModel.vertexNormalsOffsets[v];
                if (x != vertices[v] || z != secondModel.verticesZ[v] || y != secondModel.verticesY[v] || offsetVertexNormal2.magnitude == 0) continue;
                vertexNormal.x += offsetVertexNormal2.x;
                vertexNormal.y += offsetVertexNormal2.y;
                vertexNormal.z += offsetVertexNormal2.z;
                vertexNormal.magnitude += offsetVertexNormal2.magnitude;
                vertexNormal2.x += offsetVertexNormal.x;
                vertexNormal2.y += offsetVertexNormal.y;
                vertexNormal2.z += offsetVertexNormal.z;
                vertexNormal2.magnitude += offsetVertexNormal.magnitude;
                ++count2;
                this.anIntArray486[vertex] = this.anInt488;
                this.anIntArray487[v] = this.anInt488;
            }
        }
        if (count2 < 3 || !flag) {
            return;
        }
        for (triangle = 0; triangle < model.trianglesCount; ++triangle) {
            if (this.anIntArray486[model.trianglesX[triangle]] != this.anInt488 || this.anIntArray486[model.trianglesY[triangle]] != this.anInt488 || this.anIntArray486[model.trianglesZ[triangle]] != this.anInt488) continue;
            model.drawType[triangle] = -1;
        }
        for (triangle = 0; triangle < secondModel.trianglesCount; ++triangle) {
            if (this.anIntArray487[secondModel.trianglesX[triangle]] != this.anInt488 || this.anIntArray487[secondModel.trianglesY[triangle]] != this.anInt488 || this.anIntArray487[secondModel.trianglesZ[triangle]] != this.anInt488) continue;
            secondModel.drawType[triangle] = -1;
        }
    }

    public void drawTileMinimap(int[] pixels, int pixelOffset, int z, int x, int y) {
        block34: {
            int shapeOffset;
            int[] indices;
            int[] points;
            int underlayRgb;
            int overlayRgb;
            block35: {
                int i;
                if (!Client.instance.isHdMinimapEnabled()) {
                    this.drawTileMinimapSD(pixels, pixelOffset, z, x, y);
                    return;
                }
                RSTile tile = this.getTiles()[z][x][y];
                if (tile == null) {
                    return;
                }
                SceneTilePaint sceneTilePaint = tile.getSceneTilePaint();
                if (sceneTilePaint != null) {
                    int rgb = sceneTilePaint.getRBG();
                    if (sceneTilePaint.getSwColor() != 12345678) {
                        int hs = sceneTilePaint.getSwColor() & 0xFFFFFF80;
                        int seLightness = sceneTilePaint.getNwColor() & 0x7F;
                        int neLightness = sceneTilePaint.getNeColor() & 0x7F;
                        int southDeltaLightness = (sceneTilePaint.getSwColor() & 0x7F) - seLightness;
                        int northDeltaLightness = (sceneTilePaint.getSeColor() & 0x7F) - neLightness;
                        seLightness <<= 2;
                        neLightness <<= 2;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            if (sceneTilePaint.getTexture() == -1) {
                                pixels[pixelOffset] = Rasterizer3D.hslToRgb[hs | seLightness >> 2];
                                pixels[pixelOffset + 1] = Rasterizer3D.hslToRgb[hs | seLightness * 3 + neLightness >> 4];
                                pixels[pixelOffset + 2] = Rasterizer3D.hslToRgb[hs | seLightness + neLightness >> 3];
                                pixels[pixelOffset + 3] = Rasterizer3D.hslToRgb[hs | seLightness + neLightness * 3 >> 4];
                            } else {
                                int lig = 255 - ((seLightness >> 1) * (seLightness >> 1) >> 8);
                                pixels[pixelOffset] = ((rgb & 0xFF00FF) * lig & 0xFF00FF00) + ((rgb & 0xFF00) * lig & 0xFF0000) >> 8;
                                lig = 255 - ((seLightness * 3 + neLightness >> 3) * (seLightness * 3 + neLightness >> 3) >> 8);
                                pixels[pixelOffset + 1] = ((rgb & 0xFF00FF) * lig & 0xFF00FF00) + ((rgb & 0xFF00) * lig & 0xFF0000) >> 8;
                                lig = 255 - ((seLightness + neLightness >> 2) * (seLightness + neLightness >> 2) >> 8);
                                pixels[pixelOffset + 2] = ((rgb & 0xFF00FF) * lig & 0xFF00FF00) + ((rgb & 0xFF00) * lig & 0xFF0000) >> 8;
                                lig = 255 - ((seLightness + neLightness * 3 >> 3) * (seLightness + neLightness * 3 >> 3) >> 8);
                                pixels[pixelOffset + 3] = ((rgb & 0xFF00FF) * lig & 0xFF00FF00) + ((rgb & 0xFF00) * lig & 0xFF0000) >> 8;
                            }
                            seLightness += southDeltaLightness;
                            neLightness += northDeltaLightness;
                            pixelOffset += 512;
                        }
                    } else if (rgb != 0) {
                        for (int i3 = 0; i3 < 4; ++i3) {
                            pixels[pixelOffset] = rgb;
                            pixels[pixelOffset + 1] = rgb;
                            pixels[pixelOffset + 2] = rgb;
                            pixels[pixelOffset + 3] = rgb;
                            pixelOffset += 512;
                        }
                    }
                    return;
                }
                SceneTileModel sceneTileModel = tile.getSceneTileModel();
                if (sceneTileModel == null) break block34;
                int shape = sceneTileModel.getShape();
                int rotation = sceneTileModel.getRotation();
                overlayRgb = sceneTileModel.getModelOverlay();
                underlayRgb = sceneTileModel.getModelUnderlay();
                points = this.getTileShape2D()[shape];
                indices = this.getTileRotation2D()[rotation];
                shapeOffset = 0;
                if (sceneTileModel.getOverlaySwColor() == 12345678) break block35;
                int hs = sceneTileModel.getOverlaySwColor() & 0xFFFFFF80;
                int seLightness = sceneTileModel.getOverlaySeColor() & 0x7F;
                int neLightness = sceneTileModel.getOverlayNeColor() & 0x7F;
                int southDeltaLightness = (sceneTileModel.getOverlaySwColor() & 0x7F) - seLightness;
                int northDeltaLightness = (sceneTileModel.getOverlayNwColor() & 0x7F) - neLightness;
                seLightness <<= 2;
                neLightness <<= 2;
                for (i = 0; i < 4; ++i) {
                    if (sceneTileModel.getTriangleTextureId() == null) {
                        if (points[indices[shapeOffset++]] != 0) {
                            pixels[pixelOffset] = Rasterizer3D.hslToRgb[hs | seLightness >> 2];
                        }
                        if (points[indices[shapeOffset++]] != 0) {
                            pixels[pixelOffset + 1] = Rasterizer3D.hslToRgb[hs | seLightness * 3 + neLightness >> 4];
                        }
                        if (points[indices[shapeOffset++]] != 0) {
                            pixels[pixelOffset + 2] = Rasterizer3D.hslToRgb[hs | seLightness + neLightness >> 3];
                        }
                        if (points[indices[shapeOffset++]] != 0) {
                            pixels[pixelOffset + 3] = Rasterizer3D.hslToRgb[hs | seLightness + neLightness * 3 >> 4];
                        }
                    } else {
                        int lig;
                        if (points[indices[shapeOffset++]] != 0) {
                            lig = 255 - ((seLightness >> 1) * (seLightness >> 1) >> 8);
                            pixels[pixelOffset] = ((overlayRgb & 0xFF00FF) * lig & 0xFF00FF00) + ((overlayRgb & 0xFF00) * lig & 0xFF0000) >> 8;
                        }
                        if (points[indices[shapeOffset++]] != 0) {
                            lig = 255 - ((seLightness * 3 + neLightness >> 3) * (seLightness * 3 + neLightness >> 3) >> 8);
                            pixels[pixelOffset + 1] = ((overlayRgb & 0xFF00FF) * lig & 0xFF00FF00) + ((overlayRgb & 0xFF00) * lig & 0xFF0000) >> 8;
                        }
                        if (points[indices[shapeOffset++]] != 0) {
                            lig = 255 - ((seLightness + neLightness >> 2) * (seLightness + neLightness >> 2) >> 8);
                            pixels[pixelOffset + 2] = ((overlayRgb & 0xFF00FF) * lig & 0xFF00FF00) + ((overlayRgb & 0xFF00) * lig & 0xFF0000) >> 8;
                        }
                        if (points[indices[shapeOffset++]] != 0) {
                            lig = 255 - ((seLightness + neLightness * 3 >> 3) * (seLightness + neLightness * 3 >> 3) >> 8);
                            pixels[pixelOffset + 3] = ((overlayRgb & 0xFF00FF) * lig & 0xFF00FF00) + ((overlayRgb & 0xFF00) * lig & 0xFF0000) >> 8;
                        }
                    }
                    seLightness += southDeltaLightness;
                    neLightness += northDeltaLightness;
                    pixelOffset += 512;
                }
                if (underlayRgb == 0 || sceneTileModel.getUnderlaySwColor() == 12345678) break block34;
                pixelOffset -= 2048;
                shapeOffset -= 16;
                hs = sceneTileModel.getUnderlaySwColor() & 0xFFFFFF80;
                seLightness = sceneTileModel.getUnderlaySeColor() & 0x7F;
                neLightness = sceneTileModel.getUnderlayNeColor() & 0x7F;
                southDeltaLightness = (sceneTileModel.getUnderlaySwColor() & 0x7F) - seLightness;
                northDeltaLightness = (sceneTileModel.getUnderlayNwColor() & 0x7F) - neLightness;
                seLightness <<= 2;
                neLightness <<= 2;
                for (i = 0; i < 4; ++i) {
                    if (points[indices[shapeOffset++]] == 0) {
                        pixels[pixelOffset] = Rasterizer3D.hslToRgb[hs | seLightness >> 2];
                    }
                    if (points[indices[shapeOffset++]] == 0) {
                        pixels[pixelOffset + 1] = Rasterizer3D.hslToRgb[hs | seLightness * 3 + neLightness >> 4];
                    }
                    if (points[indices[shapeOffset++]] == 0) {
                        pixels[pixelOffset + 2] = Rasterizer3D.hslToRgb[hs | seLightness + neLightness >> 3];
                    }
                    if (points[indices[shapeOffset++]] == 0) {
                        pixels[pixelOffset + 3] = Rasterizer3D.hslToRgb[hs | seLightness + neLightness * 3 >> 4];
                    }
                    seLightness += southDeltaLightness;
                    neLightness += northDeltaLightness;
                    pixelOffset += 512;
                }
                break block34;
            }
            if (underlayRgb != 0) {
                for (int i = 0; i < 4; ++i) {
                    pixels[pixelOffset] = points[indices[shapeOffset++]] != 0 ? overlayRgb : underlayRgb;
                    pixels[pixelOffset + 1] = points[indices[shapeOffset++]] != 0 ? overlayRgb : underlayRgb;
                    pixels[pixelOffset + 2] = points[indices[shapeOffset++]] != 0 ? overlayRgb : underlayRgb;
                    pixels[pixelOffset + 3] = points[indices[shapeOffset++]] != 0 ? overlayRgb : underlayRgb;
                    pixelOffset += 512;
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    if (points[indices[shapeOffset++]] != 0) {
                        pixels[pixelOffset] = overlayRgb;
                    }
                    if (points[indices[shapeOffset++]] != 0) {
                        pixels[pixelOffset + 1] = overlayRgb;
                    }
                    if (points[indices[shapeOffset++]] != 0) {
                        pixels[pixelOffset + 2] = overlayRgb;
                    }
                    if (points[indices[shapeOffset++]] != 0) {
                        pixels[pixelOffset + 3] = overlayRgb;
                    }
                    pixelOffset += 512;
                }
            }
        }
    }

    public void drawTileMinimapSD(int[] pixels, int drawIndex, int zLoc, int xLoc, int yLoc) {
        int leftOverWidth = 512;
        Tile tile = this.tileArray[zLoc][xLoc][yLoc];
        if (tile == null) {
            return;
        }
        SimpleTile simpleTile = tile.mySimpleTile;
        if (simpleTile != null) {
            int tileRGB = simpleTile.getColourRGB();
            if (tileRGB == 0) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                pixels[drawIndex] = tileRGB;
                pixels[drawIndex + 1] = tileRGB;
                pixels[drawIndex + 2] = tileRGB;
                pixels[drawIndex + 3] = tileRGB;
                drawIndex += leftOverWidth;
            }
            return;
        }
        ShapedTile shapedTile = tile.myShapedTile;
        if (shapedTile == null) {
            return;
        }
        int shape = shapedTile.shape;
        int rotation = shapedTile.rotation;
        int underlayRGB = shapedTile.colourRGB;
        int overlayRGB = shapedTile.colourRGBA;
        int[] shapePoints = this.tileVertices[shape];
        int[] shapePointIndices = this.tileVertexIndices[rotation];
        int shapePtr = 0;
        if (underlayRGB != 0) {
            for (int i = 0; i < 4; ++i) {
                pixels[drawIndex] = shapePoints[shapePointIndices[shapePtr++]] != 0 ? overlayRGB : underlayRGB;
                pixels[drawIndex + 1] = shapePoints[shapePointIndices[shapePtr++]] != 0 ? overlayRGB : underlayRGB;
                pixels[drawIndex + 2] = shapePoints[shapePointIndices[shapePtr++]] != 0 ? overlayRGB : underlayRGB;
                pixels[drawIndex + 3] = shapePoints[shapePointIndices[shapePtr++]] != 0 ? overlayRGB : underlayRGB;
                drawIndex += leftOverWidth;
            }
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (shapePoints[shapePointIndices[shapePtr++]] != 0) {
                pixels[drawIndex] = overlayRGB;
            }
            if (shapePoints[shapePointIndices[shapePtr++]] != 0) {
                pixels[drawIndex + 1] = overlayRGB;
            }
            if (shapePoints[shapePointIndices[shapePtr++]] != 0) {
                pixels[drawIndex + 2] = overlayRGB;
            }
            if (shapePoints[shapePointIndices[shapePtr++]] != 0) {
                pixels[drawIndex + 3] = overlayRGB;
            }
            drawIndex += leftOverWidth;
        }
    }

    public static void buildVisibilityMap(int i, int j, int viewportWidth, int viewportHeight, int[] ai) {
        xMin = 0;
        yMin = 0;
        xMax = viewportWidth;
        yMax = viewportHeight;
        viewportHalfWidth = viewportWidth / 2;
        viewportHalfHeight = viewportHeight / 2;
        boolean[][][][] aflag = new boolean[9][32][53][53];
        for (int zAngle = 128; zAngle <= 384; zAngle += 32) {
            for (int xyAngle = 0; xyAngle < 2048; xyAngle += 64) {
                camUpDownY = Model.SINE[zAngle];
                camUpDownX = Model.COSINE[zAngle];
                camLeftRightY = Model.SINE[xyAngle];
                camLeftRightX = Model.COSINE[xyAngle];
                int angularZSegment = (zAngle - 128) / 32;
                int angularXYSegment = xyAngle / 64;
                for (int xRelativeToCamera = -26; xRelativeToCamera <= 26; ++xRelativeToCamera) {
                    for (int yRelativeToCamera = -26; yRelativeToCamera <= 26; ++yRelativeToCamera) {
                        int xRelativeToCameraPos = xRelativeToCamera * 128;
                        int yRelativeToCameraPos = yRelativeToCamera * 128;
                        boolean flag2 = false;
                        for (int k4 = -i; k4 <= j; k4 += 128) {
                            if (!SceneGraph.method311(ai[angularZSegment] + k4, yRelativeToCameraPos, xRelativeToCameraPos)) continue;
                            flag2 = true;
                            break;
                        }
                        aflag[angularZSegment][angularXYSegment][xRelativeToCamera + 26][yRelativeToCamera + 26] = flag2;
                    }
                }
            }
        }
        for (int angularZSegment = 0; angularZSegment < 8; ++angularZSegment) {
            for (int angularXYSegment = 0; angularXYSegment < 32; ++angularXYSegment) {
                for (int xRelativeToCamera = -25; xRelativeToCamera < 25; ++xRelativeToCamera) {
                    for (int yRelativeToCamera = -25; yRelativeToCamera < 25; ++yRelativeToCamera) {
                        boolean flag1 = false;
                        block9: for (int l3 = -1; l3 <= 1; ++l3) {
                            for (int j4 = -1; j4 <= 1; ++j4) {
                                if (aflag[angularZSegment][angularXYSegment][xRelativeToCamera + l3 + 26][yRelativeToCamera + j4 + 26]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (aflag[angularZSegment][(angularXYSegment + 1) % 31][xRelativeToCamera + l3 + 26][yRelativeToCamera + j4 + 26]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (aflag[angularZSegment + 1][angularXYSegment][xRelativeToCamera + l3 + 26][yRelativeToCamera + j4 + 26]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (!aflag[angularZSegment + 1][(angularXYSegment + 1) % 31][xRelativeToCamera + l3 + 26][yRelativeToCamera + j4 + 26]) continue;
                                flag1 = true;
                                break block9;
                            }
                        }
                        SceneGraph.visibilityMap[angularZSegment][angularXYSegment][xRelativeToCamera + 25][yRelativeToCamera + 25] = flag1;
                    }
                }
            }
        }
    }

    private static boolean method311(int i, int j, int k) {
        int l = j * camLeftRightY + k * camLeftRightX >> 16;
        int i1 = j * camLeftRightX - k * camLeftRightY >> 16;
        int j1 = i * camUpDownY + i1 * camUpDownX >> 16;
        int k1 = i * camUpDownX - i1 * camUpDownY >> 16;
        if (j1 < 50 || j1 >= 3500) {
            return false;
        }
        int l1 = viewportHalfWidth + l * Rasterizer3D.fieldOfView / j1;
        int i2 = viewportHalfHeight + k1 * Rasterizer3D.fieldOfView / j1;
        return l1 >= xMin && l1 <= xMax && i2 >= yMin && i2 <= yMax;
    }

    public void clickTile(int clickY, int clickX) {
        clicked = true;
        clickScreenX = clickX;
        clickScreenY = clickY;
        clickedTileX = -1;
        clickedTileY = -1;
    }

    public void render(int cameraXPos, int cameraYPos, int camAngleXY, int cameraZPos, int planeZ, int camAngleZ) {
        int x;
        Tile[][] planeTiles;
        int z;
        int maxTileZ;
        int maxTileX;
        int minTileZ;
        int distance;
        DrawCallbacks drawCallbacks = Client.instance.getDrawCallbacks();
        if (drawCallbacks != null) {
            Client.instance.getDrawCallbacks().drawScene(cameraXPos, cameraZPos, cameraYPos, camAngleZ, camAngleXY, planeZ);
        }
        boolean isGpu = Client.instance.isGpu();
        boolean checkClick = Client.instance.isCheckClick();
        boolean menuOpen = Client.instance.isMenuOpen();
        if (!menuOpen && !checkClick) {
            Client.instance.getScene().menuOpen(Client.instance.getPlane(), Client.instance.getMouseX() - Client.instance.getViewportXOffset(), Client.instance.getMouseY() - Client.instance.getViewportYOffset(), false);
        }
        if (!isGpu && skyboxColor != 0) {
            Client.instance.rasterizerFillRectangle(Client.instance.getViewportXOffset(), Client.instance.getViewportYOffset(), Client.instance.getViewportWidth(), Client.instance.getViewportHeight(), skyboxColor);
        }
        int maxX = this.getMaxX();
        int maxY = this.getMaxY();
        int maxZ = this.getMaxZ();
        int minLevel = this.getMinLevel();
        RSTile[][][] tiles = this.getTiles();
        int n = distance = isGpu ? this.drawDistance : 25;
        if (cameraXPos < 0) {
            cameraXPos = 0;
        } else if (cameraXPos >= maxX * 128) {
            cameraXPos = maxX * 128 - 1;
        }
        if (cameraYPos < 0) {
            cameraYPos = 0;
        } else if (cameraYPos >= maxZ * 128) {
            cameraYPos = maxZ * 128 - 1;
        }
        int realPitch = camAngleZ;
        if (camAngleZ < 128) {
            camAngleZ = 128;
        } else if (camAngleZ > 383) {
            camAngleZ = 383;
        }
        if (!pitchRelaxEnabled) {
            realPitch = camAngleZ;
        }
        Client.instance.setCycle(Client.instance.getCycle() + 1);
        Client.instance.setPitchSin(Perspective.SINE[realPitch]);
        Client.instance.setPitchCos(Perspective.COSINE[realPitch]);
        Client.instance.setYawSin(Perspective.SINE[camAngleXY]);
        Client.instance.setYawCos(Perspective.COSINE[camAngleXY]);
        int[][][] tileHeights = Client.instance.getTileHeights();
        boolean[][] renderArea = Client.instance.getVisibilityMaps()[(camAngleZ - 128) / 32][camAngleXY / 64];
        Client.instance.setRenderArea(renderArea);
        Client.instance.setCameraX2(cameraXPos);
        Client.instance.setCameraY2(cameraZPos);
        Client.instance.setCameraZ2(cameraYPos);
        int screenCenterX = cameraXPos / 128;
        int screenCenterZ = cameraYPos / 128;
        Client.instance.setScreenCenterX(screenCenterX);
        Client.instance.setScreenCenterZ(screenCenterZ);
        Client.instance.setScenePlane(planeZ);
        int minTileX = screenCenterX - distance;
        if (minTileX < 0) {
            minTileX = 0;
        }
        if ((minTileZ = screenCenterZ - distance) < 0) {
            minTileZ = 0;
        }
        if ((maxTileX = screenCenterX + distance) > maxX) {
            maxTileX = maxX;
        }
        if ((maxTileZ = screenCenterZ + distance) > maxZ) {
            maxTileZ = maxZ;
        }
        Client.instance.setMinTileX(minTileX);
        Client.instance.setMinTileZ(minTileZ);
        Client.instance.setMaxTileX(maxTileX);
        Client.instance.setMaxTileZ(maxTileZ);
        this.updateOccluders();
        Client.instance.setTileUpdateCount(0);
        if (roofRemovalMode != 0) {
            LocalPoint localDestinationLocation;
            LocalPoint localLocation;
            tilesToRemove.clear();
            RSPlayer localPlayer = Client.instance.getLocalPlayer();
            if (localPlayer != null && (roofRemovalMode & 1) != 0 && (localLocation = localPlayer.getLocalLocation()).isInScene()) {
                tilesToRemove.add(this.tileArray[Client.instance.getPlane()][localLocation.getSceneX()][localLocation.getSceneY()]);
            }
            if (hoverX >= 0 && hoverX < 104 && hoverY >= 0 && hoverY < 104 && (roofRemovalMode & 2) != 0) {
                tilesToRemove.add(this.tileArray[Client.instance.getPlane()][hoverX][hoverY]);
            }
            if ((localDestinationLocation = Client.instance.getLocalDestinationLocation()) != null && localDestinationLocation.isInScene() && (roofRemovalMode & 4) != 0) {
                tilesToRemove.add(this.tileArray[Client.instance.getPlane()][localDestinationLocation.getSceneX()][localDestinationLocation.getSceneY()]);
            }
            if (Client.instance.getCameraPitch() < 310 && (roofRemovalMode & 8) != 0 && localPlayer != null) {
                int playerX = localPlayer.getX() >> 7;
                int playerY = localPlayer.getY() >> 7;
                int var29 = Client.instance.getCameraX() >> 7;
                int var30 = Client.instance.getCameraY() >> 7;
                if (playerX >= 0 && playerY >= 0 && var29 >= 0 && var30 >= 0 && playerX < 104 && playerY < 104 && var29 < 104 && var30 < 104) {
                    int var31 = Math.abs(playerX - var29);
                    int var32 = Integer.compare(playerX, var29);
                    int var33 = -Math.abs(playerY - var30);
                    int var34 = Integer.compare(playerY, var30);
                    int var35 = var31 + var33;
                    while (var29 != playerX || var30 != playerY) {
                        int var36;
                        if (SceneGraph.blocking(Client.instance.getPlane(), var29, var30)) {
                            tilesToRemove.add(this.tileArray[Client.instance.getPlane()][var29][var30]);
                        }
                        if ((var36 = 2 * var35) >= var33) {
                            var35 += var33;
                            var29 += var32;
                            continue;
                        }
                        var35 += var31;
                        var30 += var34;
                    }
                }
            }
        }
        if (!menuOpen) {
            hoverY = -1;
            hoverX = -1;
        }
        for (z = minLevel; z < maxY; ++z) {
            planeTiles = this.tileArray[z];
            for (x = minTileX; x < maxTileX; ++x) {
                for (int y = minTileZ; y < maxTileZ; ++y) {
                    Tile tile = planeTiles[x][y];
                    if (tile == null) continue;
                    Tile var30 = this.tileArray[Client.instance.getPlane()][x][y];
                    if (tile.getPhysicalLevel() > planeZ && roofRemovalMode == 0 || !isGpu && !renderArea[x - screenCenterX + 25][y - screenCenterZ + 25] && tileHeights[z][x][y] - cameraYPos < 2000 || roofRemovalMode != 0 && Client.instance.getPlane() < tile.getPhysicalLevel() && tilesToRemove.contains(var30)) {
                        tile.setDraw(false);
                        tile.setVisible(false);
                        tile.setWallCullDirection(0);
                        continue;
                    }
                    tile.setDraw(true);
                    tile.setVisible(true);
                    tile.setDrawEntities(true);
                    Client.instance.setTileUpdateCount(Client.instance.getTileUpdateCount() + 1);
                }
            }
        }
        for (z = minLevel; z < maxY; ++z) {
            planeTiles = this.tileArray[z];
            for (x = -distance; x <= 0; ++x) {
                int var10 = x + screenCenterX;
                int var16 = screenCenterX - x;
                if (var10 < minTileX && var16 >= maxTileX) continue;
                for (int y = -distance; y <= 0; ++y) {
                    Tile tile;
                    int var13 = y + screenCenterZ;
                    int var14 = screenCenterZ - y;
                    if (var10 >= minTileX) {
                        Tile tile2;
                        if (var13 >= minTileZ && (tile2 = planeTiles[var10][var13]) != null && tile2.isDraw()) {
                            this.draw(tile2, true);
                        }
                        if (var14 < maxTileZ && (tile = planeTiles[var10][var14]) != null && tile.isDraw()) {
                            this.draw(tile, true);
                        }
                    }
                    if (var16 >= maxTileX) continue;
                    if (var13 >= minTileZ && (tile = planeTiles[var16][var13]) != null && tile.isDraw()) {
                        this.draw(tile, true);
                    }
                    if (var14 >= maxTileZ || (tile = planeTiles[var16][var14]) == null || !tile.isDraw()) continue;
                    this.draw(tile, true);
                }
            }
        }
        if (!isGpu && Client.instance.getOculusOrbState() != 0 && !Client.instance.getComplianceValue("orbInteraction")) {
            Client.instance.setEntitiesAtMouseCount(0);
        }
        Client.instance.setCheckClick(false);
        Client.instance.getCallbacks().drawScene();
        if (Client.instance.getDrawCallbacks() != null) {
            Client.instance.getDrawCallbacks().postDrawScene();
        }
    }

    public static boolean blocking(int plane, int x, int y) {
        return (Client.instance.getTileSettings()[plane][x][y] & 4) != 0;
    }

    private void drawTile(Tile tile, boolean flag) {
        tileDeque.insertHead(tile);
        Tile currentTile;
        while ((currentTile = (Tile)tileDeque.popHead()) != null) {
            Tile class30_sub3_16;
            Tile class30_sub3_15;
            Tile class30_sub3_14;
            Tile class30_sub3_13;
            Tile class30_sub3_12;
            Tile class30_sub3_11;
            Tile class30_sub3_10;
            Tile class30_sub3_9;
            Tile class30_sub3_8;
            if (!currentTile.aBoolean1323) continue;
            int i = currentTile.anInt1308;
            int j = currentTile.anInt1309;
            int k = currentTile.z1AnInt1307;
            int l = currentTile.anInt1310;
            Tile[][] aclass30_sub3 = this.tileArray[k];
            if (currentTile.aBoolean1322) {
                int k4;
                if (flag) {
                    Tile class30_sub3_6;
                    Tile class30_sub3_5;
                    Tile class30_sub3_4;
                    Tile class30_sub3_3;
                    Tile class30_sub3_2;
                    if (k > 0 && (class30_sub3_2 = this.tileArray[k - 1][i][j]) != null && class30_sub3_2.aBoolean1323 || i <= this.screenCenterX && i > this.minTileX && (class30_sub3_3 = aclass30_sub3[i - 1][j]) != null && class30_sub3_3.aBoolean1323 && (class30_sub3_3.aBoolean1322 || (currentTile.totalTiledObjectMask & 1) == 0) || i >= this.screenCenterX && i < this.maxTileX - 1 && (class30_sub3_4 = aclass30_sub3[i + 1][j]) != null && class30_sub3_4.aBoolean1323 && (class30_sub3_4.aBoolean1322 || (currentTile.totalTiledObjectMask & 4) == 0) || j <= this.screenCenterZ && j > this.minTileZ && (class30_sub3_5 = aclass30_sub3[i][j - 1]) != null && class30_sub3_5.aBoolean1323 && (class30_sub3_5.aBoolean1322 || (currentTile.totalTiledObjectMask & 8) == 0) || j >= this.screenCenterZ && j < this.maxTileZ - 1 && (class30_sub3_6 = aclass30_sub3[i][j + 1]) != null && class30_sub3_6.aBoolean1323 && (class30_sub3_6.aBoolean1322 || (currentTile.totalTiledObjectMask & 2) == 0)) {
                        continue;
                    }
                } else {
                    flag = true;
                }
                currentTile.aBoolean1322 = false;
                if (currentTile.firstFloorTile != null) {
                    WallObject class10;
                    Tile class30_sub3_7 = currentTile.firstFloorTile;
                    if (class30_sub3_7.mySimpleTile != null) {
                        if (!this.method320(0, i, j)) {
                            this.drawTileUnderlay(class30_sub3_7.mySimpleTile, 0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, i, j);
                        }
                    } else if (class30_sub3_7.myShapedTile != null && !this.method320(0, i, j)) {
                        this.drawTileOverlay(i, camUpDownY, camLeftRightY, class30_sub3_7.myShapedTile, camUpDownX, j, camLeftRightX);
                    }
                    if ((class10 = class30_sub3_7.wallObject) != null) {
                        class10.renderable1.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class10.xPos - xCameraPos, class10.tileHeights - zCameraPos, class10.yPos - yCameraPos, class10.uid, class10.zLoc);
                    }
                    for (int i2 = 0; i2 < class30_sub3_7.gameObjectIndex; ++i2) {
                        GameObject class28 = class30_sub3_7.gameObjects[i2];
                        if (class28 == null) continue;
                        class28.renderable.renderAtPoint(class28.turnValue, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class28.xPos - xCameraPos, class28.tileHeight - zCameraPos, class28.yPos - yCameraPos, class28.uid, class28.zLoc);
                    }
                }
                boolean flag1 = false;
                if (currentTile.mySimpleTile != null) {
                    if (!this.method320(l, i, j)) {
                        flag1 = true;
                        this.drawTileUnderlay(currentTile.mySimpleTile, l, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, i, j);
                    }
                } else if (currentTile.myShapedTile != null && !this.method320(l, i, j)) {
                    flag1 = true;
                    this.drawTileOverlay(i, camUpDownY, camLeftRightY, currentTile.myShapedTile, camUpDownX, j, camLeftRightX);
                }
                int j1 = 0;
                int j2 = 0;
                WallObject class10_3 = currentTile.wallObject;
                WallDecoration class26_1 = currentTile.wallDecoration;
                if (class10_3 != null || class26_1 != null) {
                    if (this.screenCenterX == i) {
                        ++j1;
                    } else if (this.screenCenterX < i) {
                        j1 += 2;
                    }
                    if (this.screenCenterZ == j) {
                        j1 += 3;
                    } else if (this.screenCenterZ > j) {
                        j1 += 6;
                    }
                    j2 = anIntArray478[j1];
                    currentTile.anInt1328 = anIntArray480[j1];
                }
                if (class10_3 != null) {
                    if ((class10_3.orientation1 & anIntArray479[j1]) != 0) {
                        if (class10_3.orientation1 == 16) {
                            currentTile.wallCullDirection = 3;
                            currentTile.anInt1326 = anIntArray481[j1];
                            currentTile.anInt1327 = 3 - currentTile.anInt1326;
                        } else if (class10_3.orientation1 == 32) {
                            currentTile.wallCullDirection = 6;
                            currentTile.anInt1326 = anIntArray482[j1];
                            currentTile.anInt1327 = 6 - currentTile.anInt1326;
                        } else if (class10_3.orientation1 == 64) {
                            currentTile.wallCullDirection = 12;
                            currentTile.anInt1326 = anIntArray483[j1];
                            currentTile.anInt1327 = 12 - currentTile.anInt1326;
                        } else {
                            currentTile.wallCullDirection = 9;
                            currentTile.anInt1326 = anIntArray484[j1];
                            currentTile.anInt1327 = 9 - currentTile.anInt1326;
                        }
                    } else {
                        currentTile.wallCullDirection = 0;
                    }
                    if ((class10_3.orientation1 & j2) != 0 && !this.method321(l, i, j, class10_3.orientation1)) {
                        class10_3.renderable1.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class10_3.xPos - xCameraPos, class10_3.tileHeights - zCameraPos, class10_3.yPos - yCameraPos, class10_3.uid, class10_3.zLoc);
                    }
                    if ((class10_3.orientation2 & j2) != 0 && !this.method321(l, i, j, class10_3.orientation2)) {
                        class10_3.renderable2.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class10_3.xPos - xCameraPos, class10_3.tileHeights - zCameraPos, class10_3.yPos - yCameraPos, class10_3.uid, class10_3.zLoc);
                    }
                }
                if (class26_1 != null && !this.method322(l, i, j, class26_1.renderable.modelBaseY)) {
                    if ((class26_1.orientation & j2) != 0) {
                        class26_1.renderable.renderAtPoint(class26_1.orientation2, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class26_1.xPos - xCameraPos, class26_1.tileHeights - zCameraPos, class26_1.yPos - yCameraPos, class26_1.uid, class26_1.zLoc);
                    } else if ((class26_1.orientation & 0x300) != 0) {
                        int j4 = class26_1.xPos - xCameraPos;
                        int l5 = class26_1.tileHeights - zCameraPos;
                        int k6 = class26_1.yPos - yCameraPos;
                        int i8 = class26_1.orientation2;
                        int k9 = i8 == 1 || i8 == 2 ? -j4 : j4;
                        int k10 = i8 == 2 || i8 == 3 ? -k6 : k6;
                        if ((class26_1.orientation & 0x100) != 0 && k10 < k9) {
                            int i11 = j4 + anIntArray463[i8];
                            int k11 = k6 + anIntArray464[i8];
                            class26_1.renderable.renderAtPoint(i8 * 512 + 256, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, i11, l5, k11, class26_1.uid, class26_1.zLoc);
                        }
                        if ((class26_1.orientation & 0x200) != 0 && k10 > k9) {
                            int j11 = j4 + anIntArray465[i8];
                            int l11 = k6 + anIntArray466[i8];
                            class26_1.renderable.renderAtPoint(i8 * 512 + 1280 & 0x7FF, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, j11, l5, l11, class26_1.uid, class26_1.zLoc);
                        }
                    }
                }
                if (flag1) {
                    GroundItemTile object4_1;
                    GroundDecoration class49 = currentTile.groundDecoration;
                    if (class49 != null) {
                        class49.renderable.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class49.xPos - xCameraPos, class49.tileHeights - zCameraPos, class49.yPos - yCameraPos, class49.uid, class49.zLoc);
                    }
                    if ((object4_1 = currentTile.groundItemTile) != null && object4_1.itemDropHeight == 0) {
                        if (object4_1.lowerNode != null) {
                            object4_1.lowerNode.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, object4_1.xPos - xCameraPos, object4_1.tileHeights - zCameraPos, object4_1.yPos - yCameraPos, object4_1.uid, object4_1.zLoc);
                        }
                        if (object4_1.middleNode != null) {
                            object4_1.middleNode.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, object4_1.xPos - xCameraPos, object4_1.tileHeights - zCameraPos, object4_1.yPos - yCameraPos, object4_1.uid, object4_1.zLoc);
                        }
                        if (object4_1.topNode != null) {
                            object4_1.topNode.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, object4_1.xPos - xCameraPos, object4_1.tileHeights - zCameraPos, object4_1.yPos - yCameraPos, object4_1.uid, object4_1.zLoc);
                        }
                    }
                }
                if ((k4 = currentTile.totalTiledObjectMask) != 0) {
                    Tile class30_sub3_20;
                    Tile class30_sub3_19;
                    Tile class30_sub3_18;
                    Tile class30_sub3_17;
                    if (i < this.screenCenterX && (k4 & 4) != 0 && (class30_sub3_17 = aclass30_sub3[i + 1][j]) != null && class30_sub3_17.aBoolean1323) {
                        tileDeque.insertHead(class30_sub3_17);
                    }
                    if (j < this.screenCenterZ && (k4 & 2) != 0 && (class30_sub3_18 = aclass30_sub3[i][j + 1]) != null && class30_sub3_18.aBoolean1323) {
                        tileDeque.insertHead(class30_sub3_18);
                    }
                    if (i > this.screenCenterX && (k4 & 1) != 0 && (class30_sub3_19 = aclass30_sub3[i - 1][j]) != null && class30_sub3_19.aBoolean1323) {
                        tileDeque.insertHead(class30_sub3_19);
                    }
                    if (j > this.screenCenterZ && (k4 & 8) != 0 && (class30_sub3_20 = aclass30_sub3[i][j - 1]) != null && class30_sub3_20.aBoolean1323) {
                        tileDeque.insertHead(class30_sub3_20);
                    }
                }
            }
            if (currentTile.wallCullDirection != 0) {
                boolean flag2 = true;
                for (int k1 = 0; k1 < currentTile.gameObjectIndex; ++k1) {
                    if (currentTile.gameObjects[k1].anInt528 == this.cycle || (currentTile.tiledObjectMasks[k1] & currentTile.wallCullDirection) != currentTile.anInt1326) continue;
                    flag2 = false;
                    break;
                }
                if (flag2) {
                    WallObject class10_1 = currentTile.wallObject;
                    if (!this.method321(l, i, j, class10_1.orientation1)) {
                        class10_1.renderable1.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class10_1.xPos - xCameraPos, class10_1.tileHeights - zCameraPos, class10_1.yPos - yCameraPos, class10_1.uid, class10_1.zLoc);
                    }
                    currentTile.wallCullDirection = 0;
                }
            }
            if (currentTile.aBoolean1324) {
                try {
                    int i1 = currentTile.gameObjectIndex;
                    currentTile.aBoolean1324 = false;
                    int l1 = 0;
                    block5: for (int k2 = 0; k2 < i1; ++k2) {
                        int i7;
                        int j8;
                        GameObject class28_1 = currentTile.gameObjects[k2];
                        if (class28_1.anInt528 == this.cycle) continue;
                        for (int k3 = class28_1.xLocLow; k3 <= class28_1.xLocHigh; ++k3) {
                            for (int l4 = class28_1.yLocHigh; l4 <= class28_1.yLocLow; ++l4) {
                                Tile class30_sub3_21 = aclass30_sub3[k3][l4];
                                if (class30_sub3_21.aBoolean1322) {
                                    currentTile.aBoolean1324 = true;
                                    continue block5;
                                }
                                if (class30_sub3_21.wallCullDirection == 0) continue;
                                int l6 = 0;
                                if (k3 > class28_1.xLocLow) {
                                    ++l6;
                                }
                                if (k3 < class28_1.xLocHigh) {
                                    l6 += 4;
                                }
                                if (l4 > class28_1.yLocHigh) {
                                    l6 += 8;
                                }
                                if (l4 < class28_1.yLocLow) {
                                    l6 += 2;
                                }
                                if ((l6 & class30_sub3_21.wallCullDirection) != currentTile.anInt1327) continue;
                                currentTile.aBoolean1324 = true;
                                continue block5;
                            }
                        }
                        SceneGraph.interactableObjects[l1++] = class28_1;
                        int i6 = class28_1.xLocHigh - this.screenCenterX;
                        int i5 = this.screenCenterX - class28_1.xLocLow;
                        if (i6 > i5) {
                            i5 = i6;
                        }
                        class28_1.anInt527 = (j8 = class28_1.yLocLow - this.screenCenterZ) > (i7 = this.screenCenterZ - class28_1.yLocHigh) ? i5 + j8 : i5 + i7;
                    }
                    while (l1 > 0) {
                        int i3 = -50;
                        int l3 = -1;
                        for (int j5 = 0; j5 < l1; ++j5) {
                            int l10;
                            int l9;
                            int k8;
                            int j7;
                            GameObject class28_2 = interactableObjects[j5];
                            if (class28_2.anInt528 == this.cycle) continue;
                            if (class28_2.anInt527 > i3) {
                                i3 = class28_2.anInt527;
                                l3 = j5;
                                continue;
                            }
                            if (class28_2.anInt527 != i3 || (j7 = class28_2.xPos - xCameraPos) * j7 + (k8 = class28_2.yPos - yCameraPos) * k8 <= (l9 = SceneGraph.interactableObjects[l3].xPos - xCameraPos) * l9 + (l10 = SceneGraph.interactableObjects[l3].yPos - yCameraPos) * l10) continue;
                            l3 = j5;
                        }
                        if (l3 == -1) break;
                        GameObject class28_3 = interactableObjects[l3];
                        class28_3.anInt528 = this.cycle;
                        if (!this.method323(l, class28_3.xLocLow, class28_3.xLocHigh, class28_3.yLocHigh, class28_3.yLocLow, class28_3.renderable.modelBaseY)) {
                            class28_3.renderable.renderAtPoint(class28_3.turnValue, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class28_3.xPos - xCameraPos, class28_3.tileHeight - zCameraPos, class28_3.yPos - yCameraPos, class28_3.uid, class28_3.zLoc);
                        }
                        for (int k7 = class28_3.xLocLow; k7 <= class28_3.xLocHigh; ++k7) {
                            for (int l8 = class28_3.yLocHigh; l8 <= class28_3.yLocLow; ++l8) {
                                Tile class30_sub3_22 = aclass30_sub3[k7][l8];
                                if (class30_sub3_22.wallCullDirection != 0) {
                                    tileDeque.insertHead(class30_sub3_22);
                                    continue;
                                }
                                if (k7 == i && l8 == j || !class30_sub3_22.aBoolean1323) continue;
                                tileDeque.insertHead(class30_sub3_22);
                            }
                        }
                    }
                    if (currentTile.aBoolean1324) {
                        continue;
                    }
                }
                catch (Exception _ex) {
                    currentTile.aBoolean1324 = false;
                }
            }
            if (!currentTile.aBoolean1323 || currentTile.wallCullDirection != 0 || i <= this.screenCenterX && i > this.minTileX && (class30_sub3_8 = aclass30_sub3[i - 1][j]) != null && class30_sub3_8.aBoolean1323 || i >= this.screenCenterX && i < this.maxTileX - 1 && (class30_sub3_9 = aclass30_sub3[i + 1][j]) != null && class30_sub3_9.aBoolean1323 || j <= this.screenCenterZ && j > this.minTileZ && (class30_sub3_10 = aclass30_sub3[i][j - 1]) != null && class30_sub3_10.aBoolean1323 || j >= this.screenCenterZ && j < this.maxTileZ - 1 && (class30_sub3_11 = aclass30_sub3[i][j + 1]) != null && class30_sub3_11.aBoolean1323) continue;
            currentTile.aBoolean1323 = false;
            --this.tileUpdateCount;
            GroundItemTile object4 = currentTile.groundItemTile;
            if (object4 != null && object4.itemDropHeight != 0) {
                if (object4.lowerNode != null) {
                    object4.lowerNode.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, object4.xPos - xCameraPos, object4.tileHeights - zCameraPos - object4.itemDropHeight, object4.yPos - yCameraPos, object4.uid, object4.zLoc);
                }
                if (object4.middleNode != null) {
                    object4.middleNode.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, object4.xPos - xCameraPos, object4.tileHeights - zCameraPos - object4.itemDropHeight, object4.yPos - yCameraPos, object4.uid, object4.zLoc);
                }
                if (object4.topNode != null) {
                    object4.topNode.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, object4.xPos - xCameraPos, object4.tileHeights - zCameraPos - object4.itemDropHeight, object4.yPos - yCameraPos, object4.uid, object4.zLoc);
                }
            }
            if (currentTile.anInt1328 != 0) {
                WallObject class10_2;
                WallDecoration class26 = currentTile.wallDecoration;
                if (class26 != null && !this.method322(l, i, j, class26.renderable.modelBaseY)) {
                    if ((class26.orientation & currentTile.anInt1328) != 0) {
                        class26.renderable.renderAtPoint(class26.orientation2, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class26.xPos - xCameraPos, class26.tileHeights - zCameraPos, class26.yPos - yCameraPos, class26.uid, class26.zLoc);
                    } else if ((class26.orientation & 0x300) != 0) {
                        int l2 = class26.xPos - xCameraPos;
                        int j3 = class26.tileHeights - zCameraPos;
                        int i4 = class26.yPos - yCameraPos;
                        int k5 = class26.orientation2;
                        int j6 = k5 == 1 || k5 == 2 ? -l2 : l2;
                        int l7 = k5 == 2 || k5 == 3 ? -i4 : i4;
                        if ((class26.orientation & 0x100) != 0 && l7 >= j6) {
                            int i9 = l2 + anIntArray463[k5];
                            int i10 = i4 + anIntArray464[k5];
                            class26.renderable.renderAtPoint(k5 * 512 + 256, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, i9, j3, i10, class26.uid, class26.zLoc);
                        }
                        if ((class26.orientation & 0x200) != 0 && l7 <= j6) {
                            int j9 = l2 + anIntArray465[k5];
                            int j10 = i4 + anIntArray466[k5];
                            class26.renderable.renderAtPoint(k5 * 512 + 1280 & 0x7FF, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, j9, j3, j10, class26.uid, class26.zLoc);
                        }
                    }
                }
                if ((class10_2 = currentTile.wallObject) != null) {
                    if ((class10_2.orientation2 & currentTile.anInt1328) != 0 && !this.method321(l, i, j, class10_2.orientation2)) {
                        class10_2.renderable2.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class10_2.xPos - xCameraPos, class10_2.tileHeights - zCameraPos, class10_2.yPos - yCameraPos, class10_2.uid, class10_2.zLoc);
                    }
                    if ((class10_2.orientation1 & currentTile.anInt1328) != 0 && !this.method321(l, i, j, class10_2.orientation1)) {
                        class10_2.renderable1.renderAtPoint(0, camUpDownY, camUpDownX, camLeftRightY, camLeftRightX, class10_2.xPos - xCameraPos, class10_2.tileHeights - zCameraPos, class10_2.yPos - yCameraPos, class10_2.uid, class10_2.zLoc);
                    }
                }
            }
            if (k < this.maxY - 1 && (class30_sub3_12 = this.tileArray[k + 1][i][j]) != null && class30_sub3_12.aBoolean1323) {
                tileDeque.insertHead(class30_sub3_12);
            }
            if (i < this.screenCenterX && (class30_sub3_13 = aclass30_sub3[i + 1][j]) != null && class30_sub3_13.aBoolean1323) {
                tileDeque.insertHead(class30_sub3_13);
            }
            if (j < this.screenCenterZ && (class30_sub3_14 = aclass30_sub3[i][j + 1]) != null && class30_sub3_14.aBoolean1323) {
                tileDeque.insertHead(class30_sub3_14);
            }
            if (i > this.screenCenterX && (class30_sub3_15 = aclass30_sub3[i - 1][j]) != null && class30_sub3_15.aBoolean1323) {
                tileDeque.insertHead(class30_sub3_15);
            }
            if (j <= this.screenCenterZ || (class30_sub3_16 = aclass30_sub3[i][j - 1]) == null || !class30_sub3_16.aBoolean1323) continue;
            tileDeque.insertHead(class30_sub3_16);
        }
        return;
    }

    private void drawTileUnderlay(SimpleTile tile, int z, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y) {
        DrawCallbacks drawCallbacks;
        byte[][][] tileSettings = Client.instance.getTileSettings();
        boolean checkClick = Client.instance.isCheckClick();
        int tilePlane = z;
        if ((tileSettings[1][x][x] & 2) != 0) {
            tilePlane = z - 1;
        }
        if (!Client.instance.isGpu()) {
            try {
                this.drawTileUnderlaySD(tile, z, pitchSin, pitchCos, yawSin, yawCos, x, y);
            }
            catch (Exception ex) {
                Client.instance.getLogger().warn("error during tile underlay rendering", ex);
            }
            if (roofRemovalMode == 0 || !checkClick || Client.instance.getPlane() != tilePlane) {
                return;
            }
        }
        if ((drawCallbacks = Client.instance.getDrawCallbacks()) == null) {
            return;
        }
        try {
            int var15;
            int var13;
            int var11;
            int var9;
            int[][][] tileHeights = this.getTileHeights();
            int cameraX2 = Client.instance.getCameraX2();
            int cameraY2 = Client.instance.getCameraY2();
            int cameraZ2 = Client.instance.getCameraZ2();
            int zoom = Client.instance.get3dZoom();
            int centerX = Client.instance.getCenterX();
            int centerY = Client.instance.getCenterY();
            int mouseX2 = Client.instance.getMouseX2();
            int mouseY2 = Client.instance.getMouseY2();
            int var10 = var9 = (x << 7) - cameraX2;
            int var12 = var11 = (y << 7) - cameraZ2;
            int var14 = var13 = var10 + 128;
            int var16 = var15 = var12 + 128;
            int var17 = tileHeights[z][x][y] - cameraY2;
            int var18 = tileHeights[z][x + 1][y] - cameraY2;
            int var19 = tileHeights[z][x + 1][y + 1] - cameraY2;
            int var20 = tileHeights[z][x][y + 1] - cameraY2;
            int var21 = var10 * yawCos + yawSin * var12 >> 16;
            var12 = var12 * yawCos - yawSin * var10 >> 16;
            var10 = var21;
            var21 = var17 * pitchCos - pitchSin * var12 >> 16;
            var12 = pitchSin * var17 + var12 * pitchCos >> 16;
            var17 = var21;
            if (var12 >= 50) {
                var21 = var14 * yawCos + yawSin * var11 >> 16;
                var11 = var11 * yawCos - yawSin * var14 >> 16;
                var14 = var21;
                var21 = var18 * pitchCos - pitchSin * var11 >> 16;
                var11 = pitchSin * var18 + var11 * pitchCos >> 16;
                var18 = var21;
                if (var11 >= 50) {
                    var21 = var13 * yawCos + yawSin * var16 >> 16;
                    var16 = var16 * yawCos - yawSin * var13 >> 16;
                    var13 = var21;
                    var21 = var19 * pitchCos - pitchSin * var16 >> 16;
                    var16 = pitchSin * var19 + var16 * pitchCos >> 16;
                    var19 = var21;
                    if (var16 >= 50) {
                        var21 = var9 * yawCos + yawSin * var15 >> 16;
                        var15 = var15 * yawCos - yawSin * var9 >> 16;
                        var9 = var21;
                        var21 = var20 * pitchCos - pitchSin * var15 >> 16;
                        if ((var15 = pitchSin * var20 + var15 * pitchCos >> 16) >= 50) {
                            int dy = var10 * zoom / var12 + centerX;
                            int dx = var17 * zoom / var12 + centerY;
                            int cy = var14 * zoom / var11 + centerX;
                            int cx = var18 * zoom / var11 + centerY;
                            int ay = var13 * zoom / var16 + centerX;
                            int ax = var19 * zoom / var16 + centerY;
                            int by = var9 * zoom / var15 + centerX;
                            int bx = var21 * zoom / var15 + centerY;
                            drawCallbacks.drawScenePaint(0, pitchSin, pitchCos, yawSin, yawCos, -cameraX2, -cameraY2, -cameraZ2, tile, z, x, y, zoom, centerX, centerY);
                            if ((ay - by) * (cx - bx) - (ax - bx) * (cy - by) > 0) {
                                if (checkClick && Client.instance.containsBounds(mouseX2, mouseY2, ax, bx, cx, ay, by, cy)) {
                                    SceneGraph.setTargetTile(x, y);
                                }
                                if (Client.instance.containsBounds(MouseHandler.mouseX, MouseHandler.mouseY, ax, bx, cx, ay, by, cy)) {
                                    SceneGraph.hoverTile(x, y, tilePlane);
                                }
                            }
                            if ((dy - cy) * (bx - cx) - (dx - cx) * (by - cy) > 0) {
                                if (checkClick && this.inBounds(clickScreenX, clickScreenY, dx, cx, bx, dy, cy, by)) {
                                    SceneGraph.setTargetTile(x, y);
                                }
                                if (this.inBounds(MouseHandler.mouseX, MouseHandler.mouseY, dx, cx, bx, dy, cy, by)) {
                                    SceneGraph.hoverTile(x, y, tilePlane);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            Client.instance.getLogger().warn("error during underlay rendering", ex);
        }
    }

    public static void hoverTile(int x, int y, int plane) {
        if (plane == Client.instance.getPlane() && !Client.instance.isMenuOpen()) {
            hoverX = x;
            hoverY = y;
        }
    }

    private static void setTargetTile(int targetX, int targetY) {
        Client.instance.setSelectedSceneTileX(targetX);
        Client.instance.setSelectedSceneTileY(targetY);
    }

    private void drawTileUnderlaySD(SimpleTile simpleTile, int z, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y) {
        int j3;
        int l2;
        int j2;
        int l1;
        int i2 = l1 = (x << 7) - xCameraPos;
        int k2 = j2 = (y << 7) - yCameraPos;
        int i3 = l2 = i2 + 128;
        int k3 = j3 = k2 + 128;
        int l3 = this.heightMap[z][x][y] - zCameraPos;
        int i4 = this.heightMap[z][x + 1][y] - zCameraPos;
        int j4 = this.heightMap[z][x + 1][y + 1] - zCameraPos;
        int k4 = this.heightMap[z][x][y + 1] - zCameraPos;
        int l4 = k2 * yawSin + i2 * yawCos >> 16;
        k2 = k2 * yawCos - i2 * yawSin >> 16;
        i2 = l4;
        l4 = l3 * pitchCos - k2 * pitchSin >> 16;
        k2 = l3 * pitchSin + k2 * pitchCos >> 16;
        l3 = l4;
        if (k2 < 50) {
            return;
        }
        l4 = j2 * yawSin + i3 * yawCos >> 16;
        j2 = j2 * yawCos - i3 * yawSin >> 16;
        i3 = l4;
        l4 = i4 * pitchCos - j2 * pitchSin >> 16;
        j2 = i4 * pitchSin + j2 * pitchCos >> 16;
        i4 = l4;
        if (j2 < 50) {
            return;
        }
        l4 = k3 * yawSin + l2 * yawCos >> 16;
        k3 = k3 * yawCos - l2 * yawSin >> 16;
        l2 = l4;
        l4 = j4 * pitchCos - k3 * pitchSin >> 16;
        k3 = j4 * pitchSin + k3 * pitchCos >> 16;
        j4 = l4;
        if (k3 < 50) {
            return;
        }
        l4 = j3 * yawSin + l1 * yawCos >> 16;
        j3 = j3 * yawCos - l1 * yawSin >> 16;
        l1 = l4;
        l4 = k4 * pitchCos - j3 * pitchSin >> 16;
        j3 = k4 * pitchSin + j3 * pitchCos >> 16;
        k4 = l4;
        if (j3 < 50) {
            return;
        }
        int i5 = Rasterizer3D.originViewX + i2 * Rasterizer3D.fieldOfView / k2;
        int j5 = Rasterizer3D.originViewY + l3 * Rasterizer3D.fieldOfView / k2;
        int k5 = Rasterizer3D.originViewX + i3 * Rasterizer3D.fieldOfView / j2;
        int l5 = Rasterizer3D.originViewY + i4 * Rasterizer3D.fieldOfView / j2;
        int i6 = Rasterizer3D.originViewX + l2 * Rasterizer3D.fieldOfView / k3;
        int j6 = Rasterizer3D.originViewY + j4 * Rasterizer3D.fieldOfView / k3;
        int k6 = Rasterizer3D.originViewX + l1 * Rasterizer3D.fieldOfView / j3;
        int l6 = Rasterizer3D.originViewY + k4 * Rasterizer3D.fieldOfView / j3;
        Rasterizer3D.alpha = 0;
        if ((i6 - k6) * (l5 - l6) - (j6 - l6) * (k5 - k6) > 0) {
            boolean bl = Rasterizer3D.textureOutOfDrawingBounds = i6 < 0 || k6 < 0 || k5 < 0 || i6 > Rasterizer2D.lastX || k6 > Rasterizer2D.lastX || k5 > Rasterizer2D.lastX;
            if (clicked && this.inBounds(clickScreenX, clickScreenY, j6, l6, l5, i6, k6, k5)) {
                clickedTileX = x;
                clickedTileY = y;
            }
            if (this.inBounds(MouseHandler.mouseX, MouseHandler.mouseY, j6, l6, l5, i6, k6, k5)) {
                hoverX = x;
                hoverY = y;
            }
            if (simpleTile.getTexture() == -1) {
                if (simpleTile.getCenterColor() != 12345678) {
                    Rasterizer3D.drawShadedTriangle(j6, l6, l5, i6, k6, k5, simpleTile.getCenterColor(), simpleTile.getEastColor(), simpleTile.getNorthColor());
                }
            } else if (!lowMem) {
                if (simpleTile.isFlat()) {
                    Rasterizer3D.drawTexturedTriangle(j6, l6, l5, i6, k6, k5, simpleTile.getCenterColor(), simpleTile.getEastColor(), simpleTile.getNorthColor(), i2, i3, l1, l3, i4, k4, k2, j2, j3, simpleTile.getTexture());
                } else {
                    Rasterizer3D.drawTexturedTriangle(j6, l6, l5, i6, k6, k5, simpleTile.getCenterColor(), simpleTile.getEastColor(), simpleTile.getNorthColor(), l2, l1, i3, j4, k4, i4, k3, j3, j2, simpleTile.getTexture());
                }
            } else {
                int textureColor = TEXTURE_COLORS[simpleTile.getTexture()];
                Rasterizer3D.drawShadedTriangle(j6, l6, l5, i6, k6, k5, this.light(textureColor, simpleTile.getCenterColor()), this.light(textureColor, simpleTile.getEastColor()), this.light(textureColor, simpleTile.getNorthColor()));
            }
        }
        if ((i5 - k5) * (l6 - l5) - (j5 - l5) * (k6 - k5) > 0) {
            boolean bl = Rasterizer3D.textureOutOfDrawingBounds = i5 < 0 || k5 < 0 || k6 < 0 || i5 > Rasterizer2D.lastX || k5 > Rasterizer2D.lastX || k6 > Rasterizer2D.lastX;
            if (clicked && this.inBounds(clickScreenX, clickScreenY, j5, l5, l6, i5, k5, k6)) {
                clickedTileX = x;
                clickedTileY = y;
            }
            if (this.inBounds(MouseHandler.mouseX, MouseHandler.mouseY, j5, l5, l6, i5, k5, k6)) {
                hoverX = x;
                hoverY = y;
            }
            if (simpleTile.getTexture() == -1) {
                if (simpleTile.getNorthEastColor() != 12345678) {
                    Rasterizer3D.drawShadedTriangle(j5, l5, l6, i5, k5, k6, simpleTile.getNorthEastColor(), simpleTile.getNorthColor(), simpleTile.getEastColor());
                }
            } else {
                if (!lowMem) {
                    Rasterizer3D.drawTexturedTriangle(j5, l5, l6, i5, k5, k6, simpleTile.getNorthEastColor(), simpleTile.getNorthColor(), simpleTile.getEastColor(), i2, i3, l1, l3, i4, k4, k2, j2, j3, simpleTile.getTexture());
                    return;
                }
                int j7 = TEXTURE_COLORS[simpleTile.getTexture()];
                Rasterizer3D.drawShadedTriangle(j5, l5, l6, i5, k5, k6, this.light(j7, simpleTile.getNorthEastColor()), this.light(j7, simpleTile.getNorthColor()), this.light(j7, simpleTile.getEastColor()));
            }
        }
    }

    private void drawTileOverlay(int tileX, int pitchSin, int yawSin, ShapedTile tile, int pitchCos, int tileY, int yawCos) {
        DrawCallbacks drawCallbacks;
        RSTile rsTile = this.getTiles()[Client.instance.getPlane()][tileX][tileY];
        boolean checkClick = Client.instance.isCheckClick();
        if (!Client.instance.isGpu()) {
            this.drawTileOverlaySD(tileX, pitchSin, yawSin, tile, pitchCos, tileY, yawCos);
            if (roofRemovalMode == 0 || !checkClick || rsTile == null || rsTile.getSceneTileModel() != tile || rsTile.getPhysicalLevel() != Client.instance.getPlane()) {
                return;
            }
        }
        if ((drawCallbacks = Client.instance.getDrawCallbacks()) == null) {
            return;
        }
        try {
            int i;
            int cameraX2 = Client.instance.getCameraX2();
            int cameraY2 = Client.instance.getCameraY2();
            int cameraZ2 = Client.instance.getCameraZ2();
            int zoom = Client.instance.get3dZoom();
            int centerX = Client.instance.getCenterX();
            int centerY = Client.instance.getCenterY();
            drawCallbacks.drawSceneModel(0, pitchSin, pitchCos, yawSin, yawCos, -cameraX2, -cameraY2, -cameraZ2, tile, Client.instance.getPlane(), tileX, tileY, zoom, centerX, centerY);
            ShapedTile tileModel = tile;
            int[] faceX = tileModel.getFaceX();
            int[] faceY = tileModel.getFaceY();
            int[] faceZ = tileModel.getFaceZ();
            int[] vertexX = tileModel.getVertexX();
            int[] vertexY = tileModel.getVertexY();
            int[] vertexZ = tileModel.getVertexZ();
            int vertexCount = vertexX.length;
            int faceCount = faceX.length;
            int mouseX2 = Client.instance.getMouseX2();
            int mouseY2 = Client.instance.getMouseY2();
            for (i = 0; i < vertexCount; ++i) {
                int vx = vertexX[i] - cameraX2;
                int vy = vertexY[i] - cameraY2;
                int vz = vertexZ[i] - cameraZ2;
                int rotA = vz * yawSin + vx * yawCos >> 16;
                int rotB = vz * yawCos - vx * yawSin >> 16;
                int var13 = vy * pitchCos - rotB * pitchSin >> 16;
                int var12 = vy * pitchSin + rotB * pitchCos >> 16;
                if (var12 < 50) {
                    return;
                }
                int ax = rotA * zoom / var12 + centerX;
                int ay = var13 * zoom / var12 + centerY;
                SceneGraph.tmpX[i] = ax;
                SceneGraph.tmpY[i] = ay;
            }
            for (i = 0; i < faceCount; ++i) {
                int va = faceX[i];
                int x1 = tmpX[va];
                int vb = faceY[i];
                int x2 = tmpX[vb];
                int vc = faceZ[i];
                int y3 = tmpY[vc];
                int y2 = tmpY[vb];
                int y1 = tmpY[va];
                int x3 = tmpX[vc];
                if ((x1 - x2) * (y3 - y2) - (y1 - y2) * (x3 - x2) <= 0) continue;
                if (checkClick && Client.instance.containsBounds(mouseX2, mouseY2, y1, y2, y3, x1, x2, x3)) {
                    SceneGraph.setTargetTile(tileX, tileY);
                }
                if (!Client.instance.containsBounds(MouseHandler.mouseX, MouseHandler.mouseY, y1, y2, y3, x1, x2, x3)) continue;
                SceneGraph.hoverTile(tileX, tileY, rsTile.getPhysicalLevel());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawTileOverlaySD(int tileX, int pitchSin, int yawSin, ShapedTile tile, int pitchCos, int tileY, int yawCos) {
        int k1 = tile.origVertexX.length;
        for (int l1 = 0; l1 < k1; ++l1) {
            int i2 = tile.origVertexX[l1] - xCameraPos;
            int k2 = tile.origVertexY[l1] - zCameraPos;
            int i3 = tile.origVertexZ[l1] - yCameraPos;
            int k3 = i3 * yawSin + i2 * yawCos >> 16;
            i3 = i3 * yawCos - i2 * yawSin >> 16;
            i2 = k3;
            k3 = k2 * pitchCos - i3 * pitchSin >> 16;
            i3 = k2 * pitchSin + i3 * pitchCos >> 16;
            k2 = k3;
            if (i3 < 50) {
                return;
            }
            if (tile.triangleTexture != null) {
                ShapedTile.anIntArray690[l1] = i2;
                ShapedTile.anIntArray691[l1] = k2;
                ShapedTile.anIntArray692[l1] = i3;
            }
            ShapedTile.anIntArray688[l1] = Rasterizer3D.originViewX + i2 * Rasterizer3D.fieldOfView / i3;
            ShapedTile.anIntArray689[l1] = Rasterizer3D.originViewY + k2 * Rasterizer3D.fieldOfView / i3;
        }
        Rasterizer3D.alpha = 0;
        k1 = tile.triangleA.length;
        for (int j2 = 0; j2 < k1; ++j2) {
            int l2 = tile.triangleA[j2];
            int i4 = ShapedTile.anIntArray688[l2];
            int j3 = tile.triangleB[j2];
            int j4 = ShapedTile.anIntArray688[j3];
            int l3 = tile.triangleC[j2];
            int j5 = ShapedTile.anIntArray689[l3];
            int i5 = ShapedTile.anIntArray689[j3];
            int l4 = ShapedTile.anIntArray689[l2];
            int k4 = ShapedTile.anIntArray688[l3];
            if ((i4 - j4) * (j5 - i5) - (l4 - i5) * (k4 - j4) <= 0) continue;
            boolean bl = Rasterizer3D.textureOutOfDrawingBounds = i4 < 0 || j4 < 0 || k4 < 0 || i4 > Rasterizer2D.lastX || j4 > Rasterizer2D.lastX || k4 > Rasterizer2D.lastX;
            if (clicked && this.inBounds(clickScreenX, clickScreenY, l4, i5, j5, i4, j4, k4)) {
                clickedTileX = tileX;
                clickedTileY = tileY;
            }
            if (this.inBounds(MouseHandler.mouseX, MouseHandler.mouseY, l4, i5, j5, i4, j4, k4)) {
                hoverX = tileX;
                hoverY = tileY;
            }
            if (tile.triangleTexture == null || tile.triangleTexture[j2] == -1) {
                if (tile.triangleHslA[j2] == 12345678) continue;
                Rasterizer3D.drawShadedTriangle(l4, i5, j5, i4, j4, k4, tile.triangleHslA[j2], tile.triangleHslB[j2], tile.triangleHslC[j2]);
                continue;
            }
            if (!lowMem) {
                if (tile.flat) {
                    Rasterizer3D.drawTexturedTriangle(l4, i5, j5, i4, j4, k4, tile.triangleHslA[j2], tile.triangleHslB[j2], tile.triangleHslC[j2], ShapedTile.anIntArray690[0], ShapedTile.anIntArray690[1], ShapedTile.anIntArray690[3], ShapedTile.anIntArray691[0], ShapedTile.anIntArray691[1], ShapedTile.anIntArray691[3], ShapedTile.anIntArray692[0], ShapedTile.anIntArray692[1], ShapedTile.anIntArray692[3], tile.triangleTexture[j2]);
                    continue;
                }
                Rasterizer3D.drawTexturedTriangle(l4, i5, j5, i4, j4, k4, tile.triangleHslA[j2], tile.triangleHslB[j2], tile.triangleHslC[j2], ShapedTile.anIntArray690[l2], ShapedTile.anIntArray690[j3], ShapedTile.anIntArray690[l3], ShapedTile.anIntArray691[l2], ShapedTile.anIntArray691[j3], ShapedTile.anIntArray691[l3], ShapedTile.anIntArray692[l2], ShapedTile.anIntArray692[j3], ShapedTile.anIntArray692[l3], tile.triangleTexture[j2]);
                continue;
            }
            int k5 = TEXTURE_COLORS[tile.triangleTexture[j2]];
            Rasterizer3D.drawShadedTriangle(l4, i5, j5, i4, j4, k4, this.light(k5, tile.triangleHslA[j2]), this.light(k5, tile.triangleHslB[j2]), this.light(k5, tile.triangleHslC[j2]));
        }
    }

    private int light(int j, int k) {
        k = 127 - k;
        if ((k = k * (j & 0x7F) / 160) < 2) {
            k = 2;
        } else if (k > 126) {
            k = 126;
        }
        return (j & 0xFF80) + k;
    }

    public boolean inBounds(int i, int j, int k, int l, int i1, int j1, int k1, int l1) {
        if (j < k && j < l && j < i1) {
            return false;
        }
        if (j > k && j > l && j > i1) {
            return false;
        }
        if (i < j1 && i < k1 && i < l1) {
            return false;
        }
        if (i > j1 && i > k1 && i > l1) {
            return false;
        }
        int i2 = (j - k) * (k1 - j1) - (i - j1) * (l - k);
        int j2 = (j - i1) * (j1 - l1) - (i - l1) * (k - i1);
        int k2 = (j - l) * (l1 - k1) - (i - k1) * (i1 - l);
        return i2 * k2 > 0 && k2 * j2 > 0;
    }

    private void occlude() {
        int sceneClusterCount = sceneClusterCounts[this.currentRenderPlane];
        SceneCluster[] sceneClusters = SceneGraph.sceneClusters[this.currentRenderPlane];
        anInt475 = 0;
        for (int sceneIndex = 0; sceneIndex < sceneClusterCount; ++sceneIndex) {
            int maxRelativeX;
            int relativeZ;
            int maxRelativeY;
            int minRelativeY;
            SceneCluster sceneCluster = sceneClusters[sceneIndex];
            if (sceneCluster.orientation == 1) {
                int relativeX = sceneCluster.startXLoc - this.screenCenterX + 25;
                if (relativeX < 0 || relativeX > 50) continue;
                minRelativeY = sceneCluster.startYLoc - this.screenCenterZ + 25;
                if (minRelativeY < 0) {
                    minRelativeY = 0;
                }
                if ((maxRelativeY = sceneCluster.endYLoc - this.screenCenterZ + 25) > 50) {
                    maxRelativeY = 50;
                }
                boolean flag = false;
                while (minRelativeY <= maxRelativeY) {
                    if (!renderArea[relativeX][minRelativeY++]) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                int dXPos = xCameraPos - sceneCluster.startXPos;
                if (dXPos > 32) {
                    sceneCluster.cullDirection = 1;
                } else {
                    if (dXPos >= -32) continue;
                    sceneCluster.cullDirection = 2;
                    dXPos = -dXPos;
                }
                sceneCluster.anInt801 = (sceneCluster.startYPos - yCameraPos << 8) / dXPos;
                sceneCluster.anInt802 = (sceneCluster.endYPos - yCameraPos << 8) / dXPos;
                sceneCluster.anInt803 = (sceneCluster.startZPos - zCameraPos << 8) / dXPos;
                sceneCluster.anInt804 = (sceneCluster.endZPos - zCameraPos << 8) / dXPos;
                SceneGraph.aClass47Array476[SceneGraph.anInt475++] = sceneCluster;
                continue;
            }
            if (sceneCluster.orientation == 2) {
                int maxRelativeX2;
                int relativeY = sceneCluster.startYLoc - this.screenCenterZ + 25;
                if (relativeY < 0 || relativeY > 50) continue;
                int minRelativeX = sceneCluster.startXLoc - this.screenCenterX + 25;
                if (minRelativeX < 0) {
                    minRelativeX = 0;
                }
                if ((maxRelativeX2 = sceneCluster.endXLoc - this.screenCenterX + 25) > 50) {
                    maxRelativeX2 = 50;
                }
                boolean flag1 = false;
                while (minRelativeX <= maxRelativeX2) {
                    if (!renderArea[minRelativeX++][relativeY]) continue;
                    flag1 = true;
                    break;
                }
                if (!flag1) continue;
                int dYPos = yCameraPos - sceneCluster.startYPos;
                if (dYPos > 32) {
                    sceneCluster.cullDirection = 3;
                } else {
                    if (dYPos >= -32) continue;
                    sceneCluster.cullDirection = 4;
                    dYPos = -dYPos;
                }
                sceneCluster.anInt799 = (sceneCluster.startXPos - xCameraPos << 8) / dYPos;
                sceneCluster.anInt800 = (sceneCluster.endXPos - xCameraPos << 8) / dYPos;
                sceneCluster.anInt803 = (sceneCluster.startZPos - zCameraPos << 8) / dYPos;
                sceneCluster.anInt804 = (sceneCluster.endZPos - zCameraPos << 8) / dYPos;
                SceneGraph.aClass47Array476[SceneGraph.anInt475++] = sceneCluster;
                continue;
            }
            if (sceneCluster.orientation != 4 || (relativeZ = sceneCluster.startZPos - zCameraPos) <= 128) continue;
            minRelativeY = sceneCluster.startYLoc - this.screenCenterZ + 25;
            if (minRelativeY < 0) {
                minRelativeY = 0;
            }
            if ((maxRelativeY = sceneCluster.endYLoc - this.screenCenterZ + 25) > 50) {
                maxRelativeY = 50;
            }
            if (minRelativeY > maxRelativeY) continue;
            int minRelativeX = sceneCluster.startXLoc - this.screenCenterX + 25;
            if (minRelativeX < 0) {
                minRelativeX = 0;
            }
            if ((maxRelativeX = sceneCluster.endXLoc - this.screenCenterX + 25) > 50) {
                maxRelativeX = 50;
            }
            boolean flag2 = false;
            block3: for (int i4 = minRelativeX; i4 <= maxRelativeX; ++i4) {
                for (int j4 = minRelativeY; j4 <= maxRelativeY; ++j4) {
                    if (!renderArea[i4][j4]) continue;
                    flag2 = true;
                    break block3;
                }
            }
            if (!flag2) continue;
            sceneCluster.cullDirection = 5;
            sceneCluster.anInt799 = (sceneCluster.startXPos - xCameraPos << 8) / relativeZ;
            sceneCluster.anInt800 = (sceneCluster.endXPos - xCameraPos << 8) / relativeZ;
            sceneCluster.anInt801 = (sceneCluster.startYPos - yCameraPos << 8) / relativeZ;
            sceneCluster.anInt802 = (sceneCluster.endYPos - yCameraPos << 8) / relativeZ;
            SceneGraph.aClass47Array476[SceneGraph.anInt475++] = sceneCluster;
        }
    }

    private boolean method320(int zLoc, int xLoc, int yLoc) {
        int l = this.anIntArrayArrayArray445[zLoc][xLoc][yLoc];
        if (l == -this.cycle) {
            return false;
        }
        if (l == this.cycle) {
            return true;
        }
        int xPos = xLoc << 7;
        int yPos = yLoc << 7;
        if (this.method324(xPos + 1, this.heightMap[zLoc][xLoc][yLoc], yPos + 1) && this.method324(xPos + 128 - 1, this.heightMap[zLoc][xLoc + 1][yLoc], yPos + 1) && this.method324(xPos + 128 - 1, this.heightMap[zLoc][xLoc + 1][yLoc + 1], yPos + 128 - 1) && this.method324(xPos + 1, this.heightMap[zLoc][xLoc][yLoc + 1], yPos + 128 - 1)) {
            this.anIntArrayArrayArray445[zLoc][xLoc][yLoc] = this.cycle;
            return true;
        }
        this.anIntArrayArrayArray445[zLoc][xLoc][yLoc] = -this.cycle;
        return false;
    }

    private boolean method321(int i, int j, int k, int l) {
        if (!this.method320(i, j, k)) {
            return false;
        }
        int i1 = j << 7;
        int j1 = k << 7;
        int k1 = this.heightMap[i][j][k] - 1;
        int l1 = k1 - 120;
        int i2 = k1 - 230;
        int j2 = k1 - 238;
        if (l < 16) {
            if (l == 1) {
                if (i1 > xCameraPos) {
                    if (!this.method324(i1, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (i > 0) {
                    if (!this.method324(i1, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1) && this.method324(i1, i2, j1 + 128);
            }
            if (l == 2) {
                if (j1 < yCameraPos) {
                    if (!this.method324(i1, k1, j1 + 128)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (i > 0) {
                    if (!this.method324(i1, l1, j1 + 128)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1 + 128) && this.method324(i1 + 128, i2, j1 + 128);
            }
            if (l == 4) {
                if (i1 < xCameraPos) {
                    if (!this.method324(i1 + 128, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (i > 0) {
                    if (!this.method324(i1 + 128, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1 + 128, i2, j1) && this.method324(i1 + 128, i2, j1 + 128);
            }
            if (l == 8) {
                if (j1 > yCameraPos) {
                    if (!this.method324(i1, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1)) {
                        return false;
                    }
                }
                if (i > 0) {
                    if (!this.method324(i1, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1) && this.method324(i1 + 128, i2, j1);
            }
        }
        if (!this.method324(i1 + 64, j2, j1 + 64)) {
            return false;
        }
        if (l == 16) {
            return this.method324(i1, i2, j1 + 128);
        }
        if (l == 32) {
            return this.method324(i1 + 128, i2, j1 + 128);
        }
        if (l == 64) {
            return this.method324(i1 + 128, i2, j1);
        }
        if (l == 128) {
            return this.method324(i1, i2, j1);
        }
        System.out.println("Warning unsupported wall type");
        return true;
    }

    private boolean method322(int i, int j, int k, int l) {
        if (!this.method320(i, j, k)) {
            return false;
        }
        int i1 = j << 7;
        int j1 = k << 7;
        return this.method324(i1 + 1, this.heightMap[i][j][k] - l, j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[i][j + 1][k] - l, j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[i][j + 1][k + 1] - l, j1 + 128 - 1) && this.method324(i1 + 1, this.heightMap[i][j][k + 1] - l, j1 + 128 - 1);
    }

    private boolean method323(int i, int j, int k, int l, int i1, int j1) {
        if (j == k && l == i1) {
            if (!this.method320(i, j, l)) {
                return false;
            }
            int k1 = j << 7;
            int i2 = l << 7;
            return this.method324(k1 + 1, this.heightMap[i][j][l] - j1, i2 + 1) && this.method324(k1 + 128 - 1, this.heightMap[i][j + 1][l] - j1, i2 + 1) && this.method324(k1 + 128 - 1, this.heightMap[i][j + 1][l + 1] - j1, i2 + 128 - 1) && this.method324(k1 + 1, this.heightMap[i][j][l + 1] - j1, i2 + 128 - 1);
        }
        for (int l1 = j; l1 <= k; ++l1) {
            for (int j2 = l; j2 <= i1; ++j2) {
                if (this.anIntArrayArrayArray445[i][l1][j2] != -this.cycle) continue;
                return false;
            }
        }
        int k2 = (j << 7) + 1;
        int i3 = this.heightMap[i][j][l] - j1;
        int l2 = (l << 7) + 2;
        if (!this.method324(k2, i3, l2)) {
            return false;
        }
        int j3 = (k << 7) - 1;
        if (!this.method324(j3, i3, l2)) {
            return false;
        }
        int k3 = (i1 << 7) - 1;
        return this.method324(k2, i3, k3) && this.method324(j3, i3, k3);
    }

    private boolean method324(int i, int j, int k) {
        for (int l = 0; l < anInt475; ++l) {
            int i2;
            SceneCluster class47 = aClass47Array476[l];
            if (class47.cullDirection == 1) {
                int i1 = class47.startXPos - i;
                if (i1 <= 0) continue;
                int j2 = class47.startYPos + (class47.anInt801 * i1 >> 8);
                int k3 = class47.endYPos + (class47.anInt802 * i1 >> 8);
                int l4 = class47.startZPos + (class47.anInt803 * i1 >> 8);
                int i6 = class47.endZPos + (class47.anInt804 * i1 >> 8);
                if (k < j2 || k > k3 || j < l4 || j > i6) continue;
                return true;
            }
            if (class47.cullDirection == 2) {
                int j1 = i - class47.startXPos;
                if (j1 <= 0) continue;
                int k2 = class47.startYPos + (class47.anInt801 * j1 >> 8);
                int l3 = class47.endYPos + (class47.anInt802 * j1 >> 8);
                int i5 = class47.startZPos + (class47.anInt803 * j1 >> 8);
                int j6 = class47.endZPos + (class47.anInt804 * j1 >> 8);
                if (k < k2 || k > l3 || j < i5 || j > j6) continue;
                return true;
            }
            if (class47.cullDirection == 3) {
                int k1 = class47.startYPos - k;
                if (k1 <= 0) continue;
                int l2 = class47.startXPos + (class47.anInt799 * k1 >> 8);
                int i4 = class47.endXPos + (class47.anInt800 * k1 >> 8);
                int j5 = class47.startZPos + (class47.anInt803 * k1 >> 8);
                int k6 = class47.endZPos + (class47.anInt804 * k1 >> 8);
                if (i < l2 || i > i4 || j < j5 || j > k6) continue;
                return true;
            }
            if (class47.cullDirection == 4) {
                int l1 = k - class47.startYPos;
                if (l1 <= 0) continue;
                int i3 = class47.startXPos + (class47.anInt799 * l1 >> 8);
                int j4 = class47.endXPos + (class47.anInt800 * l1 >> 8);
                int k5 = class47.startZPos + (class47.anInt803 * l1 >> 8);
                int l6 = class47.endZPos + (class47.anInt804 * l1 >> 8);
                if (i < i3 || i > j4 || j < k5 || j > l6) continue;
                return true;
            }
            if (class47.cullDirection != 5 || (i2 = j - class47.startZPos) <= 0) continue;
            int j3 = class47.startXPos + (class47.anInt799 * i2 >> 8);
            int k4 = class47.endXPos + (class47.anInt800 * i2 >> 8);
            int l5 = class47.startYPos + (class47.anInt801 * i2 >> 8);
            int i7 = class47.endYPos + (class47.anInt802 * i2 >> 8);
            if (i < j3 || i > k4 || k < l5 || k > i7) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addItem(int id, int quantity, WorldPoint point) {
        int sceneX = point.getX() - Client.instance.getBaseX();
        int sceneY = point.getY() - Client.instance.getBaseY();
        int plane = point.getPlane();
        if (sceneX < 0 || sceneY < 0 || sceneX >= 104 || sceneY >= 104) {
            return;
        }
        RSTileItem item = Client.instance.newTileItem();
        item.setId(id);
        item.setQuantity(quantity);
        RSNodeDeque[][][] groundItems = Client.instance.getGroundItemDeque();
        if (groundItems[plane][sceneX][sceneY] == null) {
            groundItems[plane][sceneX][sceneY] = Client.instance.newNodeDeque();
        }
        groundItems[plane][sceneX][sceneY].addFirst(item);
        if (plane == Client.instance.getPlane()) {
            Client.instance.updateItemPile(sceneX, sceneY);
        }
    }

    @Override
    public void removeItem(int id, int quantity, WorldPoint point) {
        int sceneX = point.getX() - Client.instance.getBaseX();
        int sceneY = point.getY() - Client.instance.getBaseY();
        int plane = point.getPlane();
        if (sceneX < 0 || sceneY < 0 || sceneX >= 104 || sceneY >= 104) {
            return;
        }
        RSNodeDeque items = Client.instance.getGroundItemDeque()[plane][sceneX][sceneY];
        if (items == null) {
            return;
        }
        RSTileItem item = (RSTileItem)items.last();
        while (item != null) {
            if (item.getId() == id && quantity == 1) {
                item.remove();
                break;
            }
            item = (RSTileItem)items.previous();
        }
        if (items.last() == null) {
            Client.instance.getGroundItemDeque()[plane][sceneX][sceneY] = null;
        }
        Client.instance.updateItemPile(sceneX, sceneY);
    }

    @Override
    public int getDrawDistance() {
        return this.drawDistance;
    }

    @Override
    public void setDrawDistance(int drawDistance) {
        this.drawDistance = drawDistance;
    }

    @Override
    public void generateHouses() {
    }

    @Override
    public void setRoofRemovalMode(int flags) {
        roofRemovalMode = flags;
    }

    @Override
    public RSGameObject[] getObjects() {
        return this.gameObjectsCache;
    }

    @Override
    public RSTile[][][] getTiles() {
        return this.tileArray;
    }

    @Override
    public int[][] getTileShape2D() {
        return this.tileVertices;
    }

    @Override
    public int[][] getTileRotation2D() {
        return this.tileVertexIndices;
    }

    @Override
    public void draw(net.runelite.api.Tile tile, boolean var2) {
        this.drawTile((Tile)tile, false);
    }

    @Override
    public int[][][] getTileHeights() {
        return this.heightMap;
    }

    @Override
    public int getBaseX() {
        return Client.instance.getBaseX();
    }

    @Override
    public int getBaseY() {
        return Client.instance.getBaseY();
    }

    @Override
    public boolean isInstance() {
        return Client.instance.isInInstancedRegion();
    }

    @Override
    public int[][][] getInstanceTemplateChunks() {
        return new int[0][][];
    }

    @Override
    public void drawTile(int[] pixels, int pixelOffset, int width, int z, int x, int y) {
    }

    @Override
    public void updateOccluders() {
        this.occlude();
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getMaxZ() {
        return this.maxZ;
    }

    @Override
    public int getMinLevel() {
        return this.minLevel;
    }

    @Override
    public void setMinLevel(int lvl) {
        this.minLevel = lvl;
    }

    @Override
    public void newGroundItemPile(int plane, int x, int y, int hash, RSRenderable var5, long var6, RSRenderable var7, RSRenderable var8) {
    }

    @Override
    public boolean newGameObject(int plane, int startX, int startY, int var4, int var5, int centerX, int centerY, int height, RSRenderable entity, int orientation, boolean tmp, long tag, int flags) {
        return false;
    }

    @Override
    public void removeGameObject(net.runelite.api.GameObject gameObject) {
        this.removeGameObject(gameObject.getPlane(), gameObject.getX(), gameObject.getY());
    }

    @Override
    public void removeGameObject(int plane, int x, int y) {
    }

    @Override
    public void removeWallObject(net.runelite.api.WallObject wallObject) {
        this.removeWallObject(wallObject.getPlane(), wallObject.getX(), wallObject.getY());
    }

    public void removeWallObject(WallObject wallObject) {
        RSTile[][][] tiles = this.getTiles();
        for (int y = 0; y < 104; ++y) {
            for (int x = 0; x < 104; ++x) {
                RSTile tile = tiles[Client.instance.getPlane()][x][y];
                if (tile == null || tile.getWallObject() != wallObject) continue;
                tile.setWallObject(null);
            }
        }
    }

    @Override
    public void removeDecorativeObject(DecorativeObject decorativeObject) {
        RSTile[][][] tiles = this.getTiles();
        for (int y = 0; y < 104; ++y) {
            for (int x = 0; x < 104; ++x) {
                RSTile tile = tiles[Client.instance.getPlane()][x][y];
                if (tile == null || tile.getDecorativeObject() != decorativeObject) continue;
                tile.setDecorativeObject(null);
            }
        }
    }

    @Override
    public void removeDecorativeObject(int plane, int x, int y) {
    }

    @Override
    public void removeGroundObject(GroundObject groundObject) {
        RSTile[][][] tiles = this.getTiles();
        for (int y = 0; y < 104; ++y) {
            for (int x = 0; x < 104; ++x) {
                RSTile tile = tiles[Client.instance.getPlane()][x][y];
                if (tile == null || tile.getGroundObject() != groundObject) continue;
                tile.setGroundObject(null);
            }
        }
    }

    @Override
    public void removeGroundObject(int plane, int x, int y) {
    }

    @Override
    public short[][][] getUnderlayIds() {
        return Client.instance.currentMapRegion.underlays;
    }

    @Override
    public void setUnderlayIds(short[][][] underlayIds) {
        Client.instance.currentMapRegion.underlays = underlayIds;
    }

    @Override
    public short[][][] getOverlayIds() {
        return Client.instance.currentMapRegion.overlays;
    }

    @Override
    public void setOverlayIds(short[][][] overlayIds) {
        Client.instance.currentMapRegion.overlays = overlayIds;
    }

    @Override
    public byte[][][] getTileShapes() {
        return Client.instance.currentMapRegion.overlayTypes;
    }

    @Override
    public void setTileShapes(byte[][][] tileShapes) {
        Client.instance.currentMapRegion.overlayTypes = tileShapes;
    }

    @Override
    public void menuOpen(int selectedPlane, int screenX, int screenY, boolean viewportWalking) {
    }

    static {
        hdMinimapEnabled = false;
        tmpX = new int[6];
        tmpY = new int[6];
        roofRemovalMode = 0;
        tilesToRemove = new HashSet<RSTile>();
        lowMem = false;
        interactableObjects = new GameObject[100];
        anIntArray463 = new int[]{53, -53, -53, 53};
        anIntArray464 = new int[]{-53, -53, 53, 53};
        anIntArray465 = new int[]{-45, 45, 45, -45};
        anIntArray466 = new int[]{45, 45, -45, -45};
        clickedTileX = -1;
        clickedTileY = -1;
        hoverX = -1;
        hoverY = -1;
        aClass47Array476 = new SceneCluster[500];
        tileDeque = new Deque();
        anIntArray478 = new int[]{19, 55, 38, 155, 255, 110, 137, 205, 76};
        anIntArray479 = new int[]{160, 192, 80, 96, 0, 144, 80, 48, 160};
        anIntArray480 = new int[]{76, 8, 137, 4, 0, 1, 38, 2, 19};
        anIntArray481 = new int[]{0, 0, 2, 0, 0, 2, 1, 1, 0};
        anIntArray482 = new int[]{2, 0, 0, 2, 0, 0, 0, 4, 4};
        anIntArray483 = new int[]{0, 4, 4, 8, 0, 0, 8, 0, 0};
        anIntArray484 = new int[]{1, 1, 0, 0, 0, 8, 0, 0, 8};
        TEXTURE_COLORS = new int[]{41, 39248, 41, 4643, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 43086, 41, 41, 41, 41, 41, 41, 41, 8602, 41, 28992, 41, 41, 41, 41, 41, 5056, 41, 41, 41, 7079, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 3131, 41, 41, 41};
        cullingClusterPlaneCount = 4;
        sceneClusterCounts = new int[cullingClusterPlaneCount];
        sceneClusters = new SceneCluster[cullingClusterPlaneCount][500];
        visibilityMap = new boolean[8][32][51][51];
    }
}

