/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.Model;
import com.client.Renderable;
import com.client.definitions.GraphicsDefinition;
import com.client.definitions.SeqFrame;
import net.runelite.api.Actor;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.ProjectileSpawned;
import net.runelite.rs.api.RSModel;
import net.runelite.rs.api.RSNode;
import net.runelite.rs.api.RSProjectile;

final class Projectile
extends Renderable
implements RSProjectile {
    public final int startCycle;
    public final int stopCycle;
    private double xIncrement;
    private double yIncrement;
    private double diagonalIncrement;
    private double heightIncrement;
    private double aDouble1578;
    private boolean started;
    private final int projectileX;
    private final int projectileY;
    private final int startHeight;
    public final int endHeight;
    public double xPos;
    public double yPos;
    public double cnterHeight;
    private final int initialSlope;
    private final int initialDistance;
    public final int target;
    private final GraphicsDefinition projectileGFX;
    private int gfxStage;
    private int gfxTickOfCurrentStage;
    public int turnValue;
    private int tiltAngle;
    public final int projectileZ;
    public int gfxid;
    public int endX;
    public int endY;
    public double currentCyclee;
    private int targetX;
    private int targetY;

    public void calculateIncrements(int currentCycle, int targetY, int targetCenterHeight, int targetX) {
        double cyclesLeft;
        if (!this.started) {
            double xToGo = targetX - this.projectileX;
            double yToGo = targetY - this.projectileY;
            double distanceToGo = Math.sqrt(xToGo * xToGo + yToGo * yToGo);
            this.xPos = (double)this.projectileX + xToGo * (double)this.initialDistance / distanceToGo;
            this.yPos = (double)this.projectileY + yToGo * (double)this.initialDistance / distanceToGo;
            this.cnterHeight = this.startHeight;
        }
        this.currentCyclee = cyclesLeft = (double)(this.stopCycle + 1 - currentCycle);
        this.xIncrement = ((double)targetX - this.xPos) / cyclesLeft;
        this.yIncrement = ((double)targetY - this.yPos) / cyclesLeft;
        this.diagonalIncrement = Math.sqrt(this.xIncrement * this.xIncrement + this.yIncrement * this.yIncrement);
        if (!this.started) {
            this.heightIncrement = -this.diagonalIncrement * Math.tan((double)this.initialSlope * 0.02454369);
        }
        this.aDouble1578 = 2.0 * ((double)targetCenterHeight - this.cnterHeight - this.heightIncrement * cyclesLeft) / (cyclesLeft * cyclesLeft);
        this.projectileMoved(targetX, targetY, targetCenterHeight, targetCenterHeight);
    }

    public void projectileMoved(int targetX, int targetY, int targetZ, int cycle) {
        this.targetX = targetX;
        this.targetY = targetY;
        LocalPoint position = new LocalPoint(targetX, targetY);
        ProjectileMoved projectileMoved = new ProjectileMoved();
        projectileMoved.setProjectile(this);
        projectileMoved.setPosition(position);
        projectileMoved.setZ(targetZ);
        Client.instance.getCallbacks().post(projectileMoved);
    }

    @Override
    public Model getRotatedModel() {
        Model model = this.projectileGFX.getModel();
        if (model == null) {
            return null;
        }
        int j = -1;
        if (this.projectileGFX.animationSequence != null) {
            j = this.projectileGFX.animationSequence.frameIDs[this.gfxStage];
        }
        Model model_1 = new Model(true, SeqFrame.noAnimationInProgress(j), false, model);
        if (j != -1) {
            model_1.generateBones();
            model_1.interpolate(j);
            model_1.groupedTriangleLabels = null;
            model_1.groupedVertexLabels = null;
        }
        if (this.projectileGFX.resizeXY != 128 || this.projectileGFX.resizeZ != 128) {
            model_1.scale(this.projectileGFX.resizeXY, this.projectileGFX.resizeXY, this.projectileGFX.resizeZ);
        }
        model_1.rotateZ(this.tiltAngle);
        model_1.light(64 + this.projectileGFX.modelBrightness, 850 + this.projectileGFX.modelShadow, -30, -50, -30, true);
        return model_1;
    }

    public Projectile(int initialSlope, int endHeight, int creationCycle, int destructionCycle, int initialDistance, int startZ, int startHeight, int y, int x, int target, int gfxMoving) {
        this.gfxid = gfxMoving;
        this.projectileGFX = GraphicsDefinition.cache[gfxMoving];
        this.projectileZ = startZ;
        this.projectileX = x;
        this.projectileY = y;
        this.startHeight = startHeight;
        this.startCycle = creationCycle;
        this.stopCycle = destructionCycle;
        this.currentCyclee = creationCycle;
        this.initialSlope = initialSlope;
        this.initialDistance = initialDistance;
        this.target = target;
        this.endHeight = endHeight;
        this.started = false;
        ProjectileSpawned spawned = new ProjectileSpawned();
        spawned.setProjectile(this);
        Client.instance.getCallbacks().post(spawned);
    }

    public void progressCycles(int cyclesMissed) {
        this.started = true;
        this.xPos += this.xIncrement * (double)cyclesMissed;
        this.yPos += this.yIncrement * (double)cyclesMissed;
        this.cnterHeight += this.heightIncrement * (double)cyclesMissed + 0.5 * this.aDouble1578 * (double)cyclesMissed * (double)cyclesMissed;
        this.heightIncrement += this.aDouble1578 * (double)cyclesMissed;
        this.turnValue = (int)(Math.atan2(this.xIncrement, this.yIncrement) * 325.949) + 1024 & 0x7FF;
        this.tiltAngle = (int)(Math.atan2(this.heightIncrement, this.diagonalIncrement) * 325.949) & 0x7FF;
        if (this.projectileGFX != null && this.projectileGFX.animationSequence != null) {
            this.gfxTickOfCurrentStage += cyclesMissed;
            while (this.gfxTickOfCurrentStage > this.projectileGFX.animationSequence.getDuration(this.gfxStage)) {
                this.gfxTickOfCurrentStage -= this.projectileGFX.animationSequence.getDuration(this.gfxStage) + 1;
                ++this.gfxStage;
                if (this.gfxStage < this.projectileGFX.animationSequence.frameCount) continue;
                this.gfxStage = 0;
            }
        }
    }

    public void stillFocus(int endX, int endY) {
        this.endX = endX;
        this.endY = endY;
    }

    @Override
    public RSModel getModel() {
        return this.getRotatedModel();
    }

    @Override
    public Actor getInteracting() {
        if (this.target < 0) {
            return Client.instance.players[-this.target - 1];
        }
        if (this.target > 0) {
            return Client.instance.getNpcs().get(this.target - 1);
        }
        return null;
    }

    @Override
    public int getRemainingCycles() {
        int currentGameCycle = Client.instance.getGameCycle();
        return this.getEndCycle() - currentGameCycle;
    }

    @Override
    public int getId() {
        return this.gfxid;
    }

    @Override
    public int getRsInteracting() {
        return this.target;
    }

    @Override
    public int getHeight() {
        return (int)this.cnterHeight;
    }

    @Override
    public int getEndHeight() {
        return this.endHeight;
    }

    @Override
    public int getX1() {
        return this.endX;
    }

    @Override
    public int getY1() {
        return this.endY;
    }

    @Override
    public int getFloor() {
        return (int)this.cnterHeight;
    }

    @Override
    public int getStartMovementCycle() {
        return this.startCycle;
    }

    @Override
    public int getEndCycle() {
        return this.stopCycle;
    }

    @Override
    public int getSlope() {
        return this.initialSlope;
    }

    @Override
    public int getStartHeight() {
        return this.startHeight;
    }

    @Override
    public double getX() {
        return this.xPos;
    }

    @Override
    public double getY() {
        return this.yPos;
    }

    @Override
    public double getZ() {
        return this.cnterHeight;
    }

    @Override
    public double getScalar() {
        return this.diagonalIncrement;
    }

    @Override
    public double getVelocityX() {
        return this.xIncrement;
    }

    @Override
    public double getVelocityY() {
        return this.yIncrement;
    }

    @Override
    public double getVelocityZ() {
        return this.heightIncrement;
    }

    @Override
    public RSNode getNext() {
        return null;
    }

    @Override
    public long getHash() {
        return 0L;
    }

    @Override
    public RSNode getPrevious() {
        return null;
    }

    @Override
    public void onUnlink() {
    }

    @Override
    public int getModelHeight() {
        return this.modelBaseY;
    }

    @Override
    public void setModelHeight(int modelHeight) {
        this.modelBaseY = modelHeight;
    }

    @Override
    public void draw(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, long hash) {
        this.renderAtPoint(orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash, 0);
    }
}

