/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.utilities.JsonUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Queue;

public class PacketLog {
    private static Queue<LoggedPacket> packets = new ArrayDeque<LoggedPacket>();

    public static void add(int opcode, int length, byte[] inStreamBuffer) {
        byte[] buffer = new byte[length];
        System.arraycopy(inStreamBuffer, 0, buffer, 0, length);
        packets.add(new LoggedPacket(opcode, length, buffer));
        while (packets.size() > 10) {
            packets.poll();
        }
    }

    public static void log() {
        try {
            ArrayList<LoggedPacket> loggedPackets = new ArrayList<LoggedPacket>(packets);
            System.err.println(JsonUtil.toJsonString(loggedPackets));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clear() {
        packets.clear();
    }

    private static class LoggedPacket {
        private final int opcode;
        private final int length;
        private final byte[] buffer;

        public LoggedPacket(int opcode, int length, byte[] buffer) {
            this.opcode = opcode;
            this.length = length;
            this.buffer = buffer;
        }

        public String toString() {
            return "LoggedPacket{opcode=" + this.opcode + ", length=" + this.length + ", buffer=" + Arrays.toString(this.buffer) + "}";
        }
    }
}

